/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.reports;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class AuditMgmtUtil {
    private static AuditMgmtUtil handle = null;
    public static final long ENROLLMENT_NOTIFICATION = 2L;
    public static final long PWD_EXPIRE_NOTIFICATION = 4L;
    public static final long ACC_EXPIRE_NOTIFICATION = 8L;
    public static final long PWD_EXPIRED_NOTIFICATION = 0x2000000L;
    public static final long RP_NOTIFICATION = 16L;
    public static final long UA_NOTIFICATION = 32L;
    public static final long CP_NOTIFICATION = 64L;
    public static final long VC_NOTIFICATION = 128L;
    public static final long MAIL_TO_ADMIN_NOTIFICATION = 256L;
    public static final long ACC_EXPIRED_NOTIFICATION = 0x4000000L;
    public static final long VC_LOGIN_NOTIFICATION = 0x10000000L;
    public static final long ENROLLMENT_ACKNOWLEDGEMENT_NOTIFICATION = 0x80000000L;
    public static final long SELF_UPDATE_NOTIFICATION = 0x100000000L;
    public static final long BLOCKED_USER_NOTIFICATION = 0x200000000L;
    public static final long MFA_NOTIFICATION = 0x40000000000L;
    public static final long SUCCESS = 512L;
    public static final long FAILURE = 1024L;
    public static final long CHANGE_PASSWORD = 0x200000000000L;
    public static final long USER_MUST_CHANGE_PASSWORD = 0x400000000000L;
    public static final long MAIL = 2048L;
    public static final long SMS = 4096L;
    public static final long MOBILE = 0x400000L;
    public static final long SELF_SERVED = 8192L;
    public static final long AUTOMATIC = 16384L;
    public static final long SECURITY_QA = 32768L;
    public static final long VERIFICATION_CODE = 65536L;
    public static final long GOOGLE_AUTHENTICATOR = 0x200000L;
    public static final long RSA_SECURID = 0x800000000L;
    public static final long RADIUS_AUTHENTICATOR = 0x1000000000L;
    public static final long PUSH_AUTHENTICATOR = 0x4000000000L;
    public static final long FINGER_PRINT_AUTHENTICATOR = 0x8000000000L;
    public static final long QR_CODE_AUTHENTICATOR = 0x10000000000L;
    public static final long TOTP_AUTHENTICATOR = 0x20000000000L;
    public static final long MANUAL_LOGIN = 131072L;
    public static final long SSO_LOGIN = 262144L;
    public static final long RP = 524288L;
    public static final long UA = 0x100000L;
    public static final long RSA_LOGIN = 0x40000000L;
    public static final long VC_LOGIN = 0x8000000L;
    public static final long DUOWEB_LOGIN = 0x20000000L;
    public static final long RADIUS_LOGIN = 0x400000000L;
    public static final long MOBILE_AUTO_LOGIN = 0x2000000000L;
    public static final long SAML_SSO_LOGIN = 0x80000000000L;
    public static final long SMARTCARD_LOGIN = 0x100000000000L;
    public static final long WIN_LOG_TFA = 0x800000000000L;
    public static final long ANDROID_NOTIFICATION = 0x800000L;
    public static final long IOS_NOTIFICATION = 0x1000000L;
    public static final long[] USR_ATTEMPTS_IDS = new long[]{131072L, 262144L, 0x80000000000L, 0x100000000000L, 0x40000000L, 0x8000000L, 0x20000000L, 0x400000000L, 0x2000000000L, 524288L, 0x100000L, 0x800000000000L};
    public static final String[] USER_ATTEMPTS = new String[]{"adssp.reports.audit_report.user_attempts.type_manual_login_text", "adssp.reports.audit_report.user_attempts.type_sso_text", "adssp.reports.audit_report.user_attempts.type_saml_sso_login", "adssp.reports.audit_report.user_attempts.type_smartcard_text", "adssp.reports.audit_report.user_attempts.type_rsa_login_text", "adssp.reports.audit_report.user_attempts.type_vc_login_text", "adssp.reports.audit_report.user_attempts.type_duoweb_login_text", "adssp.reports.audit_report.user_attempts.type_radius_login_text", "adssp.reports.audit_report.user_attempts.type_mob_auto_login", "adssp.common.text.reset_pwd", "adssp.common.text.unlock", "adssp.reports.audit_report.user_attempts.type_windows_login_text"};
    public static final long[] IDENTITY_VERIFICATION_IDS = new long[]{32768L, 65536L, 0x200000L, 0x800000000L, 0x1000000000L, 0x4000000000L, 0x8000000000L, 0x10000000000L, 0x20000000000L};
    public static final String[] IDENTITY_VERIFICATION = new String[]{"adssp.reports.common.text_security_que", "adssp.reports.common.text_verification_code", "adssp.reports.common.text_google_auth", "adssp.login.tfa.rsa_heading", "adssp.login.tfa.radius_heading", "adssp.enrollment.push_notification_auth.heading", "adssp.enrollment.finger_print_auth.heading", "adssp.enrollment.qr_code_auth.heading", "adssp.enrollment.totp_auth.heading"};
    public static final long[] MAIL_IDS = new long[]{2L, 4L, 0x2000000L, 8L, 0x4000000L, 16L, 32L, 64L, 128L, 256L, 0x10000000L, 0x80000000L, 0x100000000L, 0x200000000L, 0x40000000000L};
    public static final String[] MAIL_ACTIONS = new String[]{"adssp.reports.audit_report.notification_delivery_report.enrollment_notificaiton", "adssp.reports.audit_report.notification_delivery_report.password_expire_notificaiton", "adssp.reports.audit_report.notification_delivery_report.password_expired_notificaiton", "adssp.reports.audit_report.notification_delivery_report.account_expire_notificaiton", "adssp.reports.audit_report.notification_delivery_report.account_expired_notification", "adssp.reports.audit_report.notification_delivery_report.reset_password_notificaiton", "adssp.reports.audit_report.notification_delivery_report.unlock_account_notificaiton", "adssp.reports.audit_report.notification_delivery_report.change_password_notificaiton", "adssp.reports.audit_report.notification_delivery_report.verification_code_notificaiton", "adssp.reports.audit_report.notification_delivery_report.mail_to_admin", "adssp.reports.audit_report.notification_delivery_report.vc_login", "adssp.reports.audit_report.notification_delivery_report.enrollment_ack_notification", "adssp.reports.audit_report.notification_delivery_report.self_update_ack_notification", "adssp.reports.audit_report.notification_delivery_report.block_user_notification", "adssp.reports.audit_report.notification_delivery_report.mfa_notificaiton"};
    public static final long[] PUSH_NOTIFICATION_IDS = new long[]{0x800000L, 0x1000000L};
    public static final String[] PUSH_NOTIFICATION_DEVICES = new String[]{"adssp.reports.audit_report.notification.android", "adssp.reports.audit_report.notification.ios"};
    public static final long[] STATUS_IDS = new long[]{512L, 1024L};
    public static final String[] STATUS = new String[]{"adssp.common.text.success", "adssp.common.text.failure"};
    public static final long[] DELEGATE_IDS = new long[]{8192L, 16384L};
    public static final String[] DELEGATIONS = new String[]{"adssp.common.text.self", "adssp.common.text.automatic"};
    public static final long[] RPUA_TYPE_IDS = new long[]{8192L, 16384L};
    public static final String[] RPUA_TYPES = new String[]{"adssp.common.text.self", "adssp.common.text.automatic"};
    public static final String[] RP_DB_TEXT = new String[]{"audit.action.reset_pwd", "audit.action.automatic_reset_pwd"};
    public static final String[] UA_DB_TEXT = new String[]{"audit.action.unlocked", "audit.action.automatic_unlock"};
    public static final long[] CHANGE_PWD_TYPE_IDS = new long[]{0x200000000000L, 0x400000000000L};
    public static final String[] CHANGE_PWD_TYPES = new String[]{"audit.action.change_pwd", "adssp.audit.change_pwd.umcp"};
    public static final long[] NOTIFICATION_IDS = new long[]{2048L, 4096L, 0x400000L};
    public static final String[] NOTIFICATIONS = new String[]{"adssp.reports.audit_report.notification_delivery_report.mail", "adssp.reports.audit_report.notification_delivery_report.sms", "adssp.reports.audit_report.notification_delivery_report.push_notification"};
    public static final String[] NOTIFICATIONS_CONDITION = new String[]{"adssp.reports.audit_report.notification_delivery_report.mail", "adssp.reports.audit_report.notification_delivery_report.sms", "adssp.reports.audit_report.notification_delivery_report.android.push_notification", "adssp.reports.audit_report.notification_delivery_report.ios.push_notification"};
    public static Map auditTables = null;
    public static JSONObject sspAudit = null;
    public static JSONObject sspNotificationAudit = null;
    public static JSONObject sspUserAttemptsAudit = null;
    public static JSONObject sspSTEMailAudit = null;
    public static final String RPUA_FILTER = "26112";
    public static final String NOTIFY_FILTER = "4413477363710";
    public static final String MISC_FILTER = "1536";
    public static final String CHANGE_PWD_FILTER = "105553116268032";
    public static final String ID_VERIFICATION_FILTER = "4226250014720";
    public static final String USER_ATTEMPTS_FILTER = "167282133042688";
    public static final List RPUA_REPORT_IDS = Arrays.asList("101", "102");
    public static final List NOTIFY_REPORT_IDS = Arrays.asList("110");
    public static final List MISC_REPORT_IDS = Arrays.asList("103");
    public static final List CHANGE_PWD_IDS = Arrays.asList("108");
    public static final List ID_VERIFICATION_REPORT_IDS = Arrays.asList("106");
    public static final List USER_ATTEMPTS_IDS = Arrays.asList("111");
    public static final String[] USER_ATTEMPTS_UI_COLUMNS = new String[]{"LOGIN_NAME", "TIME", "HOST", "DOMAIN_NAME", "NO_OF_ATTEMPT", "TYPE", "ERROR_MESSAGE"};
    public static final String[] USER_ATTEMPTS_UI_COLUMNS_DISP = new String[]{"adssp.reports.common.text.audit_login_name", "adssp.reports.common.text.time", "adssp.reports.common.text.audit_from_adress", "adssp.common.text.domain_name", "adssp.reports.audit_report.total_attempt", "adssp.common.text.type", "adssp.reports.common.text.status"};
    public static final String[] NOTIFY_UI_COLUMNS = new String[]{"NAME", "TIME", "ACTION_NAME", "NOTIFICATION_TYPE", "DOMAIN_NAME", "SENT_COUNT", "ERROR_MESSAGE"};
    public static final String[] NOTIFY_UI_COLUMNS_DISP = new String[]{"adssp.reports.common.text.audit_login_name", "adssp.reports.common.text.audit_sent_on", "adssp.reports.audit_rep.column.action_name", "adssp.reports.audit_rep.column.notify_type", "adssp.common.text.domain_name", "adssp.reports.notify_audit_rep.column.count", "adssp.common.text.delivery_status"};
    public static final String[] RPUA_UI_COLUMNS = new String[]{"NAME", "TIME", "HOST", "DOMAIN_NAME", "NO_OF_ATTEMPT", "TYPE", "ERROR_MESSAGE"};
    public static final String[] RPUA_UI_COLUMNS_DISP = new String[]{"adssp.reports.common.text.audit_login_name", "adssp.reports.common.text.time", "adssp.reports.common.text.audit_from_adress", "adssp.common.text.domain_name", "adssp.reports.audit_report.total_attempt", "adssp.common.text.type", "adssp.reports.common.text.status"};
    public static final String[] MISC_UI_COLUMNS = new String[]{"NAME", "TIME", "HOST", "DOMAIN_NAME", "NO_OF_ATTEMPT", "ERROR_MESSAGE"};
    public static final String[] MISC_UI_COLUMNS_DISP = new String[]{"adssp.reports.common.text.audit_login_name", "adssp.reports.common.text.time", "adssp.reports.common.text.audit_from_adress", "adssp.common.text.domain_name", "adssp.reports.audit_report.total_attempt", "adssp.reports.common.text.status"};
    public static final String[] CHANGE_PWD_COLUMNS = new String[]{"NAME", "TIME", "HOST", "DOMAIN_NAME", "NO_OF_ATTEMPT", "TYPE", "ERROR_MESSAGE"};
    public static final String[] CHANGE_PWD_COLUMNS_DISP = new String[]{"adssp.reports.common.text.audit_login_name", "adssp.reports.common.text.time", "adssp.reports.common.text.audit_from_adress", "adssp.common.text.domain_name", "adssp.reports.audit_report.total_attempt", "adssp.common.text.type", "adssp.reports.common.text.status"};
    public static final String[] ID_VERIFICATION_UI_COLUMNS = new String[]{"NAME", "TIME", "HOST", "DOMAIN_NAME", "TYPE", "NO_OF_ATTEMPT"};
    public static final String[] ID_VERIFICATION_UI_COLUMNS_DISP = new String[]{"adssp.reports.common.text.audit_login_name", "adssp.reports.common.text.time", "adssp.reports.common.text.audit_from_adress", "adssp.common.text.domain_name", "adssp.common.text.identity_type", "adssp.reports.audit_report.total_attempt"};
    public static final String[] AUDIT_QUERY_COLUMNS = new String[]{"LOGIN_ID", "USER_ID", "NAME", "DOMAIN_NAME", "ERROR_MESSAGE", "HOST", "IP", "TYPE", "STATUS", "TIME", "NO_OF_ATTEMPT"};
    public static final String[] NOTIFY_AUDIT_QUERY_COLUMNS = new String[]{"DOMAIN_NAME", "ERROR_MESSAGE", "TIME", "SENT_COUNT", "ACTION_NAME", "NAME", "NOTIFICATION_TYPE"};
    public static final String[] USER_ATTEMPTS_QUERY_COLUMNS = new String[]{"LOGIN_NAME", "DOMAIN_NAME", "HOST", "IP", "TIME", "TYPE", "STATUS", "ERROR_MESSAGE", "NO_OF_ATTEMPT"};

    public String getDefAuditFilter(String reportId) {
        return USER_ATTEMPTS_IDS.contains(reportId) ? USER_ATTEMPTS_FILTER : (NOTIFY_REPORT_IDS.contains(reportId) ? NOTIFY_FILTER : (RPUA_REPORT_IDS.contains(reportId) ? RPUA_FILTER : (ID_VERIFICATION_REPORT_IDS.contains(reportId) ? ID_VERIFICATION_FILTER : (CHANGE_PWD_IDS.contains(reportId) ? CHANGE_PWD_FILTER : MISC_FILTER))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuditMgmtUtil getInstance() {
        if (handle != null) return handle;
        Class<AuditMgmtUtil> clazz = AuditMgmtUtil.class;
        synchronized (AuditMgmtUtil.class) {
            if (handle != null) return handle;
            handle = new AuditMgmtUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return handle;
        }
    }

    private AuditMgmtUtil() {
        try {
            if (auditTables != null) {
                return;
            }
            final JSONObject TIME = new JSONObject("{'type':BIGINT, \t'desc':'Time at which created',\t\t\t'default':0}");
            final JSONObject HOST = new JSONObject("{'type':NCHAR,\t'desc':'Machine Name', \t      \t\t\t'length':255,\t\t'default':NULL}");
            final JSONObject IP = new JSONObject("{'type':NCHAR,\t'desc':'IP', \t\t       \t\t\t'length':100,\t\t'default':NULL}");
            final JSONObject TYPE = new JSONObject("{'type':NCHAR,\t'desc':'Type of the Action',       \t\t'length':100,\t\t'default':NULL}");
            final JSONObject ACCESS_MODE = new JSONObject("{'type':NCHAR,\t'desc':'Access Mode',   \t       \t\t'length':20 }");
            final JSONObject NAME = new JSONObject("{'type':NCHAR,\t'desc':'Name of the user',       \t\t'length':50,\t\t'default':NULL}");
            final JSONObject DOMAIN_NAME = new JSONObject("{'type':NCHAR,\t'desc':'Domain Name', \t      \t\t\t'length':250,\t\t'default':NULL}");
            final JSONObject ERROR_MESSAGE = new JSONObject("{'type':NCHAR,\t'desc':'Message at the failure',   \t\t'length':2000}");
            final JSONObject DELIVERED_TIME = new JSONObject("{'type':BIGINT,\t'desc':'At what time mail deliverd',\t\t'default':0,\t\t'nullable':false}");
            final JSONObject LOGIN_ID = new JSONObject("{'type':BIGINT,\t'desc':'Login ID of User', \t\t\t'default':0,\t\t'nullable':false}");
            final JSONObject USER_ID = new JSONObject("{'type':BIGINT,\t'desc':'Target User', \t       \t\t\t'default':0,\t\t'nullable':false}");
            final JSONObject LOGIN_NAME = new JSONObject("{'type':NCHAR,\t'desc':'Login Name used to login', \t\t'length':255,\t\t'nullable':false}");
            final JSONObject NOTIFICATION_TYPE = new JSONObject("{'type':NCHAR,\t'desc':'Type of the notification', \t\t'length':200, \t\t'nullable':false}");
            final JSONObject ACTION_NAME = new JSONObject("{'type':NCHAR,\t'desc':'For which action mail has been sent',\t'length':200, \t\t'nullable':false}");
            final JSONObject STATUS = new JSONObject("{'type':INTEGER,\t'desc':'Status of the Action - Boolean values 0 : failure, 1 : Success','nullable':false,'default':0}");
            final JSONObject OBJECT_GUID = new JSONObject("{'type':NCHAR,\t'desc':'GUID of user',\t'length':200, \t\t'nullable':true}");
            final JSONObject TIME_STE = new JSONObject("{'type':BIGINT, \t'desc':'Time at which created',\t\t\t'default':-1,\t   'nullable':false}");
            final JSONObject DELIVERED_TIME_STE = new JSONObject("{'type':BIGINT, \t'desc':'Time at which delivered',\t\t\t'default':-1,\t'nullable':false}");
            final JSONObject NAME_STE = new JSONObject("{'type':NCHAR,\t'desc':'Name of the user',       \t\t'length':255,\t\t'default':'--',\t'nullable':false }");
            final JSONObject NOTIFICATION_TYPE_STE = new JSONObject("{'type':NCHAR,\t'desc':'Notification Type',       \t\t'length':255,\t\t'default':'adssp.reports.audit_report.notification_delivery_report.mail', 'nullable':true}");
            final JSONObject ACTION_NAME_STE = new JSONObject("{'type':NCHAR,\t'desc':'For which action mail has been sent',\t'length':255, 'default':'adssp.reports.audit_report.notification_delivery_report.password_expire_notificaiton', \t\t'nullable':true}");
            sspAudit = new JSONObject(){
                {
                    this.put("COLUMNS", new JSONObject(){
                        {
                            this.put("LOGIN_ID", LOGIN_ID);
                            this.put("USER_ID", USER_ID);
                            this.put("HOST", HOST);
                            this.put("IP", IP);
                            this.put("TIME", TIME);
                            this.put("TYPE", TYPE);
                            this.put("STATUS", STATUS);
                            this.put("ERROR_MESSAGE", ERROR_MESSAGE);
                            this.put("ACCESS_MODE", ACCESS_MODE);
                        }
                    });
                    this.put("INDEX", new String[]{"HOST", "IP"});
                    this.put("FK", new String[][]{{"AaaLogin", "LOGIN_ID"}});
                }
            };
            sspNotificationAudit = new JSONObject(){
                {
                    this.put("COLUMNS", new JSONObject(){
                        {
                            this.put("NAME", NAME);
                            this.put("DOMAIN_NAME", DOMAIN_NAME);
                            this.put("NOTIFICATION_TYPE", NOTIFICATION_TYPE);
                            this.put("ACTION_NAME", ACTION_NAME);
                            this.put("TIME", TIME);
                            this.put("DELIVERED_TIME", DELIVERED_TIME);
                            this.put("ERROR_MESSAGE", ERROR_MESSAGE);
                        }
                    });
                    this.put("INDEX", new String[]{"NAME", "DOMAIN_NAME", "NOTIFICATION_TYPE", "ACTION_NAME"});
                }
            };
            sspUserAttemptsAudit = new JSONObject(){
                {
                    this.put("COLUMNS", new JSONObject(){
                        {
                            this.put("LOGIN_NAME", LOGIN_NAME);
                            this.put("DOMAIN_NAME", DOMAIN_NAME);
                            this.put("HOST", HOST);
                            this.put("IP", IP);
                            this.put("TIME", TIME);
                            this.put("TYPE", TYPE);
                            this.put("STATUS", STATUS);
                            this.put("ERROR_MESSAGE", ERROR_MESSAGE);
                            this.put("ACCESS_MODE", ACCESS_MODE);
                        }
                    });
                    this.put("INDEX", new String[]{"LOGIN_NAME", "TYPE"});
                }
            };
            sspSTEMailAudit = new JSONObject(){
                {
                    this.put("COLUMNS", new JSONObject(){
                        {
                            this.put("USER_UNIQUE_ID", USER_ID);
                            this.put("OBJECT_GUID", OBJECT_GUID);
                            this.put("NAME", NAME_STE);
                            this.put("DOMAIN_NAME", DOMAIN_NAME);
                            this.put("NOTIFICATION_TYPE", NOTIFICATION_TYPE_STE);
                            this.put("ACTION_NAME", ACTION_NAME_STE);
                            this.put("TIME", TIME_STE);
                            this.put("DELIVERED_TIME", DELIVERED_TIME_STE);
                            this.put("STATUS", STATUS);
                            this.put("ERROR_MESSAGE", ERROR_MESSAGE);
                        }
                    });
                    this.put("INDEX", new String[0]);
                    this.put("FK", new String[][]{{"SSPSTEDeliveryStatus", "USER_UNIQUE_ID"}});
                }
            };
            auditTables = new HashMap(){
                {
                    this.put("SSPAUDIT", sspAudit);
                    this.put("SSPNOTIFICATIONAUDIT", sspNotificationAudit);
                    this.put("SSPUSERATTEMPTSAUDIT", sspUserAttemptsAudit);
                    this.put("SSPSTEMAILAUDIT", sspSTEMailAudit);
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String[] getColList(String tableName) {
        try {
            if (auditTables == null) {
                return null;
            }
            if (auditTables.containsKey(tableName)) {
                JSONObject auditTable = (JSONObject)auditTables.get(tableName);
                return JSONObject.getNames((JSONObject)auditTable.getJSONObject("COLUMNS"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

