/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.reports;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.reports.AuditQueryGenerator;
import com.adventnet.sym.adsm.common.server.reports.AuditReportHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class AuditMsSQLGenerator
extends AuditQueryGenerator {
    private StringBuffer subQuery = new StringBuffer();
    private static Logger logger = Logger.getLogger(AuditMsSQLGenerator.class.getName());

    @Override
    public String generateQuery(String reportType, Hashtable inputHash) throws Exception {
        String sqlQuery = "USER_ATTEMPTS".equalsIgnoreCase(reportType) ? this.userAttemptsAuditQuery(reportType, inputHash) : ("NOTIFICATION".equalsIgnoreCase(reportType) ? this.notifyAuditQuery(reportType, inputHash) : this.actionAuditQuery(reportType, inputHash));
        return sqlQuery;
    }

    @Override
    public String getPreviousAttemptQuery(Properties props, String reportType) {
        String sq = "USER_ATTEMPTS".equalsIgnoreCase(reportType) ? this.getUserAttempts(props) : ("NOTIFICATION".equalsIgnoreCase(reportType) ? this.getNotifyAttempts(props) : this.getActionAttempts(props));
        return sq;
    }

    public String actionAuditQuery(String reportType, Hashtable inputHash) {
        String sq = null;
        try {
            if (this.subQuery.length() > 0) {
                this.subQuery = new StringBuffer();
            }
            StringBuffer completeQuery = new StringBuffer();
            this.subQuery.append(super.generateQuery(reportType, inputHash));
            if (this.subQuery.length() > 0) {
                completeQuery.append("SELECT DOMAIN_NAME, NAME, LOGIN_ID, USER_ID, HOST, IP, TYPE, MAX(TIME) AS TIME, MAX(AUDIT_ID) AS AUDIT_ID, COUNT(*) AS NO_OF_ATTEMPT FROM (");
                completeQuery.append(this.subQuery);
                completeQuery.append(") AS groupQuery GROUP BY groupQuery.NAME, groupQuery.IP, groupQuery.DOMAIN_NAME, groupQuery.LOGIN_ID, groupQuery.USER_ID,groupQuery.HOST, groupQuery.TYPE");
                String sortColumn = (String)inputHash.get("SORT_COLUMN");
                if (sortColumn != null) {
                    boolean ascending = (Boolean)inputHash.get("ASCENDING");
                    sq = this.addSortColumn(completeQuery.toString(), sortColumn, ascending);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sq;
    }

    public String getAuditStatusQuery(String baseTable, Hashtable inputHash, String auditIds) {
        StringBuffer statusQuery = new StringBuffer();
        try {
            long fromTime = (Long)inputHash.get("FROM_TIME");
            long toTime = (Long)inputHash.get("TO_TIME");
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(AuditReportHandler.metaDataQuery(fromTime, toTime, baseTable));
            if (!dataObject.isEmpty()) {
                Iterator itr = dataObject.getRows("SSPMETATABLE");
                while (itr.hasNext()) {
                    Row row = (Row)itr.next();
                    String lookUpTableName = (String)row.get("LOOKUP_TABLENAME");
                    statusQuery.append("SELECT ERROR_MESSAGE, STATUS, AUDIT_ID FROM " + lookUpTableName + " WHERE AUDIT_ID IN (" + auditIds + ") UNION ALL ");
                }
            }
            if (AuditReportHandler.isAuditTableExist(baseTable)) {
                statusQuery.append("SELECT ERROR_MESSAGE, STATUS, AUDIT_ID FROM " + baseTable + " WHERE AUDIT_ID IN (" + auditIds + ")");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statusQuery.toString();
    }

    public String notifyAuditQuery(String reportType, Hashtable inputHash) {
        String sq = null;
        try {
            if (this.subQuery.length() > 0) {
                this.subQuery = new StringBuffer();
            }
            StringBuffer completeQuery = new StringBuffer();
            this.subQuery.append(super.generateQuery(reportType, inputHash));
            if (this.subQuery.length() > 0) {
                completeQuery.append("SELECT DOMAIN_NAME, ACTION_NAME, NOTIFICATION_TYPE, NAME, MAX(TIME) AS TIME, MAX(AUDIT_ID) AS AUDIT_ID, COUNT(*) as SENT_COUNT FROM (");
                completeQuery.append(this.subQuery);
                completeQuery.append(") AS mainQuery");
                long filterAsBit = Long.parseLong((String)inputHash.get("FILTER"));
                String[] criterias = this.auditNotifyFilter(filterAsBit);
                String actionQuery = criterias[1];
                if (!actionQuery.equals("")) {
                    completeQuery.append(" WHERE " + actionQuery);
                }
                completeQuery.append(" GROUP BY mainQuery.DOMAIN_NAME, mainQuery.ACTION_NAME, mainQuery.NOTIFICATION_TYPE, mainQuery.NAME");
                String sortColumn = (String)inputHash.get("SORT_COLUMN");
                if (sortColumn != null) {
                    boolean ascending = (Boolean)inputHash.get("ASCENDING");
                    sq = this.addSortColumn(completeQuery.toString(), sortColumn, ascending);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sq;
    }

    public String getNotifyStatusQuery(Hashtable inputHash, String auditIds) {
        StringBuffer statusQuery = new StringBuffer();
        try {
            long fromTime = (Long)inputHash.get("FROM_TIME");
            long toTime = (Long)inputHash.get("TO_TIME");
            long filterAsBit = Long.parseLong((String)inputHash.get("FILTER"));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(AuditReportHandler.metaDataQuery(fromTime, toTime, "SSPNotificationAudit"));
            if (!dataObject.isEmpty()) {
                Iterator itr = dataObject.getRows("SSPMETATABLE");
                while (itr.hasNext()) {
                    Row row = (Row)itr.next();
                    String lookUpTableName = (String)row.get("LOOKUP_TABLENAME");
                    statusQuery.append("SELECT ERROR_MESSAGE, AUDIT_ID,ACTION_NAME FROM " + lookUpTableName + " WHERE AUDIT_ID IN (" + auditIds + ") UNION ALL ");
                }
            }
            if (AuditReportHandler.isAuditTableExist("SSPNotificationAudit")) {
                statusQuery.append("SELECT ERROR_MESSAGE, AUDIT_ID,ACTION_NAME FROM SSPNotificationAudit WHERE AUDIT_ID IN (" + auditIds + ")");
            }
            if (AuditReportHandler.isFilterEnabled(4L, filterAsBit) || AuditReportHandler.isFilterEnabled(8L, filterAsBit) || AuditReportHandler.isFilterEnabled(0x2000000L, filterAsBit) || AuditReportHandler.isFilterEnabled(0x4000000L, filterAsBit)) {
                DataObject backUpObj = CommonUtil.getPersistence(new boolean[0]).get(AuditReportHandler.metaDataQuery(fromTime, toTime, "SSPSTEMailAudit"));
                if (!backUpObj.isEmpty()) {
                    Iterator Itr2 = backUpObj.getRows("SSPMETATABLE");
                    while (Itr2.hasNext()) {
                        Row row = (Row)Itr2.next();
                        String lookUpTableName = (String)row.get("LOOKUP_TABLENAME");
                        if (statusQuery.length() > 0) {
                            statusQuery.append(" UNION ALL ");
                        }
                        statusQuery.append(" SELECT ERROR_MESSAGE, AUDIT_ID,ACTION_NAME FROM " + lookUpTableName + " WHERE AUDIT_ID IN (" + auditIds + ")");
                    }
                }
                if (AuditReportHandler.isAuditTableExist("SSPSTEMailAudit")) {
                    if (statusQuery.length() > 0) {
                        statusQuery.append(" UNION ALL ");
                    }
                    statusQuery.append(" SELECT ERROR_MESSAGE, AUDIT_ID,ACTION_NAME FROM SSPSTEMailAudit WHERE AUDIT_ID IN (" + auditIds + ")");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statusQuery.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getStatusMessage(String framedQuery, Map statusMap, String actionType, Hashtable inputHash) {
        Connection connection = null;
        Statement statement = null;
        Statement preStatement = null;
        ResultSet resultSetObj = null;
        ResultSet rs = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            if (framedQuery != null && !framedQuery.equals("")) {
                StringBuffer auditIds = new StringBuffer();
                resultSetObj = QueryUtil.executeQuery("Getting value from tables", statement, framedQuery, false);
                while (resultSetObj.next()) {
                    Long auditId = null;
                    try {
                        if (auditIds.length() > 0) {
                            auditIds.append(", ");
                        }
                        auditId = resultSetObj.getLong("AUDIT_ID");
                        auditIds.append(auditId);
                    }
                    catch (SQLException sqlEx) {
                        logger.log(Level.INFO, "SQL Exception occured while iterating result set objects....." + sqlEx.getMessage());
                    }
                }
                String statusQuery = "";
                if (auditIds.length() > 0) {
                    statusQuery = actionType.equalsIgnoreCase("NOTIFICATION") ? this.getNotifyStatusQuery(inputHash, auditIds.toString()) : this.getAuditStatusQuery(actionType.equalsIgnoreCase("USER_ATTEMPTS") ? "SSPUserAttemptsAudit" : "SSPAudit", inputHash, auditIds.toString());
                }
                if (statusQuery != null && !statusQuery.equals("")) {
                    resultSetObj = QueryUtil.executeQuery("Getting value from tables", statement, statusQuery);
                    while (resultSetObj.next()) {
                        ArrayList<Object> statusList = new ArrayList<Object>();
                        int statusValue = 1;
                        Long auditIdValue = 0L;
                        String errorMsgValue = "";
                        JSONObject notifyType = new JSONObject();
                        try {
                            if (actionType.equalsIgnoreCase("NOTIFICATION")) {
                                errorMsgValue = resultSetObj.getString("ERROR_MESSAGE");
                                auditIdValue = resultSetObj.getLong("AUDIT_ID");
                                if (statusMap.get(auditIdValue) != null) {
                                    notifyType = (JSONObject)statusMap.get(auditIdValue);
                                }
                                notifyType.put(resultSetObj.getString("ACTION_NAME"), (Object)errorMsgValue);
                                statusMap.put(auditIdValue, notifyType);
                                continue;
                            }
                            errorMsgValue = resultSetObj.getString("ERROR_MESSAGE");
                            statusList.add(errorMsgValue);
                            if (actionType.equalsIgnoreCase("SSP_ACTION") || actionType.equalsIgnoreCase("USER_ATTEMPTS")) {
                                statusValue = resultSetObj.getInt("STATUS");
                                statusList.add(statusValue);
                            }
                            auditIdValue = resultSetObj.getLong("AUDIT_ID");
                            statusMap.put(auditIdValue, statusList);
                        }
                        catch (SQLException sqlEx) {
                            logger.log(Level.INFO, "SQL Exception occured while iterating result set objects....." + sqlEx.getMessage());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSetObj != null) {
                    resultSetObj.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (preStatement != null) {
                    preStatement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getActionAttempts(Properties props) {
        StringBuffer sq = null;
        try {
            sq = new StringBuffer("SELECT LOGIN_ID, ERROR_MESSAGE, USER_ID, HOST, IP, STATUS, TIME from ( ").append(this.subQuery).append("AND TYPE= '").append((String)props.get("AUDIT_TYPE")).append("')  PRETIMETEMP where PRETIMETEMP.LOGIN_ID=").append((Long)props.get("LOGIN_ID")).append(" AND PRETIMETEMP.USER_ID = ").append((Long)props.get("USER_ID")).append(" AND PRETIMETEMP.HOST ='").append(StrUtil.queryEscape((String)props.get("HOST"))).append("' AND PRETIMETEMP.IP ='").append((String)props.get("IP")).append("' ORDER BY TIME DESC");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sq != null ? sq.toString() : null;
    }

    private String getNotifyAttempts(Properties props) {
        StringBuffer sq = null;
        try {
            sq = new StringBuffer("SELECT ERROR_MESSAGE, TIME, ACTION_NAME, DOMAIN_NAME from ( ").append(this.subQuery).append(")  PRETIMETEMP WHERE  ACTION_NAME ='").append(StrUtil.queryEscape((String)props.get("ACTION_NAME"))).append("' AND NOTIFICATION_TYPE = '").append(StrUtil.queryEscape((String)props.get("NOTIFICATION_TYPE"))).append("' AND NAME ='").append(StrUtil.queryEscape((String)props.get("NAME"))).append("' AND DOMAIN_NAME = '").append(StrUtil.queryEscape((String)props.get("DOMAIN_NAME"))).append("' ORDER BY TIME DESC");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sq != null ? sq.toString() : null;
    }

    private String getUserAttempts(Properties props) {
        StringBuffer sq = null;
        try {
            sq = new StringBuffer("SELECT LOGIN_NAME, DOMAIN_NAME, ERROR_MESSAGE, HOST, IP, STATUS, TIME from ( ").append(this.subQuery).append("AND TYPE= '").append((String)props.get("AUDIT_TYPE")).append("')  PRETIMETEMP where PRETIMETEMP.LOGIN_NAME='").append(StrUtil.queryEscape((String)props.get("LOGIN_NAME"))).append("' AND PRETIMETEMP.DOMAIN_NAME = '").append(StrUtil.queryEscape((String)props.get("DOMAIN_NAME"))).append("' AND PRETIMETEMP.HOST ='").append(StrUtil.queryEscape((String)props.get("HOST"))).append("' AND PRETIMETEMP.IP ='").append((String)props.get("IP")).append("' ORDER BY TIME DESC");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sq != null ? sq.toString() : null;
    }

    @Override
    public String getCountQuery(Map countQueryMap) {
        String cntQuery = "";
        try {
            cntQuery = super.getCountQuery(countQueryMap);
            if (!cntQuery.equals("")) {
                cntQuery = "select user_id, ip,type from (" + cntQuery + ") as number_attempts group by user_id, ip,type";
                cntQuery = "select count(user_id) from (" + cntQuery + ") as count_table";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cntQuery;
    }

    @Override
    public String getNavigationQuery(String query, int numOfObjects, int startIndex, String sortColumn) {
        int endIndex = startIndex + numOfObjects;
        String sorting = "";
        if (query.toLowerCase().indexOf("desc") != -1) {
            sorting = "DESC";
        }
        if (sortColumn.equalsIgnoreCase("TIME")) {
            sortColumn = "MAX(TIME)";
        } else if (sortColumn.equalsIgnoreCase("NO_OF_ATTEMPT") || sortColumn.equalsIgnoreCase("SENT_COUNT")) {
            sortColumn = "COUNT(*)";
        }
        query = query.replaceFirst("SELECT ", "SELECT TOP " + endIndex + " ROW_NUMBER() OVER (ORDER BY " + sortColumn + " " + sorting + ") AS ROWNUM, ");
        String finalQuery = "SELECT * FROM (" + query + ") AS limitQuery WHERE limitQuery.ROWNUM BETWEEN " + (startIndex + 1) + " AND " + endIndex;
        return finalQuery;
    }

    @Override
    public String moveOrRenameQuery(String tableName, String newTableName) {
        String sq = "SP_RENAME " + tableName + ", " + newTableName + "; ";
        return sq;
    }

    @Override
    public String getColumnExistQuery(String tableName, String columnName) {
        String sql = "SELECT * FROM SYS.COLUMNS WHERE NAME = N'" + columnName + "' AND OBJECT_ID = OBJECT_ID(N'" + tableName + "')";
        return sql;
    }

    @Override
    public String createTableQuery(String tableName, String newFKName) {
        String createQuery = "";
        if (tableName.equalsIgnoreCase("SSPAudit")) {
            createQuery = "CREATE TABLE SSPAudit (LOGIN_ID bigint NOT NULL default '0', HOST NVARCHAR(255) default NULL, IP NVARCHAR(100) default NULL, USER_ID bigint NOT NULL default '0', TIME bigint default '0', TYPE NVARCHAR(100) default NULL, STATUS int NOT NULL default '0', ERROR_MESSAGE NVARCHAR(2000), ACCESS_MODE NVARCHAR(20), AUDIT_ID bigint NOT NULL, PRIMARY KEY  (AUDIT_ID), CONSTRAINT " + newFKName + " FOREIGN KEY (LOGIN_ID) REFERENCES AaaLogin (LOGIN_ID) ON DELETE CASCADE);";
            createQuery = createQuery + "CREATE INDEX HOSTIndex ON SSPAudit(HOST); CREATE INDEX IPIndex ON SSPAudit(IP);";
            createQuery = createQuery + "CREATE INDEX " + this.getFKIndexName(newFKName) + " ON SSPAudit(LOGIN_ID);";
        } else if (tableName.equalsIgnoreCase("SSPNotificationAudit")) {
            createQuery = "CREATE TABLE SSPNotificationAudit (NAME NVARCHAR(50) default NULL, DOMAIN_NAME NVARCHAR(250) default NULL, NOTIFICATION_TYPE NVARCHAR(200) NOT NULL, ACTION_NAME NVARCHAR(200) NOT NULL, TIME bigint default '0', DELIVERED_TIME bigint NOT NULL default '0', ERROR_MESSAGE NVARCHAR(2000), AUDIT_ID bigint NOT NULL, PRIMARY KEY  (AUDIT_ID));";
            createQuery = createQuery + "CREATE INDEX NAMEIndex ON SSPNotificationAudit(NAME);CREATE INDEX DOMAIN_NAMEIndex ON SSPNotificationAudit(DOMAIN_NAME);CREATE INDEX NOTIFICATION_TYPEIndex ON SSPNotificationAudit(NOTIFICATION_TYPE);CREATE INDEX ACTION_NAMEIndex ON SSPNotificationAudit(ACTION_NAME)";
        } else if (tableName.equalsIgnoreCase("SSPSTEMailAudit")) {
            createQuery = "CREATE TABLE SSPSTEMailAudit (AUDIT_ID bigint NOT NULL, USER_UNIQUE_ID bigint NOT NULL, OBJECT_GUID NVARCHAR(2000), NAME NVARCHAR(250) NOT NULL, DOMAIN_NAME NVARCHAR(2000), NOTIFICATION_TYPE NVARCHAR(2000), ACTION_NAME NVARCHAR(2000), TIME bigint NOT NULL default '-1', DELIVERED_TIME bigint NOT NULL default '-1', STATUS int NOT NULL, ERROR_MESSAGE NVARCHAR(2000), PRIMARY KEY  (AUDIT_ID), CONSTRAINT " + newFKName + " FOREIGN KEY (USER_UNIQUE_ID) REFERENCES sspstedeliverystatus (USER_UNIQUE_ID) ON DELETE CASCADE)";
        } else if (tableName.equalsIgnoreCase("SSPUserAttemptsAudit")) {
            createQuery = "CREATE TABLE " + tableName + " (LOGIN_NAME NVARCHAR(255) NOT NULL, DOMAIN_NAME NVARCHAR(250) default NULL, HOST NVARCHAR(255) default NULL, IP NVARCHAR(100) default NULL, TIME bigint default '0', TYPE NVARCHAR(100) default NULL, STATUS int NOT NULL default '0', ERROR_MESSAGE NVARCHAR(2000), ACCESS_MODE NVARCHAR(20), AUDIT_ID bigint, PRIMARY KEY  (AUDIT_ID));";
            createQuery = createQuery + "CREATE INDEX LOGIN_NAMEIndex ON " + tableName + "(LOGIN_NAME);CREATE INDEX TYPEIndex ON " + tableName + "(TYPE);";
        }
        logger.log(Level.INFO, "creating table for ..." + tableName + " & qry is :::" + createQuery);
        return createQuery;
    }

    public String getActionSubQuery(String baseTable, String auditType, long fromTime, long toTime) {
        StringBuffer sql = null;
        try {
            sql = new StringBuffer("SELECT TOP 100 PERCENT AaaLogin.DOMAINNAME as DOMAIN_NAME, AaaLogin.NAME, ").append(baseTable).append(".LOGIN_ID, ").append(baseTable).append(".USER_ID, HOST, IP, TYPE, TIME AS TIME, AUDIT_ID FROM ").append(baseTable).append(" INNER JOIN AaaLogin ON (").append(baseTable).append(".USER_ID = AaaLogin.USER_ID) WHERE TIME BETWEEN ").append(fromTime).append(" AND ").append(toTime).append(" AND ( TYPE = '").append(auditType).append("')");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sql != null ? sql.toString() : null;
    }

    public String getNotifySubQuery(String baseTable, long fromTime, long toTime) {
        StringBuffer sql = null;
        try {
            sql = new StringBuffer("SELECT ").append(baseTable).append(".AUDIT_ID, ").append(baseTable).append(".DOMAIN_NAME, ").append(baseTable).append(".ERROR_MESSAGE, ").append(baseTable).append(".TIME, ").append(baseTable).append(".NOTIFICATION_TYPE, ").append(baseTable).append(".ACTION_NAME, ").append(baseTable).append(".NAME FROM ").append(baseTable).append(" WHERE TIME BETWEEN ").append(fromTime).append(" AND ").append(toTime).append(" ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sql != null ? sql.toString() : null;
    }

    public String getFKIndexName(String name) {
        name = String.valueOf(name.hashCode()).replace("-", "_");
        return "IDX_" + name;
    }

    public String userAttemptsAuditQuery(String reportType, Hashtable inputHash) {
        String sq = null;
        try {
            if (this.subQuery.length() > 0) {
                this.subQuery = new StringBuffer();
            }
            StringBuffer completeQuery = new StringBuffer();
            this.subQuery.append(super.generateQuery(reportType, inputHash));
            if (this.subQuery.length() > 0) {
                completeQuery.append("SELECT LOGIN_NAME, DOMAIN_NAME, HOST, IP, MAX(TIME) as TIME, TYPE, MAX(AUDIT_ID) AS AUDIT_ID, COUNT(*) AS NO_OF_ATTEMPT FROM (");
                completeQuery.append(this.subQuery);
                completeQuery.append(") AS groupQuery GROUP BY groupQuery.LOGIN_NAME, groupQuery.IP, groupQuery.DOMAIN_NAME, groupQuery.HOST, groupQuery.TYPE");
                String sortColumn = (String)inputHash.get("SORT_COLUMN");
                if (sortColumn != null) {
                    boolean ascending = (Boolean)inputHash.get("ASCENDING");
                    sq = this.addSortColumn(completeQuery.toString(), sortColumn, ascending);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getFKConstraintName(String tableName, Statement statement) {
        String fkConName = "";
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SELECT constraint_name as fkConstraintName FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS where table_name like '" + tableName + "' and constraint_name like '%fk%'");
            while (resultSet.next()) {
                fkConName = resultSet.getString("fkConstraintName");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fkConName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPKConstraintName(String tableName, Statement statement) {
        String pkConName = "";
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SELECT constraint_name as pkConstraintName FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS where table_name like '" + tableName + "' and constraint_name like '%pk%'");
            while (resultSet.next()) {
                pkConName = resultSet.getString("pkConstraintName");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return pkConName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDelConstrainPresent(String fkConName, Statement statement) {
        String delConstraint = "";
        boolean isDelConstrainPresent = false;
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("SELECT delete_rule as delConstraint FROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS where constraint_name = '" + fkConName + "'");
            while (resultSet.next()) {
                delConstraint = resultSet.getString("delConstraint");
                if (!delConstraint.equalsIgnoreCase("cascade")) continue;
                isDelConstrainPresent = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isDelConstrainPresent;
    }
}

