/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.reports;

import com.adventnet.sym.adsm.common.server.reports.AuditQueryGenerator;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class AuditMySQL5Generator
extends AuditQueryGenerator {
    private StringBuffer subQuery = new StringBuffer();

    @Override
    public String generateQuery(String reportType, Hashtable inputHash) throws Exception {
        String sqlQuery = "USER_ATTEMPTS".equalsIgnoreCase(reportType) ? this.userAttemptsAuditQuery(reportType, inputHash) : ("NOTIFICATION".equalsIgnoreCase(reportType) ? this.notifyAuditQuery(reportType, inputHash) : this.actionAuditQuery(reportType, inputHash));
        return sqlQuery;
    }

    @Override
    public String getPreviousAttemptQuery(Properties props, String reportType) {
        String sq = "USER_ATTEMPTS".equalsIgnoreCase(reportType) ? this.getUserAttempts(props) : ("NOTIFICATION".equalsIgnoreCase(reportType) ? this.getNotifyAttempts(props) : this.getActionAttempts(props));
        return sq;
    }

    public String actionAuditQuery(String reportType, Hashtable inputHash) {
        String sq = null;
        try {
            if (this.subQuery.length() > 0) {
                this.subQuery = new StringBuffer();
            }
            StringBuffer completeQuery = new StringBuffer();
            this.subQuery.append(super.generateQuery(reportType, inputHash));
            if (this.subQuery.length() > 0) {
                completeQuery.append("SELECT LOGIN_ID, USER_ID, NAME, DOMAIN_NAME, ERROR_MESSAGE, HOST, IP, TYPE, STATUS, MAX(TIME) as TIME, COUNT(*) as NO_OF_ATTEMPT from ( SELECT * FROM( ");
                completeQuery.append(this.subQuery);
                completeQuery.append(")TEMP1 ORDER BY TIME DESC ) TEMP GROUP BY TEMP.TYPE,TEMP.NAME, TEMP.IP, TEMP.DOMAIN_NAME, TEMP.LOGIN_ID, TEMP.USER_ID,TEMP.HOST");
                String sortColumn = (String)inputHash.get("SORT_COLUMN");
                if (sortColumn != null) {
                    boolean ascending = (Boolean)inputHash.get("ASCENDING");
                    sq = this.addSortColumn(completeQuery.toString(), sortColumn, ascending);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sq;
    }

    public String notifyAuditQuery(String reportType, Hashtable inputHash) {
        String sq = null;
        try {
            if (this.subQuery.length() > 0) {
                this.subQuery = new StringBuffer();
            }
            StringBuffer completeQuery = new StringBuffer();
            this.subQuery.append(super.generateQuery(reportType, inputHash));
            if (this.subQuery.length() > 0) {
                completeQuery.append("SELECT DOMAIN_NAME, ERROR_MESSAGE, MAX(TIME) as TIME, COUNT(*) as SENT_COUNT, ACTION_NAME, NAME, NOTIFICATION_TYPE from (");
                completeQuery.append(this.subQuery.toString());
                completeQuery.append(" ORDER BY TIME DESC ) TEMP ");
                String filter = (String)inputHash.get("FILTER");
                long filterAsBit = filter != null ? Long.parseLong(filter) : 0L;
                String[] criterias = this.auditNotifyFilter(filterAsBit);
                String actionQuery = criterias[1];
                if (!actionQuery.equals("")) {
                    completeQuery.append(" WHERE " + actionQuery);
                }
                completeQuery.append(" GROUP BY TEMP.DOMAIN_NAME,TEMP.ACTION_NAME,TEMP.NOTIFICATION_TYPE,TEMP.NAME");
                String sortColumn = (String)inputHash.get("SORT_COLUMN");
                if (sortColumn != null) {
                    boolean ascending = (Boolean)inputHash.get("ASCENDING");
                    sq = this.addSortColumn(completeQuery.toString(), sortColumn, ascending);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sq;
    }

    public String userAttemptsAuditQuery(String reportType, Hashtable inputHash) {
        String sq = null;
        try {
            if (this.subQuery.length() > 0) {
                this.subQuery = new StringBuffer();
            }
            StringBuffer completeQuery = new StringBuffer();
            this.subQuery.append(super.generateQuery(reportType, inputHash));
            if (this.subQuery.length() > 0) {
                completeQuery.append("SELECT LOGIN_NAME, DOMAIN_NAME, HOST, IP, MAX(TIME) as TIME, TYPE, STATUS, ERROR_MESSAGE, COUNT(*) as NO_OF_ATTEMPT from (");
                completeQuery.append(this.subQuery);
                completeQuery.append(" ORDER BY TIME DESC ) TEMP GROUP BY TEMP.TYPE, TEMP.LOGIN_NAME, TEMP.IP, TEMP.DOMAIN_NAME, TEMP.HOST");
                String sortColumn = (String)inputHash.get("SORT_COLUMN");
                if (sortColumn != null) {
                    boolean ascending = (Boolean)inputHash.get("ASCENDING");
                    sq = this.addSortColumn(completeQuery.toString(), sortColumn, ascending);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sq;
    }

    private String getActionAttempts(Properties props) {
        StringBuffer sq = null;
        try {
            sq = new StringBuffer("SELECT LOGIN_ID, ERROR_MESSAGE, USER_ID, HOST, IP, STATUS, TIME from ( ").append(this.subQuery).append("AND TYPE= '").append((String)props.get("AUDIT_TYPE")).append("')  PRETIMETEMP where PRETIMETEMP.LOGIN_ID=").append((Long)props.get("LOGIN_ID")).append(" AND PRETIMETEMP.USER_ID = ").append((Long)props.get("USER_ID")).append(" AND PRETIMETEMP.HOST ='").append(StrUtil.queryEscape((String)props.get("HOST"))).append("' AND PRETIMETEMP.IP ='").append((String)props.get("IP")).append("' ORDER BY TIME DESC");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sq != null ? sq.toString() : null;
    }

    private String getNotifyAttempts(Properties props) {
        StringBuffer sq = null;
        try {
            sq = new StringBuffer("SELECT ERROR_MESSAGE, TIME, ACTION_NAME, DOMAIN_NAME from ( ").append(this.subQuery).append(")  PRETIMETEMP WHERE  ACTION_NAME ='").append(StrUtil.queryEscape((String)props.get("ACTION_NAME"))).append("' AND NOTIFICATION_TYPE = '").append(StrUtil.queryEscape((String)props.get("NOTIFICATION_TYPE"))).append("' AND NAME ='").append(StrUtil.queryEscape((String)props.get("NAME"))).append("' AND (DOMAIN_NAME = '").append(StrUtil.queryEscape((String)props.get("DOMAIN_NAME"))).append("' OR DOMAIN_NAME = '')").append(" ORDER BY TIME DESC");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sq != null ? sq.toString() : null;
    }

    private String getUserAttempts(Properties props) {
        StringBuffer sq = null;
        try {
            sq = new StringBuffer("SELECT LOGIN_NAME, DOMAIN_NAME, ERROR_MESSAGE, HOST, IP, STATUS, TIME from ( ").append(this.subQuery).append("AND TYPE= '").append((String)props.get("AUDIT_TYPE")).append("')  PRETIMETEMP where PRETIMETEMP.LOGIN_NAME='").append(StrUtil.queryEscape((String)props.get("LOGIN_NAME"))).append("' AND PRETIMETEMP.DOMAIN_NAME = '").append(StrUtil.queryEscape((String)props.get("DOMAIN_NAME"))).append("' AND PRETIMETEMP.HOST ='").append(StrUtil.queryEscape((String)props.get("HOST"))).append("' AND PRETIMETEMP.IP ='").append((String)props.get("IP")).append("' ORDER BY TIME DESC");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sq != null ? sq.toString() : null;
    }

    @Override
    public String getCountQuery(Map countQueryMap) {
        String cntQuery = "";
        try {
            cntQuery = super.getCountQuery(countQueryMap);
            if (!cntQuery.equals("")) {
                cntQuery = "select user_id, ip from (" + cntQuery + ") as number_attempts group by user_id, ip,type";
                cntQuery = "select count(user_id) from (" + cntQuery + ") as count_table";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cntQuery;
    }
}

