/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.reports;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.mysql.QueryGenerator;
import com.adventnet.sym.adsm.common.server.reports.AuditMgmtUtil;
import com.adventnet.sym.adsm.common.server.reports.AuditReportHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.util.QueryUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class AuditQueryGenerator
implements QueryGenerator {
    protected String[] tableNames = new String[]{"SSPAudit", "SSPSTEMailAudit"};
    protected String[] fkColumns = new String[]{"LOGIN_ID", "USER_UNIQUE_ID"};
    protected String[] referenceTableNames = new String[]{"AaaLogin", "SSPSTEDeliveryStatus"};
    private static Logger logger = Logger.getLogger(AuditQueryGenerator.class.getName());

    @Override
    public String generateQuery(String reportType, Hashtable inputHash) throws Exception {
        String sqlQuery = "USER_ATTEMPTS".equalsIgnoreCase(reportType) ? this.getUserAttemptsAuditUnionQuery(inputHash) : ("NOTIFICATION".equalsIgnoreCase(reportType) ? this.getNotifyAuditUnionQuery(inputHash) : this.getActionAuditUnionQuery(inputHash));
        return sqlQuery;
    }

    @Override
    public String getNavigationQuery(String query, int numOfObjects, int startIndex, String sortColumn) {
        return query + " LIMIT " + numOfObjects + " offset " + startIndex;
    }

    public void renameIndex(String oldTableName, String newTableName) {
    }

    @Override
    public String moveOrRenameQuery(String tableName, String newTableName) {
        return "ALTER TABLE " + tableName + " RENAME " + newTableName + ";";
    }

    public String getColumnExistQuery(String tableName, String columnName) {
        return "SHOW COLUMNS FROM `" + tableName + "` LIKE '" + columnName + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isColumnExist(String sql) {
        boolean isColumnExist = false;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery("Getting row if column exist", statement, sql);
            if (resultSet.next()) {
                isColumnExist = true;
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isColumnExist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createTableQuery(String tableName, String newFKName) {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        RelationalAPI relationalAPI = null;
        String createSyntax = "";
        try {
            relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            statement = connection.createStatement();
            String sql = "SHOW CREATE TABLE " + tableName + ";";
            if (sql == null) {
                String string = null;
                return string;
            }
            resultSet = QueryUtil.executeQuery("Dropping and Re-Creating Tablet tables", statement, sql);
            while (resultSet.next()) {
                createSyntax = resultSet.getString(2);
            }
            if (createSyntax != null) {
                int fkNIndex = createSyntax.indexOf("CONSTRAINT");
                int fkNEnding = createSyntax.indexOf("FOREIGN KEY");
                if (fkNIndex != -1 && fkNEnding != -1) {
                    String fkName = createSyntax.substring(fkNIndex, fkNEnding);
                    logger.log(Level.INFO, "OLD FK CONSTRAINT NAME :" + fkName);
                    createSyntax = createSyntax.replace(fkName, "CONSTRAINT `" + newFKName + "` ");
                    logger.log(Level.INFO, "Create table Syntax for [{0}] is [{1}]", new Object[]{tableName, createSyntax});
                }
                createSyntax = this.modifyIndexName(statement, createSyntax, tableName, newFKName);
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return createSyntax;
    }

    public String exportAuditQuery(String reportType, Hashtable inputHash) {
        try {
            String innerQuery = "USER_ATTEMPTS".equalsIgnoreCase(reportType) ? this.getUserAttemptsAuditUnionQuery(inputHash) : ("NOTIFICATION".equalsIgnoreCase(reportType) ? this.getNotifyAuditUnionQuery(inputHash) : this.getActionAuditUnionQuery(inputHash));
            Object ascending = inputHash.get("ASCENDING");
            return this.addSortColumn(innerQuery, (String)inputHash.get("SORT_COLUMN"), ascending != null ? (Boolean)ascending : false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String addSortColumn(String query, String sortColumn, boolean ascending) {
        if (sortColumn != null) {
            query = !ascending ? query + " order by " + sortColumn + " desc " : query + " order by " + sortColumn;
        }
        return query;
    }

    public String getPreviousAttemptQuery(Properties props, String reportType) {
        return null;
    }

    public String getActionAuditUnionQuery(Hashtable inputHash) {
        StringBuffer unionQuery = new StringBuffer();
        try {
            long fromTime = (Long)inputHash.get("FROM_TIME");
            long toTime = (Long)inputHash.get("TO_TIME");
            String filter = (String)inputHash.get("FILTER");
            long filterAsBit = filter != null ? Long.parseLong(filter) : 0L;
            String domainName = (String)inputHash.get("DOMAIN_NAME");
            String searchString = (String)inputHash.get("SEARCH_STRING");
            String auditType = inputHash.get("AUDIT_TYPE").toString();
            ArrayList ouList = (ArrayList)inputHash.get("OULIST");
            if (ouList != null && ouList.size() > 0) {
                ouList = OUUtil.getParentOUs(ouList);
            }
            String filterCrit = this.auditActionFilter(filterAsBit);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(AuditReportHandler.metaDataQuery(fromTime, toTime, "SSPAudit"));
            if (!dataObject.isEmpty()) {
                Iterator itr = dataObject.getRows("SSPMETATABLE");
                while (itr.hasNext()) {
                    Row row = (Row)itr.next();
                    String lookUpTableName = (String)row.get("LOOKUP_TABLENAME");
                    if (unionQuery.length() > 0) {
                        unionQuery.append(" UNION ALL ");
                    }
                    unionQuery.append(this.getActionSubQuery(lookUpTableName, this.getWhereClause(auditType, filterAsBit), domainName, ouList, fromTime, toTime));
                    unionQuery.append(filterCrit).append(this.quickSearchQuery(searchString, lookUpTableName));
                }
            }
            if (AuditReportHandler.isAuditTableExist("SSPAudit")) {
                if (unionQuery.length() > 0) {
                    unionQuery.append(" UNION ALL ");
                }
                unionQuery.append(this.getActionSubQuery("SSPAudit", this.getWhereClause(auditType, filterAsBit), domainName, ouList, fromTime, toTime));
                unionQuery.append(filterCrit).append(this.quickSearchQuery(searchString, "SSPAudit"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unionQuery.toString();
    }

    public String getNotifyAuditUnionQuery(Hashtable inputHash) {
        StringBuffer unionQuery = new StringBuffer();
        try {
            DataObject dataObject;
            long fromTime = (Long)inputHash.get("FROM_TIME");
            long toTime = (Long)inputHash.get("TO_TIME");
            String filter = (String)inputHash.get("FILTER");
            long filterAsBit = filter != null ? Long.parseLong(filter) : 0L;
            String searchString = (String)inputHash.get("SEARCH_STRING");
            String domainName = (String)inputHash.get("DOMAIN_NAME");
            ArrayList ouList = (ArrayList)inputHash.get("OULIST");
            if (ouList != null && ouList.size() > 0) {
                ouList = OUUtil.getParentOUs(ouList);
            }
            String criteria = "";
            String actionQuery = "";
            String[] arrayOfCriteria = new String[]{};
            if (filterAsBit != Long.parseLong("4413477363710")) {
                arrayOfCriteria = this.auditNotifyFilter(filterAsBit);
            }
            if (arrayOfCriteria.length > 0) {
                criteria = arrayOfCriteria[0];
                actionQuery = arrayOfCriteria[1];
            }
            if (!(dataObject = CommonUtil.getPersistence(new boolean[0]).get(AuditReportHandler.metaDataQuery(fromTime, toTime, "SSPNotificationAudit"))).isEmpty()) {
                Iterator itr = dataObject.getRows("SSPMETATABLE");
                while (itr.hasNext()) {
                    Row row = (Row)itr.next();
                    String lookUpTableName = (String)row.get("LOOKUP_TABLENAME");
                    if (unionQuery.length() > 0) {
                        unionQuery.append(" UNION ALL ");
                    }
                    unionQuery.append(this.getNotifySubQuery(lookUpTableName, domainName, ouList, fromTime, toTime));
                    unionQuery.append(criteria).append(this.quickSearchQuery(searchString, lookUpTableName));
                }
            }
            if (AuditReportHandler.isAuditTableExist("SSPNotificationAudit")) {
                if (unionQuery.length() > 0) {
                    unionQuery.append(" UNION ALL ");
                }
                unionQuery.append(this.getNotifySubQuery("SSPNotificationAudit", domainName, ouList, fromTime, toTime));
                unionQuery.append(criteria).append(this.quickSearchQuery(searchString, "SSPNotificationAudit"));
            }
            if (AuditReportHandler.isFilterEnabled(4L, filterAsBit) || AuditReportHandler.isFilterEnabled(8L, filterAsBit) || AuditReportHandler.isFilterEnabled(0x2000000L, filterAsBit) || AuditReportHandler.isFilterEnabled(0x4000000L, filterAsBit)) {
                DataObject backUpObj = CommonUtil.getPersistence(new boolean[0]).get(AuditReportHandler.metaDataQuery(fromTime, toTime, "SSPSTEMailAudit"));
                if (!backUpObj.isEmpty()) {
                    Iterator Itr2 = backUpObj.getRows("SSPMETATABLE");
                    while (Itr2.hasNext()) {
                        Row row = (Row)Itr2.next();
                        String lookUpTableName = (String)row.get("LOOKUP_TABLENAME");
                        if (unionQuery.length() > 0) {
                            unionQuery.append(" UNION ALL ");
                        }
                        unionQuery.append(this.getNotifySubQuery(lookUpTableName, domainName, ouList, fromTime, toTime));
                        unionQuery.append(criteria).append(this.quickSearchQuery(searchString, lookUpTableName));
                    }
                }
                if (AuditReportHandler.isAuditTableExist("SSPSTEMailAudit")) {
                    if (unionQuery.length() > 0) {
                        unionQuery.append(" UNION ALL ");
                    }
                    unionQuery.append(this.getNotifySubQuery("SSPSTEMailAudit", domainName, ouList, fromTime, toTime));
                    unionQuery.append(criteria).append(this.quickSearchQuery(searchString, "SSPSTEMailAudit"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unionQuery.toString();
    }

    public String getUserAttemptsAuditUnionQuery(Hashtable inputHash) {
        StringBuffer unionQuery = new StringBuffer();
        try {
            long fromTime = (Long)inputHash.get("FROM_TIME");
            long toTime = (Long)inputHash.get("TO_TIME");
            String filter = (String)inputHash.get("FILTER");
            long filterAsBit = filter != null ? Long.parseLong(filter) : 0L;
            String searchString = (String)inputHash.get("SEARCH_STRING");
            String baseTable = "SSPUserAttemptsAudit";
            String filterAndSearchCrit = "";
            if (!filter.equals("167282133042688") || searchString != null && !searchString.equals("")) {
                filterAndSearchCrit = this.auditUserAttemptsFilter(searchString, filterAsBit, baseTable);
            }
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(AuditReportHandler.metaDataQuery(fromTime, toTime, baseTable));
            String[] colList = AuditMgmtUtil.getInstance().getColList(baseTable.toUpperCase());
            if (!dataObject.isEmpty()) {
                Iterator itr = dataObject.getRows("SSPMETATABLE");
                while (itr.hasNext()) {
                    Row row = (Row)itr.next();
                    String lookUpTableName = (String)row.get("LOOKUP_TABLENAME");
                    if (unionQuery.length() > 0) {
                        unionQuery.append(" UNION ALL ");
                    }
                    unionQuery.append(this.getUserAttemptsSubQuery(lookUpTableName, colList, fromTime, toTime));
                    unionQuery.append(filterAndSearchCrit).append(this.quickSearchQuery(searchString, lookUpTableName));
                }
            }
            if (AuditReportHandler.isAuditTableExist(baseTable)) {
                if (unionQuery.length() > 0) {
                    unionQuery.append(" UNION ALL ");
                }
                unionQuery.append(this.getUserAttemptsSubQuery(baseTable, colList, fromTime, toTime));
                unionQuery.append(filterAndSearchCrit).append(this.quickSearchQuery(searchString, baseTable));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return unionQuery.toString();
    }

    private String getActionSubQuery(String baseTable, String whereClause, String domainName, ArrayList ouList, long fromTime, long toTime) {
        StringBuffer sql = null;
        try {
            sql = new StringBuffer("SELECT  AaaLogin.DOMAINNAME as DOMAIN_NAME, AaaLogin.NAME, ").append(baseTable).append(".LOGIN_ID, ").append(baseTable).append(".USER_ID, ").append("HOST, IP, TYPE, TIME AS TIME, ERROR_MESSAGE, STATUS, AUDIT_ID  FROM ").append(baseTable).append(" INNER JOIN AaaLogin ON (").append(baseTable).append(".USER_ID = AaaLogin.USER_ID)");
            if (domainName != null) {
                String domainTableName = CommonUtil.getDomainUserTableName(domainName);
                sql = sql.append(" INNER JOIN ").append(domainTableName).append(" USERS on AaaLogin.NAME = USERS.SAM_ACCOUNT_NAME");
                sql = sql.append(" WHERE AaaLogin.DOMAINNAME = '").append(domainName).append("'");
                if (ouList != null) {
                    int size = ouList.size();
                    String dbServerName = PersistenceInitializer.getConfigurationValue((String)"DBName");
                    for (int i = 0; i < size; ++i) {
                        String ouName = (String)ouList.get(i);
                        if (ouName == null) continue;
                        if (i == 0) {
                            sql.append(" AND (");
                        }
                        sql = "mysql".equalsIgnoreCase(dbServerName) ? sql.append(" DN_STRING like '%").append(QueryUtil.mySqlCritEscape(ouName)).append("'") : sql.append(" DN_STRING like '%").append(QueryUtil.criteriaEscape(ouName)).append("'");
                        if (i != size - 1) {
                            sql.append(" OR ");
                            continue;
                        }
                        if ("mysql".equalsIgnoreCase(dbServerName)) {
                            sql = sql.append(" escape '\\\\'");
                        } else if ("mssql".equalsIgnoreCase(dbServerName)) {
                            sql = sql.append(" escape '\\'");
                        }
                        sql.append(")");
                    }
                }
            }
            sql = sql.append(" AND TIME BETWEEN ").append(fromTime).append(" AND ").append(toTime).append(" AND (").append(whereClause).append(")");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sql.toString();
    }

    private String getNotifySubQuery(String baseTable, String domainName, ArrayList ouList, long fromTime, long toTime) {
        StringBuffer sql = null;
        try {
            sql = new StringBuffer("SELECT ").append(baseTable).append(".AUDIT_ID, ").append(baseTable).append(".DOMAIN_NAME, ").append(baseTable).append(".ERROR_MESSAGE, ").append(baseTable).append(".TIME, ").append(baseTable).append(".NOTIFICATION_TYPE, ").append(baseTable).append(".ACTION_NAME, ").append(baseTable).append(".NAME FROM ").append(baseTable);
            if (domainName != null) {
                String domainTableName = CommonUtil.getDomainUserTableName(domainName);
                sql = sql.append(" INNER JOIN ").append(domainTableName).append(" USERS ON " + baseTable + ".NAME = USERS.SAM_ACCOUNT_NAME");
                sql = sql.append(" WHERE (" + baseTable + ".DOMAIN_NAME = '").append(domainName).append("'").append(" OR ").append(baseTable).append(".DOMAIN_NAME='')");
                if (ouList != null) {
                    int size = ouList.size();
                    String dbServerName = PersistenceInitializer.getConfigurationValue((String)"DBName");
                    for (int i = 0; i < size; ++i) {
                        String ouName = (String)ouList.get(i);
                        if (ouName == null) continue;
                        if (i == 0) {
                            sql.append(" AND (");
                        }
                        sql = "mysql".equalsIgnoreCase(dbServerName) ? sql.append(" DN_STRING like '%").append(QueryUtil.mySqlCritEscape(ouName)).append("'") : sql.append(" DN_STRING like '%").append(QueryUtil.criteriaEscape(ouName)).append("'");
                        if (i != size - 1) {
                            sql.append(" OR ");
                            continue;
                        }
                        if ("mysql".equalsIgnoreCase(dbServerName)) {
                            sql = sql.append(" escape '\\\\'");
                        } else if ("mssql".equalsIgnoreCase(dbServerName)) {
                            sql = sql.append(" escape '\\'");
                        }
                        sql.append(")");
                    }
                }
                sql = sql.append(" AND ");
            } else {
                sql.append(" WHERE ");
            }
            sql = sql.append("TIME BETWEEN ").append(fromTime).append(" AND ").append(toTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sql.toString();
    }

    private String getUserAttemptsSubQuery(String baseTable, String[] colList, long fromTime, long toTime) {
        StringBuffer sql = null;
        try {
            sql = new StringBuffer("SELECT AUDIT_ID");
            for (int i = 0; i < colList.length; ++i) {
                sql.append(", ").append(colList[i]);
            }
            sql.append(" FROM ").append(baseTable).append(" WHERE TIME BETWEEN ").append(fromTime).append(" AND ").append(toTime).append(" ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sql.toString();
    }

    private String auditActionFilter(long filterAsBit) {
        String query = "";
        try {
            if (AuditReportHandler.isFilterEnabled(512L, filterAsBit) && AuditReportHandler.isFilterEnabled(1024L, filterAsBit) || AuditReportHandler.isFilterEnabled(32768L, filterAsBit) && AuditReportHandler.isFilterEnabled(65536L, filterAsBit) && AuditReportHandler.isFilterEnabled(0x200000L, filterAsBit) && AuditReportHandler.isFilterEnabled(0x800000000L, filterAsBit) && AuditReportHandler.isFilterEnabled(0x1000000000L, filterAsBit) && AuditReportHandler.isFilterEnabled(0x4000000000L, filterAsBit) && AuditReportHandler.isFilterEnabled(0x8000000000L, filterAsBit) && AuditReportHandler.isFilterEnabled(0x10000000000L, filterAsBit) && AuditReportHandler.isFilterEnabled(0x20000000000L, filterAsBit)) {
                query = "";
            } else if (AuditReportHandler.isFilterEnabled(512L, filterAsBit)) {
                query = " AND (ERROR_MESSAGE = 'adssp.common.text.success' OR STATUS= 1) ";
            } else if (AuditReportHandler.isFilterEnabled(1024L, filterAsBit)) {
                query = " AND (ERROR_MESSAGE != 'adssp.common.text.success' AND ERROR_MESSAGE != 'NULL' AND STATUS != 1) ";
            } else {
                boolean flag = false;
                query = " AND (";
                if (AuditReportHandler.isFilterEnabled(32768L, filterAsBit)) {
                    query = query + "(TYPE='audit.action.security_ques')";
                    flag = true;
                }
                if (AuditReportHandler.isFilterEnabled(65536L, filterAsBit)) {
                    if (flag) {
                        query = query + " OR ";
                    } else {
                        flag = true;
                    }
                    query = query + "(TYPE='audit.action.verification_code')";
                }
                if (AuditReportHandler.isFilterEnabled(0x200000L, filterAsBit)) {
                    if (flag) {
                        query = query + " OR ";
                    } else {
                        flag = true;
                    }
                    query = query + "(TYPE='audit.action.authenticator_code')";
                }
                if (AuditReportHandler.isFilterEnabled(0x800000000L, filterAsBit)) {
                    if (flag) {
                        query = query + " OR ";
                    } else {
                        flag = true;
                    }
                    query = query + "(TYPE='audit.action.rsa_authentication')";
                }
                if (AuditReportHandler.isFilterEnabled(0x1000000000L, filterAsBit)) {
                    if (flag) {
                        query = query + " OR ";
                    } else {
                        flag = true;
                    }
                    query = query + "(TYPE='audit.action.radius_authentication')";
                }
                if (AuditReportHandler.isFilterEnabled(0x4000000000L, filterAsBit)) {
                    if (flag) {
                        query = query + " OR ";
                    } else {
                        flag = true;
                    }
                    query = query + "(TYPE='audit.action.mobile_app_auth.push')";
                }
                if (AuditReportHandler.isFilterEnabled(0x8000000000L, filterAsBit)) {
                    if (flag) {
                        query = query + " OR ";
                    } else {
                        flag = true;
                    }
                    query = query + "(TYPE='audit.action.mobile_app_auth.finger_print')";
                }
                if (AuditReportHandler.isFilterEnabled(0x10000000000L, filterAsBit)) {
                    if (flag) {
                        query = query + " OR ";
                    } else {
                        flag = true;
                    }
                    query = query + "(TYPE='audit.action.mobile_app_auth.qr_code')";
                }
                if (AuditReportHandler.isFilterEnabled(0x20000000000L, filterAsBit)) {
                    if (flag) {
                        query = query + " OR ";
                    }
                    query = query + "(TYPE='audit.action.mobile_app_auth.totp')";
                }
                query = query + ")";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return query;
    }

    public String[] auditNotifyFilter(long filterAsBit) {
        String[] criterias = new String[3];
        String criteria = "";
        try {
            criteria = AuditReportHandler.constructCondition(filterAsBit);
            int notificationFilterLen = 0;
            int actionFilterLen = 0;
            String tempStr = AuditReportHandler.generateReportQuery(filterAsBit, AuditMgmtUtil.NOTIFICATION_IDS, AuditMgmtUtil.NOTIFICATIONS_CONDITION, " NOTIFICATION_TYPE = ");
            String[] notificationConditions = tempStr.split(",");
            tempStr = AuditReportHandler.generateReportQuery(filterAsBit, AuditMgmtUtil.MAIL_IDS, AuditMgmtUtil.MAIL_ACTIONS, " ACTION_NAME = ");
            String[] actionConditions = tempStr.split(",");
            notificationFilterLen = notificationConditions.length;
            actionFilterLen = actionConditions.length;
            String actionQuery = "";
            for (int i = 0; i < notificationFilterLen; ++i) {
                String str = notificationConditions[i];
                for (int j = 0; j < actionFilterLen; ++j) {
                    if (!actionQuery.equals("")) {
                        actionQuery = actionQuery + " OR";
                    }
                    actionQuery = actionQuery + "(" + str + "AND " + actionConditions[j] + ")";
                }
            }
            if (!actionQuery.equals("")) {
                criteria = criteria + " AND (" + actionQuery + ")";
            }
            criterias[0] = criteria;
            criterias[1] = actionQuery;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return criterias;
    }

    private String auditUserAttemptsFilter(String searchString, long filterAsBit, String tableName) {
        String query = "";
        try {
            if (AuditReportHandler.isFilterEnabled(512L, filterAsBit) && AuditReportHandler.isFilterEnabled(1024L, filterAsBit)) {
                query = "";
            } else if (AuditReportHandler.isFilterEnabled(512L, filterAsBit)) {
                query = " AND STATUS = 1 ";
            } else if (AuditReportHandler.isFilterEnabled(1024L, filterAsBit)) {
                query = " AND STATUS = 0 ";
            }
            String userAttemptsQuery = AuditReportHandler.constructingCriteria(filterAsBit, AuditMgmtUtil.USR_ATTEMPTS_IDS, AuditMgmtUtil.USER_ATTEMPTS, " TYPE = ");
            if (!userAttemptsQuery.equals("")) {
                query = query + " AND (" + userAttemptsQuery + ")";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return query;
    }

    public String getCountQuery(Map countQueryMap) {
        StringBuffer cntQuery = new StringBuffer();
        try {
            long startTime = (Long)countQueryMap.get("startTime");
            long endTime = (Long)countQueryMap.get("endTime");
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(AuditReportHandler.metaDataQuery(startTime, endTime, "SSPAudit"));
            if (AuditReportHandler.isAuditTableExist("SSPAudit")) {
                cntQuery.append(this.getCountQuery("SSPAudit", countQueryMap));
                if (!dataObject.isEmpty()) {
                    Iterator Itr2 = dataObject.getRows("SSPMETATABLE");
                    while (Itr2.hasNext()) {
                        Row row = (Row)Itr2.next();
                        String tableName = (String)row.get("LOOKUP_TABLENAME");
                        cntQuery.append(" union all ");
                        cntQuery.append(this.getCountQuery(tableName, countQueryMap));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cntQuery.toString();
    }

    private String getCountQuery(String tableName, Map countQueryMap) {
        StringBuffer sql = null;
        try {
            String status = "";
            String domain = (String)countQueryMap.get("domain");
            long startTime = (Long)countQueryMap.get("startTime");
            long endTime = (Long)countQueryMap.get("endTime");
            String reportType = (String)countQueryMap.get("reportType");
            sql = new StringBuffer("SELECT ").append(tableName).append(".USER_ID, ").append(tableName).append(".IP, ").append(tableName).append(".TYPE ").append(" FROM ").append(tableName).append(" inner join AaaLogin on ").append(tableName).append(".LOGIN_ID=AaaLogin.LOGIN_ID ");
            if (domain != null) {
                String domainUsersTable = CommonUtil.getDomainUserTableName(domain);
                sql = sql.append("inner join ").append(domainUsersTable).append(" on AaaLogin.name = ").append(domainUsersTable).append(".SAM_ACCOUNT_NAME ");
            }
            sql = sql.append(" where ");
            int size = 0;
            ArrayList ouList = null;
            if (countQueryMap.containsKey("OULIST")) {
                ouList = (ArrayList)countQueryMap.get("OULIST");
                size = ouList.size();
            }
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    String ouName = (String)ouList.get(i);
                    if (ouName == null) continue;
                    if (i == 0) {
                        sql = sql.append(" (");
                    }
                    sql = sql.append(" DN_STRING like '%").append(QueryUtil.criteriaEscape(ouName)).append("'");
                    sql = i != size - 1 ? sql.append(" OR ") : sql.append(") and ");
                }
            }
            sql = sql.append(tableName).append(".time>").append(startTime).append(" and ").append(tableName + ".time<").append(endTime).append(" and ").append(tableName).append(".type IN (").append(reportType).append(")");
            status = reportType.lastIndexOf("audit.action.security_ques") != -1 || reportType.lastIndexOf("audit.action.verification_code") != -1 ? "0" : "1";
            sql = sql.append(" and ").append(tableName).append(".status=").append(status).append(" and AaaLogin.domainname='").append(domain).append("'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sql == null ? "" : sql.toString();
    }

    public int getResetUnlockCount(Map countQueryMap, String auditType) {
        int reportCnt = 0;
        try {
            long startTime = (Long)countQueryMap.get("startTime");
            long endTime = (Long)countQueryMap.get("endTime");
            String domain = (String)countQueryMap.get("domain");
            Long userId = (Long)countQueryMap.get("userId");
            String tableName = "SSPAudit";
            String type = auditType.equals("reset") ? "audit.action.reset_pwd" : (auditType.equals("unlock") ? "audit.action.unlocked" : "");
            String[] accessModes = new String[]{"WebPage", "NApp_IOS", "NApp_Android", "MApp", "GINA"};
            if (AuditReportHandler.isAuditTableExist("SSPAudit")) {
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"USER_ID"), (Object)userId, 0);
                crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"TIME"), (Object)startTime, 4));
                crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"TIME"), (Object)endTime, 6));
                crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"STATUS"), (Object)Character.valueOf('1'), 0));
                crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"TYPE"), (Object)type, 0));
                crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"ERROR_MESSAGE"), (Object)"adssp.common.text.success", 0));
                crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"ACCESS_MODE"), (Object)accessModes, 8));
                DataObject d = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                reportCnt = d.size(tableName);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(AuditReportHandler.metaDataQuery(startTime, endTime, "SSPAudit"));
                if (!dataObject.isEmpty()) {
                    Iterator Itr2 = dataObject.getRows("SSPMETATABLE");
                    while (Itr2.hasNext()) {
                        Row row = (Row)Itr2.next();
                        tableName = (String)row.get("LOOKUP_TABLENAME");
                        Criteria crite = new Criteria(Column.getColumn((String)tableName, (String)"USER_ID"), (Object)userId, 0);
                        crite = crite.and(new Criteria(Column.getColumn((String)tableName, (String)"TIME"), (Object)startTime, 4));
                        crite = crite.and(new Criteria(Column.getColumn((String)tableName, (String)"TIME"), (Object)endTime, 6));
                        crite = crite.and(new Criteria(Column.getColumn((String)tableName, (String)"STATUS"), (Object)Character.valueOf('1'), 0));
                        crite = crite.and(new Criteria(Column.getColumn((String)tableName, (String)"TYPE"), (Object)type, 0));
                        crite = crite.and(new Criteria(Column.getColumn((String)tableName, (String)"ERROR_MESSAGE"), (Object)"adssp.common.text.success", 0));
                        DataObject da = CommonUtil.getPersistence(new boolean[0]).get(tableName, crite);
                        Iterator iter = da.getRows(tableName);
                        while (iter.hasNext()) {
                            Row ro = (Row)iter.next();
                            ++reportCnt;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reportCnt;
    }

    public String quickSearchQuery(String searchString, String baseTable) {
        String LIKE;
        String selectQuery = "";
        String dbServerName = PersistenceInitializer.getConfigurationValue((String)"DBName");
        String string = LIKE = dbServerName.equalsIgnoreCase("postgres") ? "ILIKE" : "LIKE";
        if (searchString != null && searchString != "") {
            String[] splittedStr;
            for (String param : splittedStr = searchString.split(Pattern.quote("||"))) {
                String[] arr = param.split("=", 2);
                String tableName = baseTable;
                if (arr[0].equalsIgnoreCase("NAME")) {
                    tableName = "USERS";
                    arr[0] = "SAM_ACCOUNT_NAME";
                }
                selectQuery = selectQuery + " AND " + tableName + "." + arr[0] + " " + LIKE + " '%" + QueryUtil.criteriaEscape(arr[1]) + "%'";
            }
        }
        return selectQuery;
    }

    public void getStatusMessage(String framedQuery, Map statusMap, String actionType, Hashtable inputHash) {
    }

    public String getWhereClause(String auditType, long filterAsBit) {
        StringBuilder whereClause = null;
        if (auditType.equals("'audit.action.unlocked'")) {
            StringBuilder stringBuilder = whereClause = AuditReportHandler.isFilterEnabled(8192L, filterAsBit) ? new StringBuilder("TYPE = ").append(auditType) : null;
            if (AuditReportHandler.isFilterEnabled(16384L, filterAsBit)) {
                whereClause = whereClause == null ? new StringBuilder(" ") : whereClause.append(" OR ");
                whereClause = whereClause.append("TYPE = 'audit.action.automatic_unlock'");
            }
        } else if (auditType.equals("'audit.action.reset_pwd'")) {
            StringBuilder stringBuilder = whereClause = AuditReportHandler.isFilterEnabled(8192L, filterAsBit) ? new StringBuilder("TYPE = ").append(auditType) : null;
            if (AuditReportHandler.isFilterEnabled(16384L, filterAsBit)) {
                whereClause = whereClause == null ? new StringBuilder(" ") : whereClause.append(" OR ");
                whereClause = whereClause.append("TYPE = 'audit.action.automatic_reset_pwd'");
            }
        } else if (auditType.contains("'audit.action.change_pwd'")) {
            StringBuilder stringBuilder = whereClause = AuditReportHandler.isFilterEnabled(0x200000000000L, filterAsBit) ? new StringBuilder("TYPE = ").append("'audit.action.change_pwd'") : null;
            if (AuditReportHandler.isFilterEnabled(0x400000000000L, filterAsBit)) {
                whereClause = whereClause == null ? new StringBuilder(" ") : whereClause.append(" OR ");
                whereClause = whereClause.append("TYPE = 'adssp.audit.change_pwd.umcp'");
            }
        } else {
            whereClause = new StringBuilder("TYPE IN (").append(auditType).append(")");
        }
        return whereClause.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String modifyIndexName(Statement statement, String createSyntax, String tableName, String newFKName) {
        ResultSet resultSet = null;
        try {
            String indexQuery = "SHOW INDEX FROM SSPAudit";
            resultSet = QueryUtil.executeQuery("Getting Foreign Key Constraint Name From SSPAudit", statement, indexQuery);
            while (resultSet.next()) {
                String indexName = resultSet.getString("Key_name");
                logger.log(Level.INFO, "indexName :: " + indexName);
                if (!indexName.startsWith("SSPAudit_FK") || !indexName.endsWith("_IDX")) continue;
                createSyntax = createSyntax.replace(indexName, newFKName + "_IDX");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return createSyntax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFKConstraintName(String tableName, Statement statement) {
        String createSyntax = "";
        String fkConName = "";
        ResultSet resultSet = null;
        try {
            String sql = "SHOW CREATE TABLE " + tableName + ";";
            if (sql == null) {
                String string = null;
                return string;
            }
            resultSet = QueryUtil.executeQuery("Getting show create table", statement, sql);
            while (resultSet.next()) {
                createSyntax = resultSet.getString(2);
            }
            if (createSyntax != null) {
                int fkNIndex = createSyntax.indexOf("CONSTRAINT") + 12;
                int fkNEnding = createSyntax.indexOf("FOREIGN KEY") - 2;
                if (fkNIndex != -1 && fkNEnding != -1) {
                    fkConName = createSyntax.substring(fkNIndex, fkNEnding);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fkConName;
    }

    public String getPKConstraintName(String tableName, Statement statement) {
        String pkConName = "";
        return pkConName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String RowCount(String tableName, Statement statement) {
        String count = "0";
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery("select count(*) from " + tableName);
            while (resultSet.next()) {
                count = resultSet.getString(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return count;
    }

    public void dropConstraint(String tableName, String fkConName, Statement statement) {
        try {
            String dropConstQuery = "ALTER TABLE " + tableName + " DROP CONSTRAINT " + fkConName + ";";
            QueryUtil.executeUpdate("dropConstQuery", statement, dropConstQuery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getFalse() {
        return "0";
    }

    public String getTrue() {
        return "1";
    }

    public boolean isDelConstrainPresent(String fkConName, Statement statement) {
        return false;
    }
}

