/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.reports.AuditQueryGenerator;
import com.adventnet.sym.adsm.common.server.util.MoveRecreateTableHandler;
import com.adventnet.sym.adsm.common.server.util.QueryGeneratorFactory;
import com.adventnet.sym.adsm.common.server.util.QueryUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AuditReportHandler {
    private static Logger logger = Logger.getLogger(AuditReportHandler.class.getName());

    public static SelectQuery metaDataQuery(long fromTime, long toTime, String tableName) {
        logger.log(Level.INFO, "FromTime : " + fromTime + ". ToTime : " + toTime);
        SelectQueryImpl stQuery = new SelectQueryImpl(new Table("SSPMETATABLE"));
        Criteria sCrit = new Criteria(Column.getColumn((String)"SSPMETATABLE", (String)"START_TIME"), (Object)fromTime, 4);
        sCrit = sCrit.and(new Criteria(Column.getColumn((String)"SSPMETATABLE", (String)"START_TIME"), (Object)toTime, 6));
        Criteria eCrit = new Criteria(Column.getColumn((String)"SSPMETATABLE", (String)"END_TIME"), (Object)fromTime, 4);
        eCrit = eCrit.and(new Criteria(Column.getColumn((String)"SSPMETATABLE", (String)"END_TIME"), (Object)toTime, 6));
        Criteria common = new Criteria(Column.getColumn((String)"SSPMETATABLE", (String)"START_TIME"), (Object)0, 0);
        Criteria fCrit = sCrit.or(eCrit).or(common);
        fCrit = fCrit.and(new Criteria(Column.getColumn((String)"SSPMETATABLE", (String)"TABLE_NAME"), (Object)tableName, 0, false));
        stQuery.setCriteria(fCrit);
        stQuery.addSelectColumn(Column.getColumn((String)"SSPMETATABLE", (String)"*"));
        return stQuery;
    }

    public static boolean isAuditTableExist(String tableName) {
        boolean exist = true;
        try {
            Row r = new Row(tableName);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in checkTable. " + tableName + " does not exist !");
            exist = false;
        }
        return exist;
    }

    public static void checkForBackUp(String tableName) {
        try {
            AuditQueryGenerator qgObj = QueryGeneratorFactory.getInstance();
            String query = "SELECT COUNT(*) FROM " + tableName;
            int rowsCount = QueryUtil.getRowsCount(query);
            if (rowsCount >= 500000) {
                MoveRecreateTableHandler.getInstance().moveRecreateTable(tableName, qgObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isFilterEnabled(long compare, long filter) {
        try {
            if ((compare & filter) == compare) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String constructingCriteria(long filterAsBit, long[] filters, String[] actions, String criteria) {
        String query = "";
        for (int i = 0; i < filters.length; ++i) {
            if (!AuditReportHandler.isFilterEnabled(filters[i], filterAsBit)) continue;
            query = query.equals("") ? criteria + "'" + actions[i] + "'" : query + " OR " + criteria + "'" + actions[i] + "'";
        }
        return query;
    }

    public static String constructCondition(long filterAsBit) {
        String criteria = "";
        if (AuditReportHandler.isFilterEnabled(512L, filterAsBit) && AuditReportHandler.isFilterEnabled(1024L, filterAsBit)) {
            criteria = "";
        } else if (AuditReportHandler.isFilterEnabled(512L, filterAsBit)) {
            criteria = " AND ERROR_MESSAGE IN ('adssp.common.text.success','ads.push_notification.pn_sent_success_txt')";
        } else if (AuditReportHandler.isFilterEnabled(1024L, filterAsBit)) {
            criteria = " AND ERROR_MESSAGE NOT IN ('adssp.common.text.success','ads.push_notification.pn_sent_success_txt')";
        }
        return criteria;
    }

    public static String generateReportQuery(long filterAsBit, long[] filters, String[] actions, String criteria) {
        String squery = "";
        for (int i = 0; i < filters.length; ++i) {
            if (!AuditReportHandler.isFilterEnabled(filters[i], filterAsBit)) continue;
            if (filters[i] == 0x400000L) {
                if (AuditReportHandler.isFilterEnabled(0x800000L, filterAsBit) && AuditReportHandler.isFilterEnabled(0x1000000L, filterAsBit)) {
                    squery = squery + criteria + "'" + actions[i] + "',";
                    squery = squery + criteria + "'" + actions[++i] + "',";
                    continue;
                }
                if (AuditReportHandler.isFilterEnabled(0x800000L, filterAsBit)) {
                    squery = squery + criteria + "'" + actions[i] + "',";
                    continue;
                }
                if (!AuditReportHandler.isFilterEnabled(0x1000000L, filterAsBit)) continue;
                squery = squery + criteria + "'" + actions[++i] + "',";
                continue;
            }
            squery = squery + criteria + "'" + actions[i] + "',";
        }
        return squery;
    }
}

