/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.reports;

import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.ForeignKeyColumnDefinition;
import com.adventnet.db.persistence.metadata.ForeignKeyDefinition;
import com.adventnet.db.persistence.metadata.IndexDefinition;
import com.adventnet.db.persistence.metadata.PrimaryKeyDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.UniqueValueGeneration;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.sym.adsm.common.server.reports.AuditMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class CreateAuditTable {
    public static boolean create(String tableName) {
        Logger logger = Logger.getLogger(CreateAuditTable.class.getName());
        try {
            TableDefinition tableDef = new TableDefinition();
            tableDef.setTableName(tableName);
            CreateAuditTable.fillColumns(tableDef);
            ColumnDefinition keyCol = new ColumnDefinition();
            keyCol.setColumnName("AUDIT_ID");
            keyCol.setDescription("Unique ID");
            keyCol.setDataType("BIGINT");
            keyCol.setNullable(false);
            UniqueValueGeneration uniq = new UniqueValueGeneration();
            uniq.setGeneratorName(tableName + ".AUDIT_ID");
            uniq.setNameColumn("AUDIT_ID");
            keyCol.setUniqueValueGeneration(uniq);
            tableDef.addColumnDefinition(keyCol);
            PrimaryKeyDefinition pkDef = new PrimaryKeyDefinition();
            pkDef.setName(tableName + "_PK" + System.currentTimeMillis());
            pkDef.addColumnName("AUDIT_ID");
            pkDef.setTableName(tableName);
            tableDef.setPrimaryKey(pkDef);
            CommonUtil.getPersistence(new boolean[0]).createTable("adssp", tableDef);
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage();
            logger.log(Level.INFO, "Exception message :  " + message);
            return false;
        }
        return true;
    }

    private static void fillColumns(TableDefinition def) {
        try {
            int i;
            String tableName = def.getTableName().toUpperCase();
            AuditMgmtUtil.getInstance();
            JSONObject table = (JSONObject)AuditMgmtUtil.auditTables.get(tableName);
            JSONObject columns = table.getJSONObject("COLUMNS");
            String[] columnNames = JSONObject.getNames((JSONObject)columns);
            String[] indexColumns = (String[])table.get("INDEX");
            for (i = 0; i < columnNames.length; ++i) {
                ColumnDefinition coldef = new ColumnDefinition();
                JSONObject column = columns.getJSONObject(columnNames[i]);
                boolean nullable = true;
                String type = column.getString("type");
                coldef.setColumnName(columnNames[i]);
                coldef.setDescription(column.getString("desc"));
                coldef.setDataType(type);
                if (column.has("length")) {
                    coldef.setMaxLength(column.getInt("length"));
                }
                if (column.has("default")) {
                    if (type.equalsIgnoreCase("BIGINT") || type.equalsIgnoreCase("INTEGER")) {
                        coldef.setDefaultValue((Object)column.getInt("default"));
                    }
                    if (type.equalsIgnoreCase("NCHAR")) {
                        coldef.setDefaultValue((Object)column.getString("default"));
                    }
                }
                if (column.has("nullable")) {
                    nullable = column.getBoolean("nullable");
                }
                coldef.setNullable(nullable);
                def.addColumnDefinition(coldef);
            }
            for (i = 0; i < indexColumns.length; ++i) {
                IndexDefinition iDef = new IndexDefinition();
                iDef.addColumn(indexColumns[i]);
                iDef.setName(indexColumns[i] + "Index" + System.currentTimeMillis());
                def.addIndex(iDef);
            }
            if (table.has("FK")) {
                String[][] fk = (String[][])table.get("FK");
                if (fk == null) {
                    return;
                }
                for (int i2 = 0; i2 < fk.length; ++i2) {
                    String refTable = fk[i2][0];
                    String refColumn = fk[i2][1];
                    TableDefinition tableDefinition = MetaDataUtil.getTableDefinitionByName((String)refTable);
                    ColumnDefinition rcd = tableDefinition.getColumnDefinitionByName(refColumn);
                    ColumnDefinition cd = new ColumnDefinition();
                    cd.setColumnName(rcd.getColumnName());
                    cd.setTableName(tableName);
                    cd.setDataType(rcd.getDataType());
                    cd.setDisplayName(rcd.getDisplayName());
                    cd.setMaxLength(rcd.getMaxLength());
                    cd.setKey(true);
                    cd.setRootColumn(rcd);
                    ForeignKeyColumnDefinition fkc = new ForeignKeyColumnDefinition();
                    fkc.setLocalColumnDefinition(cd);
                    fkc.setReferencedColumnDefinition(rcd);
                    ForeignKeyDefinition fkDef = new ForeignKeyDefinition();
                    fkDef.setName(tableName + "_FK" + System.currentTimeMillis());
                    fkDef.setMasterTableName(refTable);
                    fkDef.setBidirectional(false);
                    fkDef.addForeignKeyColumns(fkc);
                    fkDef.setConstraints(1);
                    def.addForeignKey(fkDef);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

