/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GinaReportUtil {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    private static final String AGENT_TABLE = "AgentComputerDetails";

    public static int getNewInstallationCount(String searchPattern, String domainName, String defaultNamingContext) {
        int totalInstalledMachine = GinaReportUtil.getInstalledComputerCount(searchPattern, domainName, defaultNamingContext);
        int totalErrorOccuredMachine = GinaReportUtil.getErrorComputerCount(searchPattern, domainName, defaultNamingContext);
        int totalComputerCount = GinaReportUtil.getAllComputerCount(searchPattern, domainName, defaultNamingContext);
        int count = totalComputerCount - totalInstalledMachine - totalErrorOccuredMachine;
        return count;
    }

    public static ArrayList getNewInstallationList(String searchPattern, String domainName, int startIndex, int numOfObjects, String dNContext) {
        String tableName = CommonUtil.getDomainComputerTableName(domainName);
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        try {
            Table table = new Table(tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(new Column(tableName, "DN_STRING"), (Object)("*" + dNContext), 2);
            ArrayList installedlist = GinaReportUtil.getInstalledMachineList(searchPattern, domainName, -1, -1, dNContext);
            ArrayList errorlist = GinaReportUtil.getErrorMachineList(searchPattern, domainName, -1, -1, dNContext);
            String[] totalArray = new String[installedlist.size() + errorlist.size()];
            int totcount = -1;
            for (int i = 0; i < installedlist.size(); ++i) {
                Properties sids = (Properties)installedlist.get(i);
                totalArray[++totcount] = sids.getProperty("NAME");
            }
            String[] errorarray = new String[errorlist.size()];
            for (int i = 0; i < errorlist.size(); ++i) {
                Properties sids = (Properties)errorlist.get(i);
                totalArray[++totcount] = sids.getProperty("NAME");
            }
            criteria = criteria.and(new Criteria(new Column(tableName, "NAME"), (Object)totalArray, 9));
            if (searchPattern != null) {
                criteria = criteria.and(new Criteria(new Column(tableName, "NAME"), (Object)("*" + searchPattern), 2, false));
            }
            query.addSelectColumn(new Column(null, "*"));
            query.addSortColumn(new SortColumn(new Column(tableName, "NAME"), true));
            if (startIndex != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            if (numOfObjects != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            query.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            ReportAttributeHandler attributeHandler = ReportAttributeHandler.getInstance();
            Iterator iterator = dataObject.getRows(tableName);
            while (iterator.hasNext()) {
                Properties properties = new Properties();
                Row row = (Row)iterator.next();
                properties.setProperty("NAME", (String)row.get("NAME"));
                String dn = (String)row.get("DN_STRING");
                properties.setProperty("DISTINGUISHED_NAME", dn);
                properties.setProperty("FQDN", attributeHandler.getLocation(domainName, dn));
                properties.setProperty("GUID", (String)row.get("OBJECT_GUID"));
                if ((String)row.get("DNS_NAME") != null) {
                    properties.setProperty("DNS_NAME", (String)row.get("DNS_NAME"));
                } else {
                    properties.setProperty("DNS_NAME", "--");
                }
                arrayList.add(properties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        reportLogger.log(Level.INFO, "Total number of computers in " + domainName + " is " + arrayList.size());
        return arrayList;
    }

    public static ArrayList getInstalledMachineList(String searchPattern, String domainName, int startIndex, int numOfObjects, String defaultnamingcontext) {
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        try {
            Table table = new Table(AGENT_TABLE);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(new Column(AGENT_TABLE, "COMPUTER_DN"), (Object)("*" + defaultnamingcontext), 2);
            Criteria crit = new Criteria(new Column(AGENT_TABLE, "INSTALL_STATUS"), (Object)"adssp_admin_gina_install_success", 0);
            crit = crit.or(new Criteria(new Column(AGENT_TABLE, "INSTALL_STATUS"), (Object)"adssp_admin_gina_reinstall_success", 0));
            criteria = criteria.and(crit);
            if (searchPattern != null) {
                criteria = criteria.and(new Criteria(new Column(AGENT_TABLE, "COMPUTER_NAME"), (Object)("*" + searchPattern), 2, false));
            }
            query.addSelectColumn(new Column(null, "*"));
            query.addSortColumn(new SortColumn(new Column(AGENT_TABLE, "COMPUTER_NAME"), true));
            if (startIndex != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            if (numOfObjects != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            query.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator iterator = dataObject.getRows(AGENT_TABLE);
            while (iterator.hasNext()) {
                Properties properties = new Properties();
                Row row = (Row)iterator.next();
                properties.setProperty("NAME", (String)row.get("COMPUTER_NAME"));
                properties.setProperty("IPNAME", (String)row.get("COMPUTER_IP"));
                properties.setProperty("GUID", (String)row.get("OBJECT_GUID"));
                String dn = (String)row.get("COMPUTER_DN");
                properties.setProperty("DISTINGUISHED_NAME", dn);
                ReportAttributeHandler attributeHandler = ReportAttributeHandler.getInstance();
                properties.setProperty("FQDN", attributeHandler.getLocation(domainName, dn));
                properties.setProperty("INSTALL_STATUS", (String)row.get("INSTALL_STATUS"));
                if ((String)row.get("DNS_NAME") != null) {
                    properties.setProperty("DNS_NAME", (String)row.get("DNS_NAME"));
                } else {
                    properties.setProperty("DNS_NAME", "--");
                }
                arrayList.add(properties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        reportLogger.log(Level.INFO, "Total Installed computers in " + domainName + " are " + arrayList.size());
        return arrayList;
    }

    public static ArrayList getErrorMachineList(String searchPattern, String domainName, int startIndex, int numOfObjects, String defaultnamingcontext) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        try {
            Table table = new Table(AGENT_TABLE);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(new Column(AGENT_TABLE, "COMPUTER_DN"), (Object)("*" + defaultnamingcontext), 2);
            Criteria crit = new Criteria(new Column(AGENT_TABLE, "INSTALL_STATUS"), (Object)new String[]{"adssp_admin_gina_install_success", "adssp_admin_gina_reinstall_success", "licenserestrict"}, 9);
            criteria = criteria.and(crit);
            if (searchPattern != null) {
                criteria = criteria.and(new Criteria(new Column(AGENT_TABLE, "COMPUTER_NAME"), (Object)("*" + searchPattern), 2, false));
            }
            query.addSelectColumn(new Column(null, "*"));
            query.addSortColumn(new SortColumn(new Column(AGENT_TABLE, "COMPUTER_NAME"), true));
            if (startIndex != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            if (numOfObjects != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            query.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator iterator = dataObject.getRows(AGENT_TABLE);
            while (iterator.hasNext()) {
                Properties properties = new Properties();
                Row row = (Row)iterator.next();
                properties.setProperty("NAME", (String)row.get("COMPUTER_NAME"));
                properties.setProperty("IPNAME", (String)row.get("COMPUTER_IP"));
                properties.setProperty("GUID", (String)row.get("OBJECT_GUID"));
                String dn = (String)row.get("COMPUTER_DN");
                properties.setProperty("DISTINGUISHED_NAME", dn);
                ReportAttributeHandler attributeHandler = ReportAttributeHandler.getInstance();
                properties.setProperty("FQDN", attributeHandler.getLocation(domainName, dn));
                properties.setProperty("REASON", rb.getString((String)row.get("INSTALL_STATUS")));
                properties.setProperty("TROUBLESHOOT", (String)row.get("INSTALL_STATUS"));
                if ((String)row.get("DNS_NAME") != null) {
                    properties.setProperty("DNS_NAME", (String)row.get("DNS_NAME"));
                } else {
                    properties.setProperty("DNS_NAME", "--");
                }
                arrayList.add(properties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        reportLogger.log(Level.INFO, "Total Error Installation computers in " + domainName + " are " + arrayList.size());
        return arrayList;
    }

    public static ArrayList getUpdateList(Long generationid) {
        String tablename = "AgentComputerReportResult";
        Table table = new Table(tablename);
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        Criteria criteria = new Criteria(new Column(tablename, "REPORT_GENERATION_ID"), (Object)generationid, 0);
        SelectQueryImpl query = new SelectQueryImpl(table);
        query.addSelectColumn(new Column(null, "*"));
        query.setCriteria(criteria);
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator iterator = dataObject.getRows(tablename);
            while (iterator.hasNext()) {
                Properties properties = new Properties();
                Row row = (Row)iterator.next();
                properties.setProperty("objectGUID", (String)row.get("OBJECT_GUID"));
                properties.setProperty("INSTALL_STATUS", (String)row.get("INSTALL_STATUS"));
                arrayList.add(properties);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        return arrayList;
    }

    public static ArrayList getOUListComputer(String searchPattern, String domainName, int startIndex, int numOfObjects, ArrayList selectedOUs, String defaultnamingcontext) {
        int i;
        String tableName = CommonUtil.getDomainComputerTableName(domainName);
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        ArrayList arrayList1 = new ArrayList();
        String inValues = "";
        int count = 0;
        selectedOUs = OUUtil.getParentOUs(selectedOUs);
        ArrayList installedlist = GinaReportUtil.getInstalledMachineList(searchPattern, domainName, -1, -1, defaultnamingcontext);
        ArrayList errorlist = GinaReportUtil.getErrorMachineList(searchPattern, domainName, -1, -1, defaultnamingcontext);
        String[] totalArray = new String[installedlist.size() + errorlist.size()];
        int totcount = -1;
        for (int i2 = 0; i2 < installedlist.size(); ++i2) {
            Properties sids = (Properties)installedlist.get(i2);
            totalArray[++totcount] = sids.getProperty("NAME");
        }
        String[] errorarray = new String[errorlist.size()];
        for (i = 0; i < errorlist.size(); ++i) {
            Properties sids = (Properties)errorlist.get(i);
            totalArray[++totcount] = sids.getProperty("NAME");
        }
        for (i = 0; i < selectedOUs.size(); ++i) {
            inValues = "*" + (String)selectedOUs.get(i);
            try {
                Table table = new Table(tableName);
                SelectQueryImpl query = new SelectQueryImpl(table);
                Criteria criteria = new Criteria(new Column(tableName, "DN_STRING"), (Object)inValues, 2);
                criteria = criteria.and(new Criteria(new Column(tableName, "NAME"), (Object)totalArray, 9));
                if (searchPattern != null) {
                    criteria = criteria.and(new Criteria(new Column(tableName, "NAME"), (Object)("*" + searchPattern), 2, false));
                }
                query.addSelectColumn(new Column(null, "*"));
                query.addSortColumn(new SortColumn(new Column(tableName, "NAME"), true));
                if (startIndex != -1) {
                    query.setRange(new Range(startIndex, numOfObjects));
                }
                if (numOfObjects != -1) {
                    query.setRange(new Range(startIndex, numOfObjects));
                }
                query.setCriteria(criteria);
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                if (count == -1) continue;
                Iterator iterator = dataObject.getRows(tableName);
                while (iterator.hasNext()) {
                    Properties properties = new Properties();
                    Row row = (Row)iterator.next();
                    properties.setProperty("NAME", (String)row.get("NAME"));
                    String dn = (String)row.get("DN_STRING");
                    properties.setProperty("DISTINGUISHED_NAME", dn);
                    ReportAttributeHandler attributeHandler = ReportAttributeHandler.getInstance();
                    properties.setProperty("FQDN", attributeHandler.getLocation(domainName, dn));
                    properties.setProperty("GUID", (String)row.get("OBJECT_GUID"));
                    if ((String)row.get("DNS_NAME") != null) {
                        properties.setProperty("DNS_NAME", (String)row.get("DNS_NAME"));
                    } else {
                        properties.setProperty("DNS_NAME", "--");
                    }
                    arrayList.add(properties);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        reportLogger.log(Level.INFO, "Total number of computers(OUList) in " + domainName + " are " + arrayList.size());
        return arrayList;
    }

    public static int getAllComputerCount(String searchPattern, String domainName, String defaultnamingcontext) {
        String tableName = CommonUtil.getDomainComputerTableName(domainName);
        Criteria criteria = null;
        try {
            if (searchPattern != null) {
                criteria = new Criteria(new Column(tableName, "NAME"), (Object)("*" + searchPattern), 2, false);
            }
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            return dataObject.size(tableName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getOUCount(String searchPattern, String domainName, ArrayList selectedOUs, String defaultnamingcontext) {
        int i;
        String tableName = CommonUtil.getDomainComputerTableName(domainName);
        String inValues = "";
        int count = 0;
        selectedOUs = OUUtil.getParentOUs(selectedOUs);
        ArrayList installedlist = GinaReportUtil.getInstalledMachineList(searchPattern, domainName, -1, -1, defaultnamingcontext);
        ArrayList errorlist = GinaReportUtil.getErrorMachineList(searchPattern, domainName, -1, -1, defaultnamingcontext);
        String[] totalArray = new String[installedlist.size() + errorlist.size()];
        int totcount = -1;
        for (int i2 = 0; i2 < installedlist.size(); ++i2) {
            Properties sids = (Properties)installedlist.get(i2);
            totalArray[++totcount] = sids.getProperty("NAME");
        }
        String[] errorarray = new String[errorlist.size()];
        for (i = 0; i < errorlist.size(); ++i) {
            Properties sids = (Properties)errorlist.get(i);
            totalArray[++totcount] = sids.getProperty("NAME");
        }
        for (i = 0; i < selectedOUs.size(); ++i) {
            inValues = "*" + (String)selectedOUs.get(i);
            try {
                DataObject dataObject;
                Criteria criteria = new Criteria(new Column(tableName, "DN_STRING"), (Object)inValues, 2);
                criteria = criteria.and(new Criteria(new Column(tableName, "NAME"), (Object)totalArray, 9));
                if (searchPattern != null) {
                    criteria = criteria.and(new Criteria(new Column(tableName, "NAME"), (Object)("*" + searchPattern), 2, false));
                }
                if ((dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria)).size(tableName) == -1) continue;
                count += dataObject.size(tableName);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        reportLogger.log(Level.INFO, "Total number of OUs in " + domainName + " is " + count);
        return count;
    }

    public static int getInstalledComputerCount(String searchPattern, String domainName, String defaultNamingContext) {
        try {
            DataObject dataObject;
            int count;
            Criteria criteria = new Criteria(new Column(AGENT_TABLE, "COMPUTER_DN"), (Object)("*" + defaultNamingContext), 2);
            Criteria crit = new Criteria(new Column(AGENT_TABLE, "INSTALL_STATUS"), (Object)"adssp_admin_gina_install_success", 0);
            crit = crit.or(new Criteria(new Column(AGENT_TABLE, "INSTALL_STATUS"), (Object)"adssp_admin_gina_reinstall_success", 0));
            criteria = criteria.and(crit);
            if (searchPattern != null) {
                criteria = criteria.and(new Criteria(new Column(AGENT_TABLE, "COMPUTER_NAME"), (Object)("*" + searchPattern), 2, false));
            }
            if ((count = (dataObject = CommonUtil.getPersistence(new boolean[0]).get(AGENT_TABLE, criteria)).size(AGENT_TABLE)) != -1) {
                return count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static int getErrorComputerCount(String searchPattern, String domainName, String defaultNamingContext) {
        try {
            DataObject dataObject;
            int count;
            Criteria criteria = new Criteria(new Column(AGENT_TABLE, "COMPUTER_DN"), (Object)("*" + defaultNamingContext), 2);
            Criteria crit = new Criteria(new Column(AGENT_TABLE, "INSTALL_STATUS"), (Object)new String[]{"adssp_admin_gina_install_success", "adssp_admin_gina_reinstall_success", "licenserestrict"}, 9);
            criteria = criteria.and(crit);
            if (searchPattern != null) {
                criteria = criteria.and(new Criteria(new Column(AGENT_TABLE, "COMPUTER_NAME"), (Object)("*" + searchPattern), 2, false));
            }
            if ((count = (dataObject = CommonUtil.getPersistence(new boolean[0]).get(AGENT_TABLE, criteria)).size(AGENT_TABLE)) != -1) {
                return count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }
}

