/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.reports;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.EnrollmentHandler;
import com.adventnet.sym.adsm.common.server.admin.TechnicianHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.QueryUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class LicensedUsersHandler {
    private static Logger logger = Logger.getLogger(LicensedUsersHandler.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getUsersCount(String domainName, Integer reportId, ArrayList ouList, String searchString, String reportFilter) throws Exception {
        int count = 0;
        Connection connection = null;
        DataSet dataSet = null;
        try {
            String users_Table = CommonUtil.getDomainUserTableName(domainName);
            Table aaaLogin = Table.getTable((String)"AaaLogin");
            SelectQueryImpl sq = new SelectQueryImpl(aaaLogin);
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0, false);
            Join aaaTablejoin = new Join(aaaLogin, Table.getTable((String)users_Table), new String[]{"NAME"}, new String[]{"SAM_ACCOUNT_NAME"}, 2);
            Join enrollJoin = new Join(aaaLogin, Table.getTable((String)"SSPUserPropertyMap"), new String[]{"LOGIN_ID"}, new String[]{"USER_LOGIN_ID"}, 1);
            sq.addJoin(aaaTablejoin);
            sq.addJoin(enrollJoin);
            if (reportFilter.equalsIgnoreCase("Technician")) {
                Join techJoin = new Join(aaaLogin, Table.getTable((String)"ADMPUsersRoleMapping"), new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2);
                sq.addJoin(techJoin);
                crit = crit.and(new Criteria(Column.getColumn((String)"ADMPUsersRoleMapping", (String)"ADMP_ROLE_ID"), (Object)10000L, 1));
            } else if (reportFilter.equalsIgnoreCase("Enrolled")) {
                crit = crit.and(new Criteria(Column.getColumn((String)"SSPUserPropertyMap", (String)"REGISTRATION_STATUS"), null, 1));
            } else if (reportFilter.equalsIgnoreCase("Not-Enrolled")) {
                crit = crit.and(new Criteria(Column.getColumn((String)"SSPUserPropertyMap", (String)"REGISTRATION_STATUS"), null, 0));
            }
            if (ouList != null && !ouList.isEmpty()) {
                crit = crit.and(LicensedUsersHandler.getOUCriteria(users_Table, ouList));
            }
            if (searchString != null && !searchString.equals("")) {
                crit = crit.and(LicensedUsersHandler.getSearchCriteria(users_Table, searchString));
            }
            sq.addSelectColumn(Column.getColumn((String)users_Table, (String)"SAM_ACCOUNT_NAME").count());
            sq.setCriteria(crit);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            logger.log(Level.INFO, "The SELECT QUERY ::: " + relAPI.getSelectSQL((Query)sq));
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                count = (Integer)dataSet.getValue(1);
                logger.log(Level.INFO, "The count is " + count);
            }
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getUsers(String domainName, Integer reportId, ArrayList ouList, String[] attrList, String sortColumn, boolean ascending, int startIndex, int numOfObjects, Boolean export, String searchString, String reportFilter) throws Exception {
        ArrayList<Properties> list = new ArrayList<Properties>();
        DataSet dataSet = null;
        Connection connection = null;
        try {
            String users_Table = CommonUtil.getDomainUserTableName(domainName);
            Table aaaLogin = Table.getTable((String)"AaaLogin");
            SelectQueryImpl sq = new SelectQueryImpl(aaaLogin);
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0, false);
            Join aaaTablejoin = new Join(aaaLogin, Table.getTable((String)users_Table), new String[]{"NAME"}, new String[]{"SAM_ACCOUNT_NAME"}, 2);
            Join enrollJoin = new Join(aaaLogin, Table.getTable((String)"SSPUserPropertyMap"), new String[]{"LOGIN_ID"}, new String[]{"USER_LOGIN_ID"}, 1);
            sq.addJoin(aaaTablejoin);
            sq.addJoin(enrollJoin);
            if (reportFilter.equalsIgnoreCase("Technician")) {
                Join techJoin = new Join(aaaLogin, Table.getTable((String)"ADMPUsersRoleMapping"), new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2);
                sq.addJoin(techJoin);
                crit = crit.and(new Criteria(Column.getColumn((String)"ADMPUsersRoleMapping", (String)"ADMP_ROLE_ID"), (Object)10000L, 1));
                logger.log(Level.INFO, "The technician query added " + crit);
            } else if (reportFilter.equalsIgnoreCase("Enrolled")) {
                crit = crit.and(new Criteria(Column.getColumn((String)"SSPUserPropertyMap", (String)"REGISTRATION_STATUS"), null, 1));
            } else if (reportFilter.equalsIgnoreCase("Not-Enrolled")) {
                crit = crit.and(new Criteria(Column.getColumn((String)"SSPUserPropertyMap", (String)"REGISTRATION_STATUS"), null, 0));
            }
            if (ouList != null && !ouList.isEmpty()) {
                crit = crit.and(LicensedUsersHandler.getOUCriteria(users_Table, ouList));
            }
            if (searchString != null && !searchString.equals("")) {
                crit = crit.and(LicensedUsersHandler.getSearchCriteria(users_Table, searchString));
            }
            sq.addSelectColumn(Column.getColumn((String)"SSPUserPropertyMap", (String)"REGISTRATION_STATUS"));
            sq.addSelectColumn(Column.getColumn((String)users_Table, (String)"OBJECT_GUID"));
            sq.addSelectColumn(Column.getColumn((String)users_Table, (String)"DN_STRING"));
            for (String str : attrList) {
                sq.addSelectColumn(Column.getColumn((String)users_Table, (String)str));
            }
            sq.addSortColumn(new SortColumn(Column.getColumn((String)users_Table, (String)sortColumn), ascending));
            if (!export.booleanValue()) {
                sq.setRange(new Range(startIndex, numOfObjects));
                logger.log(Level.INFO, "Export :: " + export);
            }
            sq.setCriteria(crit);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            logger.log(Level.INFO, "GetUsers :: The SELECT QUERY ::: " + relAPI.getSelectSQL((Query)sq));
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            try {
                while (dataSet.next()) {
                    Properties p = new Properties();
                    if (dataSet.getValue("REGISTRATION_STATUS") == null) {
                        p.put("ENROLL_STATUS", "adssp.reports.audit.licensedusers.statmsg_not_enrolled_user");
                    } else {
                        p.put("ENROLL_STATUS", "adssp.reports.audit.licensedusers.statmsg_enrolled_user");
                    }
                    p.put("OBJECT_GUID", (String)dataSet.getValue("OBJECT_GUID"));
                    for (String str : attrList) {
                        String val = (String)dataSet.getValue(str);
                        if (val == null) {
                            val = "-";
                        }
                        p.put(str, val);
                    }
                    list.add(p);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
        return list;
    }

    public static String isTechnicanUser(String samAccName, String domainName) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)samAccName, 0, false);
            crit = crit.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0, false));
            crit = crit.and(new Criteria(Column.getColumn((String)"ADMPUsersRoleMapping", (String)"ADMP_ROLE_ID"), (Object)10000L, 1));
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"AaaLogin"));
            Join j = new Join(Table.getTable((String)"AaaLogin"), Table.getTable((String)"ADMPUsersRoleMapping"), new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2);
            sq.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"));
            sq.addSelectColumn(Column.getColumn((String)"ADMPUsersRoleMapping", (String)"LOGIN_ID"));
            sq.addSelectColumn(Column.getColumn((String)"ADMPUsersRoleMapping", (String)"ADMP_ROLE_ID"));
            sq.addJoin(j);
            sq.setCriteria(crit);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!obj.isEmpty()) {
                return "adssp.reports.audit.licensedusers.text_technician_notallow";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isEnrolledUser(Long loginId) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"), (Object)loginId, 0);
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"AaaLogin"));
            Join j = new Join(Table.getTable((String)"AaaLogin"), Table.getTable((String)"SSPUserPropertyMap"), new String[]{"LOGIN_ID"}, new String[]{"USER_LOGIN_ID"}, 2);
            sq.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"));
            sq.addSelectColumn(Column.getColumn((String)"SSPUserPropertyMap", (String)"USER_LOGIN_ID"));
            sq.addJoin(j);
            sq.setCriteria(crit);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (obj.isEmpty()) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static String isEnrolledUser(String samAccName, String domainName) {
        return LicensedUsersHandler.isEnrolledUser(samAccName, domainName, null);
    }

    public static String isEnrolledUser(String samAccName, String domainName, String domainDnsName) {
        try {
            Boolean enrollStatus;
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)samAccName, 0, false);
            if (domainDnsName != null && !domainDnsName.equals("")) {
                String tableName = "ADSMDomainConfiguration";
                Criteria c = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_DNS_NAME"), (Object)domainDnsName, 0, false);
                c.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_FLAT_NAME"), (Object)domainName, 0, false));
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, c);
                if (!dataObj.isEmpty()) {
                    Row r = dataObj.getFirstRow(tableName);
                    domainName = (String)r.get("DOMAIN_NAME");
                }
            }
            crit = crit.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0, false));
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"AaaLogin"));
            Join j = new Join(Table.getTable((String)"AaaLogin"), Table.getTable((String)"SSPUserPropertyMap"), new String[]{"LOGIN_ID"}, new String[]{"USER_LOGIN_ID"}, 2);
            sq.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"));
            sq.addSelectColumn(Column.getColumn((String)"SSPUserPropertyMap", (String)"USER_LOGIN_ID"));
            sq.addJoin(j);
            sq.setCriteria(crit);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!obj.isEmpty() && (enrollStatus = Boolean.valueOf(EnrollmentHandler.isEnrolled(samAccName, domainName))).booleanValue()) {
                return "adssp.reports.audit.licensedusers.statmsg_enrolled_user";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "adssp.reports.audit.licensedusers.statmsg_not_enrolled_user";
    }

    public static Criteria getOUCriteria(String tableName, ArrayList ouList) {
        Criteria ouCrit = null;
        try {
            for (int i = 0; i < ouList.size(); ++i) {
                String ou = QueryUtil.mickeyCriteriaEscape((String)ouList.get(i));
                ouCrit = ouCrit != null ? ouCrit.or(new Criteria(Column.getColumn((String)tableName, (String)"DN_STRING"), (Object)ou, 11, false)) : new Criteria(Column.getColumn((String)tableName, (String)"DN_STRING"), (Object)ou, 11, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ouCrit;
    }

    public static Criteria getSearchCriteria(String tableName, String searchString) {
        Criteria searchCrit = null;
        try {
            String[] splittedStr;
            for (String param : splittedStr = searchString.split(Pattern.quote("||"))) {
                String[] arr = param.split("=", 2);
                searchCrit = searchCrit != null ? searchCrit.and(new Criteria(Column.getColumn((String)tableName, (String)arr[0]), (Object)("*" + arr[1] + "*"), 2, false)) : new Criteria(Column.getColumn((String)tableName, (String)arr[0]), (Object)("*" + arr[1] + "*"), 2, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return searchCrit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getTechnicianUsers() {
        String[] users = null;
        ArrayList<String> list = new ArrayList<String>();
        DataSet dataSet = null;
        Connection connection = null;
        try {
            SelectQuery query = TechnicianHandler.getQueryForTechnicians(new Long(-1L), true);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            ArrayList<String> keys = new ArrayList<String>();
            while (dataSet.next()) {
                String key = dataSet.getValue("NAME").toString() + dataSet.getValue("DOMAINNAME").toString();
                if (keys.contains(key)) continue;
                keys.add(key);
                list.add((String)dataSet.getValue("NAME"));
            }
            users = list.toArray(new String[list.size()]);
        }
        catch (Exception e) {
            try {
                logger.log(Level.SEVERE, "Error in getting Help desk user details");
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DBUtil.closeQuietly(connection, dataSet);
                throw throwable;
            }
            DBUtil.closeQuietly(connection, dataSet);
        }
        DBUtil.closeQuietly(connection, dataSet);
        return users;
    }

    public static void deleteLicensedUsers(String domainName, String[] usersToDelete) {
        try {
            int noOfUsers = usersToDelete.length;
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"AaaLogin"));
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0, false);
            crit = crit.and(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)usersToDelete, 8, false);
            CommonUtil.getPersistence(new boolean[0]).delete(crit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getUsedLicenseCount() {
        Connection connection = null;
        DataSet dataSet = null;
        int usedLicenseCount = 0;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"AaaLogin"));
            Criteria c = new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)"", 1, false);
            Column col = Column.getColumn(null, (String)"*").count();
            sq.addSelectColumn(col);
            sq.setCriteria(c);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                usedLicenseCount = (Integer)dataSet.getValue(1);
            }
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
        return usedLicenseCount - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getEnrolledUsersCount() {
        Connection connection = null;
        int usedLicenseCount = 0;
        DataSet dataSet = null;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SSPUserPropertyMap"));
            Column col = Column.getColumn(null, (String)"*").count();
            sq.addSelectColumn(col);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                usedLicenseCount = (Integer)dataSet.getValue(1);
            }
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
        return usedLicenseCount;
    }

    public static int getAvailableLicenseCount() {
        int usedLicenseCount = LicensedUsersHandler.getUsedLicenseCount();
        int totalLicenseCount = Integer.parseInt(CommonUtil.getLicenseProperty("DomainUsers", "NumberOfUsers"));
        return totalLicenseCount - usedLicenseCount;
    }
}

