/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.reports;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.sym.adsm.common.server.reports.AuditPgSQLGenerator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecordWriter {
    private static Logger LOGGER = Logger.getLogger("ReportLogger");
    private FileWriter fWriter = null;
    private PrintWriter writer = null;
    private String fileName = null;
    private String tableName = null;

    public RecordWriter(String tableName) {
        LOGGER.log(Level.INFO, "RecordWriter Constructor Called for  {0}", tableName);
        this.tableName = tableName;
        this.initTempFile();
    }

    public void writeData(Long generationId, ArrayList guids) {
        String dbServerName = PersistenceInitializer.getConfigurationValue((String)"DBName");
        String delimiter = "postgres".equalsIgnoreCase(dbServerName) ? "\t" : "|**|";
        int size = guids.size();
        for (int i = 0; i < size; ++i) {
            String guid = (String)guids.get(i);
            if ("postgres".equalsIgnoreCase(dbServerName)) {
                this.writer.println(generationId + delimiter + guid.replaceAll("\\\\", "\\\\\\\\"));
                continue;
            }
            this.writer.println(generationId + delimiter + guid.replaceAll("\\\\", "\\\\\\\\") + delimiter);
        }
    }

    public synchronized void flush() {
        this.writeToFile();
        this.dumpToDatabase();
    }

    private void initTempFile() {
        try {
            String dirName = System.getProperty("server.home") + File.separator + "temp";
            File dir = new File(dirName);
            if (!dir.exists()) {
                dir.mkdir();
            }
            this.fileName = dirName + File.separator + this.tableName + "_" + System.currentTimeMillis() + ".txt";
            this.fWriter = new FileWriter(this.fileName, false);
            this.writer = new PrintWriter((Writer)new BufferedWriter(this.fWriter), false);
            LOGGER.log(Level.FINER, "[RecordWriter.initTempFile()] Created new temp file as {0}{1}{2}", new Object[]{dirName, File.separator, this.fileName});
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, " Exception while opening file for table: {0}", this.tableName);
            LOGGER.log(Level.WARNING, " Exception while opening file to log flows: {0}", e);
        }
    }

    private void writeToFile() {
        this.writer.flush();
        this.closeWriters();
    }

    private void closeWriters() {
        try {
            this.writer.close();
            this.fWriter.close();
            this.writer = null;
            this.fWriter = null;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, " Exception while closing file {0}", e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeCommand(String[] command) throws Exception {
        Process p = new ProcessBuilder(command).start();
        BufferedReader in = null;
        String recordWriterlogs = System.getProperty("server.dir") + File.separator + "logs" + File.separator + "bcploadArchive.log";
        FileOutputStream fos = new FileOutputStream(recordWriterlogs);
        try {
            int c;
            in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((c = in.read()) != -1) {
                fos.write(c);
            }
        }
        catch (IOException ioex) {
            LOGGER.log(Level.INFO, "Problem in loading the archive file");
            ioex.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void dumpToDatabase() {
        RelationalAPI rapi = RelationalAPI.getInstance();
        Connection con = null;
        Statement stmt = null;
        if (this.fileName != null) {
            try {
                File tmpFile = new File(this.fileName);
                String filePath = tmpFile.getCanonicalPath();
                filePath = filePath.replace('\\', '/');
                String dbServerName = PersistenceInitializer.getConfigurationValue((String)"DBName");
                Properties dbPro = PersistenceInitializer.getDefaultDBProps();
                String connectionURL = dbPro.getProperty("url");
                connectionURL = connectionURL.replaceAll(" ", "");
                if (dbServerName.equalsIgnoreCase("mssql")) {
                    String urlDBServerlen = "://";
                    String urlDBNamelen = "DatabaseName=";
                    String dbName = null;
                    String dbServer = connectionURL.substring(connectionURL.indexOf("://") + urlDBServerlen.length(), connectionURL.lastIndexOf(":"));
                    String dbPort = connectionURL.substring(connectionURL.lastIndexOf(":") + 1, connectionURL.indexOf(";"));
                    if (connectionURL.indexOf("Domain=") != -1) {
                        dbName = connectionURL.substring(connectionURL.indexOf("DatabaseName=") + urlDBNamelen.length(), connectionURL.indexOf(";Domain="));
                        LOGGER.log(Level.INFO, "IsWinAuthType is true : dbname is : {0}", dbName);
                        RecordWriter.executeCommand(new String[]{"..\\bin\\bcp.exe", dbName + ".dbo." + this.tableName, "in", filePath, "-S", dbServer + "," + dbPort, "-h \"CHECK_CONSTRAINTS\"", "-T", "-t", "|**|", "-r", "|**|\\n", "-e", "..\\logs\\error.txt", "-c"});
                    } else {
                        dbName = connectionURL.substring(connectionURL.indexOf("DatabaseName=") + urlDBNamelen.length(), connectionURL.length());
                        RecordWriter.executeCommand(new String[]{"..\\bin\\bcp.exe", dbName + ".dbo." + this.tableName, "in", filePath, "-S", dbServer + "," + dbPort, "-h \"CHECK_CONSTRAINTS\"", "-U", dbPro.getProperty("username"), "-P", dbPro.getProperty("password"), "-t", "|**|", "-r", "|**|\\n", "-e", "..\\logs\\error.txt", "-c"});
                    }
                } else if (dbServerName.equalsIgnoreCase("postgres")) {
                    con = DriverManager.getConnection(connectionURL, dbPro.getProperty("username"), dbPro.getProperty("password"));
                    AuditPgSQLGenerator.dumpFile(con, filePath, this.tableName);
                } else {
                    String sql = "load data local infile '" + filePath + "' into table " + this.tableName + " fields terminated by '|**|' ";
                    con = rapi.getConnection();
                    stmt = con.createStatement();
                    long time = System.currentTimeMillis();
                    int recordCount = stmt.executeUpdate(sql);
                    LOGGER.log(Level.FINER, "Loaded {0} rows to Table {1}", new Object[]{new Integer(recordCount), this.tableName});
                }
                this.deleteFile();
            }
            catch (Exception exp) {
                LOGGER.log(Level.FINER, "[RecordWriter.run()] Exception while loading data to table {0}", this.tableName);
                exp.printStackTrace();
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    con.close();
                }
                catch (Exception exp) {
                    stmt = null;
                    con = null;
                }
            }
        }
    }

    private void deleteFile() {
        try {
            if (this.fileName == null) {
                return;
            }
            File tmpFile = new File(this.fileName);
            boolean del = tmpFile.delete();
            tmpFile = null;
            LOGGER.log(Level.FINER, " Deleted tmp file {0} when closing service{1}", new Object[]{this.fileName, new Boolean(del)});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

