/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.reports;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.AlterTableQuery;
import com.adventnet.ds.query.AlterTableQueryImpl;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.SearchProfileHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.TimeZoneUtil;
import com.manageengine.ads.fw.iamapps.handler.IAMAttributeHandler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class ReportAttributeHandler {
    private static ReportAttributeHandler handler = null;
    private Hashtable reportTableNameMap = null;
    private Hashtable tableNameAttributesMap = null;
    private Hashtable reportIdVsViewAttributesMap = null;
    private ArrayList domainList = null;
    private String[] tableArray = new String[]{"ADSMUserCustomDetails", "ADSMPasswordCustomDetails", "ADSMGroupCustomDetails", "ADSMComputerCustomDetails", "ADSMExchangeCustomDetails", "ADSMPolicyCustomDetails"};
    private static String[] baseTableArray = new String[]{"ADSMUserGeneralDetails", "*************", "ADSMGroupGeneralDetails", "ADSMComputerGeneralDetails", "ADSMMRGeneralDetails", "ADSMPwdPolicyDetails"};
    private String[] dataHandler = new String[]{"CHAR", "INTEGER", "BIGINT", "BOOLEAN", "DATETIME"};
    private Long[] dataValue = new Long[]{3L, 7L, 10L, 6L, 10L};
    private String message = "";
    private Object syncObj = null;
    private static String[] nonModifiableAttribs = new String[]{"samaccountname", "samaccounttype", "useraccountcontrol", "cn", "instancetype", "objectcategory", "objectclass", "objectsid", "objectguid", "useraccountcontrol", "memberof", "password", "pwdlastset"};
    public static ArrayList<String> nonModifiableAttribList = new ArrayList<String>(Arrays.asList(nonModifiableAttribs));

    private ReportAttributeHandler() {
        this.reportTableNameMap = new Hashtable();
        this.tableNameAttributesMap = new Hashtable();
        this.reportIdVsViewAttributesMap = new Hashtable();
        this.syncObj = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOUName(String domainName, String distinguishedName) {
        distinguishedName = distinguishedName.toLowerCase();
        String ret = "";
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        Hashtable<Integer, String> indexVsOU = new Hashtable<Integer, String>();
        Object object = this.syncObj;
        synchronized (object) {
            try {
                if (this.domainList == null) {
                    Hashtable domains = DomainHandler.getDomainsAndOUs(1L);
                    this.domainList = (ArrayList)domains.get("domainList");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (int i = 0; i < this.domainList.size(); ++i) {
                Properties domainProp = (Properties)this.domainList.get(i);
                if (!((String)domainProp.get("DOMAIN_NAME")).equalsIgnoreCase(domainName)) continue;
                ArrayList ouList = (ArrayList)domainProp.get("ouList");
                for (int j = 0; j < ouList.size(); ++j) {
                    Properties ouProp = (Properties)ouList.get(j);
                    String dn = ((String)ouProp.get("DISTINGUISHED_NAME")).toLowerCase();
                    String ouName = (String)ouProp.get("OU_NAME");
                    if (!distinguishedName.endsWith(dn) || distinguishedName.equalsIgnoreCase(dn)) continue;
                    Integer ind = new Integer(distinguishedName.indexOf(dn));
                    int insertedIndex = indexList.size();
                    for (int k = 0; k < indexList.size(); ++k) {
                        Integer index = (Integer)indexList.get(k);
                        if (ind <= index) continue;
                        insertedIndex = k;
                        break;
                    }
                    indexList.add(insertedIndex, ind);
                    indexVsOU.put(ind, ouName);
                }
            }
        }
        for (int i = 0; i < indexList.size(); ++i) {
            if (ret.length() != 0) {
                ret = ret + "/";
            }
            ret = ret + indexVsOU.get(indexList.get(i));
        }
        return ret;
    }

    public String getLocation(String domainName, String distinguishedName) {
        String domainDNSName = DomainHandler.getDomainDNSName(domainName);
        StringBuilder location = new StringBuilder(domainDNSName);
        String ouname = this.getOUName(domainName, distinguishedName);
        if (ouname != null && !ouname.equals("")) {
            location.append("/");
            location.append(ouname);
        }
        return location.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReportAttributeHandler getInstance() {
        if (handler != null) return handler;
        Class<ReportAttributeHandler> clazz = ReportAttributeHandler.class;
        synchronized (ReportAttributeHandler.class) {
            if (handler != null) return handler;
            handler = new ReportAttributeHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return handler;
        }
    }

    public ArrayList getTableNames(Integer reportId) {
        return this.getTableNames(reportId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getTableNames(Integer reportId, String objectClass) {
        ArrayList<String> reportTableList;
        String key = reportId.toString();
        if (objectClass != null) {
            objectClass = objectClass.toLowerCase();
            key = key + objectClass;
        }
        if ((reportTableList = (ArrayList<String>)this.reportTableNameMap.get(key)) == null) {
            reportTableList = new ArrayList<String>();
            try {
                String q = "select distinct(TABLE_NAME) from ADSMAttributeDetails inner join ADSMTotalReports on ADSMAttributeDetails.ATTRIB_ID = ADSMTotalReports.ATTRIB_ID where ADSMTotalReports.REPORT_ID = " + reportId.toString();
                if (objectClass != null) {
                    ObjectClass objClass = SearchProfileHandler.getInstance().getObjectClass(objectClass);
                    Integer startRange = objClass.getStartRange();
                    Integer endRange = objClass.getEndRange();
                    q = q + " and ADSMAttributeDetails.ATTRIB_ID >= " + startRange + " and ADSMAttributeDetails.ATTRIB_ID <= " + endRange;
                }
                Connection connection = null;
                Statement stmt = null;
                ResultSet rs = null;
                try {
                    RelationalAPI relationalAPI = RelationalAPI.getInstance();
                    connection = relationalAPI.getConnection();
                    stmt = connection.createStatement();
                    rs = stmt.executeQuery(q);
                    while (rs.next()) {
                        reportTableList.add(rs.getString(1));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                        if (rs != null) {
                            rs.close();
                        }
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception e) {}
                }
                this.reportTableNameMap.put(key, reportTableList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return reportTableList;
    }

    public Criteria getObjectClassCriteria(String objectClass) {
        Criteria crit = null;
        try {
            if (objectClass != null) {
                ObjectClass objClass = SearchProfileHandler.getInstance().getObjectClass(objectClass);
                Integer startRange = objClass.getStartRange();
                Integer endRange = objClass.getEndRange();
                crit = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)startRange, 4);
                crit = crit.and(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)endRange, 6));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    public ArrayList getAttributes(String tableName, Integer reportId) {
        return this.getAttributes(tableName, reportId, null);
    }

    public ArrayList getAttributes(String tableName, Integer reportId, String objectClass) {
        ArrayList attributeList = new ArrayList();
        try {
            String key = tableName + "-" + reportId;
            if (objectClass != null) {
                objectClass = objectClass.toLowerCase();
                key = key + objectClass;
            }
            if ((attributeList = (ArrayList)this.tableNameAttributesMap.get(key)) == null) {
                attributeList = new ArrayList();
                Table table = Table.getTable((String)"ADSMAttributeDetails");
                SelectQueryImpl selectQuery = new SelectQueryImpl(table);
                Column column = Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME");
                Criteria criteria = new Criteria(column, (Object)tableName, 0);
                criteria = criteria.and(new Criteria(Column.getColumn((String)"ADSMTotalReports", (String)"REPORT_ID"), (Object)reportId, 0));
                Criteria objCrit = this.getObjectClassCriteria(objectClass);
                if (objCrit != null) {
                    criteria = criteria.and(objCrit);
                }
                selectQuery.setCriteria(criteria);
                selectQuery.addJoin(new Join(table, Table.getTable((String)"ADSMTotalReports"), new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
                selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"));
                selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_DISP_NAME"));
                selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
                selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_DATA_TYPE"));
                selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"DATA_HANDLER_TYPE"));
                selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"RELATIONAL_TYPE"));
                selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"));
                selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"));
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
                if (!dataObject.isEmpty()) {
                    attributeList = CommonUtil.getList(dataObject, new String[]{"ATTRIB_DISP_NAME", "ATTRIB_COLUMN_NAME", "DATA_HANDLER_TYPE", "RELATIONAL_TYPE", "ATTRIB_LDAP_NAME", "ATTRIB_DATA_TYPE", "ATTRIB_ID", "TABLE_NAME"}, "ADSMAttributeDetails");
                }
                this.tableNameAttributesMap.put(key, attributeList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attributeList;
    }

    public ArrayList getViewAttributes(Integer reportId) {
        return this.getViewAttributes(reportId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getViewAttributes(Integer reportId, String objectClass) {
        ArrayList<Object> viewList;
        String key = reportId.toString();
        if (objectClass != null) {
            objectClass = objectClass.toLowerCase();
            key = key + objectClass;
        }
        if ((viewList = (ArrayList<Object>)this.reportIdVsViewAttributesMap.get(key)) == null) {
            viewList = new ArrayList<Object>();
            Connection connection = null;
            try {
                Table baseTable = Table.getTable((String)"ADSMAttributeDetails");
                Table joinTable = Table.getTable((String)"ADSMViewReports");
                SelectQueryImpl sq = new SelectQueryImpl(baseTable);
                sq.addJoin(new Join(baseTable, joinTable, new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
                Criteria criteria = new Criteria(Column.getColumn((String)"ADSMViewReports", (String)"REPORT_ID"), (Object)reportId, 0);
                Criteria objCrit = this.getObjectClassCriteria(objectClass);
                if (objCrit != null) {
                    criteria = criteria.and(objCrit);
                }
                sq.setCriteria(criteria);
                Column column = Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID");
                sq.addSelectColumn(column);
                sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
                boolean isAscending = true;
                SortColumn sortcolumn = new SortColumn(Column.getColumn((String)"ADSMViewReports", (String)"PRIORITY_ID"), isAscending);
                sq.addSortColumn(sortcolumn);
                RelationalAPI relAPI = RelationalAPI.getInstance();
                connection = relAPI.getConnection();
                DataSet dataSet = relAPI.executeQuery((Query)sq, connection);
                while (dataSet.next()) {
                    viewList.add(dataSet.getValue(1));
                }
                dataSet.close();
                this.reportIdVsViewAttributesMap.put(key, viewList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (SQLException se) {}
            }
        }
        return viewList;
    }

    public ArrayList getViewColumn(Integer reportId) {
        return this.getViewColumn(reportId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getViewColumn(Integer reportId, String objectClass) {
        ArrayList<Properties> viewList = new ArrayList<Properties>();
        Connection connection = null;
        try {
            Table baseTable = Table.getTable((String)"ADSMAttributeDetails");
            Table joinTable = Table.getTable((String)"ADSMViewReports");
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            sq.addJoin(new Join(baseTable, joinTable, new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMViewReports", (String)"REPORT_ID"), (Object)reportId, 0);
            Criteria objCrit = this.getObjectClassCriteria(objectClass);
            if (objCrit != null) {
                criteria = criteria.and(objCrit);
            }
            sq.setCriteria(criteria);
            boolean isAscending = true;
            SortColumn sortcolumn = new SortColumn(Column.getColumn((String)"ADSMViewReports", (String)"PRIORITY_ID"), isAscending);
            sq.addSortColumn(sortcolumn);
            Column column = Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID");
            sq.addSelectColumn(column);
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_DISP_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"RELATIONAL_TYPE"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"SHOW_SEARCH"));
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            DataSet dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                Properties prop = new Properties();
                prop.put("ATTRIB_ID", dataSet.getValue(1));
                prop.put("ATTRIB_DISP_NAME", (String)dataSet.getValue(2));
                prop.put("ATTRIB_LDAP_NAME", dataSet.getValue(3));
                prop.put("RELATIONAL_TYPE", dataSet.getValue(4));
                prop.put("TABLE_NAME", dataSet.getValue(5));
                prop.put("ATTRIB_COLUMN_NAME", dataSet.getValue(6));
                prop.put("SHOW_SEARCH", dataSet.getValue(7));
                viewList.add(prop);
            }
            dataSet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return viewList;
    }

    public ArrayList getEditColumn(Integer reportId, ArrayList viewList) {
        ArrayList totalList = this.getTotalColumn(reportId);
        ArrayList<Properties> nonVisibleList = new ArrayList<Properties>();
        for (int i = 0; i < totalList.size(); ++i) {
            Properties prop = (Properties)totalList.get(i);
            if (viewList.contains(prop)) continue;
            nonVisibleList.add(prop);
        }
        return nonVisibleList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getTotalColumn(Integer reportId) {
        ArrayList<Properties> totalList = null;
        Connection connection = null;
        totalList = new ArrayList<Properties>();
        try {
            Table baseTable = Table.getTable((String)"ADSMAttributeDetails");
            Table joinTable = Table.getTable((String)"ADSMTotalReports");
            SelectQueryImpl selectQuery = new SelectQueryImpl(baseTable);
            selectQuery.addJoin(new Join(baseTable, joinTable, new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMTotalReports", (String)"REPORT_ID"), (Object)reportId, 0);
            selectQuery.setCriteria(criteria);
            Column column = Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID");
            boolean isAscending = true;
            SortColumn sortColumn = new SortColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_DISP_NAME"), isAscending);
            selectQuery.addSelectColumn(column);
            column = Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_DISP_NAME");
            selectQuery.addSelectColumn(column);
            selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"RELATIONAL_TYPE"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"SHOW_SEARCH"));
            selectQuery.addSortColumn(sortColumn);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            DataSet dataSet = relAPI.executeQuery((Query)selectQuery, connection);
            while (dataSet.next()) {
                Properties reportprop = new Properties();
                reportprop.put("ATTRIB_ID", dataSet.getValue(1));
                reportprop.put("ATTRIB_DISP_NAME", (String)dataSet.getValue(2));
                reportprop.put("ATTRIB_LDAP_NAME", dataSet.getValue(3));
                reportprop.put("RELATIONAL_TYPE", dataSet.getValue(4));
                reportprop.put("TABLE_NAME", dataSet.getValue(5));
                reportprop.put("ATTRIB_COLUMN_NAME", dataSet.getValue(6));
                reportprop.put("SHOW_SEARCH", dataSet.getValue(7));
                totalList.add(reportprop);
            }
            dataSet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return totalList;
    }

    public boolean saveColumns(Integer reportId, ArrayList list) {
        boolean success = true;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMViewReports", (String)"REPORT_ID"), (Object)reportId, 0);
            CommonUtil.getPersistence(new boolean[0]).delete(crit);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            for (int i = 0; i < list.size(); ++i) {
                Properties p = (Properties)list.get(i);
                Row r = new Row("ADSMViewReports");
                r.set("REPORT_ID", (Object)reportId);
                r.set("ATTRIB_ID", p.get("ATTRIB_ID"));
                r.set("PRIORITY_ID", p.get("PRIORITY_ID"));
                dataObject.addRow(r);
            }
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            this.reportIdVsViewAttributesMap.remove(reportId.toString());
        }
        catch (Exception e) {
            success = false;
            e.printStackTrace();
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getModifiedColumns(Integer reportId) {
        ArrayList<Properties> modifiedList = new ArrayList<Properties>();
        Connection connection = null;
        try {
            Table baseTable = Table.getTable((String)"ADSMAttributeDetails");
            Table joinTable = Table.getTable((String)"ADSMModifiedColumns");
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            sq.addJoin(new Join(baseTable, joinTable, new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMModifiedColumns", (String)"REPORT_ID"), (Object)reportId, 0);
            sq.setCriteria(criteria);
            boolean isAscending = true;
            SortColumn sortcolumn = new SortColumn(Column.getColumn((String)"ADSMModifiedColumns", (String)"PRIORITY_ID"), isAscending);
            sq.addSortColumn(sortcolumn);
            Column column = Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID");
            sq.addSelectColumn(column);
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_DISP_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"RELATIONAL_TYPE"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            DataSet dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                Properties prop = new Properties();
                prop.put("ATTRIB_ID", dataSet.getValue(1));
                prop.put("ATTRIB_DISP_NAME", dataSet.getValue(2));
                prop.put("ATTRIB_LDAP_NAME", dataSet.getValue(3));
                prop.put("RELATIONAL_TYPE", dataSet.getValue(4));
                prop.put("TABLE_NAME", dataSet.getValue(5));
                prop.put("ATTRIB_COLUMN_NAME", dataSet.getValue(6));
                modifiedList.add(prop);
            }
            dataSet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return modifiedList;
    }

    public void setValues(String tableName, String columnName, ArrayList list, String sid) {
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)sid, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            dataObj.deleteRows(tableName, criteria);
            CommonUtil.getPersistence(new boolean[0]).update(dataObj);
            for (int i = 0; i < list.size(); ++i) {
                Row r = new Row(tableName);
                r.set("OBJECT_GUID", (Object)sid);
                r.set(columnName, (Object)((String)list.get(i)));
                dataObj.addRow(r);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getCount(String tableName, String sid) {
        Connection connection = null;
        Table table = Table.getTable((String)tableName);
        int rowCount = 0;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(table);
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)sid, 0);
            Column col = Column.getColumn(null, (String)"*").count();
            sq.addSelectColumn(col);
            sq.setCriteria(crit);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            DataSet dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                rowCount = (Integer)dataSet.getValue(1);
            }
            dataSet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return rowCount;
    }

    public Integer insertCustomValues(Map hashMap, String tableName, String dataType, String columnName, Long reportCategoryId) throws Exception {
        Object criteria = null;
        Long dataHandlerType = 0L;
        int attribId = this.getAttribId("ADSMAttributeDetails", tableName);
        Long actionId = this.getActionIdForCustomAttributes("ADMPActionDetails");
        actionId = actionId + 1L;
        hashMap.put("ATTRIB_ID", ++attribId);
        hashMap.put("MODIFY_ID", actionId);
        hashMap.put("AU_TABLE_NAME", "ADSMAUNamingAttributes");
        for (int i = 0; i < this.dataHandler.length; ++i) {
            if (!dataType.equals(this.dataHandler[i])) continue;
            dataHandlerType = this.dataValue[i];
        }
        hashMap.put("DATA_HANDLER_TYPE", dataHandlerType);
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row row = new Row("ADSMAttributeDetails");
            row.setAll(hashMap);
            dataObj.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).add(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.alterCustomTable(tableName, columnName, dataType);
        this.updateActionDetails((String)hashMap.get("ATTRIB_DISP_NAME"), actionId);
        this.updateTotalTable(attribId, tableName);
        return attribId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getAttribId(String attributeTable, String tableName) throws Exception {
        String[] tables = new String[]{"ADSMUserCustomDetails", "ADSMGroupCustomDetails", "ADSMComputerCustomDetails", "ADSMPasswordCustomDetails", "ADSMExchangeCustomDetails", "ADSMPolicyCustomDetails"};
        int attribId = 0;
        int gThan = 0;
        int lThan = 0;
        Connection connection = null;
        Criteria crit = null;
        for (int i = 0; i < tables.length; ++i) {
            if (!tableName.equals(tables[i])) continue;
            gThan = 1500 + i * 1000;
            lThan = 2000 + i * 1000;
            crit = this.getCriteria(gThan, lThan, attributeTable);
            break;
        }
        try {
            Table table = Table.getTable((String)attributeTable);
            SelectQueryImpl sq = new SelectQueryImpl(table);
            Column col = Column.getColumn((String)attributeTable, (String)"ATTRIB_ID").maximum();
            sq.addSelectColumn(col);
            sq.setCriteria(crit);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            DataSet dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                if (dataSet.getValue(1) != null) {
                    attribId = (Integer)dataSet.getValue(1);
                    continue;
                }
                attribId = gThan;
            }
            dataSet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return attribId;
    }

    public Criteria getCriteria(int gThan, int lThan, String attributeTable) {
        Criteria crit = new Criteria(Column.getColumn((String)attributeTable, (String)"ATTRIB_ID"), (Object)gThan, 4);
        Criteria criter = crit.and(new Criteria(Column.getColumn((String)attributeTable, (String)"ATTRIB_ID"), (Object)lThan, 6));
        return criter;
    }

    public void alterCustomTable(String tableName, String columnName, String dataType) throws Exception {
        Object criteria = null;
        Object defaultValue = null;
        AlterTableQueryImpl alt = new AlterTableQueryImpl(tableName, 1);
        alt.setColumnName(columnName);
        if (dataType.equalsIgnoreCase("DATETIME")) {
            dataType = "BIGINT";
        }
        alt.setDataType(dataType);
        alt.setMaxLength(250);
        alt.setNullable(true);
        alt.setDefaultValue(defaultValue);
        try {
            CommonUtil.getPersistence(new boolean[0]).alterTable((AlterTableQuery)alt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateTotalTable(int attribId, String tableName) throws Exception {
        ArrayList list = new ArrayList();
        try {
            String baseTableName = null;
            for (int i = 0; i < this.tableArray.length; ++i) {
                if (!this.tableArray[i].equalsIgnoreCase(tableName)) continue;
                baseTableName = baseTableArray[i];
            }
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMReports", (String)"BASE_TABLE_NAME"), baseTableName, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMReports", crit);
            Iterator ite = dataObj.getRows("ADSMReports");
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            while (ite.hasNext()) {
                Row r = (Row)ite.next();
                int reportId = (Integer)r.get("REPORT_ID");
                Row row = new Row("ADSMTotalReports");
                row.set("REPORT_ID", (Object)reportId);
                row.set("ATTRIB_ID", (Object)attribId);
                dObj.addRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateActionDetails(String displayName, Long actionId) {
        String tableName = "ADMPActionDetails";
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, (Row)null);
            Row r = new Row(tableName);
            r.set("ACTION_ID", (Object)actionId);
            r.set("ACTION_NAME", (Object)displayName);
            r.set("PARENT_ID", (Object)1915L);
            r.set("PRIORITY", (Object)new Integer(1));
            dataObject.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getActionIdForCustomAttributes(String tableName) {
        Long actionId = 1350L;
        Connection connection = null;
        try {
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl sq = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"ACTION_ID"), (Object)1350L, 4);
            criteria = criteria.and(Column.getColumn((String)tableName, (String)"ACTION_ID"), (Object)1400L, 7);
            Column col = Column.getColumn((String)tableName, (String)"ACTION_ID").maximum();
            sq.addSelectColumn(col);
            sq.setCriteria(criteria);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            DataSet dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                if (dataSet.getValue(1) == null) continue;
                actionId = (Long)dataSet.getValue(1);
            }
            dataSet.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {}
        }
        return actionId;
    }

    public ArrayList getFieldList() {
        ArrayList<Properties> fieldList = new ArrayList<Properties>();
        try {
            Criteria crit = null;
            String tableName = "ADSMCustomFields";
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMCustomFields", crit);
            Iterator ite = dataObj.getRows(tableName);
            while (ite.hasNext()) {
                Row r = (Row)ite.next();
                Properties prop = new Properties();
                prop.put("FIELD_ID", (Long)r.get("FIELD_ID"));
                prop.put("LDAP_NAME", (String)r.get("LDAP_NAME"));
                prop.put("DISPLAY_NAME", (String)r.get("DISPLAY_NAME"));
                prop.put("DATA_TYPE", (String)r.get("DATA_TYPE"));
                prop.put("FOR_REPORTS", (String)r.get("FOR_REPORTS"));
                fieldList.add(prop);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldList;
    }

    public ArrayList getCustomFieldList() {
        ArrayList<JSONObject> critList = new ArrayList<JSONObject>();
        try {
            String[] defaultArray = new String[]{"mail", "mobile", "department"};
            for (int i = 0; i < defaultArray.length; ++i) {
                JSONObject crit = new JSONObject();
                String defaultvalue = defaultArray[i];
                crit.put("LDAP_NAME", (Object)defaultvalue);
                crit.put("TITLE", (Object)defaultvalue);
                crit.put("DISPLAY_NAME", (Object)defaultvalue);
                critList.add(crit);
            }
            ArrayList customfields = this.getFieldList();
            for (int i = 0; i < customfields.size(); ++i) {
                JSONObject crit = new JSONObject();
                Properties prop = (Properties)customfields.get(i);
                String ldap_name = (String)prop.get("LDAP_NAME");
                String ldapdisplayname = (String)prop.get("DISPLAY_NAME");
                if (ldap_name.equalsIgnoreCase("mail") || ldap_name.equalsIgnoreCase("department") || ldap_name.equalsIgnoreCase("mobile")) continue;
                crit.put("LDAP_NAME", (Object)ldap_name);
                String title = StrUtil.encodeURIComponent(ldapdisplayname);
                crit.put("TITLE", (Object)title);
                if (ldapdisplayname.length() > 10) {
                    ldapdisplayname = ldapdisplayname.substring(0, 9) + "..";
                }
                crit.put("DISPLAY_NAME", (Object)StrUtil.encodeURIComponent(ldapdisplayname));
                critList.add(crit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return critList;
    }

    public Long addCustomFields(ArrayList categoryList, int attribId, Map hashMap, String dataHandlerType) throws Exception {
        Long fieldId = new Long(0L);
        try {
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r = new Row("ADSMCustomFields");
            r.set("LDAP_NAME", (Object)((String)hashMap.get("ATTRIB_LDAP_NAME")));
            r.set("DISPLAY_NAME", (Object)((String)hashMap.get("ATTRIB_DISP_NAME")));
            r.set("DATA_TYPE", (Object)dataHandlerType);
            r.set("FOR_REPORTS", (Object)"adssp.admin.general.custom_attr.custom_attr");
            dObj.addRow(r);
            Row row = new Row("ADSMCustomIds");
            row.set("FIELD_ID", r.get("FIELD_ID"));
            row.set("CATEGORY_ID", (Object)new Long(1L));
            row.set("ATTRIB_ID", (Object)attribId);
            dObj.addRow(row);
            Long IAMattrId = IAMAttributeHandler.getAttributeId((String)((String)hashMap.get("ATTRIB_LDAP_NAME")));
            if (IAMattrId == 0L) {
                Row r2 = new Row("ADSIAMADAttributes");
                r2.set("ATTRIB_NAME", (Object)((String)hashMap.get("ATTRIB_LDAP_NAME")));
                r2.set("DISPLAY_NAME", (Object)((String)hashMap.get("ATTRIB_DISP_NAME")));
                r2.set("OBJECT_TYPE", (Object)"USER");
                r2.set("DATA_TYPE", (Object)dataHandlerType);
                dObj.addRow(r2);
            }
            CommonUtil.getPersistence(new boolean[0]).add(dObj);
            fieldId = (Long)r.get("FIELD_ID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldId;
    }

    public JSONObject updateCustomAttributes(HttpServletRequest request) {
        JSONObject status = new JSONObject();
        try {
            Long IAMattrId;
            String tableName = "ADSMUserCustomDetails";
            String dataType = request.getParameter("DATA_TYPE");
            String ldapName = request.getParameter("LDAP_NAME");
            String displayName = request.getParameter("DISPLAY_NAME");
            Long fieldId = new Long(request.getParameter("FIELD_ID"));
            Criteria c = new Criteria(Column.getColumn((String)"ADSMCustomFields", (String)"FIELD_ID"), (Object)fieldId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMCustomFields", c);
            Row r = obj.getFirstRow("ADSMCustomFields");
            String old_ldapname = (String)r.get("LDAP_NAME");
            this.updatePolicyLDAPAttribName(old_ldapname, ldapName);
            r.set("DISPLAY_NAME", (Object)displayName);
            r.set("LDAP_NAME", (Object)ldapName);
            r.set("DATA_TYPE", (Object)dataType);
            obj.updateRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(obj);
            Criteria c1 = new Criteria(Column.getColumn((String)"ADSMCustomIds", (String)"FIELD_ID"), (Object)fieldId, 0);
            DataObject obj1 = CommonUtil.getPersistence(new boolean[0]).get("ADSMCustomIds", c1);
            Row r1 = obj1.getFirstRow("ADSMCustomIds");
            Long categId = (Long)r1.get("CATEGORY_ID");
            Criteria c2 = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), r1.get("ATTRIB_ID"), 0);
            DataObject obj2 = CommonUtil.getPersistence(new boolean[0]).get("ADSMAttributeDetails", c2);
            Row r2 = obj2.getFirstRow("ADSMAttributeDetails");
            String oldLDAPName = (String)r2.get("ATTRIB_LDAP_NAME");
            r2.set("ATTRIB_LDAP_NAME", (Object)ldapName);
            r2.set("ATTRIB_DISP_NAME", (Object)displayName);
            String columnName = (String)r2.get("ATTRIB_COLUMN_NAME");
            for (int i = 0; i < this.dataHandler.length; ++i) {
                if (!dataType.equals(this.dataHandler[i])) continue;
                r2.set("DATA_HANDLER_TYPE", (Object)this.dataValue[i]);
                break;
            }
            obj2.updateRow(r2);
            CommonUtil.getPersistence(new boolean[0]).update(obj2);
            Criteria c3 = new Criteria(Column.getColumn((String)"ADMPActionDetails", (String)"ACTION_ID"), r2.get("MODIFY_ID"), 0);
            DataObject obj3 = CommonUtil.getPersistence(new boolean[0]).get("ADMPActionDetails", c3);
            if (!obj3.isEmpty()) {
                Row r3 = obj3.getFirstRow("ADMPActionDetails");
                r3.set("ACTION_NAME", (Object)displayName);
                obj3.updateRow(r3);
                CommonUtil.getPersistence(new boolean[0]).update(obj3);
            }
            Criteria c4 = new Criteria(Column.getColumn((String)"SSPSPDisplayColumn", (String)"ATTRIB_ID"), r2.get("ATTRIB_ID"), 0);
            DataObject obj4 = CommonUtil.getPersistence(new boolean[0]).get("SSPSPDisplayColumn", c4);
            if (!obj4.isEmpty()) {
                Row r4 = obj4.getFirstRow("SSPSPDisplayColumn");
                r4.set("ATTRIB_DISP_NAME", (Object)displayName);
                obj4.updateRow(r4);
                CommonUtil.getPersistence(new boolean[0]).update(obj4);
            }
            Criteria c5 = new Criteria(Column.getColumn((String)"SSPSPSearchCriteria", (String)"ATTRIB_ID"), r2.get("ATTRIB_ID"), 0);
            DataObject obj5 = CommonUtil.getPersistence(new boolean[0]).get("SSPSPSearchCriteria", c5);
            if (!obj5.isEmpty()) {
                Row r5 = obj5.getFirstRow("SSPSPSearchCriteria");
                r5.set("ATTRIB_DISP_NAME", (Object)displayName);
                obj5.updateRow(r5);
                CommonUtil.getPersistence(new boolean[0]).update(obj5);
            }
            if ((IAMattrId = Long.valueOf(IAMAttributeHandler.getAttributeId((String)oldLDAPName))) > 18L) {
                Criteria c6 = new Criteria(Column.getColumn((String)"ADSIAMADAttributes", (String)"ATTRIB_ID"), (Object)IAMattrId, 0);
                DataObject obj6 = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMADAttributes", c6);
                if (!obj6.isEmpty()) {
                    Row r6 = obj6.getFirstRow("ADSIAMADAttributes");
                    r6.set("DISPLAY_NAME", (Object)displayName);
                    r6.set("ATTRIB_NAME", (Object)ldapName);
                    r6.set("DATA_TYPE", (Object)dataType);
                    obj6.updateRow(r6);
                    CommonUtil.getPersistence(new boolean[0]).update(obj6);
                }
            }
            Long actionId = (Long)r2.get("MODIFY_ID");
            status.put("ACTION_ID", (Object)actionId);
            status.put("FIELD_ID", (Object)fieldId);
            this.deleteCustomDetails(categId, columnName);
            this.alterCustomTable(tableName, columnName, dataType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public void updatePolicyLDAPAttribName(String old_ldapname, String new_ldapname) {
        try {
            if (!(old_ldapname.equalsIgnoreCase("mail") || old_ldapname.equalsIgnoreCase("mobile") || old_ldapname.equalsIgnoreCase("department"))) {
                Criteria criteria = new Criteria(Column.getColumn((String)"SSPPolicyLDAPCriteria", (String)"ATTRIB_LDAP_NAME"), (Object)old_ldapname, 0);
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("SSPPolicyLDAPCriteria", criteria);
                if (!dataObj.isEmpty()) {
                    Row r = dataObj.getFirstRow("SSPPolicyLDAPCriteria");
                    r.set("ATTRIB_LDAP_NAME", (Object)new_ldapname);
                    dataObj.updateRow(r);
                    CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Long deleteCustomFields(Long fieldId) {
        Long modifyId = null;
        Criteria criteria = new Criteria(Column.getColumn((String)"ADSMCustomIds", (String)"FIELD_ID"), (Object)fieldId, 0);
        Criteria fieldCrit = new Criteria(Column.getColumn((String)"ADSMCustomFields", (String)"FIELD_ID"), (Object)fieldId, 0);
        try {
            if (fieldId != null) {
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMCustomIds", criteria);
                Iterator ite = dataObj.getRows("ADSMCustomIds", criteria);
                while (ite.hasNext()) {
                    Row r = (Row)ite.next();
                    int attribId = (Integer)r.get("ATTRIB_ID");
                    Long categId = (Long)r.get("CATEGORY_ID");
                    Criteria crit = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)attribId, 0);
                    DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMAttributeDetails", crit);
                    modifyId = (Long)dObj.getValue("ADSMAttributeDetails", "MODIFY_ID", crit);
                    String columnName = (String)dObj.getValue("ADSMAttributeDetails", "ATTRIB_COLUMN_NAME", crit);
                    String ldapName = (String)dObj.getValue("ADSMAttributeDetails", "ATTRIB_LDAP_NAME", crit);
                    CommonUtil.getPersistence(new boolean[0]).delete(crit);
                    this.deleteCustomDetails(categId, columnName);
                    crit = new Criteria(Column.getColumn((String)"ADMPActionDetails", (String)"ACTION_ID"), (Object)modifyId, 0);
                    CommonUtil.getPersistence(new boolean[0]).delete(crit);
                    crit = new Criteria(Column.getColumn((String)"SSPSPDisplayColumn", (String)"ATTRIB_ID"), (Object)attribId, 0);
                    CommonUtil.getPersistence(new boolean[0]).delete(crit);
                    crit = new Criteria(Column.getColumn((String)"SSPSPSearchCriteria", (String)"ATTRIB_ID"), (Object)attribId, 0);
                    CommonUtil.getPersistence(new boolean[0]).delete(crit);
                    Long IAMattrId = IAMAttributeHandler.getAttributeId((String)ldapName);
                    if (IAMattrId <= 18L) continue;
                    crit = new Criteria(Column.getColumn((String)"ADSIAMADAttributes", (String)"ATTRIB_ID"), (Object)IAMattrId, 0);
                    CommonUtil.getPersistence(new boolean[0]).delete(crit);
                }
                dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMCustomFields", fieldCrit);
                dataObj.deleteRows("ADSMCustomFields", fieldCrit);
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return modifyId;
    }

    public static boolean isPolicyLDAPCriteria(String ldap_name) {
        try {
            if (!(ldap_name.equalsIgnoreCase("mail") || ldap_name.equalsIgnoreCase("mobile") || ldap_name.equalsIgnoreCase("department"))) {
                Criteria criteria = new Criteria(Column.getColumn((String)"SSPPolicyLDAPCriteria", (String)"ATTRIB_LDAP_NAME"), (Object)ldap_name, 0);
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("SSPPolicyLDAPCriteria", criteria);
                if (!dataObj.isEmpty()) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean deleteCustomDetails(Long categId, String columnName) {
        boolean status = true;
        String tableName = this.tableArray[(int)categId.longValue() - 1];
        AlterTableQueryImpl alt = new AlterTableQueryImpl(tableName, columnName, 3);
        try {
            CommonUtil.getPersistence(new boolean[0]).alterTable((AlterTableQuery)alt);
        }
        catch (Exception e) {
            e.printStackTrace();
            status = false;
        }
        return status;
    }

    public static String getFieldLDAPName(Long fieldId) {
        String ldapName = "";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMCustomFields", (String)"FIELD_ID"), (Object)fieldId, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMCustomFields", criteria);
            Iterator ite = dataObj.getRows("ADSMCustomFields");
            while (ite.hasNext()) {
                Row r = (Row)ite.next();
                ldapName = (String)r.get("LDAP_NAME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ldapName;
    }

    public Properties getFieldRow(Long fieldId) {
        Properties p = new Properties();
        ArrayList<String> list = new ArrayList<String>();
        Criteria crit = new Criteria(Column.getColumn((String)"ADSMCustomFields", (String)"FIELD_ID"), (Object)fieldId, 0);
        Criteria criteria = new Criteria(Column.getColumn((String)"ADSMCustomIds", (String)"FIELD_ID"), (Object)fieldId, 0);
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMCustomFields", crit);
            Row fieldRow = dataObj.getRow("ADSMCustomFields", crit);
            p.put("LDAP_NAME", fieldRow.get("LDAP_NAME"));
            p.put("DISPLAY_NAME", fieldRow.get("DISPLAY_NAME"));
            p.put("DATA_TYPE", fieldRow.get("DATA_TYPE"));
            p.put("UPDATE_FIELD_ID", fieldId);
            DataObject idObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMCustomIds", criteria);
            Iterator ite = idObj.getRows("ADSMCustomIds", criteria);
            while (ite.hasNext()) {
                Row r = (Row)ite.next();
                Long categId = (Long)r.get("CATEGORY_ID");
                int attribId = (Integer)r.get("ATTRIB_ID");
                p.put("ATTRIB_ID", (Object)attribId);
                String customTable = this.tableArray[(int)categId.longValue() - 1];
                p.put(customTable, new Boolean("true"));
                list.add(customTable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetValues() {
        Object object = this.syncObj;
        synchronized (object) {
            this.domainList = null;
        }
    }

    public void resetAttributes() {
        this.reportTableNameMap = new Hashtable();
        this.tableNameAttributesMap = new Hashtable();
        this.reportIdVsViewAttributesMap = new Hashtable();
    }

    public Properties getAttributeProps(int[] ids) {
        Properties attribList = new Properties();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)ids, 8);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMAttributeDetails", crit);
            Iterator it = obj.getRows("ADSMAttributeDetails");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Properties prop = new Properties();
                prop.put("ATTRIB_ID", r.get("ATTRIB_ID"));
                prop.put("ATTRIB_DISP_NAME", r.get("ATTRIB_DISP_NAME"));
                prop.put("ATTRIB_LDAP_NAME", r.get("ATTRIB_LDAP_NAME"));
                prop.put("RELATIONAL_TYPE", r.get("RELATIONAL_TYPE"));
                prop.put("TABLE_NAME", r.get("TABLE_NAME"));
                prop.put("ATTRIB_COLUMN_NAME", r.get("ATTRIB_COLUMN_NAME"));
                attribList.put(r.get("ATTRIB_ID"), prop);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attribList;
    }

    public static String getColumnName(String displayName) {
        String str = "";
        try {
            String columnName = displayName.toUpperCase();
            char[] ar = columnName.toCharArray();
            for (int i = 0; i < ar.length; ++i) {
                str = ar[i] >= 'a' && ar[i] <= 'z' || ar[i] >= 'A' && ar[i] <= 'Z' || ar[i] >= '0' && ar[i] <= '9' ? str + ar[i] : str + "_";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CommonUtil.getValidName(str);
    }

    public static boolean isColumnExists(String tableName, String columnName) {
        try {
            TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)tableName);
            if (!tableDef.hasColumn(columnName)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String getCustomColumnName(String colName) {
        colName = String.valueOf(colName.hashCode()).replace("-", "_");
        return "COL_" + colName;
    }

    public static Boolean isAttributeModifiable(String ldapName) {
        return !nonModifiableAttribList.contains(ldapName.toLowerCase());
    }

    public static Hashtable getCustomAttributesDataType() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMCustomFields", (Criteria)null);
            Iterator it = obj.getRows("ADSMCustomFields");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                h.put(((String)r.get("LDAP_NAME")).toLowerCase(), (String)r.get("DATA_TYPE"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return h;
    }

    public static String getCustomAttribDate(String ldapName, String value, HttpServletRequest request, AdventNetResourceBundle rb) {
        String dateTime = null;
        try {
            if (rb == null) {
                rb = ResourceBundleMgr.getInstance().getBundle();
            }
            Long timeInMillis = Long.parseLong(value);
            if (ldapName.equalsIgnoreCase("accountExpires") && (timeInMillis == 0L || timeInMillis >= 5223372036854775807L)) {
                dateTime = rb.getString("adssp.reports.adreport.status.never_expires");
            } else if (timeInMillis != 0L) {
                if (request != null) {
                    dateTime = TimeZoneUtil.getTimeInCustomFormat(CommonUtil.getSystemTimeFromFileTime(timeInMillis), request);
                } else {
                    HashMap dateFormatMap = TimeZoneUtil.getCustomDateFormat(1L);
                    dateTime = TimeZoneUtil.getTimeInCustomFormat(CommonUtil.getSystemTimeFromFileTime(timeInMillis), dateFormatMap, rb);
                }
            } else {
                dateTime = "0";
            }
        }
        catch (Exception e) {
            dateTime = null;
        }
        return dateTime;
    }

    public static JSONObject getConstrainedAttrib() {
        JSONObject jsonObj = null;
        try {
            jsonObj = new JSONObject("{accountexpires:['BIGINT','DATETIME'],pwdlastset:['BIGINT','DATETIME'],whenchanged:['BIGINT','DATETIME'],whencreated:['BIGINT','DATETIME'],badpasswordtime:['BIGINT','DATETIME'],lastlogon:['BIGINT','DATETIME'],lastlogontimestamp:['BIGINT','DATETIME']}");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObj;
    }

    public static boolean isAttrInViewReports(int attribId) {
        boolean isPresent = false;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMViewReports", (String)"ATTRIB_ID"), (Object)attribId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMViewReports", crit);
            if (!obj.isEmpty()) {
                isPresent = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isPresent;
    }

    public static boolean isAttrInEmpSearch(int attribId) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPSPSearchCriteria", (String)"ATTRIB_ID"), (Object)attribId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSPSearchCriteria", crit);
            if (!obj.isEmpty()) {
                return true;
            }
            crit = new Criteria(Column.getColumn((String)"SSPSPDisplayColumn", (String)"ATTRIB_ID"), (Object)attribId, 0);
            obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSPDisplayColumn", crit);
            if (!obj.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

