/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.reports;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainUtil;
import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.admin.AdvancedPolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.AuditAPI;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.RestrictUsersHandler;
import com.adventnet.sym.adsm.common.server.admin.SchedulerHandler;
import com.adventnet.sym.adsm.common.server.admin.SecondaryAttributesHandler;
import com.adventnet.sym.adsm.common.server.admin.SelfServiceHandler;
import com.adventnet.sym.adsm.common.server.admin.SoonToExpireHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.configuration.EnrollmentNotifyHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mail.SendMailAPI;
import com.adventnet.sym.adsm.common.server.mailalias.GSSelfServiceHandler;
import com.adventnet.sym.adsm.common.server.notifications.PolicyNotifications;
import com.adventnet.sym.adsm.common.server.reports.AuditMgmtUtil;
import com.adventnet.sym.adsm.common.server.reports.RecordWriter;
import com.adventnet.sym.adsm.common.server.reports.ReportTask;
import com.adventnet.sym.adsm.common.server.reports.util.PasswordAgeUtil;
import com.adventnet.sym.adsm.common.server.security.PasswordGenerator;
import com.adventnet.sym.adsm.common.server.selfservice.nonad.NonADHandler;
import com.adventnet.sym.adsm.common.server.sms.SMSAction;
import com.adventnet.sym.adsm.common.server.taskengine.SchedulerConfiguration;
import com.adventnet.sym.adsm.common.server.util.APCUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.FormatUtil;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.TimeZoneUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import com.adventnet.sym.adsm.common.server.util.ZipUtility;
import com.adventnet.sym.adsm.common.server.util.licensing.LicenseManager;
import com.adventnet.sym.adsm.common.server.util.licensing.LicenseUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.manageengine.ads.fw.mobile.pushnotification.PNEnrollmentHandler;
import com.manageengine.ads.fw.mobile.pushnotification.PushNotificationConstants;
import com.manageengine.ads.fw.mobile.pushnotification.SendPushNotification;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReportHandler
implements PushNotificationConstants {
    private static int[] reportIds = new int[]{1, 2, 3};
    private static Logger logger = Logger.getLogger("ReportHandler");
    public static final String[] LDAP_ATTRIBUTES = new String[0];
    public static final String[] CUSTOM_LDAP = new String[0];
    public static final String[] CUSTOM_ATTRIBUTES = new String[]{"reportName", "dateTime", "scheduleTime"};

    public static DataObject getReportDetails(Integer reportId) {
        DataObject dataObj = null;
        try {
            Column col = Column.getColumn((String)"ADSMReports", (String)"REPORT_ID");
            Criteria criteria = new Criteria(col, (Object)new Long(reportId.intValue()), 0);
            dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMReports", criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObj;
    }

    public static Long addReportGenerationDetails(Hashtable reportProps) {
        Long ret = null;
        try {
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r = new Row("ADSMObjectGenerationDetails");
            r.set("LOGIN_ID", reportProps.get("LOGIN_ID"));
            r.set("REPORT_ID", reportProps.get("REPORT_ID"));
            r.set("CREATION_TIME", (Object)new Long(System.currentTimeMillis()));
            r.set("STATUS", reportProps.get("STATUS"));
            r.set("REPORT_GENERATION_NAME", (Object)new Date().toString());
            r.set("DESCRIPTION", reportProps.get("DESCRIPTION"));
            r.set("DOMAIN_NAME", reportProps.get("DOMAIN_NAME"));
            dataObj.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).add(dataObj);
            ret = (Long)r.get("REPORT_GENERATION_ID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Row getGeneratedReportDetails(Long generationId, Long loginId) {
        Row desc = null;
        try {
            Column col = Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"REPORT_GENERATION_ID");
            Criteria criteria = new Criteria(col, (Object)generationId, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMObjectGenerationDetails", criteria);
            desc = dataObj.getRow("ADSMObjectGenerationDetails");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return desc;
    }

    public static void updateGeneratedReportDetails(Long generationId, String description, Long loginId) {
        try {
            Column col = Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"REPORT_GENERATION_ID");
            Criteria criteria = new Criteria(col, (Object)generationId, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMObjectGenerationDetails", criteria);
            Row desc = dataObj.getRow("ADSMObjectGenerationDetails");
            desc.set("DESCRIPTION", (Object)description);
            desc.set("LOGIN_ID", (Object)loginId);
            dataObj.updateRow(desc);
            CommonUtil.getPersistence(new boolean[0]).update(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateReportGenerationDetails(Long generationId, int status, String desc, Long loginId) {
        try {
            Column col = Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"REPORT_GENERATION_ID");
            Criteria criteria = new Criteria(col, (Object)generationId, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMObjectGenerationDetails", criteria);
            Row r = dataObj.getRow("ADSMObjectGenerationDetails");
            r.set("STATUS", (Object)new Long(status));
            r.set("DESCRIPTION", (Object)desc);
            r.set("LOGIN_ID", (Object)loginId);
            dataObj.updateRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Long getRecentlyGeneratedReports(Integer reportId, Long loginId) {
        Long ret = null;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMObjectGenerationDetails"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"REPORT_GENERATION_ID"));
            Column col = Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"REPORT_ID");
            Criteria criteria = new Criteria(col, (Object)reportId, 0);
            Column col1 = Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"LOGIN_ID");
            criteria = criteria.and(new Criteria(col1, (Object)loginId, 0));
            Column column = Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"CREATION_TIME");
            SortColumn sortCol = new SortColumn(column, false);
            sq.addSortColumn(sortCol);
            sq.setCriteria(criteria);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!dataObj.isEmpty()) {
                Row r = dataObj.getRow("ADSMObjectGenerationDetails");
                ret = (Long)r.get("REPORT_GENERATION_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Long getRecentlyGeneratedReports(String domainName, Integer reportId, Long loginId) {
        Long ret = null;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMObjectGenerationDetails"));
            Criteria c = new Criteria(Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            c = c.and(new Criteria(Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"REPORT_ID"), (Object)reportId, 0));
            c = c.and(new Criteria(Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"LOGIN_ID"), (Object)loginId, 0));
            query.setCriteria(c);
            query.addSelectColumn(Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"REPORT_GENERATION_ID"));
            Column column = Column.getColumn((String)"ADSMObjectGenerationDetails", (String)"CREATION_TIME");
            SortColumn sortCol = new SortColumn(column, false);
            query.addSortColumn(sortCol);
            query.setCriteria(c);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                Row r = dataObj.getRow("ADSMObjectGenerationDetails");
                ret = (Long)r.get("REPORT_GENERATION_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void addSIDReportResult(Long generationId, String resultTableName, ArrayList guids) {
        RecordWriter writer = new RecordWriter(resultTableName);
        writer.writeData(generationId, guids);
        writer.flush();
    }

    public static void checkAndAddSIDReportResult(Long generationId, String resultTableName, ArrayList guids) {
        try {
            String[] objectIds = new String[guids.size()];
            for (int i = 0; i < guids.size(); ++i) {
                objectIds[i] = (String)guids.get(i);
            }
            Criteria crit = new Criteria(Column.getColumn((String)resultTableName, (String)"OBJECT_GUID"), (Object)objectIds, 8);
            Criteria c = new Criteria(Column.getColumn((String)resultTableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
            c = c.and(crit);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(resultTableName, c);
            for (int j = 0; j < guids.size(); ++j) {
                String guid = (String)guids.get(j);
                Row r = dataObject.getRow(resultTableName, new Criteria(Column.getColumn((String)resultTableName, (String)"OBJECT_GUID"), (Object)guid, 0));
                if (r != null) continue;
                Row row = new Row(resultTableName);
                row.set("REPORT_GENERATION_ID", (Object)generationId);
                row.set("OBJECT_GUID", (Object)guid);
                dataObject.addRow(row);
            }
            CommonUtil.getPersistenceLite().update(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.INFO, " Error while updating the SID Report Result : " + e.getMessage());
        }
    }

    public static void getMultipleValues(ArrayList attributeList, Hashtable multipleValuesSids) {
        ReportHandler.getMultipleValues(attributeList, multipleValuesSids, "OBJECT_GUID");
    }

    public static void getMultipleValues(ArrayList attributeList, Hashtable multipleValuesSids, String tableKey) {
        try {
            ArrayList<String> checkList = new ArrayList<String>();
            for (int i = 0; i < attributeList.size(); ++i) {
                Properties attributeProp = (Properties)attributeList.get(i);
                Integer relationalType = (Integer)attributeProp.get("RELATIONAL_TYPE");
                if (relationalType.equals(new Integer(0))) continue;
                String tableName = attributeProp.getProperty("TABLE_NAME");
                String columnName = attributeProp.getProperty("ATTRIB_COLUMN_NAME");
                Integer attributeId = (Integer)attributeProp.get("ATTRIB_ID");
                if (checkList.contains(tableName)) continue;
                SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
                String[] guids = new String[multipleValuesSids.size()];
                int j = 0;
                Enumeration e = multipleValuesSids.keys();
                while (e.hasMoreElements()) {
                    guids[j] = (String)e.nextElement();
                    ++j;
                }
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)tableKey), (Object)guids, 8);
                sq.setCriteria(crit);
                sq.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
                if (!dataObj.isEmpty()) {
                    Iterator it = dataObj.getRows(tableName);
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        String s = (String)r.get(tableKey);
                        ArrayList tableValues = ReportHandler.getTableAttributes(attributeList, tableName);
                        Hashtable attributeIds = (Hashtable)multipleValuesSids.get(s);
                        for (int k = 0; k < tableValues.size(); ++k) {
                            Properties props = (Properties)tableValues.get(k);
                            ArrayList<Object> values = (ArrayList<Object>)attributeIds.get((Integer)props.get("ATTRIB_ID"));
                            if (values == null) {
                                values = new ArrayList<Object>();
                                attributeIds.put((Integer)props.get("ATTRIB_ID"), values);
                            }
                            values.add(r.get((String)props.get("COLUMN_NAME")));
                        }
                    }
                }
                checkList.add(tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getTableAttributes(ArrayList attributeList, String tableName) {
        ArrayList<Properties> tableValues = new ArrayList<Properties>();
        try {
            String baseTable = "ADSMAttributeDetails";
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)baseTable));
            sq.addSelectColumn(Column.getColumn((String)baseTable, (String)"*"));
            sq.setCriteria(new Criteria(Column.getColumn((String)baseTable, (String)"TABLE_NAME"), (Object)tableName, 0));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows(baseTable);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Properties p = new Properties();
                    p.put("ATTRIB_ID", (Integer)r.get("ATTRIB_ID"));
                    p.put("COLUMN_NAME", (String)r.get("ATTRIB_COLUMN_NAME"));
                    tableValues.add(p);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tableValues;
    }

    public static Integer getSIDReportCount(Long generationId, String resultTableName) {
        return ReportHandler.getSIDReportCount(generationId, resultTableName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getSIDReportCount(Long generationId, String resultTableName, Criteria c) {
        Connection connection = null;
        DataSet dataSet = null;
        Integer ret = null;
        try {
            Column countColumn = Column.getColumn(null, (String)"*");
            Criteria crit = new Criteria(Column.getColumn((String)resultTableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
            if (c != null) {
                crit = crit.and(c);
            }
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)resultTableName));
            sq.addSelectColumn(countColumn.count());
            sq.setCriteria(crit);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                ret = (Integer)dataSet.getValue(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (SQLException se) {
                    se.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException se) {
                    se.printStackTrace();
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Integer getCount(SelectQuery sq) {
        Connection connection = null;
        DataSet dataSet = null;
        Integer ret = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                ret = (Integer)dataSet.getValue(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (SQLException se) {
                    se.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException se) {
                    se.printStackTrace();
                }
            }
        }
        return ret;
    }

    public static Hashtable executeReport(Hashtable props) {
        Hashtable<String, Properties> result = new Hashtable<String, Properties>();
        try {
            String notifyManager;
            Hashtable mgrPrevProp = new Hashtable();
            Boolean isRepAvail = false;
            ArrayList reportIds = (ArrayList)props.get("SCHEDULED_REPORT_IDS");
            Long scheduleId = (Long)props.get("SCHEDULE_ID");
            Hashtable inputs = (Hashtable)props.get("inputParams");
            String filePath = (String)props.get("STORAGE_PATH");
            boolean isDashUpdater = inputs == null || "true".equals(inputs.get("UpdateDashBoard"));
            String notifyAdmin = (String)inputs.get("NOTIFY_ADMIN");
            if (notifyAdmin == null) {
                notifyAdmin = (String)props.get("NOTIFY_ADMIN");
            }
            if ((notifyManager = (String)inputs.get("NOTIFY_MANAGER")) == null) {
                notifyManager = (String)props.get("NOTIFY_Manager");
            }
            String dir = "";
            ArrayList<String> repNames = new ArrayList<String>();
            for (int i = 0; i < reportIds.size(); ++i) {
                int reportId = (Integer)reportIds.get(i);
                ArrayList<String> domainList = (ArrayList<String>)props.get("SCHEDULED_DOMAINS");
                Hashtable domainVsOus = (Hashtable)props.get("DOMAIN_VS_OUS");
                Hashtable domainVsGroups = (Hashtable)props.get("DOMAIN_VS_GROUPS");
                Hashtable domainVsComputers = (Hashtable)props.get("DOMAIN_VS_COMPDETAILS");
                DataObject obj = ReportHandler.getReportDetails(reportId);
                Row r = obj.getFirstRow("ADSMReports");
                String className = (String)r.get("CLASS_NAME");
                String reportName = (String)r.get("REPORT_NAME");
                Class<?> classToInvoke = Class.forName(className.trim());
                ReportTask listener = (ReportTask)classToInvoke.newInstance();
                listener.init(r);
                repNames.add(reportName);
                Boolean checkLicense = (Boolean)props.get("CHECK_LICENSE");
                if (domainList == null || domainList.size() == 0) {
                    domainList = new ArrayList<String>();
                    Enumeration enumer = domainVsOus.keys();
                    while (enumer.hasMoreElements()) {
                        domainList.add((String)enumer.nextElement());
                    }
                }
                for (String domainName : domainList) {
                    ArrayList<Object> mgrDNList;
                    Properties notifyMgrProps;
                    String domainDN = "";
                    if (isDashUpdater) {
                        domainDN = DomainHandler.getDomainData("DOMAIN_NAME", domainName, "DEFAULT_NAMING_CONTEXT");
                    }
                    if ("dnDomainNameMap".equals(domainName)) continue;
                    Hashtable<String, String> dnDomainNameMap = new Hashtable<String, String>();
                    ArrayList conList = new ArrayList();
                    if (domainVsOus != null && domainVsOus.get(domainName) != null) {
                        conList = (ArrayList)domainVsOus.get(domainName);
                    }
                    if (domainVsGroups != null && domainVsGroups.get(domainName) != null) {
                        ArrayList itemList = (ArrayList)domainVsGroups.get(domainName);
                        if ("".equals(domainDN)) {
                            domainDN = DomainHandler.getDomainData("DOMAIN_NAME", domainName, "DEFAULT_NAMING_CONTEXT");
                        }
                        ArrayList<String> grpDNList = new ArrayList<String>();
                        String table = CommonUtil.getDomainGroupTableName(domainName);
                        Criteria crit = new Criteria(Column.getColumn((String)table, (String)"OBJECT_GUID"), (Object)itemList.toArray(new String[itemList.size()]), 8);
                        DataObject grpDO = CommonUtil.getPersistence(new boolean[0]).get(table, crit);
                        if (!grpDO.isEmpty()) {
                            grpDNList = new ArrayList();
                            Iterator grpIterator = grpDO.getRows(table);
                            while (grpIterator.hasNext()) {
                                Row grpRow = (Row)grpIterator.next();
                                grpDNList.add((String)grpRow.get("DN_STRING"));
                            }
                        }
                        if (grpDNList.size() > 0) {
                            conList.add("memberOf");
                            dnDomainNameMap.put(domainDN, domainName);
                            Properties grpProps = new Properties();
                            grpProps.setProperty("containerDN", domainDN);
                            grpProps.put("filterValues", grpDNList);
                            Properties searchFilters = new Properties();
                            searchFilters.put("memberOf", grpProps);
                            inputs.put("searchFilters", searchFilters);
                        }
                    }
                    if (isDashUpdater || conList.size() == 1 && conList.contains(domainDN)) {
                        logger.log(Level.INFO, "conList : " + conList);
                        ArrayList techOuList = ReportHandler.getUserVsReportOUMapping(1L, reportId, domainName);
                        if (techOuList != null && techOuList.size() > 0) {
                            techOuList = OUUtil.getParentOUs(techOuList);
                            ArrayList cloneConList = new ArrayList();
                            cloneConList.addAll(conList);
                            conList.clear();
                            conList.addAll(techOuList);
                            domainVsOus.put(domainName, cloneConList);
                        }
                        logger.log(Level.INFO, "conList : " + conList);
                    }
                    if (domainVsComputers != null && domainVsComputers.get(domainName) != null) {
                        ArrayList detailsList = (ArrayList)domainVsComputers.get(domainName);
                        if (detailsList != null) {
                            ArrayList<String> compList = new ArrayList<String>();
                            for (int k = 0; k < detailsList.size(); ++k) {
                                JSONObject compDetail = (JSONObject)detailsList.get(k);
                                compList.add(compDetail.getString("OBJECT_NAME"));
                            }
                            inputs.put("COMPUTER_LIST", compList);
                        }
                    } else {
                        inputs.put("COMPUTER_LIST", new ArrayList());
                    }
                    for (int j = 0; j < conList.size(); ++j) {
                        dnDomainNameMap.put((String)conList.get(j), domainName);
                    }
                    listener.executeTask(conList, dnDomainNameMap, inputs);
                    Long generationId = listener.getGenerationId();
                    ArrayList guidList = listener.getGuidList();
                    if (isDashUpdater) {
                        Integer c;
                        String statusMsg;
                        String string = statusMsg = listener.getErrorMessage() != null ? listener.getErrorMessage() : "adssp.admin.schedulelist.column.status_msg_success";
                        if (scheduleId != -1L) {
                            SchedulerConfiguration.updateScheduleStatus(domainName, scheduleId, statusMsg);
                        }
                        if ((c = listener.getResultCount()) != -1) {
                            ReportHandler.updateResultCount(domainName, reportName, c, generationId);
                        }
                    }
                    Hashtable<String, String> statusProps = new Hashtable<String, String>();
                    if ("true".equals(props.get("NOTIFY_USERS"))) {
                        props.put("ACTION_NAME", reportName.equals("adssp.xml.reports.soon_to_expire_pwd") ? "adssp.reports.audit_report.notification_delivery_report.password_expire_notificaiton" : (reportName.equals("adssp.xml.reports.pwd_expired") ? "adssp.reports.audit_report.notification_delivery_report.password_expired_notificaiton" : (reportName.equals("adssp.xml.reports.soon_to_expire_acc") ? "adssp.reports.audit_report.notification_delivery_report.account_expire_notificaiton" : "adssp.reports.audit_report.notification_delivery_report.account_expired_notification")));
                        ReportHandler.mailToUser(reportId, generationId, domainName, props, statusProps);
                        statusProps.put("MINUS_ONE", "true");
                    } else if (!isDashUpdater && "true".equals(notifyManager) && (reportId == 4 || reportId == 5)) {
                        notifyMgrProps = listener.getUserManagerProps(reportId, generationId, domainName, props);
                        props.put("notifyMgrProps", notifyMgrProps);
                    }
                    if ("true".equals((String)props.get("RESTRICT_USERS")) && guidList.size() > 0) {
                        RestrictUsersHandler.addUserToRestrict(guidList, domainName, reportId);
                    }
                    if (guidList.size() > 0 && !isDashUpdater && "true".equals(notifyAdmin)) {
                        if (dir.equals("")) {
                            String dirName = (String)props.get("DIRECTORY_NAME");
                            if (dirName == null) {
                                dirName = "";
                            }
                            dir = SchedulerHandler.makeDirectory(dirName, filePath);
                            props.put("DIRECTORY_PATH", dir);
                        }
                        props.put("DOMAIN_NAME", domainName);
                        Boolean isRepExported = listener.exportReport(reportId, generationId, scheduleId, new Long(1L), listener, props, statusProps);
                        if (!isRepAvail.booleanValue()) {
                            isRepAvail = isRepExported;
                        }
                    }
                    if (("true".equalsIgnoreCase((String)props.get("NOTIFY_MANAGER")) || "true".equals(notifyManager)) && (notifyMgrProps = (Properties)props.get("notifyMgrProps")) != null && (mgrDNList = Collections.list(notifyMgrProps.keys())) != null && mgrDNList.size() > 0) {
                        String resultTableName = "ADSMUserReportResult";
                        Hashtable<String, Object> mgrMailProps = new Hashtable<String, Object>();
                        mgrMailProps.putAll(props);
                        block8: for (String string : mgrDNList) {
                            Boolean isRepExported;
                            ArrayList userguidList = (ArrayList)notifyMgrProps.get(string);
                            ArrayList mailAttributes = SecondaryAttributesHandler.getAttributes(domainName, "MAIL");
                            mailAttributes.add("objectGUID");
                            mailAttributes.add("sAMAccountName");
                            Properties domainProperties = DomainHandler.getConfiguredValues(domainName, new Long(1L));
                            String rootDomainDN = (String)domainProperties.get("ROOT_DOMAIN_NAMING_CONTEXT");
                            ArrayList forestDomains = DomainHandler.getForestDomains(rootDomainDN, new Long(1L));
                            Properties mgrProps = new Properties();
                            for (int k = 0; k < forestDomains.size() && mgrProps.size() <= 0; ++k) {
                                Properties dProps = (Properties)forestDomains.get(k);
                                String domName = (String)dProps.get("DOMAIN_NAME");
                                Properties domProperties = DomainHandler.getConfiguredValues(domName, new Long(1L));
                                mgrProps = UserUtil.getObjValList(string, domProperties, mailAttributes, "distinguishedName");
                                if (mgrProps.size() <= 0) continue;
                                mgrProps.put("domainName", domName);
                            }
                            ArrayList guid = (ArrayList)mgrProps.get("objectGUID");
                            ArrayList samAccnt = (ArrayList)mgrProps.get("sAMAccountName");
                            mgrProps.remove("objectGUID");
                            ArrayList<String> mailIds = new ArrayList<String>();
                            for (int j = 0; j < mailAttributes.size(); ++j) {
                                String attributeKey = (String)mailAttributes.get(j);
                                ArrayList attributeValue = (ArrayList)mgrProps.get(attributeKey);
                                if (attributeValue == null) continue;
                                for (int k = 0; k < attributeValue.size(); ++k) {
                                    String value = (String)attributeValue.get(k);
                                    if (!StrUtil.isValidEmailID(value)) continue;
                                    mailIds.add(value);
                                }
                            }
                            if (mailIds == null || mailIds.size() == 0 || userguidList.size() <= 0) continue;
                            Hashtable<String, Object> reportProps = new Hashtable<String, Object>();
                            reportProps.put("REPORT_ID", reportId);
                            reportProps.put("LOGIN_ID", new Long(1L));
                            reportProps.put("DOMAIN_NAME", domainName);
                            reportProps.put("DESCRIPTION", (String)r.get("DESCRIPTION"));
                            reportProps.put("STATUS", new Long(0L));
                            Long genId = ReportHandler.addReportGenerationDetails(reportProps);
                            ReportHandler.addSIDReportResult(genId, resultTableName, userguidList);
                            ReportHandler.updateReportGenerationDetails(genId, 1, (String)r.get("DESCRIPTION"), new Long(1L));
                            String dirName = (String)mgrMailProps.get("DIRECTORY_NAME");
                            if (dirName == null) {
                                dirName = "";
                            }
                            String objGuid = (String)guid.get(0);
                            String samName = (String)samAccnt.get(0);
                            String mgrDomName = (String)mgrProps.get("domainName");
                            dir = "";
                            mgrMailProps.put("DOMAIN_NAME", domainName);
                            if ((reportId == 2 || reportId == 3 || reportId == 4 || reportId == 5) && mgrPrevProp.get(string) != null) {
                                dir = (String)((Hashtable)mgrPrevProp.get(string)).get("DIRECTORY_PATH");
                                mgrMailProps.put("DIRECTORY_PATH", dir);
                            }
                            if (dir.equals("")) {
                                dir = SchedulerHandler.makeDirectory(dirName + "_" + mgrDomName + "_" + samName + "_", filePath);
                                mgrMailProps.put("DIRECTORY_PATH", dir);
                            }
                            if (mgrMailProps.get("MANAGER_FILE_FORMAT") != null && mgrMailProps.get("MANAGER_ATTACHMENT_TYPE") != null) {
                                mgrMailProps.put("FILE_FORMAT", (String)mgrMailProps.get("MANAGER_FILE_FORMAT"));
                                mgrMailProps.put("ATTACHMENT_TYPE", (String)mgrMailProps.get("MANAGER_ATTACHMENT_TYPE"));
                            }
                            if (!(isRepExported = listener.exportReport(reportId, genId, scheduleId, new Long(1L), listener, mgrMailProps, statusProps)).booleanValue()) continue;
                            if (reportId == 2 || reportId == 3 || reportId == 4 || reportId == 5) {
                                if (mgrPrevProp.get(string) != null) continue;
                                mgrMailProps.put("EMAIL_ID_LIST", mailIds);
                                if (mgrMailProps.get("MANAGER_MAIL_SUBJECT") != null && mgrMailProps.get("MANAGER_MAIL_CONTENT") != null) {
                                    mgrMailProps.put("MAIL_SUBJECT", (String)mgrMailProps.get("MANAGER_MAIL_SUBJECT"));
                                    mgrMailProps.put("MAIL_CONTENT", (String)mgrMailProps.get("MANAGER_MAIL_CONTENT"));
                                }
                                mgrPrevProp.put(string, new Hashtable(mgrMailProps));
                                continue;
                            }
                            for (int j = 0; j < mailIds.size(); ++j) {
                                String mailId = (String)mailIds.get(j);
                                mgrMailProps.put("EMAIL_ID", mailId);
                                ReportHandler.mailToAdmin(mgrMailProps, isRepExported);
                                if ("adssp.common.text.mail_sent_success".equals(mgrMailProps.get("MAIL_STATUS"))) continue block8;
                            }
                        }
                    }
                    Properties resultProps = new Properties();
                    resultProps.put("GENERATION_ID", generationId);
                    result.put(domainName, resultProps);
                }
                listener.shutDownQueue();
            }
            Set keys = mgrPrevProp.keySet();
            block13: for (String key : keys) {
                Hashtable mgrMailProps = (Hashtable)mgrPrevProp.get(key);
                mgrMailProps.put("EXPORT_REPORT_NAMES", repNames);
                ArrayList mailIds = (ArrayList)mgrMailProps.get("EMAIL_ID_LIST");
                for (int j = 0; j < mailIds.size(); ++j) {
                    String mailId = (String)mailIds.get(j);
                    mgrMailProps.put("EMAIL_ID", mailId);
                    ReportHandler.mailToAdmin(mgrMailProps, true);
                    if ("adssp.common.text.mail_sent_success".equals(mgrMailProps.get("MAIL_STATUS"))) continue block13;
                }
            }
            if ("true".equals(notifyAdmin)) {
                props.put("EXPORT_REPORT_NAMES", repNames);
                props.put("DOMAIN_LIST", ((List)props.get("SCHEDULED_DOMAINS")).toString());
                ReportHandler.mailToAdmin(props, isRepAvail);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void executeAuditReport(Hashtable props) {
        try {
            String notifyAdmin;
            Boolean isRepAvail = false;
            Hashtable inputs = (Hashtable)props.get("inputParams");
            ArrayList reportIds = (ArrayList)props.get("SCHEDULED_REPORT_IDS");
            for (int i = 0; i < reportIds.size(); ++i) {
                int reportId = (Integer)reportIds.get(i);
                props.put("REPORT_ID", Integer.valueOf(reportId).toString());
                if (AuditMgmtUtil.USER_ATTEMPTS_IDS.contains(Integer.valueOf(reportId).toString())) {
                    ReportTask listener = ReportHandler.getListener(reportId);
                    Boolean isRepExported = listener.exportSSPReports(props);
                    if (!isRepAvail.booleanValue()) {
                        isRepAvail = isRepExported;
                    }
                    listener.shutDownQueue();
                    continue;
                }
                Hashtable domains = (Hashtable)props.get("DOMAIN_VS_OUS");
                Enumeration enumer = domains.keys();
                while (enumer.hasMoreElements()) {
                    String domainName = (String)enumer.nextElement();
                    ArrayList conList = (ArrayList)domains.get(domainName);
                    props.put("DOMAIN_NAME", domainName);
                    props.put("OU_LIST", conList);
                    ReportTask listener = ReportHandler.getListener(reportId);
                    Boolean isRepExported = listener.exportSSPReports(props);
                    if (!isRepAvail.booleanValue()) {
                        isRepAvail = isRepExported;
                    }
                    listener.shutDownQueue();
                }
            }
            String attachType = (String)props.get("ATTACHMENT_TYPE");
            String dirPath = (String)props.get("DIRECTORY_PATH");
            if (isRepAvail.booleanValue() && "ZIP".equals(attachType)) {
                ZipUtility.addtoZip(dirPath, "adssp-reports.zip");
            }
            if ((notifyAdmin = (String)inputs.get("NOTIFY_ADMIN")) == null) {
                notifyAdmin = (String)props.get("NOTIFY_ADMIN");
            }
            if ("true".equals(notifyAdmin)) {
                ReportHandler.mailToAdmin(props, isRepAvail);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void executeEnrollReport(Hashtable props) {
        try {
            String notifyAdmin;
            Boolean isRepAvail = false;
            Hashtable inputs = (Hashtable)props.get("inputParams");
            ArrayList reportIds = (ArrayList)props.get("SCHEDULED_REPORT_IDS");
            for (int i = 0; i < reportIds.size(); ++i) {
                int reportId = (Integer)reportIds.get(i);
                props.put("REPORT_ID", Integer.valueOf(reportId).toString());
                Hashtable domains = (Hashtable)props.get("DOMAIN_VS_OUS");
                Enumeration enumer = domains.keys();
                while (enumer.hasMoreElements()) {
                    String domainName = (String)enumer.nextElement();
                    ArrayList conList = (ArrayList)domains.get(domainName);
                    props.put("DOMAIN_NAME", domainName);
                    props.put("OU_LIST", conList);
                    ReportTask listener = ReportHandler.getListener(reportId);
                    Boolean isRepExported = listener.exportSSPReports(props);
                    if (!isRepAvail.booleanValue()) {
                        isRepAvail = isRepExported;
                    }
                    listener.shutDownQueue();
                }
            }
            String attachType = (String)props.get("ATTACHMENT_TYPE");
            String dirPath = (String)props.get("DIRECTORY_PATH");
            if (isRepAvail.booleanValue() && "ZIP".equals(attachType)) {
                ZipUtility.addtoZip(dirPath, "adssp-reports.zip");
            }
            if ((notifyAdmin = (String)inputs.get("NOTIFY_ADMIN")) == null) {
                notifyAdmin = (String)props.get("NOTIFY_ADMIN");
            }
            if ("true".equals(notifyAdmin)) {
                ReportHandler.mailToAdmin(props, isRepAvail);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static ReportTask getListener(int reportId) {
        ReportTask listener = null;
        try {
            DataObject obj = ReportHandler.getReportDetails(reportId);
            Row r = obj.getFirstRow("ADSMReports");
            String className = (String)r.get("CLASS_NAME");
            String reportName = (String)r.get("REPORT_NAME");
            Class<?> classToInvoke = Class.forName(className.trim());
            listener = (ReportTask)classToInvoke.newInstance();
            listener.init(r);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mailToUser(Integer reportId, Long generationId, String domainName, Hashtable notifyMailProps, Hashtable updateStatus) {
        Hashtable smsUpdateStatus = new Hashtable();
        Hashtable pnUpdateStatus = new Hashtable();
        Hashtable<String, Hashtable> mailUpdateStatus = new Hashtable<String, Hashtable>();
        Properties notifyMgrProps = new Properties();
        JSONObject pnUserProps = new JSONObject();
        JSONObject pnUserGUIDMap = new JSONObject();
        Long maxExpireDay = (Long)notifyMailProps.get("MAX_CONFIG_DAYS");
        String notifyMgr = (String)notifyMailProps.get("NOTIFY_MANAGER");
        try {
            Connection connection = null;
            DataSet dataSet = null;
            Properties mailServerProp = null;
            Long mailSentTime = (Long)notifyMailProps.get("MAIL_SENT_TIME");
            try {
                int notifyVia = Integer.parseInt(notifyMailProps.get("NOTIFY_VIA").toString());
                ArrayList notifyModes = SoonToExpireHandler.getInstance().getselectedNotifyModes(notifyVia);
                Long schTypeId = (Long)notifyMailProps.get("SCHEDULE_TYPE_ID");
                String nEnroll = (String)notifyMailProps.get("NOTIFY_ENROLLED");
                String excludeDisabledUsers = (String)notifyMailProps.get("EXCLUDE_DISABLED_USERS");
                String excludeSmartcardUsers = (String)notifyMailProps.get("EXCLUDE_SMARTCARD_USERS");
                String notifyFailureReattempt = (String)notifyMailProps.get("RETRY_NOTIFICATION");
                Long nTypeId = (Long)notifyMailProps.get("NOTIFY_TYPE_ID");
                String actionName = (String)notifyMailProps.get("ACTION_NAME");
                String expiresTodayOnly = (String)notifyMailProps.get("EXPIRES_TODAY_ONLY");
                String poolName = (String)notifyMailProps.get("POOL_NAME");
                Boolean isSynchronous = "default".equalsIgnoreCase(poolName);
                Table resultTable = Table.getTable((String)"ADSMUserReportResult");
                SelectQueryImpl query = new SelectQueryImpl(resultTable);
                Join join = new Join(resultTable, Table.getTable((String)"ADSMUserGeneralDetails"), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
                Join join1 = new Join(resultTable, Table.getTable((String)"ADSMUserAccountDetails"), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
                Join join2 = new Join(Table.getTable((String)"ADSMUserGeneralDetails"), Table.getTable((String)"AaaLogin"), new String[]{"SAM_ACCOUNT_NAME", "DOMAIN_NAME"}, new String[]{"NAME", "DOMAINNAME"}, 1);
                query.addJoin(join);
                query.addJoin(join1);
                query.addJoin(join2);
                if (nEnroll.equals("true")) {
                    Join join3 = new Join(Table.getTable((String)"AaaLogin"), Table.getTable((String)"SSPUserPropertyMap"), new String[]{"LOGIN_ID"}, new String[]{"USER_LOGIN_ID"}, 2);
                    query.addJoin(join3);
                }
                query.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"));
                query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"DISPLAY_NAME"));
                query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"SAM_ACCOUNT_NAME"));
                query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"EMAIL_ADDRESS"));
                query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"OBJECT_GUID"));
                query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"MOBILE"));
                query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"MANAGER"));
                query.addSelectColumn(Column.getColumn((String)"ADSMUserAccountDetails", (String)"DAYS_TO_EXPIRE_PASSWORD"));
                query.addSelectColumn(Column.getColumn((String)"ADSMUserAccountDetails", (String)"ACCOUNT_EXPIRY_DATE"));
                query.addSelectColumn(Column.getColumn((String)"ADSMUserAccountDetails", (String)"PASSWORD_EXPIRY_DATE"));
                query.addSortColumn(new SortColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"SAM_ACCOUNT_NAME"), true));
                Criteria cri = new Criteria(Column.getColumn((String)"ADSMUserReportResult", (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
                if ("true".equals(excludeDisabledUsers)) {
                    cri = cri.and(new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"ACCOUNT_STATUS"), (Object)"adssp.admin.common.text.disabled", 1));
                }
                if ("true".equals(excludeSmartcardUsers)) {
                    cri = cri.and(new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"SMARTCARD_USER"), (Object)"adssp.admin.common.text.enabled", 1));
                }
                query.setCriteria(cri);
                RelationalAPI relationalAPI = RelationalAPI.getInstance();
                connection = relationalAPI.getConnection();
                dataSet = relationalAPI.executeQuery((Query)query, connection);
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
                ArrayList<String> finalReport = new ArrayList<String>();
                while (dataSet.next()) {
                    ArrayList<String> attrList;
                    Properties userProps;
                    Hashtable userNotifyProps = notifyMailProps;
                    String displayName = (String)dataSet.getValue("DISPLAY_NAME");
                    String manager = (String)dataSet.getValue("MANAGER");
                    String objectGuid = (String)dataSet.getValue("OBJECT_GUID");
                    String name = (String)dataSet.getValue("SAM_ACCOUNT_NAME");
                    String noOfDays = (String)dataSet.getValue("DAYS_TO_EXPIRE_PASSWORD");
                    String pwdExpDate = String.valueOf(dataSet.getValue("PASSWORD_EXPIRY_DATE"));
                    HashMap dateFormatMap = TimeZoneUtil.getCustomDateFormat(1L);
                    long time = Long.valueOf(pwdExpDate);
                    String formattedDate = TimeZoneUtil.getTimeInCustomFormat(time, dateFormatMap, rb);
                    if (nTypeId == 2L && reportId != 3) {
                        Long accExpDate = CommonUtil.getSystemTimeFromFileTime((Long)dataSet.getValue("ACCOUNT_EXPIRY_DATE"));
                        noOfDays = PasswordAgeUtil.getNoOfDaysToExpire(accExpDate != 0L ? accExpDate - 1000L : 0L);
                        formattedDate = TimeZoneUtil.getTimeInCustomFormat(accExpDate, dateFormatMap, rb);
                    }
                    if (reportId != 3 && reportId != 5 && noOfDays.indexOf("today") == -1 && noOfDays.indexOf("expired") == -1 && String.valueOf(maxExpireDay).equalsIgnoreCase(noOfDays)) {
                        finalReport.add(objectGuid);
                        continue;
                    }
                    if (notifyMgr.equalsIgnoreCase("true") && manager != null && !manager.equals("-") && (ArrayList)(userProps = GSSelfServiceHandler.getObjectDetails(objectGuid, domainName, attrList = new ArrayList<String>(Arrays.asList("manager")), true)).get("manager") != null) {
                        String managerDN = (String)((ArrayList)userProps.get("manager")).get(0);
                        ArrayList<String> mngdGuidList = (ArrayList<String>)notifyMgrProps.get(managerDN);
                        if (mngdGuidList == null) {
                            mngdGuidList = new ArrayList<String>();
                        }
                        if (!mngdGuidList.contains(objectGuid)) {
                            mngdGuidList.add(objectGuid);
                        }
                        notifyMgrProps.put(managerDN, mngdGuidList);
                    }
                    boolean alreadyMailSent = false;
                    boolean alreadySMSSent = false;
                    boolean alreadyPNSent = false;
                    JSONObject deliveryStatus = new JSONObject();
                    Hashtable<String, Object> auditProps = new Hashtable<String, Object>();
                    auditProps.put("NAME", name);
                    auditProps.put("DOMAIN_NAME", domainName);
                    auditProps.put("ACTION_NAME", actionName);
                    auditProps.put("OBJECT_GUID", objectGuid);
                    auditProps.put("MAIL_SENT_TIME", mailSentTime);
                    String days = noOfDays;
                    if (days.indexOf("today") != -1) {
                        days = "0";
                    } else if (days.indexOf("expired") != -1) {
                        days = "-1";
                    }
                    Long nxtConfDay = Long.parseLong(days);
                    if (reportId == 3 || reportId == 5) {
                        if (!userNotifyProps.containsKey("EXPIRED_MAIL_CONTENT")) {
                            userNotifyProps.put("EXPIRED_MAIL_CONTENT", reportId == 3 ? rb.getString("adssp.reports.pwd_expired_notification.mail_content") : rb.getString("adssp.reports.pwd_expired_notification.mail_content"));
                        }
                        if (!userNotifyProps.containsKey("EXPIRED_MAIL_SUBJECT")) {
                            userNotifyProps.put("EXPIRED_MAIL_SUBJECT", reportId == 3 ? rb.getString("adssp.reports.acc_expired_notification.mail_subject") : rb.getString("adssp.reports.acc_expired_notification.mail_content"));
                        }
                    } else if (schTypeId == 3L) {
                        if (userNotifyProps.get(days) != null) {
                            userNotifyProps = (Hashtable)userNotifyProps.get(days);
                        } else {
                            do {
                                Long l = nxtConfDay;
                                Long l2 = nxtConfDay = Long.valueOf(nxtConfDay + 1L);
                            } while (userNotifyProps.get(nxtConfDay.toString()) == null);
                            userNotifyProps = (Hashtable)userNotifyProps.get(nxtConfDay.toString());
                        }
                    }
                    if (!"true".equalsIgnoreCase(notifyFailureReattempt) && nxtConfDay != Long.parseLong(days) && reportId != 3 && reportId != 5) {
                        finalReport.add(objectGuid);
                        continue;
                    }
                    String message = reportId != 3 && reportId != 5 ? (String)userNotifyProps.get("USER_MAIL_CONTENT") : (String)userNotifyProps.get("EXPIRED_MAIL_CONTENT");
                    String subject = reportId != 3 && reportId != 5 ? (String)userNotifyProps.get("USER_MAIL_SUBJECT") : (String)userNotifyProps.get("EXPIRED_MAIL_SUBJECT");
                    String mailPriority = reportId != 3 && reportId != 5 ? (String)userNotifyProps.get("MAIL_PRIORITY") : (String)userNotifyProps.get("EXPIRED_MAIL_PRIORITY");
                    String mailAttachment = reportId != 3 && reportId != 5 ? (String)userNotifyProps.get("MAIL_ATT_PATH") : (String)userNotifyProps.get("EXPIRED_MAIL_ATT_PATH");
                    Hashtable<String, String> keyPairValue = new Hashtable<String, String>();
                    keyPairValue.put("noOfDays", rb.getString(noOfDays));
                    keyPairValue.put("dateTime", formattedDate);
                    keyPairValue.put("reportName", (String)notifyMailProps.get("SCHEDULE_NAME"));
                    keyPairValue.put("accessURL", AdminHandler.getAccessURL());
                    message = FormatUtil.getNameFormats(domainName, message, objectGuid, "objectGUID", keyPairValue, rb);
                    subject = FormatUtil.getNameFormats(domainName, subject, objectGuid, "objectGUID", keyPairValue, rb);
                    Boolean checkAlrdySent = "true".equalsIgnoreCase(notifyFailureReattempt) && nxtConfDay != Long.parseLong(days) || nxtConfDay == Long.parseLong(days);
                    Boolean ignoreAlrdySent = isSynchronous != false || schTypeId == 3L && nxtConfDay != Long.parseLong(days);
                    if (notifyModes.contains("MAIL")) {
                        String status = "";
                        if (ignoreAlrdySent.booleanValue()) {
                            if (checkAlrdySent.booleanValue()) {
                                SoonToExpireHandler.getInstance();
                                alreadyMailSent = SoonToExpireHandler.isAlreadyMailSent(objectGuid, nxtConfDay - Long.parseLong(days), mailSentTime, actionName);
                            } else {
                                alreadyMailSent = true;
                            }
                        }
                        if (alreadyMailSent) {
                            Hashtable<String, String> mailAuditProps = new Hashtable<String, String>(auditProps);
                            mailAuditProps.put("STATUS", "adssp.reports.ste_delivery_rep_mail_already_sent");
                            mailAuditProps.put("NOTIFICATION_TYPE", "adssp.reports.audit_report.notification_delivery_report.mail");
                            mailUpdateStatus.put(objectGuid, mailAuditProps);
                        } else {
                            String mailId;
                            int j;
                            Properties userProps2 = SecondaryAttributesHandler.getNotificationAttributes(name, domainName, "MAIL");
                            ArrayList mailIds = (ArrayList)userProps2.get("MAIL_IDS") != null ? (ArrayList)userProps2.get("MAIL_IDS") : new ArrayList();
                            ArrayList secMailIds = UserUtil.getUserSecondaryMailIds(name, domainName);
                            String notifySec = ADSMPersUtil.getSyMParameter("NOTIFY_SECONDARY");
                            Boolean notifyAll = "true".equals(notifySec);
                            Boolean isInvalidMailId = true;
                            String tempStatus = "";
                            HashMap<String, Object> map = new HashMap<String, Object>(auditProps);
                            map.put("MAIL_SUBJECT", subject);
                            map.put("MAIL_CONTENT", message);
                            map.put("NOTIFICATION_TYPE", "adssp.reports.audit_report.notification_delivery_report.mail");
                            map.put("MAIL_PRIORITY", mailPriority);
                            map.put("MAIL_ATT_PATH", mailAttachment);
                            if (mailServerProp == null) {
                                mailServerProp = ADSMPersUtil.getMailServerSettings();
                            }
                            if (mailIds != null && mailIds.size() != 0) {
                                for (j = 0; j < mailIds.size(); ++j) {
                                    isInvalidMailId = false;
                                    mailId = (String)mailIds.get(j);
                                    map.put("MAIL_IDS", new String[]{mailId});
                                    if (SendMailAPI.getInstance().sendMail(map, mailUpdateStatus, mailServerProp).equals("adssp.common.text.mail_sent_success") && !notifyAll.booleanValue()) break;
                                    tempStatus = "adssp.common.text.success".equals(String.valueOf(((Hashtable)mailUpdateStatus.get(objectGuid)).get("STATUS"))) ? "adssp.common.text.success" : tempStatus;
                                }
                            }
                            if (secMailIds != null && secMailIds.size() != 0 && notifyAll.booleanValue()) {
                                for (j = 0; j < secMailIds.size(); ++j) {
                                    if ("".equals((String)secMailIds.get(j)) || mailIds.contains((String)secMailIds.get(j))) continue;
                                    isInvalidMailId = false;
                                    mailId = (String)secMailIds.get(j);
                                    map.put("MAIL_IDS", new String[]{mailId});
                                    SendMailAPI.getInstance().sendMail(map, mailUpdateStatus, mailServerProp).equals("adssp.common.text.mail_sent_success");
                                    tempStatus = "adssp.common.text.success".equals(String.valueOf(((Hashtable)mailUpdateStatus.get(objectGuid)).get("STATUS"))) ? "adssp.common.text.success" : tempStatus;
                                }
                            }
                            if (isInvalidMailId.booleanValue()) {
                                Hashtable<String, String> mailAuditProps = new Hashtable<String, String>(auditProps);
                                mailAuditProps.put("NOTIFICATION_TYPE", "adssp.reports.audit_report.notification_delivery_report.mail");
                                mailAuditProps.put("STATUS", "adssp.reports.ste_delivery_rep_invalid_email_id");
                                mailUpdateStatus.put(objectGuid, mailAuditProps);
                            } else if (tempStatus != "") {
                                Hashtable mailAuditProps = (Hashtable)mailUpdateStatus.get(objectGuid);
                                mailAuditProps.put("NOTIFICATION_TYPE", "adssp.reports.audit_report.notification_delivery_report.mail");
                                mailAuditProps.put("STATUS", tempStatus);
                                mailUpdateStatus.put(objectGuid, mailAuditProps);
                            }
                        }
                        deliveryStatus.put("MAIL", (Object)String.valueOf(((Hashtable)mailUpdateStatus.get(objectGuid)).get("STATUS")));
                    }
                    if (notifyModes.contains("SMS")) {
                        if (ignoreAlrdySent.booleanValue()) {
                            if (checkAlrdySent.booleanValue()) {
                                SoonToExpireHandler.getInstance();
                                alreadySMSSent = SoonToExpireHandler.isAlreadySMSSent(objectGuid, nxtConfDay - Long.parseLong(days), mailSentTime, actionName);
                            } else {
                                alreadySMSSent = true;
                            }
                        }
                        Hashtable<String, Object> smsAuditProps = new Hashtable<String, Object>(auditProps);
                        if (alreadySMSSent) {
                            smsAuditProps.put("STATUS", "adssp.reports.ste_delivery_rep_sms_already_sent");
                            smsAuditProps.put("NOTIFICATION_TYPE", "adssp.reports.audit_report.notification_delivery_report.sms");
                        } else {
                            smsAuditProps.put("NOTIFICATION_TYPE", "adssp.reports.audit_report.notification_delivery_report.sms");
                            String result = "adssp.common.text.success";
                            Properties userProps3 = SecondaryAttributesHandler.getNotificationAttributes(name, domainName, "MOBILE");
                            ArrayList mobileNos = (ArrayList)userProps3.get("MOBILE_NUMBERS");
                            String newMessage = message.replaceAll("<[^>]+>", " ");
                            Boolean isInvalidMobNo = true;
                            if (mobileNos != null && mobileNos.size() != 0) {
                                for (int j = 0; j < mobileNos.size(); ++j) {
                                    if (mobileNos.get(j).equals("")) continue;
                                    isInvalidMobNo = false;
                                    try {
                                        result = SMSAction.sendSMS((String)mobileNos.get(j), newMessage);
                                        if (result == null || !result.equals("adssp.common.text.smssent")) continue;
                                        result = "adssp.common.text.success";
                                        smsAuditProps.put("DELIVERED_TIME", System.currentTimeMillis());
                                        break;
                                    }
                                    catch (Exception e) {
                                        result = "adssp.reports.audit_rep.common.failure";
                                        e.printStackTrace();
                                    }
                                }
                            }
                            if (isInvalidMobNo.booleanValue()) {
                                result = "adssp.reports.ste_delivery_rep_invalid_mobile_number";
                            }
                            smsAuditProps.put("STATUS", result);
                        }
                        smsUpdateStatus.put(objectGuid, smsAuditProps);
                        deliveryStatus.put("SMS", (Object)String.valueOf(((Hashtable)smsUpdateStatus.get(objectGuid)).get("STATUS")));
                    }
                    if (notifyModes.contains("PushNotification")) {
                        Hashtable<String, String> pnAuditProps = new Hashtable<String, String>(auditProps);
                        if (dataSet.getValue("LOGIN_ID") != null && !String.valueOf(dataSet.getValue("LOGIN_ID")).equals("") && PNEnrollmentHandler.isUserConfigPN((Long)Long.valueOf(dataSet.getValue("LOGIN_ID") + ""))) {
                            pnUserGUIDMap.put(name, (Object)objectGuid);
                            if (ignoreAlrdySent.booleanValue()) {
                                if (checkAlrdySent.booleanValue()) {
                                    SoonToExpireHandler.getInstance();
                                    alreadyPNSent = SoonToExpireHandler.isAlreadyPNSent(objectGuid, nxtConfDay - Long.parseLong(days), mailSentTime, actionName);
                                } else {
                                    alreadyPNSent = true;
                                }
                            }
                            if (alreadyPNSent) {
                                pnAuditProps.put("STATUS", "adssp.reports.ste_delivery_rep_pn_already_sent");
                                pnAuditProps.put("NOTIFICATION_TYPE", "adssp.reports.audit_report.notification_delivery_report.pn");
                                pnUpdateStatus.put(objectGuid, pnAuditProps);
                                deliveryStatus.put("PushNotification", (Object)String.valueOf(((Hashtable)pnUpdateStatus.get(objectGuid)).get("STATUS")));
                            } else {
                                String notificationTypeText = "PasswordExpiryNotification";
                                int notificationId = 2;
                                if (nTypeId == 2L) {
                                    notificationTypeText = "AccountExpiryNotification";
                                    notificationId = 4;
                                }
                                String newMessage = message.replaceAll("(?s)<[^>]*>(\\s*<[^>]*>)*", " ");
                                newMessage = newMessage.replaceAll("&lt;", "<");
                                newMessage = newMessage.replaceAll("&gt;", ">");
                                JSONObject customAttribs = new JSONObject();
                                customAttribs.put("NA", notificationId);
                                JSONObject pnMessageContainer = PNEnrollmentHandler.getMessageBody((String)subject, (String)newMessage, (JSONObject)customAttribs);
                                pnUserProps.put(String.valueOf(dataSet.getValue("LOGIN_ID")), (Object)pnMessageContainer);
                            }
                        } else {
                            pnAuditProps.put("STATUS", "adssp.reports.ste_delivery_rep_pn_not_configured");
                            pnAuditProps.put("NOTIFICATION_TYPE", "adssp.reports.audit_report.notification_delivery_report.pn");
                            pnUpdateStatus.put(objectGuid, pnAuditProps);
                            deliveryStatus.put("PushNotification", (Object)String.valueOf(((Hashtable)pnUpdateStatus.get(objectGuid)).get("STATUS")));
                        }
                    }
                    if (deliveryStatus.length() <= 0) continue;
                    updateStatus.put(objectGuid, deliveryStatus);
                }
                if (notifyModes.contains("PushNotification")) {
                    String[] userLoginIds = JSONObject.getNames((JSONObject)pnUserProps);
                    if (userLoginIds != null) {
                        ArrayList<Long> mobUserList = new ArrayList<Long>();
                        Long[] loginIds = new Long[userLoginIds.length];
                        for (int i = 0; i < userLoginIds.length; ++i) {
                            loginIds[i] = Long.valueOf(userLoginIds[i]);
                            mobUserList.add(loginIds[i]);
                        }
                        logger.log(Level.INFO, "STE ...through Push Notification no. of user " + userLoginIds.length);
                        if (loginIds.length > 0) {
                            Long sentTime = System.currentTimeMillis();
                            JSONObject returnValueJSON = SendPushNotification.getInstance().sendNotification(loginIds, pnUserProps, mobUserList, EnrollmentNotifyHandler.getMachineDomainNames());
                            Hashtable<String, String> notificationProps = new Hashtable<String, String>();
                            notificationProps.put("ACTION_NAME", actionName);
                            notificationProps.put("NOTIFICATION_FROM", "SOON_TO_EXPIRE");
                            String returnValue = returnValueJSON.get("STATUS") + "";
                            returnValueJSON.remove("STATUS");
                            if (returnValueJSON.has("DELIVERY_DETAILS")) {
                                JSONArray notifiedUserList = returnValueJSON.getJSONArray("DELIVERY_DETAILS");
                                EnrollmentNotifyHandler.auditProcess(notifiedUserList, notificationProps);
                                if (notifiedUserList.length() > 0) {
                                    for (int index = 0; index < notifiedUserList.length(); ++index) {
                                        JSONObject notifiedUser = notifiedUserList.getJSONObject(index);
                                        String userName = notifiedUser.getString("NAME");
                                        String objectGUID = pnUserGUIDMap.getString(userName);
                                        if (objectGUID == null || objectGUID.equals("")) continue;
                                        JSONObject deliveryStatus = new JSONObject();
                                        deliveryStatus.put("PushNotification", (Object)notifiedUser.getString("STATUS"));
                                        if (updateStatus.get(objectGUID) != null) {
                                            deliveryStatus = (JSONObject)updateStatus.get(objectGUID);
                                            deliveryStatus.put("PushNotification", (Object)notifiedUser.getString("STATUS"));
                                        }
                                        updateStatus.put(objectGUID, deliveryStatus);
                                    }
                                }
                            }
                        }
                    }
                }
                if (finalReport.size() > 0) {
                    String[] delUsers = finalReport.toArray(new String[finalReport.size()]);
                    Criteria c = new Criteria(Column.getColumn((String)"ADSMUserReportResult", (String)"REPORT_GENERATION_ID"), (Object)generationId, 0, false);
                    c = c.and(new Criteria(Column.getColumn((String)"ADSMUserReportResult", (String)"OBJECT_GUID"), (Object)delUsers, 8, false));
                    CommonUtil.getPersistence(new boolean[0]).delete(c);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (dataSet != null) {
                    try {
                        dataSet.close();
                    }
                    catch (SQLException se) {
                        se.printStackTrace();
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException se) {
                        se.printStackTrace();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SoonToExpireHandler.getInstance();
            SoonToExpireHandler.addSTEDeliveryReport(smsUpdateStatus);
            SoonToExpireHandler.getInstance();
            SoonToExpireHandler.addSTEDeliveryReport(mailUpdateStatus);
            if (notifyMgr.equalsIgnoreCase("true")) {
                notifyMailProps.put("notifyMgrProps", notifyMgrProps);
            }
        }
    }

    public static void mailToAdmin(Hashtable mailProps, Boolean isRepAvail) {
        try {
            if (!Boolean.valueOf(ADSMPersUtil.getSyMParameter("DONT_NOTIFY_IF_NO_REPORT")).booleanValue() || isRepAvail.booleanValue()) {
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
                String adMailId = (String)mailProps.get("EMAIL_ID");
                String[] mailIds = adMailId.split(",");
                int successCount = 0;
                HashMap<String, Object> map = new HashMap<String, Object>();
                String sub = (String)mailProps.get("MAIL_SUBJECT");
                String msg = (String)mailProps.get("MAIL_CONTENT");
                String dir = (String)mailProps.get("DIRECTORY_PATH");
                String attType = "";
                if (dir != null && !dir.equals("")) {
                    attType = (String)mailProps.get("ATTACHMENT_TYPE");
                }
                String priority = (String)mailProps.get("ADMIN_MAIL_PRIORITY") != null ? (String)mailProps.get("ADMIN_MAIL_PRIORITY") : "Medium";
                String domainName = (String)mailProps.get("DOMAIN_NAME");
                String reportName = (String)mailProps.get("SCHEDULE_NAME");
                if (!isRepAvail.booleanValue()) {
                    msg = "adssp.reports.common.scheduler.no_report_available";
                    attType = "";
                }
                HashMap dateFormatMap = TimeZoneUtil.getCustomDateFormat(1L);
                SimpleDateFormat simpleDateFormat = (SimpleDateFormat)dateFormatMap.get("simpleDateFormat");
                Date currentdate = new Date(System.currentTimeMillis());
                String scheduleTime = simpleDateFormat.format(currentdate);
                Hashtable<String, String> keyPairValue = new Hashtable<String, String>();
                keyPairValue.put("reportName", reportName);
                keyPairValue.put("dateTime", TimeZoneUtil.getTimeInCustomFormat(System.currentTimeMillis(), dateFormatMap, rb));
                keyPairValue.put("scheduleTime", scheduleTime);
                msg = FormatUtil.getNameFormats(domainName, msg, keyPairValue);
                sub = FormatUtil.getNameFormats(domainName, sub, keyPairValue);
                map.put("MAIL_SUBJECT", sub);
                map.put("MAIL_CONTENT", msg);
                map.put("ATTACHMENT_TYPE", attType);
                map.put("DIRECTORY_PATH", dir);
                map.put("MAIL_PRIORITY", priority);
                map.put("DOMAIN_NAME", domainName != null ? domainName : "");
                if (mailProps.containsKey("DOMAIN_LIST")) {
                    map.put("DOMAIN_LIST", mailProps.get("DOMAIN_LIST"));
                } else {
                    map.put("DOMAIN_LIST", "");
                }
                map.put("MAIL_SENT_TIME", System.currentTimeMillis());
                map.put("NOTIFICATION_TYPE", "adssp.reports.audit_report.notification_delivery_report.mail");
                map.put("ACTION_NAME", "adssp.reports.audit_report.notification_delivery_report.mail_to_admin");
                if (mailProps.containsKey("EXPORT_REPORT_NAMES") && mailProps.get("EXPORT_REPORT_NAMES") != null) {
                    map.put("EXPORT_REPORT_NAMES", (ArrayList)mailProps.get("EXPORT_REPORT_NAMES"));
                }
                String mailStatus = "adssp.common.text.mail_sent_success";
                for (int i = 0; i < mailIds.length; ++i) {
                    Hashtable statusProps = new Hashtable();
                    String mail = mailIds[i];
                    map.put("MAIL_IDS", new String[]{mail});
                    map.put("NAME", mail);
                    map.put("OBJECT_GUID", mail);
                    Properties mailServerProp = ADSMPersUtil.getMailServerSettings();
                    mailStatus = SendMailAPI.getInstance().sendMail(map, statusProps, mailServerProp);
                    if ("adssp.common.text.mail_sent_success".equals(mailStatus)) {
                        ++successCount;
                    } else {
                        mailProps.put("FAIL_REASON", mailStatus);
                    }
                    AuditAPI.getInstance();
                    AuditAPI.addAuditLogs(statusProps);
                }
                if (mailIds.length == 1) {
                    mailProps.put("MAIL_STATUS", mailStatus);
                } else if (successCount < mailIds.length) {
                    mailStatus = MessageFormat.format(rb.getString("adssp.reports.multiple_mails.status"), successCount, mailIds.length);
                    mailProps.put("MAIL_STATUS", mailStatus + "" + mailProps.get("FAIL_REASON"));
                } else {
                    mailProps.put("MAIL_STATUS", "adssp.common.text.mail_sent_success");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetPassword(Long generationId, Long scheduleId) {
        block43: {
            try {
                Long loginId = new Long(1L);
                Long policyId = null;
                String statusMessage = "";
                Integer statusId = 1;
                Boolean isProceedSS = true;
                Criteria c = new Criteria(Column.getColumn((String)"SchedulerConfiguration", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SchedulerConfiguration", c);
                if (!obj.isEmpty()) {
                    Row r = obj.getRow("SchedulerConfiguration");
                    policyId = (Long)r.get("POLICY_ID");
                }
                Hashtable hash = PolicyHandler.getPolicyInfo(policyId, SchedulerHandler.RESET_TASK_ID);
                String automatic = "0";
                Hashtable policyProps = new Hashtable();
                if (!hash.isEmpty()) {
                    Row policy = (Row)hash.get("policy");
                    policyProps = (Hashtable)hash.get("policyProps");
                    automatic = (String)policy.get("AUTOMATIC");
                }
                if (!automatic.equalsIgnoreCase("1")) break block43;
                ArrayList<String> colNames = new ArrayList<String>();
                colNames.add("CHANGE_PWD_NEXT_LOGON");
                Hashtable colValues = APCUtil.getRequiredPCValues(policyId, colNames, "SSPSecurity");
                colNames = new ArrayList();
                colNames.add("UPDATE_ALL_DC");
                Hashtable generalValues = APCUtil.getRequiredPCValues(policyId, colNames, "SSPPolicyGeneral");
                String cPANLogon = (String)colValues.get("CHANGE_PWD_NEXT_LOGON");
                String allDC = (String)generalValues.get("UPDATE_ALL_DC");
                String logonName = "";
                String domainName = "";
                Connection connection = null;
                DataSet dataSet = null;
                try {
                    Table resultTable = Table.getTable((String)"ADSMUserReportResult");
                    SelectQueryImpl query = new SelectQueryImpl(resultTable);
                    Join join = new Join(resultTable, Table.getTable((String)"ADSMUserGeneralDetails"), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
                    Join join1 = new Join(resultTable, Table.getTable((String)"ADSMUserAccountDetails"), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
                    query.addJoin(join);
                    query.addJoin(join1);
                    query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"DOMAIN_NAME"));
                    query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"SID_STRING"));
                    query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"SAM_ACCOUNT_NAME"));
                    query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"DISTINGUISHED_NAME"));
                    query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"OBJECT_GUID"));
                    query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"EMAIL_ADDRESS"));
                    query.setCriteria(new Criteria(Column.getColumn((String)"ADSMUserReportResult", (String)"REPORT_GENERATION_ID"), (Object)generationId, 0));
                    RelationalAPI relationalAPI = RelationalAPI.getInstance();
                    connection = relationalAPI.getConnection();
                    dataSet = relationalAPI.executeQuery((Query)query, connection);
                    String fromAddress = ReportHandler.getMailFromAddress();
                    while (dataSet.next()) {
                        isProceedSS = true;
                        domainName = (String)dataSet.getValue("DOMAIN_NAME");
                        String sid = (String)dataSet.getValue("SID_STRING");
                        logonName = (String)dataSet.getValue("SAM_ACCOUNT_NAME");
                        Hashtable userProps = PolicyHandler.checkPermission(domainName, logonName);
                        Long userPolicyId = (Long)userProps.get("policyId");
                        if (!userPolicyId.equals(policyId)) continue;
                        String guid = (String)dataSet.getValue("OBJECT_GUID");
                        String password = "";
                        statusMessage = "";
                        if (((String)policyProps.get("PWD_TYPE")).equalsIgnoreCase("pwdValue")) {
                            String pwdValue = (String)policyProps.get("PWD_VALUE");
                            password = FormatUtil.getNameFormats(domainName, pwdValue, guid, "objectGUID", new Hashtable());
                        } else {
                            password = PasswordGenerator.generatePassword(policyId, logonName);
                        }
                        Hashtable<String, Object> userDetails = new Hashtable<String, Object>();
                        userDetails.put("USER_DN", (String)dataSet.getValue("DISTINGUISHED_NAME"));
                        userDetails.put("OBJECT_GUID", guid);
                        userDetails.put("USER_NAME", logonName);
                        userDetails.put("USER_SID", sid);
                        userDetails.put("DOMAIN_NAME", domainName);
                        userDetails.put("PASSWORD", password);
                        userDetails.put("ENFORCE_PWD_HIS", "0");
                        userDetails.put("POLICY_ID", policyId);
                        JSONObject nonADStatus = new JSONObject();
                        Hashtable<String, Object> keyPairValue = new Hashtable<String, Object>();
                        String resetSuccessHosts = "";
                        keyPairValue.put("password", password);
                        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
                        HashMap dateFormatMap = TimeZoneUtil.getCustomDateFormat(1L);
                        keyPairValue.put("dateTime", TimeZoneUtil.getTimeInCustomFormat(System.currentTimeMillis(), dateFormatMap, rb));
                        keyPairValue.put("forceNotificationIds", new ArrayList<Long>(Arrays.asList(PolicyNotifications.RESET_PASSWORD_MAIL, PolicyNotifications.RESET_PASSWORD_SMS)));
                        Long userloginId = 0L;
                        DataObject accountDO = ADAuthHandler.getAccountDO(logonName, domainName, "SYSTEM");
                        if (accountDO == null || accountDO.isEmpty()) {
                            logger.log(Level.INFO, "Login id doesnt exists");
                            try {
                                userloginId = ADMPUserHandler.addDomainUser(logonName, domainName);
                                accountDO = ADAuthHandler.getAccountDO(logonName, domainName, "SYSTEM");
                            }
                            catch (Exception e) {
                                isProceedSS = false;
                                e.printStackTrace();
                            }
                        } else {
                            userloginId = ADMPUserHandler.getLoginId(logonName, domainName);
                        }
                        if (userloginId == null) {
                            userloginId = SelfServiceHandler.getUserId(logonName, domainName);
                        }
                        if (!isProceedSS.booleanValue()) continue;
                        try {
                            SelfServiceHandler.resetPassword(loginId, userDetails, allDC, userloginId);
                            statusMessage = "adssp.common.text.success";
                            resetSuccessHosts = rb.getString("adssp.domain_user.link_acc.multiplatform_accounts.active_directory");
                            statusId = 1;
                            if (cPANLogon.equals("1")) {
                                SelfServiceHandler.changePwdAtNextLogon(domainName, loginId, logonName, sid, allDC);
                            }
                            if ((nonADStatus = NonADHandler.resetPassword(logonName, policyId, (String)userDetails.get("PASSWORD"), (long)userloginId)) != null && nonADStatus.length() > 0) {
                                Iterator it = nonADStatus.keys();
                                while (it.hasNext()) {
                                    String cId = it.next().toString();
                                    JSONObject pwdSyncStatus = nonADStatus.getJSONObject(cId);
                                    resetSuccessHosts = resetSuccessHosts + (pwdSyncStatus.has("sSTATUS") ? ("".equals(resetSuccessHosts) ? cId : "," + cId) : "");
                                }
                            }
                        }
                        catch (Exception e) {
                            try {
                                String isPSOnSuccessEnabled = AdvancedPolicyHandler.getRequiredPCValue(policyId, "PWD_SYNC_ON_SUCCESS", "SSPPolicyGeneral");
                                if (statusMessage.equalsIgnoreCase("") && isPSOnSuccessEnabled.equals("0") && (nonADStatus = NonADHandler.resetPassword(logonName, policyId, (String)userDetails.get("PASSWORD"), (long)userloginId)) != null && nonADStatus.length() > 0) {
                                    Iterator it = nonADStatus.keys();
                                    while (it.hasNext()) {
                                        String cId = it.next().toString();
                                        JSONObject pwdSyncStatus = nonADStatus.getJSONObject(cId);
                                        resetSuccessHosts = resetSuccessHosts + (pwdSyncStatus.has("sSTATUS") ? ("".equals(resetSuccessHosts) ? cId : "," + cId) : "");
                                    }
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            statusId = 0;
                            statusMessage = e.getMessage();
                            e.printStackTrace();
                        }
                        if (!resetSuccessHosts.equals("")) {
                            keyPairValue.put("accounts", resetSuccessHosts);
                            keyPairValue.put("hostName", "-");
                            keyPairValue.put("ipAddress", "-");
                            ArrayList<Long> nIds = new ArrayList<Long>();
                            nIds.add(PolicyNotifications.RESET_PASSWORD_MAIL);
                            nIds.add(PolicyNotifications.RESET_PASSWORD_SMS);
                            nIds.add(new Long(10L));
                            PolicyNotifications.sendNotification(domainName, logonName, policyId, nIds, keyPairValue);
                            keyPairValue.put("action", rb.getString("adssp.notification.actio.reset_pwd_admin"));
                            keyPairValue.put("actionPhrase", rb.getString("adssp.notification.actio.reset_pwd_admin"));
                            PolicyNotifications.sendMailToAdmin(domainName, logonName, policyId, keyPairValue);
                        }
                        try {
                            AuditAPI.getInstance().addAuditLog(loginId, SelfServiceHandler.getUserId(logonName, domainName), "audit.action.automatic_reset_pwd", System.currentTimeMillis(), "localhost", "127.0.0.1", new Hashtable(), statusId, statusMessage);
                            NonADHandler.addAudit(loginId, SelfServiceHandler.getUserId(logonName, domainName), "audit.action.automatic_reset_pwd", "localhost", "127.0.0.1", null, nonADStatus);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (dataSet != null) {
                        try {
                            dataSet.close();
                        }
                        catch (SQLException se) {
                            se.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException se) {
                            se.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlockUser(Long generationId, Long scheduleId) {
        block38: {
            try {
                Long loginId = new Long(1L);
                Long policyId = null;
                String statusMessage = "";
                Integer statusId = 1;
                Boolean isProceedSS = true;
                Criteria c = new Criteria(Column.getColumn((String)"SchedulerConfiguration", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SchedulerConfiguration", c);
                if (!obj.isEmpty()) {
                    Row r = obj.getRow("SchedulerConfiguration");
                    policyId = (Long)r.get("POLICY_ID");
                }
                Hashtable hash = PolicyHandler.getPolicyInfo(policyId, SchedulerHandler.UNLOCK_TASK_ID);
                String automatic = "0";
                if (hash != null) {
                    Row policy = (Row)hash.get("policy");
                    Hashtable policyProps = (Hashtable)hash.get("policyProps");
                    automatic = (String)policy.get("AUTOMATIC");
                }
                if (!automatic.equalsIgnoreCase("1")) break block38;
                Connection connection = null;
                DataSet dataSet = null;
                String domainName = "";
                ArrayList<String> colNames = new ArrayList<String>();
                colNames.add("UPDATE_ALL_DC");
                Hashtable colValues = APCUtil.getRequiredPCValues(policyId, colNames, "SSPPolicyGeneral");
                String allDC = (String)colValues.get("UPDATE_ALL_DC");
                try {
                    Table resultTable = Table.getTable((String)"ADSMUserReportResult");
                    SelectQueryImpl query = new SelectQueryImpl(resultTable);
                    Join join = new Join(resultTable, Table.getTable((String)"ADSMUserGeneralDetails"), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
                    Join join1 = new Join(resultTable, Table.getTable((String)"ADSMUserAccountDetails"), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
                    query.addJoin(join);
                    query.addJoin(join1);
                    query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"DOMAIN_NAME"));
                    query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"SID_STRING"));
                    query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"SAM_ACCOUNT_NAME"));
                    query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"DISTINGUISHED_NAME"));
                    query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"OBJECT_GUID"));
                    query.setCriteria(new Criteria(Column.getColumn((String)"ADSMUserReportResult", (String)"REPORT_GENERATION_ID"), (Object)generationId, 0));
                    RelationalAPI relationalAPI = RelationalAPI.getInstance();
                    connection = relationalAPI.getConnection();
                    dataSet = relationalAPI.executeQuery((Query)query, connection);
                    String fromAddress = ReportHandler.getMailFromAddress();
                    JSONObject nonADStatus = new JSONObject();
                    while (dataSet.next()) {
                        statusMessage = "";
                        domainName = (String)dataSet.getValue("DOMAIN_NAME");
                        isProceedSS = true;
                        Hashtable<String, String> userDetails = new Hashtable<String, String>();
                        userDetails.put("DOMAIN_NAME", domainName);
                        userDetails.put("USER_DN", (String)dataSet.getValue("DISTINGUISHED_NAME"));
                        String logonName = (String)dataSet.getValue("SAM_ACCOUNT_NAME");
                        Hashtable userProps = PolicyHandler.checkPermission(domainName, logonName);
                        Long userPolicyId = (Long)userProps.get("policyId");
                        if (!userPolicyId.equals(policyId)) continue;
                        userDetails.put("USER_SID", (String)dataSet.getValue("SID_STRING"));
                        userDetails.put("USER_NAME", (String)dataSet.getValue("SAM_ACCOUNT_NAME"));
                        Hashtable<String, Object> keyPairValue = new Hashtable<String, Object>();
                        String unlockSuccessHosts = "";
                        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
                        HashMap dateFormatMap = TimeZoneUtil.getCustomDateFormat(1L);
                        keyPairValue.put("dateTime", TimeZoneUtil.getTimeInCustomFormat(System.currentTimeMillis(), dateFormatMap, rb));
                        keyPairValue.put("forceNotificationIds", new ArrayList<Long>(Arrays.asList(PolicyNotifications.RESET_PASSWORD_MAIL, PolicyNotifications.RESET_PASSWORD_SMS)));
                        Long userloginId = 0L;
                        DataObject accountDO = ADAuthHandler.getAccountDO(logonName, domainName, "SYSTEM");
                        if (accountDO == null || accountDO.isEmpty()) {
                            logger.log(Level.INFO, "Login id doesnt exists");
                            try {
                                userloginId = ADMPUserHandler.addDomainUser(logonName, domainName);
                                accountDO = ADAuthHandler.getAccountDO(logonName, domainName, "SYSTEM");
                            }
                            catch (Exception e) {
                                isProceedSS = false;
                                e.printStackTrace();
                            }
                        } else {
                            userloginId = ADMPUserHandler.getLoginId(logonName, domainName);
                        }
                        if (!isProceedSS.booleanValue()) continue;
                        try {
                            SelfServiceHandler.unlockUser(loginId, allDC, userDetails);
                            statusMessage = "adssp.common.text.success";
                            unlockSuccessHosts = rb.getString("adssp.domain_user.link_acc.multiplatform_accounts.active_directory");
                            statusId = 1;
                            nonADStatus = NonADHandler.unlockUser((String)userDetails.get("USER_NAME"), policyId, (long)loginId);
                            Iterator it = nonADStatus.keys();
                            while (it.hasNext()) {
                                String cId = it.next().toString();
                                JSONObject unlockSyncStatus = nonADStatus.getJSONObject(cId);
                                unlockSuccessHosts = unlockSuccessHosts + (unlockSyncStatus.has("sSTATUS") ? ("".equals(unlockSuccessHosts) ? cId : "," + cId) : "");
                            }
                        }
                        catch (Exception e) {
                            statusMessage = e.getMessage();
                            statusId = 0;
                            try {
                                String isPSOnSuccessEnabled = AdvancedPolicyHandler.getRequiredPCValue(policyId, "PWD_SYNC_ON_SUCCESS", "SSPPolicyGeneral");
                                if (statusMessage.equalsIgnoreCase("") && isPSOnSuccessEnabled.equals("0")) {
                                    nonADStatus = NonADHandler.unlockUser((String)userDetails.get("USER_NAME"), policyId, (long)userloginId);
                                    Iterator it = nonADStatus.keys();
                                    while (it.hasNext()) {
                                        String cId = it.next().toString();
                                        JSONObject unlockSyncStatus = nonADStatus.getJSONObject(cId);
                                        unlockSuccessHosts = unlockSuccessHosts + (unlockSyncStatus.has("sSTATUS") ? ("".equals(unlockSuccessHosts) ? cId : "," + cId) : "");
                                    }
                                }
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            e.printStackTrace();
                        }
                        if (!unlockSuccessHosts.equals("")) {
                            keyPairValue.put("accounts", unlockSuccessHosts);
                            keyPairValue.put("hostName", "-");
                            keyPairValue.put("ipAddress", "-");
                            ArrayList<Long> nIds = new ArrayList<Long>();
                            nIds.add(PolicyNotifications.UNLOCK_ACCOUNT_MAIL);
                            nIds.add(PolicyNotifications.UNLOCK_ACCOUNT_SMS);
                            nIds.add(new Long(11L));
                            PolicyNotifications.sendNotification(domainName, logonName, policyId, nIds, keyPairValue);
                            keyPairValue.put("action", rb.getString("adssp.notification.actio.unlock_acc_admin"));
                            keyPairValue.put("actionPhrase", rb.getString("adssp.notification.actio.unlock_acc_admin"));
                            PolicyNotifications.sendMailToAdmin(domainName, logonName, policyId, keyPairValue);
                        }
                        try {
                            AuditAPI.getInstance().addAuditLog(loginId, SelfServiceHandler.getUserId((String)userDetails.get("USER_NAME"), domainName), "audit.action.automatic_unlock", System.currentTimeMillis(), "localhost", "127.0.0.1", new Hashtable(), statusId, statusMessage);
                            NonADHandler.addAudit(loginId, SelfServiceHandler.getUserId((String)userDetails.get("USER_NAME"), domainName), "audit.action.automatic_unlock", "localhost", "127.0.0.1", null, nonADStatus);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (dataSet != null) {
                        try {
                            dataSet.close();
                        }
                        catch (SQLException se) {
                            se.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException se) {
                            se.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void executeDomainReports(String domain, Long loginId) {
        ReportHandler.executeDomainReports(domain, loginId, reportIds);
    }

    public static void executeDomainReports(String domain, Long loginId, int[] reportIds) {
        try {
            Hashtable<String, Serializable> props = new Hashtable<String, Serializable>();
            props.put("SCHEDULE_ID", new Long(-1L));
            ArrayList<Integer> repIds = new ArrayList<Integer>();
            for (int rId : reportIds) {
                repIds.add(rId);
            }
            props.put("SCHEDULED_REPORT_IDS", repIds);
            Hashtable domains = DomainUtil.getContainersForExecuteReport(domain);
            props.put("DOMAIN_VS_OUS", domains);
            Hashtable<String, String> inputs = new Hashtable<String, String>();
            inputs.put("UpdateDashBoard", "true");
            props.put("inputParams", inputs);
            ReportHandler.executeReport(props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getMailFromAddress() {
        String fromAddress = "SelfService@noreply.com";
        try {
            Properties mailProp = ADSMPersUtil.getMailServerSettings();
            fromAddress = (String)mailProp.get("FROM_ADDRESS");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fromAddress;
    }

    public static Hashtable getDailyReportResults(String domainName, Long loginId) {
        Hashtable<String, Hashtable> hash = new Hashtable<String, Hashtable>();
        try {
            Criteria c = null;
            if (LicenseManager.getInstance().isFree() && !LicenseManager.getInstance().isFreeTool() && !LicenseManager.getInstance().wasFreeTool() || LicenseUtil.getPurchasedDomains() == 1) {
                Properties p = DomainHandler.getSelectedDomain(1L);
                String d = p.getProperty("DOMAIN_NAME");
                if (domainName != null && !d.equalsIgnoreCase(domainName)) {
                    return hash;
                }
                c = new Criteria(Column.getColumn((String)"ADSMHomeProps", (String)"DOMAIN_NAME"), (Object)d, 0);
            } else {
                c = domainName != null ? new Criteria(Column.getColumn((String)"ADSMHomeProps", (String)"DOMAIN_NAME"), (Object)domainName, 0) : new Criteria(Column.getColumn((String)"ADSMHomeProps", (String)"DOMAIN_NAME"), (Object)"", 1);
            }
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMHomeProps", c);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("ADSMHomeProps");
                while (it.hasNext()) {
                    Long latestGenId;
                    Row r = (Row)it.next();
                    String domain = (String)r.get("DOMAIN_NAME");
                    Hashtable h = null;
                    if (hash.get(domain) == null) {
                        h = new Hashtable();
                        h.put("count", new Properties());
                        h.put("generationIds", new Properties());
                        hash.put(domain, h);
                    } else {
                        h = (Hashtable)hash.get(domain);
                    }
                    Properties p = (Properties)h.get("count");
                    Properties p1 = (Properties)h.get("generationIds");
                    p.put(r.get("PROPERTY_NAME"), r.get("RESULT_COUNT"));
                    if (r.get("REPORT_GENERATION_ID") == null) continue;
                    Long genId = (Long)r.get("REPORT_GENERATION_ID");
                    Row genRepRow = ReportHandler.getGeneratedReportDetails(genId, loginId);
                    if (genRepRow != null && (latestGenId = ReportHandler.getRecentlyGeneratedReports(domainName, (Integer)genRepRow.get("REPORT_ID"), loginId)) != null && latestGenId > genId) {
                        genId = latestGenId;
                        p.put(r.get("PROPERTY_NAME"), ReportHandler.getSIDReportCount(genId, "ADSMUserReportResult"));
                    }
                    p1.put(r.get("PROPERTY_NAME"), genId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    public static Long getGenerationId(String propertyName) {
        Long ret = null;
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSMHomeProps", (String)"PROPERTY_NAME"), (Object)propertyName, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMHomeProps", c);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow("ADSMHomeProps");
                ret = (Long)r.get("REPORT_GENERATION_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void updateResultCount(String domainName, String propertyName, Integer count, Long generationId) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSMHomeProps", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            c = c.and(new Criteria(Column.getColumn((String)"ADSMHomeProps", (String)"PROPERTY_NAME"), (Object)propertyName, 0));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMHomeProps", c);
            Row r = new Row("ADSMHomeProps");
            r.set("DOMAIN_NAME", (Object)domainName);
            r.set("PROPERTY_NAME", (Object)propertyName);
            r.set("RESULT_COUNT", (Object)count);
            if (generationId != null) {
                r.set("REPORT_GENERATION_ID", (Object)generationId);
            }
            if (!obj.isEmpty()) {
                obj.updateRow(r);
            } else {
                obj.addRow(r);
            }
            CommonUtil.getPersistence(new boolean[0]).update(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Properties getAttributeProp(Integer attributeId, ArrayList list) {
        Properties p = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!((Properties)list.get(i)).get("ATTRIB_ID").equals(attributeId)) continue;
            p = (Properties)list.get(i);
        }
        return p;
    }

    public static void getCustomizedMultipleValues(Hashtable multipleValuesSids) {
        Enumeration e = multipleValuesSids.keys();
        while (e.hasMoreElements()) {
            Object guid = e.nextElement();
            Hashtable colVsValues = (Hashtable)multipleValuesSids.get(guid);
            Enumeration e1 = colVsValues.keys();
            while (e1.hasMoreElements()) {
                Integer attributeId = (Integer)e1.nextElement();
                ArrayList values = (ArrayList)colVsValues.get(attributeId);
                colVsValues.put(attributeId, values);
            }
        }
    }

    public static void updateUserVsReportOUMapping(Long loginId, int reportId, Hashtable domainOUList) {
        try {
            String tableName = "SSPReportOUMapping";
            ArrayList<String> domains = new ArrayList<String>();
            if (reportId > 300 && reportId < 309) {
                reportId = 306;
            }
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Enumeration e = domainOUList.keys();
            while (e.hasMoreElements()) {
                String domainDN = (String)e.nextElement();
                String domainName = DomainHandler.getDomainData("DEFAULT_NAMING_CONTEXT", domainDN, "DOMAIN_NAME");
                domains.add(domainName);
                ArrayList ouList = (ArrayList)domainOUList.get(domainDN);
                for (String ouDN : ouList) {
                    Row r = new Row(tableName);
                    r.set("LOGIN_ID", (Object)loginId);
                    r.set("REPORT_ID", (Object)reportId);
                    r.set("DOMAIN_NAME", (Object)domainName);
                    r.set("OU_DN", (Object)ouDN);
                    dataObj.addRow(r);
                }
            }
            Criteria c = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domains.toArray(new String[domains.size()]), 8);
            c = c.and(Column.getColumn((String)tableName, (String)"LOGIN_ID"), (Object)loginId, 0);
            c = c.and(Column.getColumn((String)tableName, (String)"REPORT_ID"), (Object)reportId, 0);
            logger.log(Level.FINE, "Deleting rows with Criteria : " + c);
            CommonUtil.getPersistenceLite().delete(c);
            CommonUtil.getPersistenceLite().update(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getUserVsReportOUMapping(Long loginId, int reportId, String domainName) {
        ArrayList<String> ouList = new ArrayList<String>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            if (reportId > 300 && reportId < 305) {
                reportId = 306;
            }
            String tableName = "SSPReportOUMapping";
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
            Join join = new Join(Table.getTable((String)tableName), Table.getTable((String)"ADSMOUDetails"), new String[]{"OU_DN", "DOMAIN_NAME"}, new String[]{"DISTINGUISHED_NAME", "DOMAIN_NAME"}, 2);
            query.addJoin(join);
            Criteria c = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            c = c.and(Column.getColumn((String)tableName, (String)"LOGIN_ID"), (Object)loginId, 0);
            c = c.and(Column.getColumn((String)tableName, (String)"REPORT_ID"), (Object)reportId, 0);
            query.setCriteria(c);
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"OU_DN"));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                ouList.add((String)dataSet.getValue("OU_DN"));
            }
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
        return ouList;
    }

    public static String getSSPReportName(String reportId) {
        String repName = "ADSSPReport";
        if (reportId.equals("101")) {
            repName = "Reset Password";
        } else if (reportId.equals("102")) {
            repName = "Unlock Account";
        } else if (reportId.equals("103")) {
            repName = "Self Update";
        } else if (reportId.equals("104")) {
            repName = "Enrolled Users";
        } else if (reportId.equals("105")) {
            repName = "Non-Enrolled Users";
        } else if (reportId.equals("106")) {
            repName = "Failed Attempts";
        } else if (reportId.equals("107")) {
            repName = "Licensed Users";
        } else if (reportId.equals("108")) {
            repName = "Change Password";
        } else if (reportId.equals("109")) {
            repName = "Security QA";
        } else if (reportId.equals("110")) {
            repName = "Delivery Report";
        }
        if (reportId.equals("111")) {
            repName = "User Attempts";
        } else if (reportId.equals("115")) {
            repName = "Push Registered Devices";
        }
        return repName;
    }

    public static JSONObject getReportParams(Long generationId) {
        JSONObject reportParams = new JSONObject();
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPReportParams", (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPReportParams", c);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("SSPReportParams");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    reportParams.put((String)r.get("PARAM_NAME"), (Object)((String)r.get("PARAM_VALUE")));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return reportParams;
    }

    public static void updateReportParams(Hashtable params, Long generationId) {
        try {
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Set keys = params.keySet();
            for (String key : keys) {
                String value = (String)params.get(key);
                if (value == null || "".equals(value)) continue;
                Row r = new Row("SSPReportParams");
                r.set("REPORT_GENERATION_ID", (Object)generationId);
                r.set("PARAM_NAME", (Object)key);
                r.set("PARAM_VALUE", (Object)value);
                dObj.addRow(r);
                CommonUtil.getPersistence(new boolean[0]).add(dObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

