/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.reports;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.mobile.MobileUtil;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.QueryUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;

public class ReportsUtil {
    public static String OU_TABLE_NAME = "ADSMOUDetails";
    public static String[] longDataTypeColumns = new String[]{"WHEN_CREATED", "WHEN_CHANGED", "LAST_LOGON_TIME", "LAST_LOGOFF_TIME", "BAD_PASSWORD_TIME", "ACCOUNT_LOCK_ON_TIME", "PASSWORD_LAST_SET", "CREATION_TIME", "LAST_ACCESS_TIME", "LAST_WRITE_TIME", "MODIFIED_TIME", "CREATED_ON", "CHANGED_ON", "LOCK_OUT_TIME"};
    public static final String RESET_AUDIT_REPORT = "101";
    public static final String UNLOCK_AUDIT_REPORT = "102";
    public static final String SELF_UPDATE_AUDIT_REPORT = "103";
    public static final String CHANGE_PASSWORD_AUDIT_REPORT = "108";
    public static final String NOTIFICATION_DELIVERY_AUDIT_REPORT = "110";
    public static final String IDV_AUDIT_REPORT = "106";
    public static final String USER_ATTEMPTS_AUDIT_REPORT = "111";

    public static int getOUCount(String searchPattern, String domainName, ArrayList ous) {
        int ouCount = 0;
        try {
            Criteria c;
            Criteria criteria = new Criteria(new Column(OU_TABLE_NAME, "DOMAIN_NAME"), (Object)domainName, 0);
            if (searchPattern != null) {
                criteria = criteria.and(new Criteria(new Column(OU_TABLE_NAME, "NAME"), (Object)searchPattern, 2, false));
            }
            if ((c = ReportsUtil.getOUCriteria(ous)) != null) {
                criteria = criteria.and(c);
            }
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(OU_TABLE_NAME, criteria);
            ouCount = dataObject.size(OU_TABLE_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ouCount;
    }

    public static ArrayList getOUList(String searchPattern, String domainName, int startIndex, int numOfObjects, ArrayList ous) {
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        try {
            Criteria c;
            Table table = new Table(OU_TABLE_NAME);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(new Column(OU_TABLE_NAME, "DOMAIN_NAME"), (Object)domainName, 0);
            if (searchPattern != null) {
                criteria = criteria.and(new Criteria(new Column(OU_TABLE_NAME, "NAME"), (Object)searchPattern, 2, false));
            }
            if ((c = ReportsUtil.getOUCriteria(ous)) != null) {
                criteria = criteria.and(c);
            }
            query.setCriteria(criteria);
            query.addSelectColumn(new Column(null, "*"));
            query.addSortColumn(new SortColumn(new Column(OU_TABLE_NAME, "NAME"), true));
            if (startIndex != -1) {
                query.setRange(new Range(startIndex, numOfObjects));
            }
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator iterator = dataObject.getRows(OU_TABLE_NAME);
            while (iterator.hasNext()) {
                Properties properties = new Properties();
                Row row = (Row)iterator.next();
                properties.setProperty("NAME", (String)row.get("NAME"));
                String dn = (String)row.get("DISTINGUISHED_NAME");
                properties.setProperty("DISTINGUISHED_NAME", dn);
                ReportAttributeHandler attributeHandler = ReportAttributeHandler.getInstance();
                properties.setProperty("FQDN", attributeHandler.getLocation(domainName, dn));
                arrayList.add(properties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return arrayList;
    }

    private static Criteria getOUCriteria(ArrayList ous) {
        Criteria c = null;
        try {
            for (int i = 0; ous != null && i < ous.size(); ++i) {
                String ou = QueryUtil.mickeyCriteriaEscape((String)ous.get(i));
                c = c == null ? new Criteria(new Column(OU_TABLE_NAME, "DISTINGUISHED_NAME"), (Object)("*" + ou), 2, false) : c.or(new Criteria(new Column(OU_TABLE_NAME, "DISTINGUISHED_NAME"), (Object)("*" + ou), 2, false));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    public static String getSSPAccessMode(HttpServletRequest request) {
        HttpSession session = request.getSession();
        DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute("LoginBean");
        if (MobileUtil.isNativeApp(request)) {
            return MobileUtil.getMobileProvider(request);
        }
        if (MobileUtil.isMobile(request)) {
            return "MApp";
        }
        if (bean != null) {
            String isGina = (String)bean.get("isGina");
            Boolean isMac = request.getHeader("User-Agent").toLowerCase().indexOf("macintosh") != -1;
            return isGina != null && isGina.equalsIgnoreCase("yes") ? (isMac.booleanValue() ? "MAC" : "GINA") : "WebPage";
        }
        return "WebPage";
    }
}

