/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.reports;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.enrollment.EnrollUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class SecurityQAReportHandler {
    public static ArrayList samAcNames = new ArrayList();

    public static Hashtable getUsers(String domainName, ArrayList ouList, String searchString, int startIndex, int numOfObjects, boolean ascending, Boolean export) throws Exception {
        Hashtable buildInCustomTable = new Hashtable();
        Hashtable<String, Object> resultTable = new Hashtable<String, Object>();
        String[] nameArray = new String[]{""};
        String usersTable = CommonUtil.getDomainUserTableName(domainName);
        Long[] loginIds = SecurityQAReportHandler.getEnrolledUserIds(ouList, usersTable, domainName, -1, -1, export, searchString);
        if (loginIds != null) {
            SecurityQAReportHandler.getBuildInQa(loginIds, buildInCustomTable);
            SecurityQAReportHandler.getCustomQA(loginIds, buildInCustomTable);
            nameArray = new String[buildInCustomTable.size()];
            SecurityQAReportHandler.getSortedArray(nameArray, buildInCustomTable.keys(), ascending);
        }
        if (export.booleanValue()) {
            resultTable.put("sortedList", nameArray);
        } else {
            if (startIndex > 0) {
                --startIndex;
            }
            int arraySize = numOfObjects < nameArray.length - startIndex ? numOfObjects : nameArray.length - startIndex;
            String[] resultArray = new String[arraySize];
            System.arraycopy(nameArray, startIndex, resultArray, 0, arraySize);
            resultTable.put("sortedList", resultArray);
        }
        resultTable.put("results", buildInCustomTable);
        return resultTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getBuildInQa(Long[] loginIds, Hashtable resultTable) {
        Connection connection = null;
        DataSet dataSet = null;
        try {
            Hashtable buildInQATable = new Hashtable();
            String baseTable = "SSPBuildInQAMap";
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)baseTable));
            sq.addSelectColumn(Column.getColumn((String)"SSPBuildInQAMap", (String)"ANSWER_TEXT"));
            sq.addSelectColumn(Column.getColumn((String)"SSPBuildInQAMap", (String)"ANSWER_TWO_WAY"));
            sq.addSelectColumn(Column.getColumn((String)"SSPBuildInQAMap", (String)"SALT"));
            sq.addSelectColumn(Column.getColumn((String)"SSPSecretQues", (String)"QUESTION_TEXT"));
            sq.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"NAME"));
            sq.addSelectColumn(Column.getColumn((String)"SSPBuildInQAMap", (String)"USER_LOGIN_ID"));
            Criteria crit = new Criteria(Column.getColumn((String)"SSPBuildInQAMap", (String)"USER_LOGIN_ID"), (Object)loginIds, 8);
            sq.setCriteria(crit);
            Join join = new Join(Table.getTable((String)baseTable), Table.getTable((String)"SSPSecretQues"), new String[]{"QUESTION_ID"}, new String[]{"QUESTION_ID"}, 1);
            Join join1 = new Join(Table.getTable((String)baseTable), Table.getTable((String)"AaaLogin"), new String[]{"USER_LOGIN_ID"}, new String[]{"LOGIN_ID"}, 1);
            sq.addJoin(join);
            sq.addJoin(join1);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                Properties resultProps;
                String name = (String)dataSet.getValue("NAME");
                String salt = (String)dataSet.getValue("SALT");
                String question = (String)dataSet.getValue("QUESTION_TEXT");
                String answer = (String)dataSet.getValue("ANSWER_TWO_WAY");
                if (answer == null || answer.equals("")) {
                    answer = "********";
                }
                if ((resultProps = (Properties)resultTable.get(name)) == null) {
                    resultProps = new Properties();
                }
                resultProps.put(question, answer);
                resultTable.put(name, resultProps);
            }
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getCustomQA(Long[] loginIds, Hashtable resultTable) {
        Connection connection = null;
        DataSet dataSet = null;
        try {
            String baseTable = "SSPCustomQAMap";
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)baseTable));
            sq.addSelectColumn(Column.getColumn((String)baseTable, (String)"ANSWER_TEXT"));
            sq.addSelectColumn(Column.getColumn((String)baseTable, (String)"ANSWER_TWO_WAY"));
            sq.addSelectColumn(Column.getColumn((String)baseTable, (String)"SALT"));
            sq.addSelectColumn(Column.getColumn((String)baseTable, (String)"QUESTION_TEXT"));
            sq.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"NAME"));
            sq.addSelectColumn(Column.getColumn((String)baseTable, (String)"USER_LOGIN_ID"));
            Criteria crit = new Criteria(Column.getColumn((String)baseTable, (String)"USER_LOGIN_ID"), (Object)loginIds, 8);
            sq.setCriteria(crit);
            Join join = new Join(Table.getTable((String)baseTable), Table.getTable((String)"AaaLogin"), new String[]{"USER_LOGIN_ID"}, new String[]{"LOGIN_ID"}, 1);
            sq.addJoin(join);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                Properties resultProps;
                String name = (String)dataSet.getValue("NAME");
                String salt = (String)dataSet.getValue("SALT");
                String question = (String)dataSet.getValue("QUESTION_TEXT");
                String answer = (String)dataSet.getValue("ANSWER_TWO_WAY");
                if (answer == null || answer.equals("")) {
                    answer = "********";
                }
                if ((resultProps = (Properties)resultTable.get(name)) == null) {
                    resultProps = new Properties();
                }
                resultProps.put(question, answer);
                resultTable.put(name, resultProps);
            }
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
    }

    public static void getSortedArray(String[] nameArray, Enumeration e, boolean ascending) {
        int i = 0;
        while (e.hasMoreElements()) {
            String name;
            nameArray[i] = name = (String)e.nextElement();
            ++i;
        }
        if (ascending) {
            Arrays.sort(nameArray, String.CASE_INSENSITIVE_ORDER);
        } else {
            Arrays.sort(nameArray, String.CASE_INSENSITIVE_ORDER);
            Collections.reverse(Arrays.asList(nameArray));
        }
    }

    public static Long[] getEnrolledUserIds(ArrayList ouList, String usersTable, String domainName, int startIndex, int numOfObjects, Boolean export, String searchString) {
        Long[] users = null;
        try {
            DataObject dataObj;
            Hashtable<String, Object> reportData = new Hashtable<String, Object>();
            reportData.put("DOMAIN_NAME", domainName);
            reportData.put("OU_LIST", ouList);
            reportData.put("SEARCH_STRING", SecurityQAReportHandler.formSearchString(searchString));
            SelectQuery sq = EnrollUtil.getSQForEnrolledUsers(usersTable, reportData);
            sq.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"));
            sq.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"NAME"));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"AaaLogin", (String)"NAME"), true));
            if (!export.booleanValue()) {
                sq.setRange(new Range(startIndex, numOfObjects));
            }
            if (!(dataObj = CommonUtil.getPersistence(new boolean[0]).get(sq)).isEmpty()) {
                users = new Long[dataObj.size("AaaLogin")];
                int i = 0;
                Iterator it = dataObj.getRows("AaaLogin");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    users[i] = (Long)r.get("LOGIN_ID");
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return users;
    }

    public static String formSearchString(String searchString) {
        return "".equals(searchString) ? "" : "QUESTION_TEXT=" + searchString;
    }

    public static Criteria getDefaultQuestionsCriteria(String searchText) {
        Criteria cri = null;
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            DataObject defaultQuestions = PolicyHandler.getDefaultQuestions();
            Iterator defQuesIt = defaultQuestions.getRows("SSPBuildInQ");
            while (defQuesIt.hasNext()) {
                Row questionRow = (Row)defQuesIt.next();
                String questionText = (String)questionRow.get("QUESTION_TEXT");
                if (!rb.getString(questionText).toLowerCase().contains(searchText.toLowerCase())) continue;
                if (cri != null) {
                    cri = cri.or(new Criteria(Column.getColumn((String)"SSPSecretQues", (String)"QUESTION_TEXT"), (Object)questionText, 0));
                    continue;
                }
                cri = new Criteria(Column.getColumn((String)"SSPSecretQues", (String)"QUESTION_TEXT"), (Object)questionText, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cri;
    }
}

