/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.reports;

import java.util.ArrayList;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ServerThreadPool {
    private int poolSize = 50;
    private ThreadPoolExecutor tpExec = null;
    private ArrayList sessionIds = new ArrayList();
    private static ServerThreadPool instance = null;
    private SynchronousQueue queue = new SynchronousQueue();
    private Object lockObj = new Object();

    public static synchronized ServerThreadPool getInstance() {
        if (instance == null) {
            instance = new ServerThreadPool();
        }
        return instance;
    }

    public ServerThreadPool() {
        this.tpExec = new ThreadPoolExecutor(this.poolSize / 3, this.poolSize, 50000L, TimeUnit.MILLISECONDS, this.queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTask(String sessionId, Runnable task) {
        Object object = this.lockObj;
        synchronized (object) {
            try {
                this.tpExec.execute(task);
            }
            catch (RejectedExecutionException rEE) {
                try {
                    this.tpExec.getQueue().put(task);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized void addSessionId(String sessionId) {
        this.sessionIds.add(sessionId);
    }

    public synchronized void removeSessionId(String sessionId) {
        this.sessionIds.remove(sessionId);
    }

    public synchronized boolean isRunning(String sessionId) {
        return this.sessionIds.contains(sessionId);
    }

    public synchronized boolean hasSessions() {
        return !this.sessionIds.isEmpty();
    }

    public synchronized void stopSessionTasks(String sessionId) {
        this.removeSessionId(sessionId);
    }

    public void shutDown() {
        if (this.tpExec != null) {
            this.tpExec.shutdown();
        }
    }
}

