/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.reports.enrollment;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.DeleteQuery;
import com.adventnet.ds.query.DeleteQueryImpl;
import com.adventnet.ds.query.Function;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.sym.adsm.common.server.reports.enrollment.EnrollUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.manageengine.ads.fw.mobile.pushnotification.PushNotificationConstants;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;

public class EnrollHandler
implements PushNotificationConstants {
    private static Logger logger = Logger.getLogger(EnrollHandler.class.getName());
    public static final String[] DEFAULT_COLUMNS = new String[]{"SAM_ACCOUNT_NAME", "DISPLAY_NAME", "E_MAIL", "MOBILE_NUMBER", "OU_NAME"};
    public static final String[] DEFAULT_COLUMNS_DISPLAY = new String[]{"adssp.reports.common.text.sam_name", "adssp.reports.common.text.display_name_txt", "adssp.reports.common.text.e_mail", "adssp.reports.common.text.mob_num", "adssp.common.text.ou_name"};
    public static final String[] ENROLL_COLUMNS = new String[]{"SAM_ACCOUNT_NAME", "DISPLAY_NAME", "EMAIL_ADDRESSES", "MOBILE_NUMBERS", "OU_NAME", "ENROLLED_TIME", "MODIFIED_TIME"};
    public static final String[] ENROLL_COLUMNS_DISPLAY = new String[]{"adssp.reports.common.text.sam_name", "adssp.reports.common.text.display_name_txt", "adssp.reports.common.text.e_mail", "adssp.reports.common.text.mob_num", "adssp.common.text.ou_name", "adssp.reports.enroll_rep.enroll.head_enrolled_time", "adssp.reports.enroll_rep.enroll.head_modified_time"};
    public static final String[] PUSH_REG_DEVICE_COLUMNS = new String[]{"SAM_ACCOUNT_NAME", "DOMAINNAME", "MAPP_PLATFORM", "DEVICE_MODEL", "DEVICE_OS_VERSION", "MAPP_STATUS", "DEVICE_INSTALLATION_ID"};
    public static final String[] PUSH_REG_DEVICE_COLUMNS_DISPLAY = new String[]{"adssp.reports.common.text.audit_login_name", "adssp.common.text.domain_name", "adssp.reports.audit_report.push_device_platform", "adssp.reports.audit_report.push_device_productName", "adssp.reports.audit_report.push_device_osVersion", "adssp.reports.enroll_report.push_device_status"};
    public static final String[] USER_TABLE_COLUMNS = new String[]{"SAM_ACCOUNT_NAME", "DISPLAY_NAME", "E_MAIL", "MOBILE_NUMBER", "OU_NAME", "OTHER_MOBILE"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getEnrolledUsersCount(Hashtable reportData) throws Exception {
        int count = 0;
        Connection connection = null;
        DataSet dataSet = null;
        try {
            String domainName = (String)reportData.get("DOMAIN_NAME");
            String usersTable = CommonUtil.getDomainUserTableName(domainName);
            SelectQuery selQuery = EnrollUtil.getSQForEnrolledUsers(usersTable, reportData);
            Column countColumn = Column.getColumn(null, (String)"*");
            selQuery.addSelectColumn(countColumn.count());
            RelationalAPI relApi = RelationalAPI.getInstance();
            connection = relApi.getConnection();
            logger.log(Level.INFO, "getEnrolledUsersCount method called ");
            dataSet = relApi.executeQuery((Query)selQuery, connection);
            while (dataSet.next()) {
                count = (Integer)dataSet.getValue(1);
            }
            logger.log(Level.INFO, "Total Enrolled Users :: " + count + " ::For Domain :: " + domainName);
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getEnrolledUsersList(Hashtable reportData) throws Exception {
        ArrayList<Properties> list = new ArrayList<Properties>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            String domainName = (String)reportData.get("DOMAIN_NAME");
            String usersTable = CommonUtil.getDomainUserTableName(domainName);
            SelectQuery sq = EnrollUtil.getSQForEnrolledUsers(usersTable, reportData);
            sq.addSelectColumn(Column.getColumn((String)"SSPUserPropertyMap", (String)"ENROLLED_TIME"));
            sq.addSelectColumn(Column.getColumn((String)"SSPUserPropertyMap", (String)"MODIFIED_TIME"));
            sq.addSelectColumn(Column.getColumn((String)"SSPUserPropertyMap", (String)"USER_LOGIN_ID"));
            sq.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADMPUsersPersonal", (String)"EMAIL_ADDRESSES"));
            sq.addSelectColumn(Column.getColumn((String)"ADMPUsersPersonal", (String)"MOBILE_NUMBERS"));
            for (String str : USER_TABLE_COLUMNS) {
                sq.addSelectColumn(Column.getColumn((String)usersTable, (String)str));
            }
            String sortColumn = (String)reportData.get("SORT_COLUMN");
            String sortTable = usersTable;
            if (sortColumn.equals("ENROLLED_TIME") || sortColumn.equals("MODIFIED_TIME")) {
                sortTable = "SSPUserPropertyMap";
            }
            if (sortColumn.equals("EMAIL_ADDRESSES") || sortColumn.equals("MOBILE_NUMBERS")) {
                boolean sortType = (Boolean)reportData.get("ASCENDING");
                if (CommonUtil.isMSSQL() && sortType) {
                    sortType = false;
                }
                Function concatCol = null;
                if (sortColumn.equals("EMAIL_ADDRESSES")) {
                    concatCol = Column.createFunction((String)"CONCAT", (Object[])new Object[]{Column.getColumn((String)usersTable, (String)"E_MAIL"), Column.getColumn((String)"ADMPUsersPersonal", (String)"EMAIL_ADDRESSES")});
                } else {
                    Function tempCol = Column.createFunction((String)"CONCAT", (Object[])new Object[]{Column.getColumn((String)usersTable, (String)"MOBILE_NUMBER"), Column.getColumn((String)usersTable, (String)"OTHER_MOBILE")});
                    tempCol.setType(1);
                    concatCol = Column.createFunction((String)"CONCAT", (Object[])new Object[]{tempCol, Column.getColumn((String)"ADMPUsersPersonal", (String)"MOBILE_NUMBERS")});
                }
                concatCol.setType(1);
                sq.addSortColumn(new SortColumn((Column)concatCol, sortType));
            } else {
                sq.addSortColumn(new SortColumn(Column.getColumn((String)sortTable, (String)sortColumn), ((Boolean)reportData.get("ASCENDING")).booleanValue()));
            }
            if (!((Boolean)reportData.get("EXPORT")).booleanValue()) {
                int startIndex = (Integer)reportData.get("START_INDEX");
                int numOfObjects = (Integer)reportData.get("NO_OF_OBJECTS");
                sq.setRange(new Range(startIndex, numOfObjects));
            }
            RelationalAPI relApi = RelationalAPI.getInstance();
            connection = relApi.getConnection();
            logger.log(Level.INFO, "getEnrolledUsersList method called:" + relApi.getSelectSQL((Query)sq));
            dataSet = relApi.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                String mob;
                Properties p = new Properties();
                for (String str : USER_TABLE_COLUMNS) {
                    String val = dataSet.getString(str);
                    if (val == null) {
                        val = "-";
                    }
                    if ("E_MAIL".equals(str) || "MOBILE_NUMBER".equals(str) || "OTHER_MOBILE".equals(str)) {
                        val = val.replaceAll(",", ", ");
                    }
                    p.put(str, val);
                }
                if (!"-".equals(p.getProperty("OTHER_MOBILE"))) {
                    mob = "-".equals(p.getProperty("MOBILE_NUMBER")) ? p.getProperty("OTHER_MOBILE") : p.getProperty("MOBILE_NUMBER") + ", " + p.getProperty("OTHER_MOBILE").replaceAll(",", ", ");
                    p.put("MOBILE_NUMBER", mob);
                }
                if (dataSet.getString("MOBILE_NUMBERS") != null) {
                    String string = mob = "-".equals(p.getProperty("MOBILE_NUMBER")) ? dataSet.getString("MOBILE_NUMBERS") : p.getProperty("MOBILE_NUMBER") + ", " + dataSet.getString("MOBILE_NUMBERS").replaceAll(",", ", ");
                    if (mob.endsWith(",")) {
                        mob = mob.substring(0, mob.length() - 1);
                    }
                    p.put("MOBILE_NUMBER", mob);
                }
                if (dataSet.getString("EMAIL_ADDRESSES") != null) {
                    String email;
                    String string = email = "-".equals(p.getProperty("E_MAIL")) ? dataSet.getString("EMAIL_ADDRESSES") : p.getProperty("E_MAIL") + ", " + dataSet.getString("EMAIL_ADDRESSES").replaceAll(",", ", ");
                    if (email.endsWith(",")) {
                        email = email.substring(0, email.length() - 1);
                    }
                    p.put("E_MAIL", email);
                }
                p.put("ENROLLED_TIME", (Object)dataSet.getLong("ENROLLED_TIME"));
                p.put("MODIFIED_TIME", (Object)dataSet.getLong("MODIFIED_TIME"));
                list.add(p);
            }
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
        logger.log(Level.INFO, "getEnrolledUsersList method Ends with count of :: " + list.size());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNonEnrolledUsersCount(Hashtable reportData) throws Exception {
        int count = 0;
        Connection connection = null;
        DataSet dataSet = null;
        try {
            String domainName = (String)reportData.get("DOMAIN_NAME");
            String usersTableName = CommonUtil.getDomainUserTableName(domainName);
            SelectQuery sq = EnrollUtil.getSQForNonEnrolledUsers(usersTableName, reportData);
            Column col = new Column(null, "*").count();
            sq.addSelectColumn(col);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            logger.log(Level.INFO, "getNonEnrolledUserCount method called");
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                count = (Integer)dataSet.getValue(1);
            }
            logger.log(Level.INFO, "Total Non-Enrolled Users :: " + count + " ::For Domain :: " + domainName);
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPushRegisteredDevicesCount(Hashtable reportData) {
        int count = 0;
        Connection connection = null;
        DataSet dataSet = null;
        try {
            String domainName = (String)reportData.get("DOMAIN_NAME");
            String usersTableName = CommonUtil.getDomainUserTableName(domainName);
            SelectQuery sQuery = EnrollUtil.getSQForPushRegisteredDevices(usersTableName, reportData);
            Column col = new Column(null, "*").count();
            sQuery.addSelectColumn(col);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            logger.log(Level.INFO, "getNonEnrolledUserCount method called");
            dataSet = relAPI.executeQuery((Query)sQuery, connection);
            while (dataSet.next()) {
                count = (Integer)dataSet.getValue(1);
            }
            logger.log(Level.INFO, "Total Push Registered Devices :: " + count + " ::For Domain :: " + domainName);
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getPushRegisteredDevicesList(Hashtable reportData) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        DataSet dataSet = null;
        Connection connection = null;
        try {
            logger.log(Level.INFO, "getPushRegisteredDevicesList method called");
            connection = RelationalAPI.getInstance().getConnection();
            dataSet = EnrollHandler.getDSForPushRegisteredDevices(connection, reportData);
            while (dataSet.next()) {
                Properties p = new Properties();
                for (String str : PUSH_REG_DEVICE_COLUMNS) {
                    String val = dataSet.getString(str);
                    if (val == null) {
                        val = "";
                    }
                    p.put(str, val);
                }
                list.add(p);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DBUtil.closeQuietly(connection, dataSet);
                throw throwable;
            }
            DBUtil.closeQuietly(connection, dataSet);
        }
        DBUtil.closeQuietly(connection, dataSet);
        return list;
    }

    public static DataSet getDSForPushRegisteredDevices(Connection connection, Hashtable reportData) {
        DataSet dataSet = null;
        try {
            String sortColumn;
            String domainName = (String)reportData.get("DOMAIN_NAME");
            String usersTableName = CommonUtil.getDomainUserTableName(domainName);
            SelectQuery sQuery = EnrollUtil.getSQForPushRegisteredDevices(usersTableName, reportData);
            RelationalAPI r = RelationalAPI.getInstance();
            sQuery.addSelectColumn(new Column(usersTableName, "SAM_ACCOUNT_NAME"));
            sQuery.addSelectColumn(new Column("AaaLogin", "DOMAINNAME"));
            sQuery.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"));
            sQuery.addSelectColumn(new Column("ADSMobileRegistration", "DEVICE_INSTALLATION_ID"));
            sQuery.addSelectColumn(new Column("ADSMobileApplications", "MAPP_PLATFORM"));
            sQuery.addSelectColumn(new Column("ADSMobileRegistration", "DEVICE_MODEL"));
            sQuery.addSelectColumn(new Column("ADSMobileRegistration", "DEVICE_OS_VERSION"));
            sQuery.addSelectColumn(new Column("ADSMobileRegistration", "MAPP_STATUS"));
            if (!((Boolean)reportData.get("EXPORT")).booleanValue()) {
                int startIndex = (Integer)reportData.get("START_INDEX");
                int numOfObjects = (Integer)reportData.get("NO_OF_OBJECTS");
                sQuery.setRange(new Range(startIndex, numOfObjects));
            }
            if ((sortColumn = (String)reportData.get("SORT_COLUMN")) != null) {
                String table = usersTableName;
                if (sortColumn.equalsIgnoreCase("MAPP_PLATFORM")) {
                    table = "ADSMobileApplications";
                } else if (sortColumn.equalsIgnoreCase("DEVICE_MODEL") || sortColumn.equals("DEVICE_OS_VERSION") || sortColumn.equalsIgnoreCase("MAPP_STATUS")) {
                    table = "ADSMobileRegistration";
                } else if (sortColumn.equalsIgnoreCase("DOMAINNAME")) {
                    table = "AaaLogin";
                }
                sQuery.addSortColumn(new SortColumn(Column.getColumn((String)table, (String)sortColumn), ((Boolean)reportData.get("ASCENDING")).booleanValue()));
            }
            dataSet = RelationalAPI.getInstance().executeQuery((Query)sQuery, connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getNonEnrolledUsersList(Hashtable reportData) throws Exception {
        ArrayList<Properties> list = new ArrayList<Properties>();
        DataSet dataSet = null;
        Connection connection = null;
        try {
            logger.log(Level.INFO, "getNonEnrolledUsersList method called");
            connection = RelationalAPI.getInstance().getConnection();
            dataSet = EnrollHandler.getDSForNonEnrolled(connection, reportData, DEFAULT_COLUMNS);
            Boolean isExport = (Boolean)reportData.get("EXPORT");
            while (dataSet.next()) {
                Properties p = new Properties();
                for (String str : DEFAULT_COLUMNS) {
                    String val = dataSet.getString(str);
                    if (val == null) {
                        val = "-";
                    }
                    if (isExport.booleanValue() && val.length() > 30) {
                        val = val.replaceAll(",", ", ");
                        int lengthv = val.length();
                        for (int i = 30; i < lengthv; i += 30) {
                            val = val.substring(0, i) + val.substring(i + 1, lengthv).replaceFirst("/", "/ ");
                        }
                    }
                    p.put(str, val);
                }
                list.add(p);
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DBUtil.closeQuietly(connection, dataSet);
                throw throwable;
            }
            DBUtil.closeQuietly(connection, dataSet);
        }
        DBUtil.closeQuietly(connection, dataSet);
        logger.log(Level.INFO, "getNonEnrolledUsersList method ends with count :: " + list.size());
        return list;
    }

    public static DataSet getDSForNonEnrolled(Connection connection, Hashtable reportData, String[] selColumns) throws Exception {
        DataSet dataSet = null;
        try {
            String sortColumn;
            String domainName = (String)reportData.get("DOMAIN_NAME");
            String usersTableName = CommonUtil.getDomainUserTableName(domainName);
            SelectQuery sq = EnrollUtil.getSQForNonEnrolledUsers(usersTableName, reportData);
            sq.addSelectColumn(Column.getColumn((String)usersTableName, (String)"OBJECT_GUID"));
            sq.addSelectColumn(Column.getColumn((String)usersTableName, (String)"DN_STRING"));
            sq.addSelectColumn(Column.getColumn((String)usersTableName, (String)"OU_NAME"));
            if (selColumns == null) {
                selColumns = DEFAULT_COLUMNS;
            }
            for (String str : selColumns) {
                Column col = Column.getColumn((String)usersTableName, (String)str);
                if (sq.getSelectColumns().contains(col)) continue;
                sq.addSelectColumn(col);
            }
            if (!((Boolean)reportData.get("EXPORT")).booleanValue()) {
                int startIndex = (Integer)reportData.get("START_INDEX");
                int numOfObjects = (Integer)reportData.get("NO_OF_OBJECTS");
                sq.setRange(new Range(startIndex, numOfObjects));
            }
            if ((sortColumn = (String)reportData.get("SORT_COLUMN")) != null) {
                sq.addSortColumn(new SortColumn(Column.getColumn((String)usersTableName, (String)sortColumn), ((Boolean)reportData.get("ASCENDING")).booleanValue()));
            }
            logger.log(Level.INFO, "getNonEnrolledUsersList method called");
            dataSet = RelationalAPI.getInstance().executeQuery((Query)sq, connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataSet;
    }

    public static DataSet getDSForNonEnrolled(Connection connection, String domainName, ArrayList ouList, boolean inheritChildOUs, String[] selectColumns) throws Exception {
        return EnrollHandler.getDSForNonEnrolled(connection, domainName, ouList, inheritChildOUs, null, selectColumns);
    }

    public static DataSet getDSForNonEnrolled(Connection connection, String domainName, ArrayList ouList, boolean inheritChildOUs, ArrayList groupList, String[] selectColumns) throws Exception {
        Hashtable<String, Object> reportData = new Hashtable<String, Object>();
        reportData.put("DOMAIN_NAME", domainName);
        if (ouList != null) {
            reportData.put("OU_LIST", ouList);
        }
        if (groupList != null) {
            reportData.put("GROUP_LIST", groupList);
        }
        reportData.put("INHERIT_CHILD_OUS", inheritChildOUs);
        reportData.put("EXPORT", true);
        reportData.put("ASCENDING", true);
        reportData.put("SHOW_NOTIFIED", false);
        return EnrollHandler.getDSForNonEnrolled(connection, reportData, selectColumns);
    }

    public static void disenrollListOfUsers(String domainName, String[] users, Long selectedEnrollmentTypes, boolean isIN) {
        try {
            DeleteQueryImpl deleteQuery = new DeleteQueryImpl("AaaLogin");
            deleteQuery.addJoin(new Join(Table.getTable((String)"AaaLogin"), Table.getTable((String)"SSPUserPropertyMap"), new String[]{"LOGIN_ID"}, new String[]{"USER_LOGIN_ID"}, 2));
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0, false);
            crit = crit.and(new Criteria(Column.getColumn((String)"SSPUserPropertyMap", (String)"REGISTRATION_STATUS"), (Object)1, 0));
            if (selectedEnrollmentTypes != null && selectedEnrollmentTypes != 4094L) {
                crit = crit.and(EnrollUtil.getSelectedEnrollmentTypesCrit(selectedEnrollmentTypes));
            }
            int queryConstant = isIN ? 8 : 9;
            crit = crit.and(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)users, queryConstant, false);
            deleteQuery.setCriteria(crit);
            CommonUtil.getPersistence(new boolean[0]).delete((DeleteQuery)deleteQuery);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateDisenrollSampleCsv(String disenrollAttribute) {
        FileOutputStream fos = null;
        OutputStreamWriter osr = null;
        BufferedWriter out = null;
        try {
            JSONArray csvFileData = EnrollUtil.getDisenrollHeaderData(disenrollAttribute);
            if (csvFileData != null) {
                String productHomeDir = System.getProperty("server.home");
                String filePath = productHomeDir + File.separator + "webapps" + File.separator + "adssp" + File.separator + "html" + File.separator + "disenrollSample.csv";
                fos = new FileOutputStream(filePath);
                osr = new OutputStreamWriter((OutputStream)fos, System.getProperty("file.encoding"));
                out = new BufferedWriter(osr);
                for (int i = 0; i < csvFileData.length(); ++i) {
                    out.write(csvFileData.getString(i));
                    out.newLine();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
                osr.close();
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNoOfDomainUserInResult(String domainName, Object[] samAccountNames, Hashtable reportData) {
        DataSet dataSet = null;
        Connection connection = null;
        try {
            String domainUserTable = CommonUtil.getDomainUserTableName(domainName);
            SelectQuery selectQuery = EnrollUtil.getSQForEnrolledUsers(domainUserTable, reportData);
            Column countColumn = Column.getColumn(null, (String)"*");
            selectQuery.addSelectColumn(countColumn.count());
            int queryConstant = 8;
            if (reportData.get("isIn") != null && !((Boolean)reportData.get("isIn")).booleanValue()) {
                queryConstant = 9;
            }
            Criteria crit = selectQuery.getCriteria().and(new Criteria(Column.getColumn((String)domainUserTable, (String)USER_TABLE_COLUMNS[0]), (Object)samAccountNames, queryConstant, false));
            selectQuery.setCriteria(crit);
            connection = RelationalAPI.getInstance().getConnection();
            dataSet = RelationalAPI.getInstance().executeQuery((Query)selectQuery, connection);
            if (dataSet.next()) {
                int n = (Integer)dataSet.getValue(1);
                DBUtil.closeQuietly(connection, dataSet);
                return n;
            }
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
        return 0;
    }
}

