/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.reports.enrollment;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DerivedTable;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.reports.enrollment.EnrollUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class EnrollMssqlUtil
extends EnrollUtil {
    public static SelectQuery getSQForNonEnrolledUsers(String usersTableName, Hashtable reportData) {
        String domainName = (String)reportData.get("DOMAIN_NAME");
        String searchString = (String)reportData.get("SEARCH_STRING");
        ArrayList ouList = (ArrayList)reportData.get("OU_LIST");
        ArrayList groupList = (ArrayList)reportData.get("GROUP_LIST");
        boolean showNotified = (Boolean)reportData.get("SHOW_NOTIFIED");
        Object inherit = reportData.get("INHERIT_CHILD_OUS");
        boolean inheritChildOUs = inherit == null || (Boolean)inherit != false;
        Table usersTable = Table.getTable((String)usersTableName);
        SelectQueryImpl sq = new SelectQueryImpl(usersTable);
        Join staleJoin = new Join(usersTable, Table.getTable((String)"StaleAccountUsers"), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
        sq.addJoin(staleJoin);
        Criteria crit = new Criteria(Column.getColumn((String)"StaleAccountUsers", (String)"OBJECT_GUID"), null, 0);
        if (showNotified) {
            Join join = new Join(usersTable, Table.getTable((String)"SSPEnrollDeliveryStatus"), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            sq.addJoin(join);
        }
        SelectQueryImpl subQuery = new SelectQueryImpl(Table.getTable((String)"AaaLogin"));
        Criteria enrollCrit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0, false);
        enrollCrit = enrollCrit.and(new Criteria(Column.getColumn((String)"SSPUserPropertyMap", (String)"REGISTRATION_STATUS"), (Object)new Integer(1), 0));
        subQuery.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"NAME"));
        subQuery.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"));
        subQuery.addSelectColumn(Column.getColumn((String)"SSPUserPropertyMap", (String)"USER_LOGIN_ID"));
        subQuery.addSelectColumn(Column.getColumn((String)"SSPUserPropertyMap", (String)"REGISTRATION_STATUS"));
        subQuery.addJoin(new Join(Table.getTable((String)"AaaLogin"), Table.getTable((String)"SSPUserPropertyMap"), new String[]{"LOGIN_ID"}, new String[]{"USER_LOGIN_ID"}, 2));
        subQuery.setCriteria(enrollCrit);
        DerivedTable enrolledUsersTable = new DerivedTable("AaaLogin", (Query)subQuery);
        Join enrollJoin = new Join(usersTable, (Table)enrolledUsersTable, new String[]{"SAM_ACCOUNT_NAME"}, new String[]{"NAME"}, 1);
        sq.addJoin(enrollJoin);
        crit = crit.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), null, 0));
        Criteria ouGroupCriteria = null;
        if (ouList != null && !ouList.isEmpty()) {
            ouGroupCriteria = EnrollMssqlUtil.getOUCriteria(usersTableName, ouList, inheritChildOUs);
        }
        try {
            if (groupList != null) {
                Join enrollGroupJoin = new Join(usersTable, Table.getTable((String)"ADSMGroupMembers"), new String[]{"OBJECT_GUID"}, new String[]{"GROUP_MEMBER_OBJECTGUID"}, 1);
                sq.addJoin(enrollGroupJoin);
                Criteria groupDNcrit = new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"DISTINGUISHED_NAME"), (Object)groupList.toArray(), 8);
                ArrayList<String> primaryGroupId = new ArrayList<String>();
                ArrayList<String> objectGUIDList = new ArrayList<String>();
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMGroupGeneralDetails", groupDNcrit);
                if (!obj.isEmpty()) {
                    Iterator it = obj.getRows("ADSMGroupGeneralDetails");
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        String SID = (String)r.get("SID_STRING");
                        objectGUIDList.add((String)r.get("OBJECT_GUID"));
                        String value = SID.substring(SID.lastIndexOf(45) + 1);
                        primaryGroupId.add(value);
                    }
                }
                Criteria c = new Criteria(Column.getColumn((String)"ADSMGroupMembers", (String)"OBJECT_GUID"), (Object)objectGUIDList.toArray(), 8);
                c = c.or(new Criteria(Column.getColumn((String)usersTableName, (String)"PRIMARY_GROUP_ID"), (Object)primaryGroupId.toArray(), 8));
                ouGroupCriteria = ouGroupCriteria != null ? ouGroupCriteria.or(c) : c;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ouGroupCriteria != null) {
            crit = crit.and(ouGroupCriteria);
        }
        if (searchString != null && !searchString.equals("")) {
            crit = crit.and(EnrollMssqlUtil.getSearchCriteria(usersTableName, searchString));
        }
        sq.setCriteria(crit);
        return sq;
    }
}

