/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.reports.enrollment;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Function;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.AuditAPI;
import com.adventnet.sym.adsm.common.server.admin.ProfileBuilder;
import com.adventnet.sym.adsm.common.server.admin.ProviderHandler;
import com.adventnet.sym.adsm.common.server.reports.AuditReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.reports.SecurityQAReportHandler;
import com.adventnet.sym.adsm.common.server.reports.enrollment.EnrollMssqlUtil;
import com.adventnet.sym.adsm.common.server.util.APCUtil;
import com.adventnet.sym.adsm.common.server.util.CSVReader;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.TimeZoneUtil;
import com.manageengine.ads.fw.logforward.LogForwarderAPI;
import com.manageengine.ads.fw.mobile.pushnotification.PushNotificationConstants;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class EnrollUtil
implements PushNotificationConstants {
    public static final String PUSH_REG_REPORT_ID = "115";
    public static final String ENROLL_REPORT_ID = "104";
    public static final String NON_ENROLL_REPORT_ID = "105";
    private static Logger logger = Logger.getLogger(EnrollUtil.class.getName());
    public static final long SQA_ENROLLED = 2L;
    public static final long VC_SEC_EMAIL_ENROLLED = 4L;
    public static final long VC_SEC_MOBILE_ENROLLED = 8L;
    public static final long GA_ENROLLED = 16L;
    public static final long DUO_ENROLLED = 32L;
    public static final long RSA_ENROLLED = 64L;
    public static final long RADIUS_ENROLLED = 128L;
    public static final long PN_ENROLLED = 256L;
    public static final long FP_ENROLLED = 512L;
    public static final long QR_ENROLLED = 1024L;
    public static final long TOTP_ENROLLED = 2048L;
    public static final long ALL_ENROLLMENT_TYPES = 4094L;
    public static final long[] ENROLLMENT_TYPE_IDS = new long[]{2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L};
    public static final String[] DISENROLL_ATTRIBUTES = new String[]{"SAM_ACCOUNT_NAME", "MOBILE_NUMBER", "E_MAIL"};
    public static JSONObject disenrollSampleData = null;

    public static SelectQuery getSQForEnrolledUsers(String usersTable, Hashtable reportData) {
        String domainName = (String)reportData.get("DOMAIN_NAME");
        String searchString = (String)reportData.get("SEARCH_STRING");
        ArrayList ouList = (ArrayList)reportData.get("OU_LIST");
        Long selectedEnrollmentTypes = (Long)reportData.get("SELECTED_ENROLLMENT_TYPES");
        SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"SSPUserPropertyMap"));
        sq.addJoin(new Join(Table.getTable((String)"SSPUserPropertyMap"), Table.getTable((String)"AaaLogin"), new String[]{"USER_LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2));
        sq.addJoin(new Join(Table.getTable((String)"AaaLogin"), Table.getTable((String)usersTable), new String[]{"NAME"}, new String[]{"SAM_ACCOUNT_NAME"}, 2));
        sq.addJoin(new Join(Table.getTable((String)"AaaLogin"), Table.getTable((String)"ADMPUsersPersonal"), new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2));
        Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0, false);
        crit = crit.and(new Criteria(Column.getColumn((String)"SSPUserPropertyMap", (String)"REGISTRATION_STATUS"), (Object)1, 0));
        if (!ouList.isEmpty()) {
            crit = crit.and(EnrollUtil.getOUCriteria(usersTable, ouList, true));
        }
        if (searchString != null && !searchString.equals("")) {
            if ("QUESTION_TEXT".equals(searchString.substring(0, searchString.indexOf("=")))) {
                sq.addJoin(new Join(Table.getTable((String)"AaaLogin"), Table.getTable((String)"SSPBuildInQAMap"), new String[]{"LOGIN_ID"}, new String[]{"USER_LOGIN_ID"}, 1));
                sq.addJoin(new Join(Table.getTable((String)"SSPBuildInQAMap"), Table.getTable((String)"SSPSecretQues"), new String[]{"QUESTION_ID"}, new String[]{"QUESTION_ID"}, 1));
                sq.addJoin(new Join(Table.getTable((String)"AaaLogin"), Table.getTable((String)"SSPCustomQAMap"), new String[]{"LOGIN_ID"}, new String[]{"USER_LOGIN_ID"}, 1));
                Criteria searchCrit = EnrollUtil.getSearchCriteria("SSPSecretQues", searchString);
                searchCrit = searchCrit.or(EnrollUtil.getSearchCriteria("SSPCustomQAMap", searchString));
                String[] split = searchString.split("=", 2);
                searchCrit = searchCrit.or(SecurityQAReportHandler.getDefaultQuestionsCriteria(split[1]));
                searchString = searchString.replaceFirst("QUESTION_TEXT", "SAM_ACCOUNT_NAME");
                searchCrit = searchCrit.or(EnrollUtil.getSearchCriteria(usersTable, searchString));
                crit = crit.and(searchCrit);
            } else {
                crit = crit.and(EnrollUtil.getSearchCriteria(usersTable, searchString));
            }
        }
        if (selectedEnrollmentTypes != null && selectedEnrollmentTypes != 4094L) {
            crit = crit.and(EnrollUtil.getSelectedEnrollmentTypesCrit(selectedEnrollmentTypes));
        }
        if (reportData.get("disenrollTechnicianID") != null) {
            crit = crit.and(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"), (Object)new Object[]{reportData.get("disenrollTechnicianID")}, 9, false);
        }
        sq.setCriteria(crit);
        return sq;
    }

    public static SelectQuery getSQForPushRegisteredDevices(String usersTable, Hashtable reportData) {
        String domainName = (String)reportData.get("DOMAIN_NAME");
        String searchString = (String)reportData.get("SEARCH_STRING");
        ArrayList ouList = (ArrayList)reportData.get("OU_LIST");
        String filter = (String)reportData.get("FILTER");
        SelectQueryImpl sQuery = new SelectQueryImpl(Table.getTable((String)"ADSMobileRegistration"));
        sQuery.addJoin(new Join(Table.getTable((String)"ADSMobileRegistration"), Table.getTable((String)"AaaLogin"), new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2));
        if (domainName != null) {
            sQuery.addJoin(new Join(Table.getTable((String)"AaaLogin"), Table.getTable((String)usersTable), new String[]{"NAME"}, new String[]{"SAM_ACCOUNT_NAME"}, 2));
        }
        sQuery.addJoin(new Join(Table.getTable((String)"ADSMobileRegistration"), Table.getTable((String)"ADSMobileApplications"), new String[]{"MAPP_ID"}, new String[]{"MAPP_ID"}, 2));
        Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0, false);
        if (!ouList.isEmpty()) {
            crit = crit.and(EnrollUtil.getOUCriteria(usersTable, ouList, true));
        }
        if (filter != null && !filter.equals("") && filter.equalsIgnoreCase("Android")) {
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMobileRegistration", (String)"MAPP_ID"), (Object)1, 0, false));
        } else if (filter != null && !filter.equals("") && filter.equalsIgnoreCase("IOS")) {
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMobileRegistration", (String)"MAPP_ID"), (Object)2, 0, false));
        }
        if (searchString != null && !searchString.equals("")) {
            crit = crit.and(EnrollUtil.getSearchCriteria(usersTable, searchString));
        }
        sQuery.setCriteria(crit);
        return sQuery;
    }

    public static SelectQuery getSQForNonEnrolledUsers(String usersTableName, Hashtable reportData) {
        if (!CommonUtil.isMySQL4()) {
            return EnrollMssqlUtil.getSQForNonEnrolledUsers(usersTableName, reportData);
        }
        String domainName = (String)reportData.get("DOMAIN_NAME");
        String searchString = (String)reportData.get("SEARCH_STRING");
        ArrayList ouList = (ArrayList)reportData.get("OU_LIST");
        ArrayList groupList = (ArrayList)reportData.get("GROUP_LIST");
        boolean showNotified = (Boolean)reportData.get("SHOW_NOTIFIED");
        Object inherit = reportData.get("INHERIT_CHILD_OUS");
        boolean inheritChildOUs = inherit == null || (Boolean)inherit != false;
        Table usersTable = Table.getTable((String)usersTableName);
        SelectQueryImpl sq = new SelectQueryImpl(usersTable);
        if (showNotified) {
            Join join = new Join(usersTable, Table.getTable((String)"SSPEnrollDeliveryStatus"), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            sq.addJoin(join);
        }
        String[] users = EnrollUtil.getEnrolledUsers(domainName);
        String[] staleUsers = EnrollUtil.getStaleUsers(usersTableName);
        Criteria crit = new Criteria(Column.getColumn((String)usersTableName, (String)"SAM_ACCOUNT_NAME"), (Object)users, 9, false);
        crit = crit.and(new Criteria(Column.getColumn((String)usersTableName, (String)"OBJECT_GUID"), (Object)staleUsers, 9));
        Criteria ouGroupCriteria = null;
        if (ouList != null && !ouList.isEmpty()) {
            ouGroupCriteria = EnrollUtil.getOUCriteria(usersTableName, ouList, inheritChildOUs);
        }
        try {
            if (groupList != null) {
                Join enrollGroupJoin = new Join(usersTable, Table.getTable((String)"ADSMGroupMembers"), new String[]{"OBJECT_GUID"}, new String[]{"GROUP_MEMBER_OBJECTGUID"}, 1);
                sq.addJoin(enrollGroupJoin);
                Criteria crit1 = new Criteria(Column.getColumn((String)"ADSMGroupGeneralDetails", (String)"DISTINGUISHED_NAME"), (Object)groupList.toArray(), 8);
                ArrayList<String> primaryGroupId = new ArrayList<String>();
                ArrayList<String> objectGUIDList = new ArrayList<String>();
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMGroupGeneralDetails", crit1);
                if (!obj.isEmpty()) {
                    Iterator it = obj.getRows("ADSMGroupGeneralDetails");
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        String SID = (String)r.get("SID_STRING");
                        objectGUIDList.add((String)r.get("OBJECT_GUID"));
                        String value = SID.substring(SID.lastIndexOf(45) + 1);
                        primaryGroupId.add(value);
                    }
                }
                Criteria c = new Criteria(Column.getColumn((String)"ADSMGroupMembers", (String)"OBJECT_GUID"), (Object)objectGUIDList.toArray(), 8);
                c = c.or(new Criteria(Column.getColumn((String)usersTableName, (String)"PRIMARY_GROUP_ID"), (Object)primaryGroupId.toArray(), 8));
                ouGroupCriteria = ouGroupCriteria != null ? ouGroupCriteria.or(c) : c;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (ouGroupCriteria != null) {
            crit = crit.and(ouGroupCriteria);
        }
        if (searchString != null && !searchString.equals("")) {
            crit = crit.and(EnrollUtil.getSearchCriteria(usersTableName, searchString));
        }
        sq.setCriteria(crit);
        return sq;
    }

    public static Criteria getOUCriteria(String usersTable, ArrayList ouList, boolean inheritChildOUs) {
        Criteria crit = null;
        String matchColumn = inheritChildOUs ? "DN_STRING" : "OU_NAME";
        int queryConst = inheritChildOUs ? 11 : 0;
        for (int i = 0; i < ouList.size(); ++i) {
            String ou = QueryUtil.mickeyCriteriaEscape((String)ouList.get(i));
            crit = crit != null ? crit.or(new Criteria(Column.getColumn((String)usersTable, (String)matchColumn), (Object)ou, queryConst)) : new Criteria(Column.getColumn((String)usersTable, (String)"DN_STRING"), (Object)ou, 11);
        }
        return crit;
    }

    public static Criteria getSearchCriteria(String usersTable, String searchString) {
        String[] splittedStr;
        Criteria searchCrit = null;
        for (String param : splittedStr = searchString.split(Pattern.quote("||"))) {
            String[] arr = param.split("=", 2);
            String searchTable = "MOBILE_NUMBERS".equals(arr[0]) || "EMAIL_ADDRESSES".equals(arr[0]) ? "ADMPUsersPersonal" : usersTable;
            Criteria crit = new Criteria(Column.getColumn((String)searchTable, (String)arr[0]), (Object)("*" + QueryUtil.mickeyCriteriaEscape(arr[1]) + "*"), 2, false);
            if ("MOBILE_NUMBERS".equals(arr[0])) {
                crit = crit.or(new Criteria(Column.getColumn((String)usersTable, (String)"MOBILE_NUMBER"), (Object)("*" + QueryUtil.mickeyCriteriaEscape(arr[1]) + "*"), 2, false));
            } else if ("EMAIL_ADDRESSES".equals(arr[0])) {
                crit = crit.or(new Criteria(Column.getColumn((String)usersTable, (String)"E_MAIL"), (Object)("*" + QueryUtil.mickeyCriteriaEscape(arr[1]) + "*"), 2, false));
            }
            searchCrit = searchCrit != null ? searchCrit.and(crit) : crit;
        }
        return searchCrit;
    }

    public static Criteria getSelectedEnrollmentTypesCrit(Long selectedEnrollTypes) {
        Criteria crit = null;
        try {
            for (long typeId : ENROLLMENT_TYPE_IDS) {
                if ((typeId & selectedEnrollTypes) != typeId) continue;
                crit = crit == null ? EnrollUtil.getenrollmentTypeCrit(typeId) : crit.or(EnrollUtil.getenrollmentTypeCrit(typeId));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return crit;
    }

    public static Criteria getenrollmentTypeCrit(long selEnrollmentType) {
        Criteria enrollmentTypeCrit = null;
        try {
            Function enrollmentType = Column.createFunction((String)"AND_OPERATOR", (Object[])new Object[]{Column.getColumn((String)"SSPUserPropertyMap", (String)"ENROLLMENT_TYPE"), selEnrollmentType});
            enrollmentType.setType(-5);
            enrollmentTypeCrit = new Criteria((Column)enrollmentType, (Object)selEnrollmentType, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return enrollmentTypeCrit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getEnrolledUsers(String domainName) {
        String[] users = null;
        Connection connection = null;
        DataSet dataSet = null;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"AaaLogin"));
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0, false);
            crit = crit.and(new Criteria(Column.getColumn((String)"SSPUserPropertyMap", (String)"REGISTRATION_STATUS"), (Object)new Integer(1), 0));
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"NAME"));
            sq.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"));
            sq.addSelectColumn(Column.getColumn((String)"SSPUserPropertyMap", (String)"USER_LOGIN_ID"));
            sq.addSelectColumn(Column.getColumn((String)"SSPUserPropertyMap", (String)"REGISTRATION_STATUS"));
            sq.addJoin(new Join(Table.getTable((String)"AaaLogin"), Table.getTable((String)"SSPUserPropertyMap"), new String[]{"LOGIN_ID"}, new String[]{"USER_LOGIN_ID"}, 2));
            RelationalAPI relApi = RelationalAPI.getInstance();
            connection = relApi.getConnection();
            logger.log(Level.INFO, "getEnrolledUsers method called");
            dataSet = relApi.executeQuery((Query)sq, connection);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!obj.isEmpty()) {
                ArrayList<String> list = new ArrayList<String>();
                Iterator it = obj.getRows("AaaLogin");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    list.add((String)r.get("NAME"));
                }
                users = list.toArray(new String[list.size()]);
                logger.log(Level.INFO, "getEnrolledUsers method ends with count :: " + list.size());
            }
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
        if (users == null) {
            users = new String[]{""};
        }
        return users;
    }

    public static String[] getStaleUsers(String usersTable) {
        String[] staleusers = null;
        ArrayList<String> staleList = new ArrayList<String>();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"StaleAccountUsers"));
            Join j = new Join(Table.getTable((String)"StaleAccountUsers"), Table.getTable((String)usersTable), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            sq.addSelectColumn(Column.getColumn((String)"StaleAccountUsers", (String)"OBJECT_GUID"));
            sq.addSelectColumn(Column.getColumn((String)usersTable, (String)"OBJECT_GUID"));
            sq.addJoin(j);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows(usersTable);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    staleList.add((String)r.get("OBJECT_GUID"));
                }
            }
            staleusers = staleList.toArray(new String[staleList.size()]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (staleusers == null) {
            staleusers = new String[]{""};
        }
        return staleusers;
    }

    public static DataSet getDSNonEnrolledPNConfigUsers(Connection connection, String domainName, ArrayList ouList, boolean showNotified, boolean inheritChildOUs, String[] attrList) {
        DataSet dataSet = null;
        try {
            String users_Table = CommonUtil.getDomainUserTableName(domainName);
            Table pnRegTable = Table.getTable((String)"ADSMobileRegistration");
            SelectQueryImpl sq = new SelectQueryImpl(pnRegTable);
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0, false);
            Table aaaLogin = Table.getTable((String)"AaaLogin");
            Join pnRegTableJoin = new Join(pnRegTable, Table.getTable((String)"AaaLogin"), new String[]{"LOGIN_ID"}, new String[]{"LOGIN_ID"}, 2);
            sq.addJoin(pnRegTableJoin);
            Join aaaTablejoin = new Join(aaaLogin, Table.getTable((String)users_Table), new String[]{"NAME"}, new String[]{"SAM_ACCOUNT_NAME"}, 2);
            sq.addJoin(aaaTablejoin);
            if (showNotified) {
                Join join = new Join(Table.getTable((String)users_Table), Table.getTable((String)"SSPEnrollDeliveryStatus"), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
                sq.addJoin(join);
            }
            Join enrollJoin = new Join(aaaLogin, Table.getTable((String)"SSPUserPropertyMap"), new String[]{"LOGIN_ID"}, new String[]{"USER_LOGIN_ID"}, 1);
            sq.addJoin(enrollJoin);
            crit = crit.and(new Criteria(Column.getColumn((String)"SSPUserPropertyMap", (String)"REGISTRATION_STATUS"), null, 0));
            if (ouList != null && !ouList.isEmpty()) {
                crit = crit.and(EnrollUtil.getOUCriteria(users_Table, ouList, inheritChildOUs));
            }
            sq.addSelectColumn(Column.getColumn((String)"SSPUserPropertyMap", (String)"REGISTRATION_STATUS"));
            sq.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"));
            sq.addSelectColumn(Column.getColumn((String)users_Table, (String)"OBJECT_GUID"));
            sq.addSelectColumn(Column.getColumn((String)users_Table, (String)"DN_STRING"));
            for (String str : attrList) {
                sq.addSelectColumn(Column.getColumn((String)users_Table, (String)str));
            }
            sq.setCriteria(crit);
            dataSet = RelationalAPI.getInstance().executeQuery((Query)sq, connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataSet;
    }

    public static Hashtable enrollFromCSV(Hashtable props) {
        Integer importColumn = 2;
        Boolean overWrite = false;
        Long policyId = 0L;
        Long queId = 0L;
        Hashtable impColhash = null;
        File file = null;
        Hashtable returnHash = new Hashtable();
        try {
            ArrayList policyIds = (ArrayList)props.get("SCHEDULED_POLICY_IDS");
            policyId = (Long)policyIds.get(0);
            importColumn = ((Long)props.get("IMPORT_COLUMNS")).intValue();
            file = (File)props.get("CSV_FILE");
            overWrite = (Boolean)props.get("OVERWRITE");
            impColhash = ProviderHandler.getImportColumn(importColumn);
            if (!((Boolean)impColhash.get("question")).booleanValue()) {
                queId = (Long)props.get("QUESTION_ID");
            }
            Boolean needToEnrollDuo = AuditReportHandler.isFilterEnabled(16L, importColumn.intValue());
            int hIndex = EnrollUtil.getHeaderIndex(impColhash);
            String encodingFormat = (String)props.get("FILE_ENCODING");
            Hashtable csvHeaderList = EnrollUtil.getListFromCSV(file, encodingFormat);
            ArrayList list = (ArrayList)csvHeaderList.get("CsvList");
            Vector headerVector = (Vector)csvHeaderList.get("HeaderVector");
            Hashtable indexing = EnrollUtil.getHeaderIndex(list, hIndex, headerVector, impColhash);
            int sANPos = (Integer)indexing.get("sANPos");
            int quePos = (Integer)indexing.get("quePos");
            int ansPos = (Integer)indexing.get("ansPos");
            int mobilePos = (Integer)indexing.get("mobilePos");
            int mailPos = (Integer)indexing.get("mailPos");
            String names = APCUtil.getDomainName(policyId);
            String dName = new JSONObject(names).getString("DOMAIN_NAME");
            boolean delPre = overWrite != null && overWrite != false;
            int mismatch = 0;
            ArrayList enrollList = new ArrayList();
            ArrayList<String> failure = new ArrayList<String>();
            for (Vector vector : list) {
                int fields = vector.size();
                if (fields != hIndex) {
                    failure.add((String)vector.get(sANPos));
                    ++mismatch;
                    continue;
                }
                Hashtable<String, Object> hash = new Hashtable<String, Object>();
                hash.put("NAME", (String)vector.get(sANPos));
                hash.put("QUESTION", (Boolean)impColhash.get("question") != false ? (String)vector.get(quePos) : "-");
                hash.put("QUESTION_ID", queId);
                hash.put("ANSWER", ansPos != -1 ? (String)vector.get(ansPos) : "-");
                hash.put("MOBILE", mobilePos != -1 ? (String)vector.get(mobilePos) : "-");
                hash.put("MAIL", mailPos != -1 ? (String)vector.get(mailPos) : "-");
                hash.put("DOMAIN_NAME", dName);
                hash.put("ENROLL_DUO", needToEnrollDuo);
                enrollList.add(hash);
            }
            ArrayList failureList = ProfileBuilder.buildProfile(enrollList, policyId, delPre);
            failure.addAll(failureList);
            returnHash = EnrollUtil.getStatusMessage(list, failure, mismatch);
            returnHash.put("DOMAIN_NAME", dName);
            logger.log(Level.INFO, "Successfully Enrolled : " + (list.size() - failure.size()) + ". Failed : " + failure.size());
        }
        catch (Exception ex) {
            returnHash.put("statusMessage", ex.getMessage());
            ex.printStackTrace();
        }
        return returnHash;
    }

    private static Hashtable getListFromCSV(File file, String encoding) {
        return EnrollUtil.getListFromCSV(file, encoding, false, 0);
    }

    public static Hashtable getListFromCSV(File file, String encoding, boolean isSingleValued, int limit) {
        Vector headerVector = new Vector();
        Hashtable<String, AbstractList> hashTab = new Hashtable<String, AbstractList>();
        ArrayList<Vector> list = new ArrayList<Vector>();
        ArrayList singleValuedList = new ArrayList();
        try {
            Boolean header = true;
            FileInputStream stream = new FileInputStream(file);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, encoding));
            CSVReader csvReader = new CSVReader(reader);
            try {
                if (header.booleanValue()) {
                    headerVector = csvReader.getAllFieldsInLine();
                    if (isSingleValued && headerVector.size() != 1) {
                        hashTab.put("HeaderVector", null);
                    }
                    hashTab.put("HeaderVector", headerVector);
                }
            }
            catch (Exception ex) {
                csvReader.close();
            }
            try {
                while (true) {
                    Vector valuesVector;
                    if ((valuesVector = csvReader.getAllFieldsInLine()).isEmpty() || valuesVector.size() == 0) {
                        continue;
                    }
                    if (isSingleValued) {
                        if (valuesVector.size() > 1) {
                            singleValuedList = null;
                        } else if (limit > 0) {
                            singleValuedList.add(valuesVector.get(0));
                            --limit;
                            continue;
                        }
                        break;
                    }
                    list.add(valuesVector);
                }
            }
            catch (EOFException eofexception) {
                csvReader.close();
                logger.log(Level.INFO, "Reached the End of File");
            }
            catch (Exception exception) {
                csvReader.close();
                exception.printStackTrace();
            }
            if (isSingleValued) {
                hashTab.put("CsvList", singleValuedList);
            } else {
                hashTab.put("CsvList", list);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hashTab;
    }

    private static int getHeaderIndex(Hashtable hash) {
        int i = 1;
        Enumeration e = hash.elements();
        while (e.hasMoreElements()) {
            Boolean bool = (Boolean)e.nextElement();
            if (!bool.booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private static Hashtable getHeaderIndex(ArrayList<Vector> list, int hIndex, Vector headerVector, Hashtable impColHash) throws Exception {
        Hashtable<String, Integer> indexing = new Hashtable<String, Integer>();
        try {
            int sANPos = -1;
            int quePos = -1;
            int ansPos = -1;
            int mobilePos = -1;
            int mailPos = -1;
            if (list.size() == 0) {
                throw new Exception("adssp.admin.policies.import_ans.file_no_content");
            }
            if (headerVector.size() == 0) {
                throw new Exception("adssp.admin.policies.import_ans.provide_header");
            }
            if (hIndex != headerVector.size()) {
                throw new Exception("adssp.admin.policies.import_ans.mismatch_option");
            }
            int allField = 0;
            for (int j = 0; j < hIndex; ++j) {
                String key = (String)headerVector.get(j);
                if (key.equalsIgnoreCase("samaccountname") || impColHash.get(key.toLowerCase()) != null && ((Boolean)impColHash.get(key.toLowerCase())).booleanValue()) {
                    if (key.equalsIgnoreCase("samaccountname") && sANPos == -1) {
                        sANPos = j;
                        ++allField;
                        continue;
                    }
                    if (key.equalsIgnoreCase("question") && quePos == -1) {
                        quePos = j;
                        ++allField;
                        continue;
                    }
                    if (key.equalsIgnoreCase("answer") && ansPos == -1) {
                        ansPos = j;
                        ++allField;
                        continue;
                    }
                    if (key.equalsIgnoreCase("mobile") && mobilePos == -1) {
                        mobilePos = j;
                        ++allField;
                        continue;
                    }
                    if (key.equalsIgnoreCase("mail") && mailPos == -1) {
                        mailPos = j;
                        ++allField;
                        continue;
                    }
                    throw new Exception("adssp.admin.policies.import_ans.provide_header");
                }
                throw new Exception("adssp.admin.policies.import_ans.mismatch_option");
            }
            if (allField != hIndex || sANPos == -1) {
                throw new Exception("adssp.admin.policies.import_ans.provide_header");
            }
            indexing.put("sANPos", sANPos);
            indexing.put("quePos", quePos);
            indexing.put("ansPos", ansPos);
            indexing.put("mobilePos", mobilePos);
            indexing.put("mailPos", mailPos);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return indexing;
    }

    private static Hashtable getStatusMessage(ArrayList<Vector> list, ArrayList failure, int formatFailed) {
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        String statusMessage = "";
        try {
            if (list.size() == 0) {
                statusMessage = "adssp.admin.policies.import_ans.file_no_content";
            } else if (list.size() == failure.size()) {
                hash.put("failureList", failure);
                statusMessage = "adssp.admin.policies.import_ans.auto_enroll_failed_all_users";
            } else if (failure.size() != 0) {
                hash.put("failureList", failure);
                statusMessage = "adssp.admin.policies.import_ans.auto_enroll_failed_all_users_some_users";
            } else {
                statusMessage = formatFailed == list.size() ? "adssp.admin.policies.import_ans.improper_file" : "adssp.admin.policies.import_ans.auto_enroll_success";
            }
            hash.put("statusMessage", statusMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    public static void writeToSyslogServer(HttpServletRequest request, String loginName, String domainName) {
        try {
            String ipAddress = request.getHeader("X-FORWARDED-FOR");
            String accessMode = ReportsUtil.getSSPAccessMode(request);
            JSONObject jsonLog = AuditAPI.getInstance().setAuditProps(loginName, domainName, System.currentTimeMillis(), "adssp.admin.policies.policy_config.apc_enrollment", ipAddress, "", accessMode, "audit.action.user_disenroll");
            logger.log(Level.INFO, "calling LogForwarderAPI : " + jsonLog.toString());
            LogForwarderAPI.getInstance().sendMessage(jsonLog);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONArray getDisenrollHeaderData(String disenrollAttribute) {
        try {
            if (disenrollSampleData == null) {
                disenrollSampleData = new JSONObject();
                disenrollSampleData.put(DISENROLL_ATTRIBUTES[0], Arrays.asList("sAMAccountName", "John", "Martin"));
                disenrollSampleData.put(DISENROLL_ATTRIBUTES[1], Arrays.asList("mobile", "9876543210", "9812345607"));
                disenrollSampleData.put(DISENROLL_ATTRIBUTES[2], Arrays.asList("mail", "john@test.com", "martin.alex@test.com"));
            }
            if (disenrollSampleData.has(disenrollAttribute)) {
                return (JSONArray)disenrollSampleData.get(disenrollAttribute);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Hashtable getUsersForDisenrollment(String disenrollAttribute, List csvData, List enrolledUsersList) {
        JSONObject userParamMap = new JSONObject();
        JSONObject conflictData = new JSONObject();
        ArrayList<String> usersToBeDisEnrolled = new ArrayList<String>();
        ArrayList<String> nonEnrolledData = new ArrayList<String>();
        Hashtable<String, ArrayList<String>> result = new Hashtable<String, ArrayList<String>>();
        int attributeIndex = Arrays.asList(DISENROLL_ATTRIBUTES).indexOf(disenrollAttribute);
        try {
            JSONObject isSingleValued = new JSONObject();
            isSingleValued.put(DISENROLL_ATTRIBUTES[0], true);
            isSingleValued.put(DISENROLL_ATTRIBUTES[1], false);
            isSingleValued.put(DISENROLL_ATTRIBUTES[2], false);
            if (attributeIndex != -1) {
                for (int i = 0; i < csvData.size(); ++i) {
                    String cvsValue = (String)csvData.get(i);
                    if (conflictData.has(cvsValue) || nonEnrolledData.contains(cvsValue)) continue;
                    HashSet<String> matchedData = new HashSet<String>();
                    block3: for (int j = 0; j < enrolledUsersList.size(); ++j) {
                        Properties properties = (Properties)enrolledUsersList.get(j);
                        String[] propertyValueToBeChecked = isSingleValued.getBoolean(disenrollAttribute) ? new String[]{properties.getProperty(DISENROLL_ATTRIBUTES[attributeIndex])} : properties.getProperty(DISENROLL_ATTRIBUTES[attributeIndex]).split(",");
                        for (String tmpVal : propertyValueToBeChecked) {
                            if (!cvsValue.equalsIgnoreCase(tmpVal)) continue;
                            matchedData.add(properties.getProperty("SAM_ACCOUNT_NAME"));
                            continue block3;
                        }
                    }
                    if (matchedData.size() > 1) {
                        conflictData.put(cvsValue, new ArrayList(matchedData));
                        continue;
                    }
                    if (matchedData.size() == 0) {
                        nonEnrolledData.add(cvsValue);
                        continue;
                    }
                    if (matchedData.size() != 1) continue;
                    for (Object e : matchedData) {
                        JSONArray userParams;
                        if (!usersToBeDisEnrolled.contains((String)e)) {
                            usersToBeDisEnrolled.add((String)e);
                            userParams = new JSONArray();
                            userParams.put(userParams.length(), (Object)cvsValue);
                            userParamMap.put((String)e, (Object)userParams);
                            continue;
                        }
                        userParams = (JSONArray)userParamMap.get((String)e);
                        boolean flag = false;
                        for (int l = 0; l < userParams.length(); ++l) {
                            if (!userParams.getString(l).equalsIgnoreCase(cvsValue)) continue;
                            flag = true;
                            break;
                        }
                        if (flag) continue;
                        userParams.put(userParams.length(), (Object)cvsValue);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (usersToBeDisEnrolled.size() > 0) {
            Collections.sort(usersToBeDisEnrolled);
            result.put("orderedSAMAccountNames", usersToBeDisEnrolled);
            result.put("usersToBeDisEnrolled", (ArrayList<String>)userParamMap);
        }
        result.put("conflictData", (ArrayList<String>)conflictData);
        result.put("nonEnrolledData", nonEnrolledData);
        return result;
    }

    public static void writeDisEnrollDataToLog(String domainName, Object[] usersToBeDisEnrolled, String action, String status) {
        try {
            long currentTimeMillis = System.currentTimeMillis();
            String dateTime = TimeZoneUtil.getPresentDateTime((HttpServletRequest)null, null);
            int i = 0;
            int j = 300;
            while (i < usersToBeDisEnrolled.length) {
                JSONArray jsonArray = new JSONArray();
                int k = 0;
                while (i < usersToBeDisEnrolled.length && i < j) {
                    jsonArray.put(k++, usersToBeDisEnrolled[i]);
                    ++i;
                }
                JSONObject jsonLog = new JSONObject();
                jsonLog.put("DOMAIN_NAME", (Object)domainName);
                jsonLog.put("USERS_LIST", (Object)jsonArray.toString());
                jsonLog.put("ACTION_NAME", (Object)action);
                jsonLog.put("TIME", System.currentTimeMillis());
                jsonLog.put("DATE_TIME", (Object)TimeZoneUtil.getPresentDateTime((HttpServletRequest)null, null));
                jsonLog.put("STATUS", (Object)status);
                LogForwarderAPI.getInstance().sendMessage(jsonLog);
                j += 300;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

