/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.scheduler;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainUtil;
import com.adventnet.sym.adsm.common.server.admin.SchedulerHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ScheduleAutoEnrollHandler {
    public static final String SSP_ENROLLMENT_SCHEDULER = "SSPAutoEnrollmentScheduler";
    public static String taskClass = "com.adventnet.sym.adsm.common.server.taskengine.AutoEnrollment";

    public static Hashtable getSchedulerProps(Long scheduleId, Long loginId) {
        return (Hashtable)ScheduleAutoEnrollHandler.getSchedulersProps(scheduleId, loginId).get(0);
    }

    public static ArrayList getSchedulersProps(Long loginId) {
        return ScheduleAutoEnrollHandler.getSchedulersProps(null, loginId);
    }

    public static ArrayList getSchedulersProps(Long scheduleId, Long loginId) {
        ArrayList<Hashtable> schedulersProps = new ArrayList<Hashtable>();
        try {
            DataObject obj;
            Criteria crit = null;
            String[] tableList = new String[]{SSP_ENROLLMENT_SCHEDULER, "AaaLogin"};
            ArrayList<String> tableNames = new ArrayList<String>();
            tableNames.addAll(Arrays.asList(tableList));
            Criteria loginCrit = new Criteria(Column.getColumn((String)SSP_ENROLLMENT_SCHEDULER, (String)"LOGIN_ID"), (Object)loginId, 0);
            Criteria schCrit = new Criteria(Column.getColumn((String)SSP_ENROLLMENT_SCHEDULER, (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            if (loginId != null && !ADMPRoleHandler.isDefaultAdmin(loginId).booleanValue()) {
                crit = loginCrit;
            }
            if (scheduleId != null) {
                Criteria criteria = crit = crit != null ? crit.and(schCrit) : schCrit;
            }
            if (!(obj = CommonUtil.getPersistence(new boolean[0]).get(tableNames, crit)).isEmpty()) {
                Iterator iterator = obj.getRows(SSP_ENROLLMENT_SCHEDULER);
                while (iterator.hasNext()) {
                    Row r = (Row)iterator.next();
                    Long schId = (Long)r.get("SCHEDULE_ID");
                    Row row = obj.getRow("AaaLogin", new Criteria(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"), (Object)((Long)r.get("LOGIN_ID")), 0));
                    Hashtable props = new Hashtable();
                    props.put("SCHEDULE_ID", schId);
                    props.put("CREATED_TIME", (Long)r.get("CREATED_TIME"));
                    props.put("MODIFIED_TIME", (Long)r.get("MODIFIED_TIME"));
                    props.put("LOGIN_ID", (Long)r.get("LOGIN_ID"));
                    props.put("FILE_PATH", (String)r.get("FILE_PATH"));
                    props.put("IMPORT_COLUMNS", (Long)r.get("IMPORT_COLUMNS"));
                    props.put("OVERWRITE", (Boolean)r.get("OVERWRITE"));
                    props.put("QUESTION_ID", (Long)r.get("QUESTION_ID"));
                    props.put("FILE_ENCODING", (String)r.get("FILE_ENCODING"));
                    if (ADMPRoleHandler.isADSSPUser((Long)r.get("LOGIN_ID"))) {
                        props.put("TECHNICIAN_NAME", (String)row.get("NAME") + "(" + (String)row.get("DOMAINNAME") + ")");
                    } else {
                        props.put("TECHNICIAN_NAME", (String)row.get("NAME") + "(" + DomainUtil.getDomainData((String)row.get("DOMAINNAME"), "DOMAIN_DISPLAY_NAME") + ")");
                    }
                    SchedulerHandler.getInstance();
                    props = SchedulerHandler.getSchedulerProps(schId, props);
                    schedulersProps.add(props);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return schedulersProps;
    }

    public static void setSchedulerProps(HttpServletRequest request) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Hashtable<String, Object> scheduleProps = new Hashtable<String, Object>();
            ArrayList<Long> policyIds = new ArrayList<Long>();
            Long scheduleId = Long.parseLong(request.getParameter("SCHEDULE_ID"));
            Long createdTime = Long.parseLong(request.getParameter("CREATED_TIME"));
            SchedulerHandler.getInstance();
            Long taskId = SchedulerHandler.getTaskID(taskClass);
            String schType = request.getParameter("SCHEDULE_TYPE");
            if (!scheduleId.equals(0L)) {
                Criteria scheduleCrit = new Criteria(Column.getColumn((String)SSP_ENROLLMENT_SCHEDULER, (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                DataObject scheduleObj = CommonUtil.getPersistence(new boolean[0]).get(SSP_ENROLLMENT_SCHEDULER, scheduleCrit);
                if (!scheduleObj.isEmpty()) {
                    Row r = scheduleObj.getRow(SSP_ENROLLMENT_SCHEDULER);
                    loginId = (Long)r.get("LOGIN_ID");
                }
            }
            Long timeOfDay = Long.parseLong(request.getParameter(schType.equalsIgnoreCase("hourly") ? "HOURLY_TIME_OF_DAY" : "TIME_OF_DAY"));
            Long minOfHour = Long.parseLong(request.getParameter(schType.equalsIgnoreCase("hourly") ? "HOURLY_MINS_OF_HOUR" : "MINS_OF_HOUR"));
            String polId = request.getParameter("policyId");
            if (!polId.equals("")) {
                policyIds.add(Long.parseLong(polId));
            }
            scheduleProps.put("LOGIN_ID", loginId);
            scheduleProps.put("TASK_ID", taskId);
            scheduleProps.put("SCHEDULE_ID", scheduleId);
            scheduleProps.put("CREATED_TIME", scheduleId.equals(0) ? System.currentTimeMillis() : createdTime);
            scheduleProps.put("SCHEDULE_NAME", request.getParameter("SCHEDULE_NAME"));
            scheduleProps.put("DESCRIPTION", request.getParameter("DESCRIPTION"));
            scheduleProps.put("SCHEDULE_TYPE", schType);
            scheduleProps.put("DATE_OF_MONTH", Integer.parseInt(request.getParameter("DATE_OF_MONTH")));
            scheduleProps.put("DAY_OF_WEEK", Integer.parseInt(request.getParameter("DAY_OF_WEEK")));
            scheduleProps.put("TIME_OF_DAY", timeOfDay);
            scheduleProps.put("MINS_OF_HOUR", minOfHour);
            scheduleProps.put("ADMIN_STATUS", Integer.parseInt(request.getParameter("ADMIN_STATUS")));
            scheduleProps.put("FILE_PATH", request.getParameter("FILE_PATH"));
            scheduleProps.put("IMPORT_COLUMNS", request.getParameter("IMPORT_COLUMNS"));
            scheduleProps.put("OVERWRITE", request.getParameter("overWrite") == null ? 0 : 1);
            scheduleProps.put("QUESTION_ID", request.getParameter("questionId") == null ? "1" : request.getParameter("questionId"));
            scheduleProps.put("MAPPING_POLICIES", policyIds);
            scheduleProps.put("FILE_ENCODING", request.getParameter("fileEncoding"));
            Hashtable<String, Long> defTaskProps = new Hashtable<String, Long>();
            defTaskProps.put("TIME_OF_DAY", timeOfDay);
            defTaskProps.put("MINS_OF_HOUR", minOfHour);
            scheduleProps.put("DEFAULT_TASK_PROPS", defTaskProps);
            SchedulerHandler.getInstance();
            Object schId = SchedulerHandler.updateReportScheduler(scheduleProps, request, false);
            ScheduleAutoEnrollHandler.addReportsSchedulerTable(scheduleProps, obj, schId);
            CommonUtil.getPersistence(new boolean[0]).add(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean deleteScheduler(Long scheduleId, Long loginId) {
        boolean isDeleted = false;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)SSP_ENROLLMENT_SCHEDULER, (String)"LOGIN_ID"), (Object)loginId, 0);
            crit = crit.and(Column.getColumn((String)SSP_ENROLLMENT_SCHEDULER, (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(SSP_ENROLLMENT_SCHEDULER, crit);
            if (!obj.isEmpty()) {
                SchedulerHandler.getInstance();
                SchedulerHandler.deleteScheduler(scheduleId);
                isDeleted = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isDeleted;
    }

    public static void addReportsSchedulerTable(Hashtable props, DataObject obj, Object scheduleId) {
        try {
            Row r = new Row(SSP_ENROLLMENT_SCHEDULER);
            r.set("SCHEDULE_ID", scheduleId);
            r.set("CREATED_TIME", props.get("CREATED_TIME"));
            r.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
            r.set("LOGIN_ID", (Object)((Long)props.get("LOGIN_ID")));
            r.set("FILE_PATH", (Object)((String)props.get("FILE_PATH")));
            r.set("IMPORT_COLUMNS", (Object)((String)props.get("IMPORT_COLUMNS")));
            r.set("OVERWRITE", props.get("OVERWRITE"));
            r.set("QUESTION_ID", (Object)((String)props.get("QUESTION_ID")));
            r.set("FILE_ENCODING", (Object)((String)props.get("FILE_ENCODING")));
            obj.addRow(r);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

