/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.scheduler;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.SchedulerHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class ScheduleQAFetcher {
    public static String taskClass = "com.adventnet.sym.adsm.common.server.taskengine.SQAFetcher";

    public static Hashtable getSchedulerDetails(HttpServletRequest request) {
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        Long verId = Long.parseLong(request.getParameter("VERIFICATION_ID"));
        Long schedulerId = ScheduleQAFetcher.getSchedulerId(verId);
        if (schedulerId != null) {
            SchedulerHandler.fillSQASchedulerDetails(schedulerId, hash);
        } else {
            hash.put("NO_SCHEDULER_FOUND", "true");
            hash.put("ADMIN_STATUS", 4L);
            hash.put("SCHEDULE_TYPE", "daily");
            hash.put("TIME_OF_DAY", 0L);
            hash.put("MINS_OF_HOUR", 0L);
        }
        return hash;
    }

    public static Hashtable setSchedulerDetails(HttpServletRequest request) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        Long verId = Long.parseLong(request.getParameter("VERIFICATION_ID"));
        try {
            Hashtable<String, Object> hash = new Hashtable<String, Object>();
            Long schedulerId = ScheduleQAFetcher.getSchedulerId(verId);
            String isEnabled = request.getParameter("IS_ENABLED");
            Long adminStatus = isEnabled.equals("true") ? 3L : 4L;
            hash.put("ADMIN_STATUS", adminStatus);
            hash.put("SCHEDULE_NAME", "SQAFetcher_" + verId);
            hash.put("DESCRIPTION", "Scheduler to fetch Ques and Ans from DB");
            if (schedulerId != null) {
                SchedulerHandler.fillSchedulerProps(hash, request);
                SchedulerHandler.fillDefaultTaskInput(schedulerId, hash);
                Properties prop = SchedulerHandler.updateScheduler(hash);
            } else {
                Long taskId = SchedulerHandler.getTaskID(taskClass);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                SchedulerHandler.fillSchedulerProps(hash, request);
                Object schId = SchedulerHandler.addScheduler(hash, taskId);
                ScheduleQAFetcher.setSchedulerId(verId, schId);
            }
            props.put("status", "sucess");
            props.put("statusMsg", "adssp.configuration.quick_enrollment.sqa_fetcher.update_success");
            props.put("IS_ENABLED", isEnabled);
        }
        catch (Exception e) {
            e.printStackTrace();
            props.put("status", "sucess");
            props.put("statusMsg", "adssp.configuration.quick_enrollment.sqa_fetcher.update_success");
            props.put("IS_ENABLED", ScheduleQAFetcher.getSchedulerDetails(request).get("ADMIN_STATUS").equals(3L) ? "true" : "false");
        }
        return props;
    }

    public static Long getSchedulerId(Long verId) {
        Long scheduleId = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPSQAVerification", (String)"VERIFICATION_ID"), (Object)verId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSQAVerification", crit);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("SSPSQAVerification");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    scheduleId = (Long)r.get("SCHEDULE_ID");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scheduleId;
    }

    public static void setSchedulerId(Long verId, Object schId) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPSQAVerification", (String)"VERIFICATION_ID"), (Object)verId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSQAVerification", crit);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow("SSPSQAVerification");
                r.set("SCHEDULE_ID", schId);
                obj.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Integer getAdminStatus(Long verId) {
        Integer adminStatus = 4;
        try {
            Hashtable hash = new Hashtable();
            Long scheduleId = ScheduleQAFetcher.getSchedulerId(verId);
            Criteria crit = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("Task_Input", crit);
            if (!obj.isEmpty()) {
                Row row = obj.getFirstRow("Task_Input");
                adminStatus = (Integer)row.get("ADMIN_STATUS");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return adminStatus;
    }
}

