/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.scheduler;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SchedulerUtil {
    public static final Integer ADMIN_STATUS_ENABLE = 3;
    public static final Integer ADMIN_STATUS_DISABLE = 4;
    private static Logger logger = Logger.getLogger(SchedulerUtil.class.getName());

    public static DataObject getScheduleElements(Long categoryId, String tableName) {
        DataObject obj = null;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
            Criteria c = new Criteria(Column.getColumn((String)tableName, (String)"CATEGORY_ID"), (Object)categoryId, 0);
            sq.setCriteria(c);
            sq.addJoin(new Join(Table.getTable((String)tableName), Table.getTable((String)"ScheduleElement"), new String[]{"SCHEDULE_ELEMENT_ID"}, new String[]{"SCHEDULE_ELEMENT_ID"}, 1));
            sq.addJoin(new Join(Table.getTable((String)tableName), Table.getTable((String)"ScheduleElementAttr"), new String[]{"SCHEDULE_ELEMENT_ID"}, new String[]{"SCHEDULE_ELEMENT_ID"}, 1));
            sq.addJoin(new Join(Table.getTable((String)tableName), Table.getTable((String)"ScheduleSelectElementAttr"), new String[]{"SCHEDULE_ELEMENT_ID"}, new String[]{"SCHEDULE_ELEMENT_ID"}, 1));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"*"));
            sq.addSelectColumn(Column.getColumn((String)"ScheduleElement", (String)"*"));
            sq.addSelectColumn(Column.getColumn((String)"ScheduleElementAttr", (String)"*"));
            sq.addSelectColumn(Column.getColumn((String)"ScheduleSelectElementAttr", (String)"*"));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"ScheduleSelectElementAttr", (String)"PRIORITY_ID"), true));
            obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static Hashtable getDurationPeriod(String customDays) {
        Hashtable<String, Long> props = new Hashtable<String, Long>();
        try {
            long fromTime = 0L;
            long toTime = 0L;
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            if (customDays.equalsIgnoreCase("today")) {
                fromTime = cal.getTimeInMillis();
                SchedulerUtil.setActualMaximum(cal);
                toTime = cal.getTimeInMillis();
            } else if (customDays.equalsIgnoreCase("yesterday")) {
                cal.add(5, -1);
                fromTime = cal.getTimeInMillis();
                SchedulerUtil.setActualMaximum(cal);
                toTime = cal.getTimeInMillis();
            } else if (customDays.equalsIgnoreCase("Last_7_Days")) {
                cal.add(5, -7);
                fromTime = cal.getTimeInMillis();
                SchedulerUtil.setActualMaximum(cal);
                cal.add(5, 6);
                toTime = cal.getTimeInMillis();
            } else if (customDays.equalsIgnoreCase("Last_30_Days")) {
                cal.add(5, -30);
                fromTime = cal.getTimeInMillis();
                SchedulerUtil.setActualMaximum(cal);
                cal.add(5, 29);
                toTime = cal.getTimeInMillis();
            } else if (customDays.equalsIgnoreCase("thisWeek")) {
                cal.set(7, 1);
                fromTime = cal.getTimeInMillis();
                SchedulerUtil.setActualMaximum(cal);
                cal.set(7, cal.getActualMaximum(7));
                toTime = cal.getTimeInMillis();
            } else if (customDays.equalsIgnoreCase("lastWeek")) {
                cal.set(7, 1);
                cal.set(4, cal.get(4) - 1);
                fromTime = cal.getTimeInMillis();
                SchedulerUtil.setActualMaximum(cal);
                cal.set(7, 7);
                toTime = cal.getTimeInMillis();
            } else if (customDays.equalsIgnoreCase("lastMonth")) {
                cal.set(5, 1);
                cal.set(2, cal.get(2) - 1);
                fromTime = cal.getTimeInMillis();
                SchedulerUtil.setActualMaximum(cal);
                cal.set(5, cal.getActualMaximum(5));
                toTime = cal.getTimeInMillis();
            } else {
                cal.set(5, 1);
                fromTime = cal.getTimeInMillis();
                SchedulerUtil.setActualMaximum(cal);
                cal.set(5, cal.getActualMaximum(5));
                toTime = cal.getTimeInMillis();
            }
            logger.log(Level.INFO, "fromTime ::: " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(fromTime));
            logger.log(Level.INFO, "toTime ::: " + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(toTime));
            props.put("FROM_TIME", fromTime);
            props.put("TO_TIME", toTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return props;
    }

    private static void setActualMaximum(Calendar cal) {
        cal.set(11, cal.getActualMaximum(11));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(13, cal.getActualMaximum(13));
        cal.set(14, cal.getActualMaximum(14));
    }

    public static Hashtable getReportNames(ArrayList reportIds) {
        Hashtable<Integer, String> names = new Hashtable<Integer, String>();
        try {
            Integer[] ids = reportIds.toArray(new Integer[reportIds.size()]);
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMReports", (String)"REPORT_ID"), (Object)ids, 8);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMReports", criteria);
            if (!obj.isEmpty()) {
                Iterator iterator = obj.getRows("ADSMReports");
                while (iterator.hasNext()) {
                    Row r = (Row)iterator.next();
                    names.put((Integer)r.get("REPORT_ID"), (String)r.get("REPORT_NAME"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return names;
    }

    public static int getTaskInputAdminStatus(String schedulerName) {
        int status = -1;
        try {
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("Schedule");
            tableList.add("Scheduled_Task");
            tableList.add("Task_Input");
            Criteria c = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)schedulerName, 0);
            DataObject tasks = CommonUtil.getPersistence(new boolean[0]).get(tableList, c);
            if (!tasks.isEmpty() && tasks.size("Task_Input") == 1) {
                Row r = tasks.getRow("Task_Input");
                status = (Integer)r.get("ADMIN_STATUS");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static void setTaskInputAdminStatus(String schedulerName, int status) {
        try {
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("Schedule");
            tableList.add("Scheduled_Task");
            tableList.add("Task_Input");
            Criteria c = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)schedulerName, 0);
            DataObject tasks = CommonUtil.getPersistence(new boolean[0]).get(tableList, c);
            if (!tasks.isEmpty() && tasks.size("Task_Input") == 1) {
                Row r = tasks.getRow("Task_Input");
                r.set("ADMIN_STATUS", (Object)status);
                tasks.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(tasks);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

