/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.security;

import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.APCUtil;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PasswordGenerator {
    private static final char[] ALPHA_LOWER = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] ALPHA_UPPER = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final char[] NUMERIC = new char[]{'0', '1', '2', '3', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] SPL_CHARS = new char[]{'!', '@', '#', '$', '-', '+', '(', ')', '_', '[', ']', '|', '/', '&', '%'};
    private static final int NO_OF_UPPER_CASE_CHARS = 1;
    private static Logger logger = Logger.getLogger(PasswordGenerator.class.getName());
    private static Random random = null;

    static {
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            random = new SecureRandom();
        }
    }

    public static StringBuffer createPassword(int passLen, Row pwdProps, String userName) {
        StringBuffer password = new StringBuffer(passLen);
        try {
            int noOfNumerals = Integer.valueOf((String)pwdProps.get("NUMERAL_REQ"));
            int noOfSplChars = ((Long)pwdProps.get("NO_OF_SPL_CHARS")).intValue();
            int noOfUnicChars = Integer.valueOf((String)pwdProps.get("UNICODE_CHARS"));
            int alphaLength = passLen - noOfNumerals - noOfSplChars - noOfUnicChars;
            boolean startsWithAlpha = PasswordGenerator.isEnabled((String)pwdProps.get("START_WITH_ALPHA"));
            logger.log(Level.FINE, "noOfNumerals :: " + noOfNumerals + " ::: noOfSplChars ::" + noOfSplChars + " ::: alphaLength ::" + alphaLength + " :::  startsWithAlpha :: " + startsWithAlpha);
            int splCharsAdded = 0;
            int numeralsAdded = 0;
            int unicCharsAdded = 0;
            int lettersAdded = 0;
            boolean startLetter = false;
            int caseId = 0;
            while (passLen > 0) {
                caseId = startsWithAlpha && lettersAdded == 0 ? 2 : random.nextInt(4);
                switch (caseId) {
                    case 0: {
                        if (splCharsAdded >= noOfSplChars) break;
                        int splCharIdx = -1;
                        String excludedWords = (String)pwdProps.get("EXCLUDED_WORDS");
                        do {
                            splCharIdx = random.nextInt(SPL_CHARS.length);
                        } while (excludedWords != null && !excludedWords.equals("") && PasswordGenerator.isExcludedWord(String.valueOf(password.toString()) + SPL_CHARS[splCharIdx], excludedWords));
                        password.append(SPL_CHARS[splCharIdx]);
                        ++splCharsAdded;
                        --passLen;
                        break;
                    }
                    case 1: {
                        if (numeralsAdded >= noOfNumerals) break;
                        int numIdx = random.nextInt(NUMERIC.length);
                        String excludedWords = (String)pwdProps.get("EXCLUDED_WORDS");
                        do {
                            numIdx = random.nextInt(NUMERIC.length);
                        } while (excludedWords != null && !excludedWords.equals("") && PasswordGenerator.isExcludedWord(String.valueOf(password.toString()) + NUMERIC[numIdx], excludedWords));
                        password.append(NUMERIC[numIdx]);
                        ++numeralsAdded;
                        --passLen;
                        break;
                    }
                    case 2: {
                        if (lettersAdded >= alphaLength) break;
                        int alphaIdx = random.nextInt(ALPHA_LOWER.length);
                        while (!PasswordGenerator.isPolicySatisfied(String.valueOf(password.toString()) + ALPHA_LOWER[alphaIdx], pwdProps, alphaLength, userName)) {
                            alphaIdx = random.nextInt(ALPHA_LOWER.length);
                        }
                        password.append(ALPHA_LOWER[alphaIdx]);
                        startLetter = true;
                        ++lettersAdded;
                        --passLen;
                        break;
                    }
                    case 3: {
                        if (unicCharsAdded >= noOfUnicChars) break;
                        String unic = "?";
                        while (unic.equals("?")) {
                            unic = Character.toString((char)random.nextLong());
                        }
                        password.append(unic);
                        ++unicCharsAdded;
                        --passLen;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return password;
    }

    private static boolean isPolicySatisfied(String password, Row pwdProps, int wordLength, String userName) {
        block8: {
            block7: {
                block6: {
                    boolean preventRecurrence = PasswordGenerator.isEnabled((String)pwdProps.get("PREVENT_REPEATED_CHARS"));
                    if (wordLength <= 2 || !preventRecurrence || !PasswordGenerator.isRepeatedChar(password)) break block6;
                    logger.log(Level.FINE, "Random Password fails in isRepeatedChar check");
                    return false;
                }
                boolean preventUserName = PasswordGenerator.isEnabled((String)pwdProps.get("PREVENT_CHARS_FRM_NAME"));
                if (wordLength <= 3 || !preventUserName || !PasswordGenerator.isFromUserName(userName, password)) break block7;
                logger.log(Level.FINE, "Random Password fails in isFromUserName check");
                return false;
            }
            boolean isPalindromeSet = PasswordGenerator.isEnabled((String)pwdProps.get("PALINDROME_REQ"));
            if (!isPalindromeSet || !PasswordGenerator.isPalindrome(password)) break block8;
            logger.log(Level.FINE, "Random Password fails in isPalindrome check");
            return false;
        }
        try {
            String excludedWords = (String)pwdProps.get("EXCLUDED_WORDS");
            if (excludedWords != null && !excludedWords.equals("") && PasswordGenerator.isExcludedWord(password, excludedWords)) {
                logger.log(Level.FINE, "Random Password fails in isExcludedWord check");
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static String generatePassword(Long policyId, String userName) {
        Row pwdProp = APCUtil.getAppliedPwdPolicy(policyId);
        return PasswordGenerator.generatePassword(pwdProp, userName);
    }

    public static String generatePassword(Row pwdProp, String userName) {
        String genPassword = null;
        logger.log(Level.INFO, "generatePassword method Called");
        try {
            int passLen = 0;
            int minPassLen = ((Long)pwdProp.get("MIN_LEN")).intValue();
            int maxPassLen = ((Long)pwdProp.get("MAX_LEN")).intValue();
            if (maxPassLen < 0 || maxPassLen <= minPassLen) {
                passLen = minPassLen;
            } else {
                passLen = random.nextInt(maxPassLen + 1);
                while (passLen < minPassLen) {
                    passLen = random.nextInt(maxPassLen);
                }
            }
            int noOfNumerals = Integer.valueOf((String)pwdProp.get("NUMERAL_REQ"));
            int noOfSplChars = ((Long)pwdProp.get("NO_OF_SPL_CHARS")).intValue();
            if (passLen < noOfNumerals + noOfSplChars + 3) {
                passLen = noOfSplChars + noOfNumerals + 3;
            }
            int alphaLength = passLen - noOfNumerals - noOfSplChars;
            boolean startsWithAlpha = PasswordGenerator.isEnabled((String)pwdProp.get("START_WITH_ALPHA"));
            StringBuffer password = PasswordGenerator.createPassword(passLen, pwdProp, userName);
            genPassword = password.toString();
            boolean mixedCase = PasswordGenerator.isEnabled((String)pwdProp.get("MIXED_CASE"));
            int upperCaseCount = 1;
            upperCaseCount = upperCaseCount < alphaLength ? upperCaseCount : alphaLength - 1;
            logger.log(Level.FINE, "mixedCase :: " + mixedCase + " :: upperCaseCount :: " + upperCaseCount);
            if (mixedCase && upperCaseCount > 0) {
                genPassword = PasswordGenerator.updateUpperCase(genPassword, upperCaseCount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "generatePassword method Ends");
        return genPassword;
    }

    private static boolean isEnabled(String value) {
        return "1".equals(value);
    }

    public static String updateUpperCase(String pwd, int upperCaseCount) {
        String newPwd = null;
        int pwdLength = pwd.length();
        if (pwdLength == upperCaseCount) {
            newPwd = pwd.toUpperCase();
        } else {
            int charsUpdated = 0;
            while (charsUpdated < upperCaseCount) {
                int index;
                int ran = random.nextInt(2);
                if (ran != 0) continue;
                int wordIndex = random.nextInt(pwd.length());
                if (Character.isLetter(pwd.toCharArray()[wordIndex])) {
                    wordIndex = random.nextInt(pwd.length());
                }
                if ((index = new String(ALPHA_LOWER).indexOf(pwd.toCharArray()[wordIndex])) == -1) continue;
                char[] wordArr = pwd.toCharArray();
                wordArr[wordIndex] = ALPHA_UPPER[index];
                pwd = String.valueOf(wordArr);
                ++charsUpdated;
            }
            newPwd = pwd;
        }
        return newPwd;
    }

    public static boolean isFromUserName(String userName, String pwd) {
        Boolean rep = false;
        Boolean isMoreThan3CharsRep = false;
        String lowerPwd = pwd.toLowerCase();
        String uName = userName.toLowerCase();
        int excuteCount = 0;
        do {
            int i = 0;
            while (i < uName.length()) {
                String check;
                if (i + 3 <= uName.length() && lowerPwd.indexOf(check = uName.substring(i, i + 3)) != -1) {
                    rep = true;
                    if (i + 4 > uName.length() || lowerPwd.indexOf(check = uName.substring(i, i + 3)) == -1) break;
                    isMoreThan3CharsRep = true;
                    break;
                }
                ++i;
            }
            if (rep.booleanValue()) continue;
            uName = new StringBuffer(uName).reverse().toString();
        } while (!rep.booleanValue() && ++excuteCount <= 1);
        return rep;
    }

    public static boolean isRepeatedChar(String pwd) {
        Boolean same = false;
        int[] a = new int[pwd.length()];
        int i = 0;
        while (i < pwd.length()) {
            a[i] = String.valueOf(pwd.charAt(i)).hashCode();
            ++i;
        }
        i = 0;
        while (i < pwd.length()) {
            int j = 0;
            while (j < pwd.length()) {
                if (a[i] < a[j]) {
                    int temp = a[j];
                    a[j] = a[i];
                    a[i] = temp;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < pwd.length() - 2) {
            if (a[i] == a[i + 1] && a[i] == a[i + 2]) {
                same = true;
            }
            ++i;
        }
        return same;
    }

    public static boolean isPalindrome(String pwd) {
        String secHalf;
        boolean palindrome = false;
        String lowerPwd = pwd.toLowerCase();
        String firstHalf = lowerPwd.substring(0, pwd.length() / 2);
        if (firstHalf == (secHalf = new StringBuffer(lowerPwd.substring(Math.round(pwd.length() / 2), pwd.length())).reverse().toString())) {
            palindrome = true;
        }
        return palindrome;
    }

    public static boolean isExcludedWord(String pwd, String exWords) {
        String[] arr = exWords.split(",");
        int i = 0;
        while (i < arr.length) {
            if (pwd.indexOf(arr[i]) != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

