/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.QueryConstructor;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.selfservice.nonad.PasswordSyncConstants;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import com.manageengine.ads.fw.iamapps.handler.IAMAccountHandler;
import com.manageengine.ads.fw.iamapps.handler.IAMAppHandler;
import com.manageengine.ads.fw.iamapps.handler.sso.SSOSAMLHandler;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import sun.misc.BASE64Encoder;

public class LinkAccountsHandler
extends PasswordSyncConstants {
    private static Logger logger = Logger.getLogger(LinkAccountsHandler.class.getName());

    public static JSONArray getOtherUserAccounts(Long policyId) {
        return LinkAccountsHandler.getOtherUserAccounts(policyId, null);
    }

    public static JSONArray getOtherUserAccounts(Long policyId, JSONObject ssoWithSAMLFlag) {
        Criteria c = null;
        Criteria c1 = null;
        Criteria c2 = null;
        Criteria c3 = null;
        DataObject dataObject = null;
        DataObject dataObject1 = null;
        DataObject dataObject2 = null;
        DataObject dataObject3 = null;
        Iterator it = null;
        Iterator it1 = null;
        Iterator it2 = null;
        Row r = null;
        Row r1 = null;
        Row r2 = null;
        Row r3 = null;
        JSONArray hosts = new JSONArray();
        String hostName = "";
        try {
            String domainName = "";
            Criteria crit = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"), (Object)policyId, 0, false);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("PolicyConfiguration", crit);
            domainName = (String)obj.getFirstValue("PolicyConfiguration", "DOMAIN_NAME");
            int count = 0;
            c = new Criteria(Column.getColumn((String)"SSPPSPolicies", (String)"POLICY_ID"), (Object)policyId, 0);
            dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPPSPolicies", c);
            it = dataObject.getRows("SSPPSPolicies");
            while (it.hasNext()) {
                r = (Row)it.next();
                Long pSConfigId = (Long)r.get("APP_CONFIG_ID");
                c1 = new Criteria(Column.getColumn((String)"ADSIAMAppConfig", (String)"APP_CONFIG_ID"), (Object)pSConfigId, 0);
                dataObject1 = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMAppConfig", c1);
                it1 = dataObject1.getRows("ADSIAMAppConfig");
                c2 = new Criteria(Column.getColumn((String)"SSPPSConfPolicy", (String)"APP_CONFIG_ID"), (Object)pSConfigId, 0);
                dataObject2 = CommonUtil.getPersistence(new boolean[0]).get("SSPPSConfPolicy", c2);
                it2 = dataObject2.getRows("SSPPSConfPolicy");
                while (it1.hasNext()) {
                    r1 = (Row)it1.next();
                    r2 = (Row)it2.next();
                    if (!((Boolean)r1.get("IS_ENABLED")).booleanValue()) continue;
                    c3 = new Criteria(Column.getColumn((String)"ADSIAMAppConfigParams", (String)"APP_CONFIG_ID"), (Object)pSConfigId, 0);
                    c3 = c3.and(new Criteria(Column.getColumn((String)"ADSIAMAppConfigParams", (String)"PARAM_NAME"), (Object)"MODULES", 0));
                    dataObject3 = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMAppConfigParams", c3);
                    if (!dataObject3.isEmpty()) {
                        r3 = dataObject3.getFirstRow("ADSIAMAppConfigParams");
                    }
                    JSONObject host = new JSONObject();
                    host.put("APP_CONFIG_ID", r1.get("APP_CONFIG_ID"));
                    host.put("USER_NAME", r1.get("USER_NAME"));
                    host.put("AUTH_TOKEN", r1.get("AUTH_TOKEN"));
                    host.put("APP_ID", r1.get("APP_ID"));
                    host.put("ICON_STYLE", (Object)LinkAccountsHandler.getProviderAttribute((Long)r1.get("APP_ID"), "ICON_STYLE"));
                    host.put("SP_BIG_ICON", (Object)LinkAccountsHandler.getProviderAttribute((Long)r1.get("APP_ID"), "SP_BIG_ICON"));
                    host.put("APP_NAME", (Object)LinkAccountsHandler.getProviderAttribute((Long)r1.get("APP_ID"), "APP_NAME"));
                    host.put("PROVIDER_NAME", (Object)LinkAccountsHandler.getProviderName((Long)r1.get("APP_ID")));
                    hostName = (String)r1.get("HOST_NAME");
                    host.put("HOST_NAME", (Object)hostName);
                    hostName = (String)r1.get("HOST_DISPLAY_NAME");
                    host.put("HOST_DISPLAY_NAME", (Object)hostName);
                    host.put("DESCRIPTION", r1.get("DESCRIPTION"));
                    host.put("AUTO_LINK_USER", (Object)IAMAccountHandler.isAutoLinked((Long)((Long)r1.get("APP_CONFIG_ID"))));
                    String iamModules = r3 != null ? (String)r3.get("PARAM_VALUE") : "PASSWORD_SYNC,SSO";
                    host.put("IAM_MODULES", (Object)iamModules);
                    if (ssoWithSAMLFlag != null && iamModules.contains("SSO")) {
                        Row samlMatchRow;
                        Criteria samlCrit = new Criteria(Column.getColumn((String)"ADSIAMAppConfigParams", (String)"APP_CONFIG_ID"), (Object)pSConfigId, 0);
                        samlCrit = samlCrit.and(new Criteria(Column.getColumn((String)"ADSIAMAppConfigParams", (String)"PARAM_NAME"), (Object)"SAML_URL", 0));
                        DataObject samlMatchDO = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMAppConfigParams", samlCrit);
                        if (!samlMatchDO.isEmpty() && (samlMatchRow = samlMatchDO.getFirstRow("ADSIAMAppConfigParams")).get("PARAM_VALUE") != null) {
                            ssoWithSAMLFlag.put("SAML_URL_CONFIGURED", true);
                        }
                    }
                    hosts.put(count, (Object)host);
                    ++count;
                }
            }
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("ADSIAMAppConfig");
            tablesList.add("SSPPSConfPolicy");
            boolean[] isLeftJoins = new boolean[tablesList.size()];
            Arrays.fill(isLeftJoins, true);
            c1 = new Criteria(Column.getColumn((String)"SSPPSConfPolicy", (String)"ASSIGN_ALL_POLICIES"), (Object)false, 1);
            SelectQuery query = QueryConstructor.get(tablesList, (boolean[])isLeftJoins, (Criteria)c1);
            dataObject1 = CommonUtil.getPersistence(new boolean[0]).get(query);
            it1 = dataObject1.getRows("ADSIAMAppConfig");
            dataObject2 = CommonUtil.getPersistence(new boolean[0]).get(query);
            it2 = dataObject2.getRows("SSPPSConfPolicy");
            while (it1.hasNext()) {
                r1 = (Row)it1.next();
                r2 = (Row)it2.next();
                if (!((Boolean)r1.get("IS_ENABLED")).booleanValue()) continue;
                c3 = new Criteria(Column.getColumn((String)"ADSIAMAppConfigParams", (String)"APP_CONFIG_ID"), r1.get("APP_CONFIG_ID"), 0);
                c3 = c3.and(new Criteria(Column.getColumn((String)"ADSIAMAppConfigParams", (String)"PARAM_NAME"), (Object)"MODULES", 0));
                dataObject3 = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMAppConfigParams", c3);
                if (!dataObject3.isEmpty()) {
                    r3 = dataObject3.getFirstRow("ADSIAMAppConfigParams");
                }
                JSONObject host = new JSONObject();
                host.put("APP_CONFIG_ID", r1.get("APP_CONFIG_ID"));
                host.put("APP_ID", r1.get("APP_ID"));
                host.put("USER_NAME", r1.get("USER_NAME"));
                host.put("AUTH_TOKEN", r1.get("AUTH_TOKEN"));
                host.put("ICON_STYLE", (Object)LinkAccountsHandler.getProviderAttribute((Long)r1.get("APP_ID"), "ICON_STYLE"));
                host.put("SP_BIG_ICON", (Object)LinkAccountsHandler.getProviderAttribute((Long)r1.get("APP_ID"), "SP_BIG_ICON"));
                host.put("APP_NAME", (Object)LinkAccountsHandler.getProviderAttribute((Long)r1.get("APP_ID"), "APP_NAME"));
                host.put("PROVIDER_NAME", (Object)LinkAccountsHandler.getProviderName((Long)r1.get("APP_ID")));
                hostName = (String)r1.get("HOST_NAME");
                host.put("HOST_NAME", (Object)hostName);
                hostName = (String)r1.get("HOST_DISPLAY_NAME");
                host.put("HOST_DISPLAY_NAME", (Object)hostName);
                host.put("AUTO_LINK_USER", (Object)IAMAccountHandler.isAutoLinked((Long)((Long)r1.get("APP_CONFIG_ID"))));
                host.put("DESCRIPTION", r1.get("DESCRIPTION"));
                host.put("IAM_MODULES", r3 != null ? r3.get("PARAM_VALUE") : "PASSWORD_SYNC,SSO");
                String iamModules = r3 != null ? (String)r3.get("PARAM_VALUE") : "PASSWORD_SYNC,SSO";
                host.put("IAM_MODULES", (Object)iamModules);
                if (ssoWithSAMLFlag != null && iamModules.contains("SSO")) {
                    Row samlMatchRow2;
                    Criteria samlCrit2 = new Criteria(Column.getColumn((String)"ADSIAMAppConfigParams", (String)"APP_CONFIG_ID"), r1.get("APP_CONFIG_ID"), 0);
                    samlCrit2 = samlCrit2.and(new Criteria(Column.getColumn((String)"ADSIAMAppConfigParams", (String)"PARAM_NAME"), (Object)"SAML_URL", 0));
                    DataObject samlMatchDO2 = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMAppConfigParams", samlCrit2);
                    if (!samlMatchDO2.isEmpty() && (samlMatchRow2 = samlMatchDO2.getFirstRow("ADSIAMAppConfigParams")).get("PARAM_VALUE") != null) {
                        ssoWithSAMLFlag.put("SAML_URL_CONFIGURED", true);
                    }
                }
                if (String.valueOf(r1.get("APP_ID")).equalsIgnoreCase(String.valueOf(13)) && domainName.equalsIgnoreCase((String)r1.get("HOST_NAME"))) continue;
                hosts.put(count, (Object)host);
                ++count;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hosts;
    }

    public static String getProviderAttribute(Long providerId, String attribName) {
        String providerName = null;
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSIAMApplications", (String)"APP_ID"), (Object)providerId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMApplications", c);
            Row r = dataObject.getFirstRow("ADSIAMApplications");
            providerName = (String)r.get(attribName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return providerName;
    }

    public static JSONObject getHostDetails(long pSConfigId) {
        JSONObject host = new JSONObject();
        try {
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("ADSIAMAppConfig");
            tablesList.add("ADSIAMAppConfigParams");
            boolean[] isLeftJoins = new boolean[tablesList.size()];
            Arrays.fill(isLeftJoins, true);
            Criteria c = new Criteria(Column.getColumn((String)"ADSIAMAppConfig", (String)"APP_CONFIG_ID"), (Object)pSConfigId, 0);
            SelectQuery query = QueryConstructor.get(tablesList, (boolean[])isLeftJoins, (Criteria)c);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(query);
            if (!dataobject.isEmpty()) {
                Row r = dataobject.getFirstRow("ADSIAMAppConfig");
                host.put("ADMIN_PASSWORD", r.get("PASSWORD"));
                host.put("ADMIN_USER_NAME", r.get("USER_NAME"));
                host.put("AUTH_TOKEN", r.get("AUTH_TOKEN"));
                if (dataobject.containsTable("ADSIAMAppConfigParams")) {
                    Iterator params = dataobject.getRows("ADSIAMAppConfigParams");
                    while (params.hasNext()) {
                        r = (Row)params.next();
                        host.put((String)r.get("PARAM_NAME"), r.get("PARAM_VALUE"));
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return host;
    }

    public static String getSAMLDetails(Long policyId, Long appConfigId) {
        try {
            Criteria c1 = new Criteria(Column.getColumn((String)"SSPPSConfPolicy", (String)"ASSIGN_ALL_POLICIES"), (Object)true, 0);
            c1 = c1.and(new Criteria(Column.getColumn((String)"SSPPSConfPolicy", (String)"APP_CONFIG_ID"), (Object)appConfigId, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPPSConfPolicy", c1);
            boolean shudReturn = false;
            if (!dataObject.isEmpty()) {
                shudReturn = true;
            } else {
                c1 = new Criteria(Column.getColumn((String)"SSPPSPolicies", (String)"POLICY_ID"), (Object)policyId, 0);
                c1 = c1.and(new Criteria(Column.getColumn((String)"SSPPSPolicies", (String)"APP_CONFIG_ID"), (Object)appConfigId, 0));
                dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPPSPolicies", c1);
                if (!dataObject.isEmpty()) {
                    shudReturn = true;
                }
            }
            if (shudReturn) {
                c1 = new Criteria(Column.getColumn((String)"ADSIAMAppConfigParams", (String)"PARAM_NAME"), (Object)"SAML_URL", 0);
                c1 = c1.and(new Criteria(Column.getColumn((String)"ADSIAMAppConfigParams", (String)"APP_CONFIG_ID"), (Object)appConfigId, 0));
                dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMAppConfigParams", c1);
                if (!dataObject.isEmpty()) {
                    return dataObject.getFirstRow("ADSIAMAppConfigParams").get("PARAM_VALUE").toString();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void linkAccount(JSONObject accountDetails) throws Exception {
        try {
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            long pSConfigId = (Long)accountDetails.get("APP_CONFIG_ID");
            Row r = new Row("SSPPSLinkedAccounts");
            r.set("LOGIN_ID", accountDetails.get("LOGIN_ID"));
            r.set("APP_CONFIG_ID", (Object)pSConfigId);
            r.set("USER_NAME", accountDetails.get("USER_NAME"));
            dataobject.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).add(dataobject);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void unlinkAccount(long loginId, long pSConfigId) throws Exception {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPPSLinkedAccounts", (String)"APP_CONFIG_ID"), (Object)pSConfigId, 0);
            c = c.and(Column.getColumn((String)"SSPPSLinkedAccounts", (String)"LOGIN_ID"), (Object)loginId, 0);
            CommonUtil.getPersistence(new boolean[0]).delete(c);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static boolean isAccountLinked(long loginId, long pSConfigId) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPPSLinkedAccounts", (String)"APP_CONFIG_ID"), (Object)pSConfigId, 0);
            c = c.and(Column.getColumn((String)"SSPPSLinkedAccounts", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPPSLinkedAccounts", c);
            Iterator it = dataObject.getRows("SSPPSLinkedAccounts");
            if (it.hasNext()) {
                Row r = (Row)it.next();
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static String getProviderName(Long providerId) {
        String providerName = null;
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSIAMApplications", (String)"APP_ID"), (Object)providerId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMApplications", c);
            Row r = dataObject.getFirstRow("ADSIAMApplications");
            providerName = (String)r.get("DISPLAY_NAME");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return providerName;
    }

    public static String getProviderIcon(Long providerId) {
        String providerName = null;
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSIAMApplications", (String)"APP_ID"), (Object)providerId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMApplications", c);
            Row r = dataObject.getFirstRow("ADSIAMApplications");
            providerName = (String)r.get("ICON_STYLE");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return providerName;
    }

    public static Boolean isOTPEnabled(Long cId) {
        Boolean isOTPEnabled = false;
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSIAMAppConfigParams", (String)"APP_CONFIG_ID"), (Object)cId, 0);
            c = c.and(new Criteria(Column.getColumn((String)"ADSIAMAppConfigParams", (String)"PARAM_NAME"), (Object)"IS_OTP_ENABLED", 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMAppConfigParams", c);
            if (!dataObject.isEmpty()) {
                Row r = dataObject.getFirstRow("ADSIAMAppConfigParams");
                isOTPEnabled = Boolean.valueOf((String)r.get("PARAM_VALUE"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isOTPEnabled;
    }

    public static String getOtherAccountUserName(long loginId, long pSConfigId) {
        String username = null;
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPPSLinkedAccounts", (String)"APP_CONFIG_ID"), (Object)pSConfigId, 0);
            c = c.and(Column.getColumn((String)"SSPPSLinkedAccounts", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPPSLinkedAccounts", c);
            Row r = dataObject.getFirstRow("SSPPSLinkedAccounts");
            username = (String)r.get("USER_NAME");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return username;
    }

    public static JSONArray getLinkedAccounts(long policyId, String userName, long loginId, String operation) {
        JSONArray hosts = new JSONArray();
        try {
            JSONArray hostList = LinkAccountsHandler.getOtherUserAccounts(policyId);
            for (int cid = 0; cid < hostList.length(); ++cid) {
                JSONObject host = hostList.getJSONObject(cid);
                if (host.has("IAM_MODULES") && host.getString("IAM_MODULES").equals("SSO")) continue;
                long providerId = (Long)host.get("APP_ID");
                String providerName = LinkAccountsHandler.getProviderName(providerId);
                host.put("PROVIDER_NAME", (Object)providerName);
                if ((providerName.equals("adssp.config.admin_tools.pwd_sync.google") || providerName.equals("adssp.config.admin_tools.pwd_sync.office365") || providerName.equals("adssp.config.admin_tools.pwd_sync.sales_force_text") || providerName.equals("adssp.config.admin_tools.pwd_sync.zoho_text") || providerName.equals("adssp.config.admin_tools.pwd_sync.zendesk")) && operation.equals("unlock")) {
                    host.put("PROVIDER_NAME", (Object)providerName);
                    continue;
                }
                long pSConfigId = (Long)host.get("APP_CONFIG_ID");
                if (!LinkAccountsHandler.isAccountLinked(loginId, pSConfigId)) {
                    String u_name = LinkAccountsHandler.getOtherAccountUserName(loginId, pSConfigId);
                    host.put("USERNAME", (Object)u_name);
                    hosts.put((Object)host);
                    continue;
                }
                if (!host.get("AUTO_LINK_USER").equals("true")) continue;
                String autoLinkedUserName = LinkAccountsHandler.getMappedUserName(pSConfigId, loginId, userName);
                if (autoLinkedUserName != null) {
                    host.put("USERNAME", (Object)autoLinkedUserName);
                } else {
                    host.put("USERNAME", (Object)userName);
                }
                hosts.put((Object)host);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "linkedaccounts ... " + hosts);
        return hosts;
    }

    public static String getEmailSuffix(String hostName) {
        String emailSuffix = hostName;
        try {
            URL url = new URL(hostName);
            emailSuffix = url.getHost();
            if (emailSuffix.indexOf("www") != -1) {
                emailSuffix = emailSuffix.substring(emailSuffix.indexOf("www") + 4);
                logger.log(Level.INFO, "Email suffix obtained from HostName " + emailSuffix);
            }
        }
        catch (MalformedURLException malURL) {
            logger.log(Level.INFO, "HostName was not in URL format and hence appending it as it is.");
        }
        return emailSuffix;
    }

    public static String verifyCode(HttpServletRequest request, Long userCode, String domainName) {
        String status = "failure";
        try {
            HttpSession session = request.getSession();
            String appConfigId = request.getParameter("APP_CONFIG_ID");
            Long verifyCodeForEmail = Long.parseLong((String)session.getAttribute("LINKED_ACC_VERIFY_CODE" + appConfigId));
            String regEmail = (String)session.getAttribute("LINKED_ACC_VERIFY_EMAIL" + appConfigId);
            String emailSuffix = LinkAccountsHandler.getEmailSuffix(domainName);
            String userEmail = request.getParameter("username") + "@" + emailSuffix;
            status = !userEmail.equalsIgnoreCase(regEmail) ? "adssp.domainuser.selfservice.linkaccounts.code_not_found_expiry" : (!verifyCodeForEmail.equals(userCode) ? "adssp.domainuser.selfservice.linkaccounts.verify_code_invalid" : "success");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static ArrayList<Long> getAutoLinkedProviders() {
        try {
            ArrayList<Long> psConfigId = new ArrayList<Long>();
            Criteria c = new Criteria(Column.getColumn((String)"ADSIAMAppConfigParams", (String)"PARAM_NAME"), (Object)"AUTO_LINK_USER", 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMAppConfigParams", c);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows("ADSIAMAppConfigParams");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String paramValue = (String)r.get("PARAM_VALUE");
                    if (!paramValue.equals("true")) continue;
                    Long pSConfigId = (Long)r.get("APP_CONFIG_ID");
                    psConfigId.add(pSConfigId);
                }
            }
            return psConfigId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getMappedUserName(String configId, Long policyId, Long loginId, String sAMAccountName, String domainName) {
        String mappedUserName = "";
        Iterator it = null;
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSIAMAppConfig", (String)"APP_CONFIG_ID"), (Object)configId, 0);
            Criteria polCri = new Criteria(Column.getColumn((String)"SSPPSPolicies", (String)"POLICY_ID"), (Object)policyId, 0);
            polCri = polCri.or(new Criteria(Column.getColumn((String)"SSPPSConfPolicy", (String)"ASSIGN_ALL_POLICIES"), (Object)true, 0));
            c.and(polCri);
            ArrayList<String> tableList = new ArrayList<String>();
            tableList.add("ADSIAMAppConfig");
            tableList.add("ADSIAMAppConfigParams");
            tableList.add("SSPPSPolicies");
            tableList.add("SSPPSConfPolicy");
            boolean[] isLeftJoins = new boolean[tableList.size()];
            Arrays.fill(isLeftJoins, true);
            DataObject dO = CommonUtil.getPersistence(new boolean[0]).get(QueryConstructor.get(tableList, (boolean[])isLeftJoins, (Criteria)c));
            if (!dO.isEmpty()) {
                it = dO.getRows("ADSIAMAppConfig");
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    Long appConfigId = (Long)row.get("APP_CONFIG_ID");
                    long appId = (Long)row.get("APP_ID");
                    String hostName = (String)row.get("HOST_NAME");
                    JSONObject hostDetails = IAMAppHandler.getHostDetails((long)Long.parseLong(configId));
                    String autoLink = hostDetails.optString("AUTO_LINK_USER", "true");
                    String modules = hostDetails.getString("MODULES");
                    Boolean exludeHostName = (Boolean)IAMAppHandler.getAppProperty((Long)appId, (String)"EXCLUDE_HOSTNAME");
                    if (!autoLink.equalsIgnoreCase("true") || !modules.contains("SSO")) continue;
                    JSONObject attribDataModel = IAMAccountHandler.getMappedAttributes((Long)appConfigId);
                    JSONObject attribInfo = attribDataModel.getJSONObject("ATTRIBUTES_INFO");
                    JSONObject attribDetails = attribDataModel.getJSONObject("ATTRIBUTES");
                    String[] ADAttributes = new String[]{};
                    ArrayList<String> ADAttribs = new ArrayList<String>();
                    for (int i = 0; i < attribDetails.length(); ++i) {
                        String key = String.valueOf(i + 1);
                        String attrName = attribDetails.getString(key);
                        Boolean isCustomAttrib = attribInfo.getBoolean(attrName);
                        if (isCustomAttrib.booleanValue()) continue;
                        ADAttribs.add(attrName);
                    }
                    ADAttribs.add("sAMAccountName");
                    ADAttribs.toArray(ADAttributes);
                    logger.log(Level.INFO, "Mapped AD Attributes " + ADAttributes);
                    logger.log(Level.INFO, "Mapped AD Attributes " + ADAttribs);
                    logger.log(Level.INFO, "Mapped Attributes " + attribDetails);
                    JSONObject ADUserDetails = LinkAccountsHandler.getMappedADUserDetails(sAMAccountName, domainName, ADAttribs);
                    logger.log(Level.INFO, "AD User Details are " + ADUserDetails);
                    logger.log(Level.INFO, "Attribute Data Model - " + attribDataModel);
                    boolean isEmptyAttributes = true;
                    for (int i = 0; i < attribDetails.length(); ++i) {
                        String key = String.valueOf(i + 1);
                        String attrName = attribDetails.getString(key);
                        Boolean isCustomAttrib = attribInfo.getBoolean(attrName);
                        if (!isCustomAttrib.booleanValue()) {
                            if (ADUserDetails.has(attrName)) {
                                if (ADUserDetails.getString(attrName).length() != 0) {
                                    isEmptyAttributes = false;
                                }
                                mappedUserName = mappedUserName + ADUserDetails.getString(attrName);
                            }
                        } else {
                            mappedUserName = mappedUserName + attrName;
                        }
                        if (appId != 6L) continue;
                        if (attrName.equals("objectGUID")) {
                            mappedUserName = mappedUserName.substring(mappedUserName.indexOf("{") + 1, mappedUserName.indexOf("}"));
                            mappedUserName = new BASE64Encoder().encode(SSOSAMLHandler.asByteArray((UUID)UUID.fromString(mappedUserName)));
                            continue;
                        }
                        mappedUserName = new BASE64Encoder().encode(mappedUserName.getBytes());
                    }
                    if (isEmptyAttributes) {
                        logger.log(Level.INFO, "Empty attributes found so reverting to sAMAccountName");
                        mappedUserName = ADUserDetails.getString("sAMAccountName");
                    }
                    if (exludeHostName.booleanValue()) continue;
                    mappedUserName = mappedUserName.indexOf("@") == -1 ? mappedUserName + "@" + LinkAccountsHandler.getEmailSuffix(hostName) : mappedUserName;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mappedUserName;
    }

    public static String getMappedUserName(Long appConfigId, Long loginId, String sAMAccountName) {
        try {
            String isAutoLinked = IAMAccountHandler.isAutoLinked((Long)appConfigId);
            if (isAutoLinked.equalsIgnoreCase("true")) {
                JSONObject attribDataModel = IAMAccountHandler.getMappedAttributes((Long)appConfigId);
                JSONObject attribInfo = attribDataModel.getJSONObject("ATTRIBUTES_INFO");
                JSONObject attribDetails = attribDataModel.getJSONObject("ATTRIBUTES");
                String[] ADAttributes = new String[]{};
                ArrayList<String> ADAttribs = new ArrayList<String>();
                for (int i = 0; i < attribDetails.length(); ++i) {
                    String key = String.valueOf(i + 1);
                    String attrName = attribDetails.getString(key);
                    Boolean isCustomAttrib = attribInfo.getBoolean(attrName);
                    if (isCustomAttrib.booleanValue()) continue;
                    ADAttribs.add(attrName);
                }
                ADAttribs.add("sAMAccountName");
                ADAttribs.toArray(ADAttributes);
                logger.log(Level.INFO, "Mapped AD Attributes " + ADAttributes);
                logger.log(Level.INFO, "Mapped AD Attributes " + ADAttribs);
                logger.log(Level.INFO, "Mapped Attributes " + attribDetails);
                String domainName = DomainHandler.getDomainName(loginId);
                JSONObject ADUserDetails = LinkAccountsHandler.getMappedADUserDetails(sAMAccountName, domainName, ADAttribs);
                logger.log(Level.INFO, "AD User Details are " + ADUserDetails);
                logger.log(Level.INFO, "Attribute Data Model - " + attribDataModel);
                String mappedUserName = "";
                boolean isEmptyAttributes = true;
                for (int i = 0; i < attribDetails.length(); ++i) {
                    String key = String.valueOf(i + 1);
                    String attrName = attribDetails.getString(key);
                    Boolean isCustomAttrib = attribInfo.getBoolean(attrName);
                    if (!isCustomAttrib.booleanValue()) {
                        if (!ADUserDetails.has(attrName)) continue;
                        if (ADUserDetails.getString(attrName).length() != 0) {
                            isEmptyAttributes = false;
                        }
                        mappedUserName = mappedUserName + ADUserDetails.getString(attrName);
                        continue;
                    }
                    mappedUserName = mappedUserName + attrName;
                }
                if (isEmptyAttributes) {
                    logger.log(Level.INFO, "Empty attributes found so reverting to sAMAccountName");
                    return ADUserDetails.getString("sAMAccountName");
                }
                logger.log(Level.INFO, "Mapped User Name is " + mappedUserName);
                return mappedUserName;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static JSONObject getADUserDetails(String guid, String domainName, ArrayList<String> attribs) {
        try {
            JSONObject ADUserDetails = new JSONObject();
            guid = guid.substring(1, guid.length() - 1);
            logger.log(Level.INFO, "get from ad debug " + guid + " " + domainName);
            Properties prop = ADHandler.getObjectFromGUID(DomainHandler.getConfiguredValues(domainName, 1L, null), guid, attribs);
            for (int i = 0; i < attribs.size(); ++i) {
                String attrName = attribs.get(i);
                String value = null;
                ArrayList propValue = (ArrayList)prop.get(attrName);
                if (propValue != null && propValue.size() != 0) {
                    value = propValue.get(0).toString();
                }
                if (value == null) continue;
                ADUserDetails.put(attrName, value);
            }
            return ADUserDetails;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getAuthMode(Long appId) {
        String authModeFieldValue = "FormVerification";
        try {
            JSONObject classDet = IAMAppHandler.getClassLocationInJSON((long)appId, (String)"AUTHENTICATION");
            String authClassLoc = (String)classDet.get("CLASS_LOCATION");
            Class<?> authClass = Class.forName(authClassLoc);
            Object authClassObj = authClass.newInstance();
            Field authModeField = authClassObj.getClass().getDeclaredField("authMode");
            authModeFieldValue = (String)authModeField.get(authClassObj.getClass());
        }
        catch (Exception e) {
            logger.log(Level.INFO, "LinkAccountsHandler::getAuthMode No authMode found for this appId - " + appId);
        }
        return authModeFieldValue;
    }

    public static Object getIAMConfDetails(Long app_config_id, String colName) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPPSConfPolicy", (String)"APP_CONFIG_ID"), (Object)app_config_id, 0);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get("SSPPSConfPolicy", c);
            if (!dataobject.isEmpty()) {
                Row r = dataobject.getFirstRow("SSPPSConfPolicy");
                return r.get(colName);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error in getting conf props");
        }
        return null;
    }

    public static JSONArray getUserAttribDetails(String configId, Long loginId, String userName, String domainName) {
        try {
            JSONObject defaultADAttributeList = new JSONObject();
            defaultADAttributeList.put("sn", (Object)"last_name");
            defaultADAttributeList.put("givenName", (Object)"first_name");
            defaultADAttributeList.put("mail", (Object)"mail");
            JSONArray userAttribArray = new JSONArray();
            ArrayList<String> ADAttribList = new ArrayList<String>();
            JSONObject customADMapping = LinkAccountsHandler.getADAttributeList(configId);
            if (customADMapping == null) {
                ADAttribList.add("sn");
                ADAttribList.add("givenName");
                ADAttribList.add("mail");
            }
            if (customADMapping != null) {
                defaultADAttributeList = customADMapping;
                Iterator adIterator = customADMapping.keys();
                while (adIterator.hasNext()) {
                    String adColumnName = (String)adIterator.next();
                    ADAttribList.add(adColumnName);
                }
            }
            JSONObject userADDetails = LinkAccountsHandler.getMappedADUserDetails(userName, domainName, ADAttribList);
            JSONObject userAttribDetails = new JSONObject();
            Iterator itr1 = defaultADAttributeList.keys();
            while (itr1.hasNext()) {
                userAttribDetails = new JSONObject();
                String adKey = (String)itr1.next();
                userAttribDetails.put("ATTRIB_NAME", defaultADAttributeList.get(adKey));
                userAttribDetails.put("ATTRIB_VALUE", (Object)userADDetails.optString(adKey, ""));
                userAttribArray.put((Object)userAttribDetails);
            }
            return userAttribArray;
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error in getting AD Attribute Values");
            e.printStackTrace();
            return null;
        }
    }

    public static JSONObject getADAttributeList(String configId) {
        JSONObject customADList = null;
        long appId = IAMAppHandler.getAppIdForConfigId((long)Long.valueOf(configId));
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSIAMApplicationsProps", (String)"APP_ID"), (Object)appId, 0);
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMApplicationsProps", c);
            if (!dataobject.isEmpty()) {
                Row r = dataobject.getFirstRow("ADSIAMApplicationsProps");
                String custADList = (String)r.get("ATTRIB_REQ_SAML_RESPONSE");
                customADList = new JSONObject(custADList);
                return customADList;
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error in getting conf props");
        }
        return null;
    }

    public static JSONObject getMappedADUserDetails(String logonName, String domainName, ArrayList attributeList) {
        JSONObject ADUserDetails = new JSONObject();
        try {
            Properties properties = DomainHandler.getUnAuthenticatedDomainDetails(domainName, "DOMAIN_NAME");
            Properties userDetails = UserUtil.getObjValList(logonName, properties, attributeList);
            for (int i = 0; i < attributeList.size(); ++i) {
                String attrName = (String)attributeList.get(i);
                String value = null;
                ArrayList propValue = (ArrayList)userDetails.get(attrName);
                if (propValue != null && propValue.size() != 0) {
                    value = propValue.get(0).toString();
                }
                if (value == null) continue;
                ADUserDetails.put(attrName, value);
            }
            return ADUserDetails;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ADUserDetails;
        }
    }
}

