/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.common.ByteMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base32;
import org.json.JSONObject;

public class MobileAuthHandler {
    public static JSONObject getKey(HttpServletRequest request) {
        JSONObject jObject = new JSONObject();
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Locale locale = ResourceBundleMgr.getInstance().getClientLocale(1L, request);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String issuer = rb.getString("adssp.mobile.auth.issuer");
        try {
            byte[] buffer = new byte[10];
            new SecureRandom().nextBytes(buffer);
            String secret = new String(new Base32().encode(buffer));
            jObject.put("AUTH_SECRET_KEY", (Object)secret);
            Properties prop = ADAuthHandler.getLoginUserDetails(loginId);
            String loginName = prop.getProperty("LOGIN_NAME");
            String domainName = prop.getProperty("LOGIN_DOMAIN_NAME");
            prop = UserUtil.getUserData(domainName, loginName);
            String guid = prop.getProperty("objectGUID");
            Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            String secretkey = "otpauth://totp/" + issuer.trim() + ":" + loginName + "?secret=" + secret;
            QRCodeWriter QRWrite = new QRCodeWriter();
            ByteMatrix bm = QRWrite.encode(secretkey, BarcodeFormat.QR_CODE, 200, 200, hints);
            int width = bm.getWidth();
            int height = bm.getHeight();
            byte[][] array = bm.getArray();
            BufferedImage image = new BufferedImage(width, height, 1);
            BufferedImage finalImage = new BufferedImage(140, 140, 1);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int grayValue = array[y][x] & 0xFF;
                    image.setRGB(x, y, grayValue == 0 ? 0 : 0xFFFFFF);
                }
            }
            Graphics g = finalImage.getGraphics();
            g.drawImage(image, 0, 0, 140, 140, 30, 30, 170, 170, null);
            g.dispose();
            jObject.put("AUTH_QR_CODE", (Object)image);
            String path = System.getProperty("server.home") + "/webapps/adssp/images/QR/" + guid + ".jpg";
            File outputfile = new File(path);
            if (!outputfile.exists()) {
                outputfile.mkdirs();
            }
            ImageIO.write((RenderedImage)finalImage, "jpg", outputfile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return jObject;
    }

    private static long getCode(byte[] secret, long timeUnit) throws NoSuchAlgorithmException, InvalidKeyException {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(timeUnit);
        byte[] timeBytes = buffer.array();
        Mac hmac = Mac.getInstance("HmacSHA1");
        SecretKeySpec macKey = new SecretKeySpec(secret, "RAW");
        hmac.init(macKey);
        byte[] hash = hmac.doFinal(timeBytes);
        int offset = hash[hash.length - 1] & 0xF;
        long truncatedHash = hash[offset] & 0x7F;
        for (int i = 1; i < 4; ++i) {
            truncatedHash <<= 8;
            truncatedHash |= (long)(hash[offset + i] & 0xFF);
        }
        return truncatedHash %= 1000000L;
    }

    public static boolean verifyCode(String secret, long code, long time, int variance) throws Exception {
        long timeUnit = time / 1000L / 30L;
        byte[] secretBytes = new Base32().decode(secret);
        for (int i = -variance; i <= variance; ++i) {
            if (MobileAuthHandler.getCode(secretBytes, timeUnit + (long)i) != code) continue;
            return true;
        }
        return false;
    }

    public static String getRegisteredKey(Long loginId) {
        String tableName = "SSPMobileAuthenticator";
        try {
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject dobj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            if (!dobj.isEmpty()) {
                Row r = dobj.getFirstRow(tableName);
                return (String)r.get("SECRET_KEY");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

