/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.SelfServiceHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPADAuthenticator;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.configuration.PPEHandler;
import com.adventnet.sym.adsm.common.server.selfservice.nonad.PasswordSynchronizer;
import com.adventnet.sym.adsm.common.server.selfservice.nonad.adlds.ADLDSException;
import com.adventnet.sym.adsm.common.server.util.APCUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.GroupUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class MultiADDomainHandler
implements PasswordSynchronizer {
    private static Logger logger = Logger.getLogger(MultiADDomainHandler.class.getName());
    private JSONObject host = null;
    private JSONObject status = new JSONObject();
    private String user;
    public static final int AD_PROVIDER = 13;

    @Override
    public boolean authenticate(JSONObject details) throws Exception {
        JSONObject hash = DomainHandler.getDomainDetails(details.getString("HOST_NAME"));
        return hash.length() != 0;
    }

    @Override
    public void changePassword(JSONObject details) throws Exception {
        details.put("operation", (Object)"change");
        this.resetPassword(details);
    }

    public Hashtable isValidADUser(JSONObject details, String operation) throws Exception {
        ArrayList list;
        String targetName = details.getString("END_USER_NAME");
        String targetDomainName = details.getString("HOST_NAME");
        String serviceName = "SYSTEM";
        Properties userPro = UserUtil.getUserObjectDetails(targetName, targetDomainName, new String[]{"distinguishedName", "memberOf", "primaryGroupID", "objectSID", "objectGUID", "samAccountName"}, true);
        if (userPro == null || userPro.isEmpty()) {
            throw new Exception("adssp.error.native.nosuch_object_on_the_server");
        }
        Hashtable<String, Object> userDetails = new Hashtable<String, Object>();
        userDetails.put("USER_NAME", targetName);
        ArrayList userDNList = (ArrayList)userPro.get("distinguishedName");
        String sid = (String)((ArrayList)userPro.get("objectSID")).get(0);
        String objectGUID = (String)((ArrayList)userPro.get("objectGUID")).get(0);
        String userDN = "";
        if (userDNList != null) {
            userDN = ((String)userDNList.get(0)).toLowerCase();
        }
        ArrayList userGroups = (ArrayList)userPro.get("memberOf");
        String primaryGroup = GroupUtil.getPrimaryGroup(targetDomainName, (String)((ArrayList)userPro.get("primaryGroupID")).get(0));
        if (primaryGroup != null) {
            userGroups.add(primaryGroup);
        }
        Hashtable hash = PolicyHandler.checkUserPermission(targetDomainName, userDN, userGroups);
        Long policyId = -1L;
        if (((Boolean)hash.get("status")).booleanValue()) {
            policyId = (Long)hash.get("policyId");
            Hashtable polDetails = PolicyHandler.getDefaultDomainPolicy(policyId);
            Row policyConfig = (Row)polDetails.get("policyConfig");
            String operationString = "";
            operationString = operation.equalsIgnoreCase("reset") ? "RESET_PASSWORD" : "UNLOCK_ACCOUNT";
            Boolean isAllowed = Boolean.parseBoolean((String)policyConfig.get(operationString));
            if (!isAllowed.booleanValue()) {
                throw new Exception("adssp.reset_unlock.accounts.rp_ua.permission_denied_contact_admin");
            }
        } else {
            throw new Exception("adssp.reset_unlock.accounts.rp_ua.permission_denied_contact_admin");
        }
        if (PolicyHandler.isUserRestricted(objectGUID).booleanValue()) {
            throw new Exception("adssp.common.error.permission_denied_restrict");
        }
        if (SelfServiceHandler.isPSSLimitExceeded(targetName, targetDomainName, operation, policyId)) {
            if (operation.equalsIgnoreCase("reset")) {
                throw new Exception("adssp.common.error.reset_password_limit_exceed");
            }
            throw new Exception("adssp.common.error.unlock_account_limit_exceed");
        }
        Boolean isBlocked = false;
        DataObject accountDO = ADAuthHandler.getAccountDO(targetName, targetDomainName, serviceName);
        Long loginId = 0L;
        if (accountDO == null || accountDO.isEmpty()) {
            logger.log(Level.INFO, "Login id doesnt exists");
            try {
                loginId = ADMPUserHandler.addDomainUser(targetName, targetDomainName);
                accountDO = ADAuthHandler.getAccountDO(targetName, targetDomainName, serviceName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            loginId = ADMPUserHandler.getLoginId(targetName, targetDomainName);
        }
        if (!loginId.equals(0L) && (isBlocked = (Boolean)(list = APCUtil.isUserBlocked(policyId, loginId)).get(0)).booleanValue()) {
            throw new Exception("adssp.security.que.rp.ua.page.account.blocked");
        }
        userDetails.put("USER_DN", userDN);
        userDetails.put("USER_SID", sid);
        userDetails.put("DOMAIN_NAME", targetDomainName);
        userDetails.put("LOGIN_ID", loginId);
        userDetails.put("POLICY_ID", policyId);
        return userDetails;
    }

    @Override
    public void resetPassword(JSONObject details) throws Exception {
        Hashtable userDetails = new Hashtable();
        String statusMessage = "adssp.reset_unlock.accounts.reset_result.reset_pwd_success";
        String errorStatus = "success";
        String operation = "reset";
        try {
            String password = details.getString("NEW_PASSWORD");
            userDetails = this.isValidADUser(details, operation);
            userDetails.put("PASSWORD", password);
            String updateInAllDCs = "true";
            Long targetLoginId = (Long)userDetails.get("LOGIN_ID");
            SelfServiceHandler.resetPassword(1L, userDetails, updateInAllDCs, targetLoginId);
            logger.log(Level.INFO, "multi-domain sync reset done successfully");
        }
        catch (Exception le) {
            le.printStackTrace();
            statusMessage = le.getMessage();
            if (statusMessage == null) {
                statusMessage = "adssp.nonad.pwdsync.activedirectory.password_reset_failure";
                if (details.has("operation") && details.getString("operation").equals("change")) {
                    statusMessage = "adssp.nonad.pwdsync.activedirectory.password_change_failure";
                }
            }
            errorStatus = "error";
        }
        if (!errorStatus.equalsIgnoreCase("success")) {
            this.status.put("eSTATUS", (Object)statusMessage);
        } else {
            logger.log(Level.INFO, "Password Reset in Active Directory Server for the user: " + (String)details.get("END_USER_NAME") + " is done");
            this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.activedirectory.password_reset_success");
            if (details.has("operation") && details.getString("operation").equals("change")) {
                this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.activedirectory.password_change_success");
            }
            if ((Long)userDetails.get("LOGIN_ID") != 0L) {
                PPEHandler.updatePasswordHistory((Long)userDetails.get("LOGIN_ID"), (String)userDetails.get("PASSWORD"), (Long)userDetails.get("POLICY_ID"));
            }
        }
    }

    @Override
    public void unlockUser(JSONObject details) throws Exception {
        String statusMessage = "adssp.nonad.pwdsync.activedirectory.account_unlock_success";
        String errorStatus = "success";
        String operation = "unlock";
        try {
            Hashtable userDetails = this.isValidADUser(details, operation);
            String updateInAllDCs = "true";
            SelfServiceHandler.unlockUser(1L, updateInAllDCs, userDetails);
            logger.log(Level.INFO, "Account Unlock for the user: " + (String)details.get("END_USER_NAME") + " is done");
            this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.activedirectory.account_unlock_success");
        }
        catch (Exception e) {
            e.printStackTrace();
            statusMessage = e.getMessage();
            if (statusMessage == null) {
                statusMessage = "adssp.nonad.pwdsync.activedirectory.account_unlock_failure";
            }
            errorStatus = "error";
        }
        if (!errorStatus.equalsIgnoreCase("success")) {
            this.status.put("eSTATUS", (Object)statusMessage);
        } else {
            this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.activedirectory.account_unlock_success");
        }
    }

    @Override
    public JSONObject getStatus() {
        try {
            if (this.status.has("eSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("eSTATUS") + "_message"));
            } else if (this.status.has("sSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("sSTATUS") + "_message"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.status;
    }

    @Override
    public boolean connectAccount(JSONObject details) throws Exception {
        boolean result;
        String username = (String)details.get("USER_NAME");
        String password = (String)details.get("PASSWORD");
        String isSSLEnabled = ADSMPersUtil.checkLDAPSSL();
        Properties statusProp = ADHandler.DomainUserADAuth(null, details.getString("HOST_NAME"), username, password, isSSLEnabled);
        String auth = statusProp.getProperty("IsAuthenticated");
        String status = statusProp.getProperty("Status");
        if (status == null) {
            status = statusProp.getProperty("Bind_Error");
        }
        boolean bl = result = auth != null && !auth.equalsIgnoreCase("false");
        if (!result) {
            String statusMessage;
            String string = statusMessage = status == null ? "adssp.login.common.error.invalid_username" : ADMPADAuthenticator.getLoginStatusMsg(status);
            if (statusMessage.equalsIgnoreCase("adssp.login.common.error.invalid_login")) {
                statusMessage = "adssp.login.common.error.invalid_username";
            }
            throw new ADLDSException(statusMessage);
        }
        return true;
    }

    public static boolean deleteADHost(String domainName) throws DataAccessException {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSIAMAppConfig", (String)"APP_ID"), (Object)13, 0, false);
            c = c.and(new Criteria(Column.getColumn((String)"ADSIAMAppConfig", (String)"HOST_NAME"), (Object)domainName, 0, false));
            CommonUtil.getPersistence(new boolean[0]).delete(c);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

