/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice;

import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONObject;

public class SecureLinkHandler {
    private static String tableName = "SSPSecureLinkParams";
    public static final Logger LOGGER = Logger.getLogger(SecureLinkHandler.class.getName());

    public static void setSecureLinkParams(JSONObject data) {
        try {
            Row row = new Row(tableName);
            row.set("LOGIN_ID", data.get("LOGIN_ID"));
            row.set("KEY", data.get("KEY"));
            row.set("OPERATION", data.get("OPERATION"));
            String columnType = row.getColumnType("PARAMS");
            JSONObject j = (JSONObject)data.get("PARAMS");
            Object columnValue = MetaDataUtil.convert((String)j.toString(), (String)columnType);
            row.set("PARAMS", columnValue);
            row.set("EXPIRY", data.get("EXPIRY"));
            row.set("EXPIRY_TIME", data.get("EXPIRY_TIME"));
            Criteria c = new Criteria(Column.getColumn((String)tableName, (String)"LOGIN_ID"), data.get("LOGIN_ID"), 0);
            c = c.and(new Criteria(Column.getColumn((String)tableName, (String)"OPERATION"), data.get("OPERATION"), 0));
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get(tableName, c);
            if (!dataobject.isEmpty()) {
                dataobject.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataobject);
            } else {
                dataobject.addRow(row);
                CommonUtil.getPersistence(new boolean[0]).add(dataobject);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static JSONObject getSecureLinkParams(HttpServletRequest request) {
        JSONObject params = new JSONObject();
        try {
            Criteria c = new Criteria(Column.getColumn((String)tableName, (String)"KEY"), (Object)request.getParameter("Token"), 0);
            c = c.and(new Criteria(Column.getColumn((String)tableName, (String)"OPERATION"), (Object)request.getParameter("operation"), 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, c);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows(tableName);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    List columnNames = r.getColumns();
                    for (int i = 0; i < columnNames.size(); ++i) {
                        String columnName = (String)columnNames.get(i);
                        if (r.get(columnName) == null) continue;
                        params.put(columnName, (Object)r.get(columnName).toString());
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return params;
    }

    public static void clearSecureLink(DynaValidatorForm bean) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)tableName, (String)"LOGIN_ID"), bean.get("LOGIN_ID"), 0);
            c = c.and(new Criteria(Column.getColumn((String)tableName, (String)"OPERATION"), bean.get("OPERATION"), 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, c);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows(tableName);
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    dataObject.deleteRow(row);
                }
                CommonUtil.getPersistenceLite().update(dataObject);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Exception at clearSecureLink : ", ex);
        }
    }

    public static boolean isTokenExists(String token, String operation) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)tableName, (String)"KEY"), (Object)token, 0);
            c = c.and(new Criteria(Column.getColumn((String)tableName, (String)"OPERATION"), (Object)operation, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableName, c);
            if (!dataObject.isEmpty()) {
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }
}

