/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice.nonad;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.AuditAPI;
import com.adventnet.sym.adsm.common.server.configuration.PasswordSyncHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.selfservice.LinkAccountsHandler;
import com.adventnet.sym.adsm.common.server.selfservice.nonad.PasswordSyncConstants;
import com.adventnet.sym.adsm.common.server.selfservice.nonad.PasswordSyncListener;
import com.adventnet.sym.adsm.common.server.selfservice.nonad.PasswordSynchronizer;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class NonADHandler
extends PasswordSyncConstants {
    public static PasswordSynchronizer getPwdSyncInstance(long pId) throws Exception {
        String className = PasswordSyncHandler.getClassName(pId);
        return (PasswordSynchronizer)Class.forName(className).getConstructor(null).newInstance(null);
    }

    public static boolean authenticate(JSONObject host) throws Exception {
        PasswordSynchronizer pwdsync = NonADHandler.getPwdSyncInstance(Long.valueOf((String)host.get("APP_ID")));
        return pwdsync.authenticate(host);
    }

    public static JSONObject resetPassword(String tempUsername, long policyId, String password, long loginId) throws Exception {
        int i;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        JSONArray hostList = PasswordSyncHandler.getHostList(policyId);
        JSONObject hostDetails = PasswordSyncHandler.getHosts(hostList);
        JSONArray exacthostArray = new JSONArray();
        JSONObject status = new JSONObject();
        int exacthostList = 0;
        ArrayList<Long> autoLinkedAcc = LinkAccountsHandler.getAutoLinkedProviders();
        PasswordSyncListener[] pwdsync = new PasswordSyncListener[hostList.length()];
        for (i = 0; i < hostList.length(); ++i) {
            JSONObject host = (JSONObject)hostDetails.get(hostList.get(i).toString());
            if (host.has("MODULES") && host.getString("MODULES").equals("SSO")) continue;
            Boolean isAccLinked = LinkAccountsHandler.isAccountLinked(loginId, hostList.getInt(i));
            Long appId = (Long)host.get("APP_CONFIG_ID");
            if (!isAccLinked.booleanValue()) {
                String username = PasswordSyncHandler.getOtherAccountUserName(loginId, appId);
                host.put("END_USER_NAME", (Object)username);
                host.put("NEW_PASSWORD", (Object)password);
                pwdsync[exacthostList++] = new PasswordSyncListener(host, "resetPassword");
                exacthostArray.put((Object)((Long)hostList.get(i)));
                status.put(hostList.get(i).toString(), host.get("HOST_DISPLAY_NAME"));
                continue;
            }
            if (autoLinkedAcc == null || !autoLinkedAcc.contains(appId)) continue;
            String mappedUsername = tempUsername;
            String autoLinkedUserName = LinkAccountsHandler.getMappedUserName(appId, loginId, tempUsername);
            if (autoLinkedUserName != null) {
                mappedUsername = autoLinkedUserName;
            }
            host.put("END_USER_NAME", (Object)mappedUsername);
            host.put("NEW_PASSWORD", (Object)password);
            pwdsync[exacthostList++] = new PasswordSyncListener(host, "resetPassword");
            exacthostArray.put((Object)((Long)hostList.get(i)));
            status.put(hostList.get(i).toString(), host.get("HOST_DISPLAY_NAME"));
        }
        for (i = 0; i < hostList.length() && i < exacthostList; ++i) {
            pwdsync[i].doAction();
            String psid = exacthostArray.get(i).toString();
            long psConfigId = Long.parseLong(psid);
            long providerId = NonADHandler.getProviderId(psConfigId);
            String providerName = LinkAccountsHandler.getProviderName(providerId);
            String hostName = (String)status.remove(psid);
            hostName = hostName + "[" + rb.getString(providerName) + "]";
            status.put(hostName, (Object)pwdsync[i].getStatus());
        }
        return status;
    }

    public static JSONObject resetPassword(String tempUsername, String password, JSONArray hostList, long loginId) throws Exception {
        int i;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        JSONObject hostDetails = PasswordSyncHandler.getHosts(hostList);
        JSONObject status = new JSONObject();
        int exacthostList = 0;
        PasswordSyncListener[] pwdsync = new PasswordSyncListener[hostList.length()];
        for (i = 0; i < hostList.length(); ++i) {
            JSONObject host = (JSONObject)hostDetails.get(hostList.get(i).toString());
            Long appId = (Long)host.get("APP_CONFIG_ID");
            status.put(hostList.get(i).toString(), host.get("HOST_DISPLAY_NAME"));
            Boolean isAccLinked = LinkAccountsHandler.isAccountLinked(loginId, hostList.getInt(i));
            String mappedUsername = null;
            if (!isAccLinked.booleanValue()) {
                mappedUsername = PasswordSyncHandler.getOtherAccountUserName(loginId, appId);
            }
            if (mappedUsername == null) {
                String autoLinkedUserName = LinkAccountsHandler.getMappedUserName(appId, loginId, tempUsername);
                mappedUsername = autoLinkedUserName != null ? autoLinkedUserName : tempUsername;
            }
            host.put("END_USER_NAME", (Object)mappedUsername);
            host.put("NEW_PASSWORD", (Object)password);
            pwdsync[exacthostList++] = new PasswordSyncListener(host, "resetPassword");
        }
        for (i = 0; i < hostList.length() && i < exacthostList; ++i) {
            pwdsync[i].doAction();
            String psid = hostList.get(i).toString();
            long psConfigId = Long.parseLong(psid);
            long providerId = NonADHandler.getProviderId(psConfigId);
            String providerName = LinkAccountsHandler.getProviderName(providerId);
            String hostName = (String)status.remove(psid);
            hostName = hostName + "[" + rb.getString(providerName) + "]";
            status.put(hostName, (Object)pwdsync[i].getStatus());
        }
        return status;
    }

    public static JSONObject changePassword(long pId, String userName, String oldPassword, String newPassword, long loginId) throws Exception {
        int i;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        JSONArray hostList = PasswordSyncHandler.getHostList(pId);
        JSONObject hostDetails = PasswordSyncHandler.getHosts(hostList);
        JSONArray exacthostArray = new JSONArray();
        JSONObject status = new JSONObject();
        int exacthostList = 0;
        PasswordSyncListener[] pwdsync = new PasswordSyncListener[hostList.length()];
        ArrayList<Long> autoLinkedAcc = LinkAccountsHandler.getAutoLinkedProviders();
        for (i = 0; i < hostList.length(); ++i) {
            JSONObject host = (JSONObject)hostDetails.get(hostList.get(i).toString());
            if (host.has("MODULES") && host.getString("MODULES").equals("SSO")) continue;
            Boolean isAccLinked = LinkAccountsHandler.isAccountLinked(loginId, hostList.getInt(i));
            Long appId = (Long)host.get("APP_CONFIG_ID");
            if (!isAccLinked.booleanValue()) {
                String username = PasswordSyncHandler.getOtherAccountUserName(loginId, appId);
                host.put("END_USER_NAME", (Object)username);
                host.put("NEW_PASSWORD", (Object)newPassword);
                pwdsync[exacthostList++] = new PasswordSyncListener(host, "changePassword");
                exacthostArray.put((Object)((Long)hostList.get(i)));
                status.put(hostList.get(i).toString(), host.get("HOST_DISPLAY_NAME"));
                continue;
            }
            if (autoLinkedAcc == null || !autoLinkedAcc.contains(appId)) continue;
            String mappedUsername = userName;
            String autoLinkedUserName = LinkAccountsHandler.getMappedUserName(appId, loginId, userName);
            if (autoLinkedUserName != null) {
                mappedUsername = autoLinkedUserName;
            }
            host.put("END_USER_NAME", (Object)mappedUsername);
            host.put("NEW_PASSWORD", (Object)newPassword);
            pwdsync[exacthostList++] = new PasswordSyncListener(host, "changePassword");
            exacthostArray.put((Object)((Long)hostList.get(i)));
            status.put(hostList.get(i).toString(), host.get("HOST_DISPLAY_NAME"));
        }
        for (i = 0; i < hostList.length() && i < exacthostList; ++i) {
            pwdsync[i].doAction();
            String psid = exacthostArray.get(i).toString();
            long psConfigId = Long.parseLong(psid);
            long providerId = NonADHandler.getProviderId(psConfigId);
            String providerName = LinkAccountsHandler.getProviderName(providerId);
            String hostName = (String)status.remove(psid);
            hostName = hostName + "[" + rb.getString(providerName) + "]";
            status.put(hostName, (Object)pwdsync[i].getStatus());
        }
        return status;
    }

    public static JSONObject changePassword(String tempUsername, String oldPassword, String newPassword, JSONArray hostList, long loginId) throws Exception {
        int i;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        JSONObject hostDetails = PasswordSyncHandler.getHosts(hostList);
        JSONObject status = new JSONObject();
        JSONArray exacthostArray = new JSONArray();
        int exacthostList = 0;
        PasswordSyncListener[] pwdsync = new PasswordSyncListener[hostList.length()];
        ArrayList<Long> autoLinkedAcc = LinkAccountsHandler.getAutoLinkedProviders();
        for (i = 0; i < hostList.length(); ++i) {
            JSONObject host = (JSONObject)hostDetails.get(hostList.get(i).toString());
            Boolean isAccLinked = LinkAccountsHandler.isAccountLinked(loginId, hostList.getInt(i));
            Long appId = (Long)host.get("APP_CONFIG_ID");
            if (!isAccLinked.booleanValue()) {
                String username = PasswordSyncHandler.getOtherAccountUserName(loginId, appId);
                host.put("END_USER_NAME", (Object)username);
                host.put("NEW_PASSWORD", (Object)newPassword);
                pwdsync[exacthostList++] = new PasswordSyncListener(host, "changePassword");
                exacthostArray.put((Object)((Long)hostList.get(i)));
                status.put(hostList.get(i).toString(), host.get("HOST_DISPLAY_NAME"));
                continue;
            }
            if (autoLinkedAcc == null || !autoLinkedAcc.contains(appId)) continue;
            String mappedUsername = tempUsername;
            String autoLinkedUserName = LinkAccountsHandler.getMappedUserName(appId, loginId, tempUsername);
            if (autoLinkedUserName != null) {
                mappedUsername = autoLinkedUserName;
            }
            host.put("END_USER_NAME", (Object)mappedUsername);
            host.put("NEW_PASSWORD", (Object)newPassword);
            pwdsync[exacthostList++] = new PasswordSyncListener(host, "changePassword");
            exacthostArray.put((Object)((Long)hostList.get(i)));
            status.put(hostList.get(i).toString(), host.get("HOST_DISPLAY_NAME"));
        }
        for (i = 0; i < hostList.length() && i < exacthostList; ++i) {
            pwdsync[i].doAction();
            String psid = exacthostArray.get(i).toString();
            long psConfigId = Long.parseLong(psid);
            long providerId = NonADHandler.getProviderId(psConfigId);
            String providerName = LinkAccountsHandler.getProviderName(providerId);
            String hostName = (String)status.remove(psid);
            hostName = hostName + "[" + rb.getString(providerName) + "]";
            status.put(hostName, (Object)pwdsync[i].getStatus());
        }
        return status;
    }

    public static long getProviderId(Long psConfigId) {
        long providerId = 0L;
        try {
            Criteria c = new Criteria(Column.getColumn((String)"ADSIAMAppConfig", (String)"APP_CONFIG_ID"), (Object)psConfigId, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSIAMAppConfig", c);
            Row r = dataObject.getFirstRow("ADSIAMAppConfig");
            providerId = (Long)r.get("APP_ID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return providerId;
    }

    public static JSONObject unlockUser(long pId, String userName) throws Exception {
        int i;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        JSONArray hostList = PasswordSyncHandler.getHostList(pId);
        JSONObject hostDetails = PasswordSyncHandler.getHosts(hostList);
        JSONObject status = new JSONObject();
        PasswordSyncListener[] pwdsync = new PasswordSyncListener[hostList.length()];
        for (i = 0; i < hostList.length(); ++i) {
            JSONObject host = (JSONObject)hostDetails.get(hostList.get(i).toString());
            status.put(hostList.get(i).toString(), host.get("HOST_DISPLAY_NAME"));
            host.put("END_USER_NAME", (Object)userName);
            pwdsync[i] = new PasswordSyncListener(host, "unlockUser");
        }
        for (i = 0; i < hostList.length(); ++i) {
            pwdsync[i].doAction();
            String psid = hostList.get(i).toString();
            long psConfigId = Long.parseLong(psid);
            long providerId = NonADHandler.getProviderId(psConfigId);
            String providerName = LinkAccountsHandler.getProviderName(providerId);
            String hostName = (String)status.remove(psid);
            hostName = hostName + "[" + rb.getString(providerName) + "]";
            status.put(hostName, (Object)pwdsync[i].getStatus());
        }
        return status;
    }

    public static JSONObject unlockUser(String tempUsername, long policyId, long loginId) throws Exception {
        int i;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        JSONArray hostList = PasswordSyncHandler.getHostList(policyId);
        JSONObject hostDetails = PasswordSyncHandler.getHosts(hostList);
        JSONObject status = new JSONObject();
        JSONArray linkedHostList = new JSONArray();
        int linkedHostCount = 0;
        PasswordSyncListener[] pwdsync = new PasswordSyncListener[hostList.length()];
        ArrayList<Long> autoLinkedAcc = LinkAccountsHandler.getAutoLinkedProviders();
        for (i = 0; i < hostList.length(); ++i) {
            JSONObject host = (JSONObject)hostDetails.get(hostList.get(i).toString());
            String providerName = (String)host.get("DISPLAY_NAME");
            if (providerName.equals("adssp.config.admin_tools.pwd_sync.google") || providerName.equals("adssp.config.admin_tools.pwd_sync.office365") || providerName.equals("adssp.config.admin_tools.pwd_sync.sales_force_text") || providerName.equals("adssp.config.admin_tools.pwd_sync.zoho_text") || providerName.equals("adssp.config.admin_tools.pwd_sync.zendesk") || host.has("MODULES") && host.getString("MODULES").equals("SSO")) continue;
            String username = null;
            Boolean isAccLinked = LinkAccountsHandler.isAccountLinked(loginId, hostList.getInt(i));
            Long appId = (Long)host.get("APP_CONFIG_ID");
            if (!isAccLinked.booleanValue()) {
                username = PasswordSyncHandler.getOtherAccountUserName(loginId, appId);
            } else if (autoLinkedAcc != null && autoLinkedAcc.contains(appId)) {
                String autoLinkedUserName = LinkAccountsHandler.getMappedUserName(appId, loginId, tempUsername);
                username = autoLinkedUserName != null ? autoLinkedUserName : tempUsername;
            }
            if (username == null) continue;
            String hostId = hostList.get(i).toString();
            linkedHostList.put((Object)hostId);
            host.put("END_USER_NAME", (Object)username);
            status.put(hostId, host.get("HOST_NAME"));
            pwdsync[linkedHostCount++] = new PasswordSyncListener(host, "unlockUser");
        }
        for (i = 0; i < linkedHostCount; ++i) {
            pwdsync[i].doAction();
            String psid = linkedHostList.get(i).toString();
            long psConfigId = Long.parseLong(psid);
            long providerId = NonADHandler.getProviderId(psConfigId);
            String providerName = LinkAccountsHandler.getProviderName(providerId);
            String hostName = (String)status.remove(psid);
            hostName = hostName + "[" + rb.getString(providerName) + "]";
            status.put(hostName, (Object)pwdsync[i].getStatus());
        }
        return status;
    }

    public static JSONObject unlockUser(String tempUsername, JSONArray hostList, long loginId) throws Exception {
        int i;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        JSONObject hostDetails = PasswordSyncHandler.getHosts(hostList);
        JSONObject status = new JSONObject();
        PasswordSyncListener[] pwdsync = new PasswordSyncListener[hostList.length()];
        ArrayList<Long> autoLinkedAcc = LinkAccountsHandler.getAutoLinkedProviders();
        for (i = 0; i < hostList.length(); ++i) {
            String autoLinkedUserName;
            JSONObject host = (JSONObject)hostDetails.get(hostList.get(i).toString());
            status.put(hostList.get(i).toString(), host.get("HOST_DISPLAY_NAME"));
            Boolean isAccLinked = LinkAccountsHandler.isAccountLinked(loginId, hostList.getInt(i));
            Long appId = (Long)host.get("APP_CONFIG_ID");
            String username = null;
            if (!isAccLinked.booleanValue()) {
                username = PasswordSyncHandler.getOtherAccountUserName(loginId, appId);
            } else if (autoLinkedAcc != null && autoLinkedAcc.contains(appId) && (autoLinkedUserName = LinkAccountsHandler.getMappedUserName(appId, loginId, tempUsername)) != null) {
                username = autoLinkedUserName;
            }
            if (username == null) {
                username = tempUsername;
            }
            host.put("END_USER_NAME", (Object)username);
            pwdsync[i] = new PasswordSyncListener(host, "unlockUser");
        }
        for (i = 0; i < hostList.length(); ++i) {
            pwdsync[i].doAction();
            String psid = hostList.get(i).toString();
            long psConfigId = Long.parseLong(psid);
            long providerId = NonADHandler.getProviderId(psConfigId);
            String providerName = LinkAccountsHandler.getProviderName(providerId);
            String hostName = (String)status.remove(psid);
            hostName = hostName + "[" + rb.getString(providerName) + "]";
            status.put(hostName, (Object)pwdsync[i].getStatus());
        }
        return status;
    }

    public static void addAudit(Long loginId, Long userId, String action, JSONObject nonADStatus, HttpServletRequest request) throws Exception {
        String host = request.getRemoteHost();
        String ip = CommonUtil.getIPAddress(request);
        String accessMode = ReportsUtil.getSSPAccessMode(request);
        NonADHandler.addAudit(loginId, userId, action, host, ip, accessMode, nonADStatus);
    }

    public static void addAudit(Long loginId, Long userId, String action, String host, String ip, String accessMode, JSONObject nonADStatus) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        if (nonADStatus != null && nonADStatus.length() > 0) {
            Iterator it = nonADStatus.keys();
            while (it.hasNext()) {
                String msg;
                String cId = it.next().toString();
                JSONObject pwdSyncStatus = nonADStatus.getJSONObject(cId);
                Integer syncStatus = 0;
                if (pwdSyncStatus.has("sSTATUS")) {
                    syncStatus = 1;
                    msg = (String)pwdSyncStatus.get("sSTATUS");
                } else {
                    if (!pwdSyncStatus.has("eSTATUS")) continue;
                    msg = (String)pwdSyncStatus.get("eSTATUS");
                }
                cId = NonADHandler.htmlEscape(cId);
                AuditAPI.getInstance().addAuditLog(loginId, userId, action, System.currentTimeMillis(), host, ip, new Hashtable(), syncStatus, cId + " - " + rb.getString(msg), accessMode);
            }
        }
    }

    public static boolean connectAccount(JSONObject host) throws Exception {
        PasswordSynchronizer pwdsync = NonADHandler.getPwdSyncInstance(Long.valueOf((String)host.get("APP_ID")));
        return pwdsync.connectAccount(host);
    }

    public static String htmlEscape(String str) {
        if (str != null) {
            String[] keys = new String[]{"&", ">", "<", "\""};
            String[] vals = new String[]{"&amp;", "&gt;", "&lt;", "&quot;"};
            for (int i = 0; i < keys.length; ++i) {
                String s = keys[i];
                if (!str.contains(s)) continue;
                str = str.replaceAll(s, vals[i]);
            }
        }
        return str;
    }
}

