/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice.nonad.adlds;

import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.selfservice.nonad.PasswordSynchronizer;
import com.adventnet.sym.adsm.common.server.selfservice.nonad.adlds.ADLDSException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.json.JSONObject;

public class ADLDSHandler
implements PasswordSynchronizer {
    private static Logger logger = Logger.getLogger(ADLDSHandler.class.getName());
    private final String iNITCTX = "com.sun.jndi.ldap.LdapCtxFactory";
    private JSONObject host = null;
    private JSONObject status = new JSONObject();
    private String user;
    private String objectClass;

    public native String domainAuthenticate(String var1, String var2, String var3, String var4, String var5, String var6, boolean var7);

    public static native JSONObject getUserAccount(String var0, String var1, String var2, String var3, String var4, String var5, String var6, boolean var7);

    public native String resetPassword(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, JSONObject var9);

    public native String changePassword(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, JSONObject var9);

    public native String unlockUserAccount(String var1, String var2, String var3, String var4, String var5, String var6, String var7, JSONObject var8);

    public native String userAuthenticate(String var1, String var2, String var3, String var4, String var5);

    public static boolean isValidDN(String name) {
        try {
            LdapName dn = new LdapName(name);
        }
        catch (InvalidNameException e) {
            logger.log(Level.INFO, name + " is not valid DN");
            return false;
        }
        return true;
    }

    private String getConnection() throws Exception {
        boolean isDN = ADLDSHandler.isValidDN((String)this.host.get("USER_NAME"));
        return this.domainAuthenticate((String)this.host.get("HOST_NAME"), (String)this.host.get("USER_NAME"), (String)this.host.get("PASSWORD"), (String)this.host.get("FQ_DOMAIN_NAME"), (String)this.host.get("LDAP_PORT"), (String)this.host.get("SSL_PORT"), isDN);
    }

    private void openConnection(JSONObject host) throws Exception {
        this.host = host;
        String err = this.getConnection();
        if (!err.equals("0")) {
            String errorCode = NativeError.findNonADNativeError(err, "adssp.native.error.adlds");
            if (err.equals(errorCode)) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.adlds.host_error");
            } else {
                this.status.put("eSTATUS", (Object)errorCode);
            }
            throw new ADLDSException((String)this.status.get("eSTATUS"));
        }
    }

    private void closeConnection() {
        logger.log(Level.INFO, "AD LDS connection closed.");
    }

    private boolean loadUserInformation(String username) throws Exception {
        this.user = null;
        this.objectClass = null;
        boolean isDN = ADLDSHandler.isValidDN((String)this.host.get("USER_NAME"));
        JSONObject obj = ADLDSHandler.getUserAccount((String)this.host.get("HOST_NAME"), (String)this.host.get("USER_NAME"), (String)this.host.get("PASSWORD"), (String)this.host.get("FQ_DOMAIN_NAME"), (String)this.host.get("LDAP_PORT"), (String)this.host.get("SSL_PORT"), username, isDN);
        if (obj.has("distinguishedName")) {
            this.user = obj.getString("distinguishedName");
            this.objectClass = obj.getString("objectClass");
            return true;
        }
        this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.adlds.user_not_found");
        throw new ADLDSException((String)this.status.get("eSTATUS"));
    }

    private JSONObject getHostInfo(JSONObject details) throws Exception {
        this.host = new JSONObject();
        this.host.put("HOST_NAME", (Object)((String)details.get("HOST_NAME")));
        this.host.put("USER_NAME", (Object)((String)details.get("USER_NAME")));
        this.host.put("PASSWORD", (Object)((String)details.get("PASSWORD")));
        if (details.has("PARAMS")) {
            JSONObject parameter = details.getJSONObject("PARAMS");
            Iterator it = parameter.keys();
            while (it.hasNext()) {
                String pName = it.next().toString();
                this.host.put(pName, (Object)((String)parameter.get(pName)));
            }
        } else {
            this.host.put("FQ_DOMAIN_NAME", (Object)((String)details.get("FQ_DOMAIN_NAME")));
            this.host.put("LDAP_PORT", (Object)((String)details.get("LDAP_PORT")));
            this.host.put("SSL_PORT", (Object)((String)details.get("SSL_PORT")));
        }
        return this.host;
    }

    @Override
    public boolean authenticate(JSONObject details) throws Exception {
        this.openConnection(this.getHostInfo(details));
        return true;
    }

    @Override
    public void resetPassword(JSONObject details) throws Exception {
        this.openConnection(details);
        if (this.loadUserInformation((String)details.get("END_USER_NAME"))) {
            details.put("END_USER_DN", (Object)this.user);
        }
        boolean isDN = ADLDSHandler.isValidDN((String)this.host.get("USER_NAME"));
        JSONObject props = new JSONObject();
        props.put("objectClass", (Object)this.objectClass);
        props.put("isDN", isDN);
        String err = this.resetPassword((String)this.host.get("HOST_NAME"), (String)this.host.get("USER_NAME"), (String)this.host.get("PASSWORD"), (String)this.host.get("FQ_DOMAIN_NAME"), (String)this.host.get("LDAP_PORT"), (String)this.host.get("SSL_PORT"), (String)details.get("END_USER_DN"), (String)this.host.get("NEW_PASSWORD"), props);
        if (!err.equals("0")) {
            String errorCode = NativeError.findNonADNativeError(err, "adssp.native.error.adlds");
            if (err.equals(errorCode)) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.adlds.password_reset_failure");
            } else {
                this.status.put("eSTATUS", (Object)errorCode);
            }
        } else {
            logger.log(Level.INFO, "Password Reset in AD LDS Server for the user: " + (String)details.get("END_USER_NAME") + " is done");
            this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.adlds.password_reset_success");
        }
    }

    @Override
    public void changePassword(JSONObject details) throws Exception {
        this.openConnection(details);
        if (this.loadUserInformation((String)details.get("END_USER_NAME"))) {
            details.put("END_USER_DN", (Object)this.user);
        }
        boolean isDN = ADLDSHandler.isValidDN((String)this.host.get("USER_NAME"));
        JSONObject props = new JSONObject();
        props.put("objectClass", (Object)this.objectClass);
        props.put("isDN", isDN);
        String err = this.changePassword((String)this.host.get("HOST_NAME"), (String)this.host.get("USER_NAME"), (String)this.host.get("PASSWORD"), (String)this.host.get("FQ_DOMAIN_NAME"), (String)this.host.get("LDAP_PORT"), (String)this.host.get("SSL_PORT"), (String)details.get("END_USER_DN"), (String)this.host.get("NEW_PASSWORD"), props);
        if (!err.equals("0")) {
            String errorCode = NativeError.findNonADNativeError(err, "adssp.native.error.adlds");
            if (err.equals(errorCode)) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.adlds.password_reset_failure");
            } else {
                this.status.put("eSTATUS", (Object)errorCode);
            }
        } else {
            logger.log(Level.INFO, "Password Change in AD LDS Server for the user: " + (String)details.get("END_USER_NAME") + " is done");
            this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.adlds.password_change_success");
        }
    }

    @Override
    public void unlockUser(JSONObject details) throws Exception {
        this.openConnection(details);
        if (this.loadUserInformation((String)details.get("END_USER_NAME"))) {
            details.put("END_USER_DN", (Object)this.user);
        }
        boolean isDN = ADLDSHandler.isValidDN((String)this.host.get("USER_NAME"));
        JSONObject props = new JSONObject();
        props.put("objectClass", (Object)this.objectClass);
        props.put("isDN", isDN);
        String err = this.unlockUserAccount((String)this.host.get("HOST_NAME"), (String)this.host.get("USER_NAME"), (String)this.host.get("PASSWORD"), (String)this.host.get("FQ_DOMAIN_NAME"), (String)this.host.get("LDAP_PORT"), (String)this.host.get("SSL_PORT"), (String)details.get("END_USER_DN"), props);
        if (!err.equals("0")) {
            String errorCode = NativeError.findNonADNativeError(err, "adssp.native.error.adlds");
            logger.log(Level.INFO, "Account Unlock failed " + errorCode);
            if (err.equals(errorCode)) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.adlds.account_unlock_failure");
            } else {
                this.status.put("eSTATUS", (Object)errorCode);
            }
        } else {
            logger.log(Level.INFO, "Account Unlock in AD LDS system for the user: " + (String)details.get("END_USER_NAME") + " is done");
            this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.adlds.account_unlock_success");
        }
    }

    @Override
    public JSONObject getStatus() {
        try {
            if (this.status.has("eSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("eSTATUS") + "_message"));
            } else if (this.status.has("sSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("sSTATUS") + "_message"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.status;
    }

    @Override
    public boolean connectAccount(JSONObject details) throws Exception {
        String username = (String)details.get("USER_NAME");
        String password = (String)details.get("PASSWORD");
        details.put("USER_NAME", (Object)((String)details.get("ADMIN_USER_NAME")));
        details.put("PASSWORD", (Object)((String)details.get("ADMIN_PASSWORD")));
        this.openConnection(details);
        if (this.loadUserInformation(username)) {
            details.put("USER_DN", (Object)this.user);
            details.put("USER_NAME", (Object)username);
            details.put("PASSWORD", (Object)password);
            String err = this.userAuthenticate((String)this.host.get("HOST_NAME"), (String)this.host.get("LDAP_PORT"), (String)this.host.get("SSL_PORT"), (String)details.get("USER_DN"), (String)details.get("PASSWORD"));
            if (!err.equals("0")) {
                String errorCode = NativeError.findNonADNativeError(err, "adssp.native.error.adlds");
                if (err.equals(errorCode)) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.adlds.connect_error");
                } else {
                    this.status.put("eSTATUS", (Object)errorCode);
                }
                throw new ADLDSException((String)this.status.get("eSTATUS"));
            }
            return true;
        }
        return false;
    }

    static {
        System.loadLibrary("passwordSync");
    }
}

