/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice.nonad.dynamicscrm;

import com.adventnet.sym.adsm.common.server.selfservice.nonad.PasswordSynchronizer;
import com.adventnet.sym.adsm.common.server.util.ServerUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.manageengine.ads.fw.iamapps.cloud.dynamicscrm.DynamicCRMAuthentication;
import com.manageengine.ads.fw.iamapps.cloud.office365.Office365Exception;
import com.manageengine.ads.fw.iamapps.cloud.office365.PowerShellStreamHandler;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.logging.Logger;
import org.json.JSONObject;

public class DynamicsCRMHandler
implements PasswordSynchronizer {
    DynamicCRMAuthentication dynCRMAuth = new DynamicCRMAuthentication();
    private static Logger logger = Logger.getLogger(DynamicsCRMHandler.class.getName());
    private JSONObject host;
    private JSONObject status;
    private ProcessBuilder pb;
    Process p;
    boolean closed = false;
    PrintWriter writer;
    static PowerShellStreamHandler outStream;
    static PowerShellStreamHandler errStream;

    public DynamicsCRMHandler() {
        this.host = null;
        this.status = new JSONObject();
    }

    DynamicsCRMHandler(String[] commandList) {
        this.pb = new ProcessBuilder(commandList);
        try {
            this.p = this.pb.start();
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot execute PowerShell.exe", ex);
        }
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(new BufferedOutputStream(this.p.getOutputStream())), true);
        outStream = new PowerShellStreamHandler(this.p.getInputStream(), System.out);
        errStream = new PowerShellStreamHandler(this.p.getErrorStream(), System.out);
        Thread outThread = new Thread((Runnable)outStream);
        Thread errThread = new Thread((Runnable)errStream);
        outThread.start();
        errThread.start();
    }

    public void execute(String command) {
        if (this.closed) {
            throw new IllegalStateException("Power console has ben closed.");
        }
        this.writer.println(command);
        this.writer.flush();
    }

    public void close() throws IOException {
        try {
            this.execute("exit");
            this.p.waitFor();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setProxySettings() throws Exception {
        try {
            Properties proxySettings = ServerUtil.getProxySettings();
            if (!proxySettings.isEmpty()) {
                String serverName = proxySettings.getProperty("SERVER_NAME");
                String port = proxySettings.getProperty("PORT");
                String userName = proxySettings.getProperty("USER_NAME");
                String password = proxySettings.getProperty("PASSWORD");
                System.getProperties().put("https.proxyHost", serverName);
                System.getProperties().put("https.proxyPort", port);
                System.getProperties().put("https.proxyUser", userName);
                System.getProperties().put("https.proxyPassword", password);
            }
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.proxy_exception");
        }
    }

    public String getUserName(String mail, String domain) {
        if (!StrUtil.isValidEmailID(mail)) {
            mail = mail + "@" + domain;
        }
        return mail;
    }

    @Override
    public boolean authenticate(JSONObject details) throws Exception {
        return this.dynCRMAuth.authenticate(details);
    }

    @Override
    public void changePassword(JSONObject details) throws Exception {
        this.host = details;
        try {
            String userName = (String)details.get("USER_NAME");
            String password = (String)details.get("PASSWORD");
            String endUserName = (String)details.get("END_USER_NAME");
            String endUserNewPassword = (String)details.get("NEW_PASSWORD");
            String hostName = (String)details.get("HOST_NAME");
            userName = this.getUserName(userName, hostName);
            endUserName = this.getUserName(endUserName, hostName);
            DynamicsCRMHandler pc = new DynamicsCRMHandler(new String[]{"powershell.exe", "-NoExit", "-Command", "-"});
            String scriptText = "import-module MSOnline\r\n$Username = '" + userName + "'\r\n" + "$Password = ConvertTo-SecureString -AsPlainText '" + password + "' -Force\r\n" + "$Livecred = New-Object System.Management.Automation.PSCredential $Username, $Password\r\n" + "Connect-MsolService -Credential $Livecred\r\n" + "Set-MsolUserPassword -userprincipalname " + endUserName + " -NewPassword '" + endUserNewPassword + "' -ForceChangePassword $false";
            pc.execute(scriptText);
            pc.close();
            if (DynamicsCRMHandler.errStream.output == null) {
                this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.password_change_success");
            } else if (DynamicsCRMHandler.errStream.output != null) {
                if (DynamicsCRMHandler.errStream.output.contains("no valid module file") || DynamicsCRMHandler.errStream.output.contains("Module is not configured properly")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.power_shell_error");
                } else if (DynamicsCRMHandler.errStream.output.contains("User Not Found") || DynamicsCRMHandler.errStream.output.contains("UserNotFound")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.user_not_found");
                } else if (DynamicsCRMHandler.errStream.output.contains("InvalidPasswordWeakException") || DynamicsCRMHandler.errStream.output.contains("must choose a strong password ")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.password_complex_mismatch");
                } else {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.password_change_failure");
                }
            }
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.password_change_failure");
            e.printStackTrace();
        }
    }

    @Override
    public boolean connectAccount(JSONObject details) throws Exception {
        this.setProxySettings();
        String domain = (String)details.get("HOST_NAME");
        String email = (String)details.get("USER_NAME");
        String password = (String)details.get("PASSWORD");
        email = this.getUserName(email, domain);
        DynamicsCRMHandler pc = new DynamicsCRMHandler(new String[]{"powershell.exe", "-NoExit", "-Command", "-"});
        String scriptText = "import-module MSOnline\r\n$Username = '" + email + "'\r\n" + "$Password = ConvertTo-SecureString -AsPlainText '" + password + "' -Force\r\n" + "$Livecred = New-Object System.Management.Automation.PSCredential $Username, $Password\r\n" + "Connect-MsolService -Credential $Livecred\r\n";
        pc.execute(scriptText);
        pc.close();
        if (DynamicsCRMHandler.errStream.output == null) {
            return true;
        }
        if (DynamicsCRMHandler.errStream.output != null) {
            if (DynamicsCRMHandler.errStream.output.contains("no valid module file") || DynamicsCRMHandler.errStream.output.contains("Module is not configured properly")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.power_shell_error");
            } else if (DynamicsCRMHandler.errStream.output.contains("Your password must be changed")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.invalid_credential");
            } else {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.invalid_credential");
            }
        } else {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.invalid_credential");
        }
        throw new Office365Exception((String)this.status.get("eSTATUS"));
    }

    @Override
    public JSONObject getStatus() {
        try {
            if (this.status.has("eSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("eSTATUS") + "_message"));
            } else if (this.status.has("sSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("sSTATUS") + "_message"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.status;
    }

    @Override
    public void resetPassword(JSONObject details) throws Exception {
        this.host = details;
        try {
            String userName = (String)details.get("USER_NAME");
            String password = (String)details.get("PASSWORD");
            String endUserName = (String)details.get("END_USER_NAME");
            String endUserNewPassword = (String)details.get("NEW_PASSWORD");
            String hostName = (String)details.get("HOST_NAME");
            userName = this.getUserName(userName, hostName);
            endUserName = this.getUserName(endUserName, hostName);
            DynamicsCRMHandler pc = new DynamicsCRMHandler(new String[]{"powershell.exe", "-NoExit", "-Command", "-"});
            String scriptText = "import-module MSOnline\r\n$Username = '" + userName + "'\r\n" + "$Password = ConvertTo-SecureString -AsPlainText '" + password + "' -Force\r\n" + "$Livecred = New-Object System.Management.Automation.PSCredential $Username, $Password\r\n" + "Connect-MsolService -Credential $Livecred\r\n" + "Set-MsolUserPassword -userprincipalname " + endUserName + " -NewPassword '" + endUserNewPassword + "' -ForceChangePassword $false";
            pc.execute(scriptText);
            pc.close();
            if (DynamicsCRMHandler.errStream.output == null) {
                this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.password_reset_success");
            } else if (DynamicsCRMHandler.errStream.output != null) {
                if (DynamicsCRMHandler.errStream.output.contains("no valid module file") || DynamicsCRMHandler.errStream.output.contains("Module is not configured properly")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.power_shell_error");
                } else if (DynamicsCRMHandler.errStream.output.contains("User Not Found") || DynamicsCRMHandler.errStream.output.contains("UserNotFound")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.user_not_found");
                } else if (DynamicsCRMHandler.errStream.output.contains("InvalidPasswordWeakException") || DynamicsCRMHandler.errStream.output.contains("You must choose a strong password ")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.password_complex_mismatch");
                } else {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.password_reset_failure");
                }
            }
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.password_reset_failure");
            e.printStackTrace();
        }
    }

    @Override
    public void unlockUser(JSONObject details) throws Exception {
        DynamicsCRMHandler pc = new DynamicsCRMHandler(new String[]{"powershell.exe", "-NoExit", "-Command", "-"});
        this.host = details;
        try {
            String userName = (String)details.get("USER_NAME");
            String adminPassword = (String)details.get("PASSWORD");
            String endUserName = (String)details.get("END_USER_NAME");
            String hostName = (String)details.get("HOST_NAME");
            userName = this.getUserName(userName, hostName);
            endUserName = this.getUserName(endUserName, hostName);
            String scriptText = "import-module MSOnline\r\n$Username = '" + userName + "'\r\n" + "$Password = ConvertTo-SecureString -AsPlainText '" + adminPassword + "' -Force\r\n" + "$Livecred = New-Object System.Management.Automation.PSCredential $Username, $Password\r\n" + "Connect-MsolService -Credential $Livecred\r\n" + " Get-MsolUser -EnabledFilter DisabledOnly | where-object      {$_.userprincipalname -eq \"" + endUserName + "\"}";
            pc.execute(scriptText);
            pc.close();
            if (DynamicsCRMHandler.errStream.output == null) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.user_ac_not_locked");
            } else if (DynamicsCRMHandler.errStream.output != null) {
                if (DynamicsCRMHandler.errStream.output.contains("User Not Found") || DynamicsCRMHandler.errStream.output.contains("UserNotFound")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.user_not_found");
                } else {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.unlock_failure");
                }
            } else if (DynamicsCRMHandler.outStream.output != null) {
                DynamicsCRMHandler.outStream.output = null;
                DynamicsCRMHandler.errStream.output = null;
                pc = new DynamicsCRMHandler(new String[]{"powershell.exe", "-NoExit", "-Command", "-"});
                scriptText = "import-module MSOnline\r\n$Username = '" + userName + "'\r\n" + "$Password = ConvertTo-SecureString -AsPlainText '" + adminPassword + "' -Force\r\n" + "$Livecred = New-Object System.Management.Automation.PSCredential $Username, $Password\r\n" + "Connect-MsolService -Credential $Livecred\r\n" + " set-MsolUser -Userprincipalname " + endUserName + " -BlockCredential $false";
                pc.execute(scriptText);
                pc.close();
                if (DynamicsCRMHandler.errStream.output == null) {
                    this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.user_unlocked");
                } else {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.unlock_failure");
                }
            } else {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.unlock_failure");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.dynamicsCRM.unlock_failure");
        }
    }
}

