/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice.nonad.google;

import com.adventnet.sym.adsm.common.server.selfservice.nonad.PasswordSynchronizer;
import com.adventnet.sym.adsm.common.server.selfservice.nonad.google.GoogleException;
import com.adventnet.sym.adsm.common.server.util.ServerUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.api.client.googleapis.auth.clientlogin.ClientLogin;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.admin.directory.Directory;
import com.google.api.services.admin.directory.model.User;
import com.google.api.services.admin.directory.model.Users;
import com.manageengine.ads.fw.util.ADSErrorHandler;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.json.JSONException;
import org.json.JSONObject;

public class GoogleHandler
implements PasswordSynchronizer {
    private static Logger logger = Logger.getLogger(GoogleHandler.class.getName());
    public static HttpTransport httpTransport;
    public static JacksonFactory jFactory;
    public static GoogleCredential credential;
    private JSONObject host = null;
    private JSONObject status = new JSONObject();
    private String domain;
    private String email;
    public String basePath = System.getProperty("user.dir") + File.separator;

    public void setProxySettings() throws Exception {
        try {
            Properties proxySettings = ServerUtil.getProxySettings();
            if (!proxySettings.isEmpty()) {
                String serverName = proxySettings.getProperty("SERVER_NAME");
                String port = proxySettings.getProperty("PORT");
                String userName = proxySettings.getProperty("USER_NAME");
                String password = proxySettings.getProperty("PASSWORD");
                System.getProperties().put("https.proxyHost", serverName);
                System.getProperties().put("https.proxyPort", port);
                System.getProperties().put("https.proxyUser", userName);
                System.getProperties().put("https.proxyPassword", password);
            }
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.google.proxy_error");
        }
    }

    private HttpRequestInitializer setHttpTimeout(final HttpRequestInitializer requestInitializer) {
        return new HttpRequestInitializer(){

            public void initialize(HttpRequest httpRequest) throws IOException {
                requestInitializer.initialize(httpRequest);
                httpRequest.setConnectTimeout(1800000);
                httpRequest.setReadTimeout(1800000);
            }
        };
    }

    private void openConnection(JSONObject details) throws Exception {
        String APPLICATION_NAME = "PASSWORD_SYNC";
        String SERVICE_ACCOUNT_EMAIL = (String)details.get("SERVICE_ACC_EMAIL");
        String SERVICE_ACCOUNT_USER = (String)details.get("USER_NAME");
        httpTransport = new NetHttpTransport();
        jFactory = new JacksonFactory();
        try {
            String path = "";
            if (details.has("P12_KEY")) {
                path = this.basePath + "GoogleApps" + File.separator + "gappskey.p12";
            }
            if (details.has("APP_CONFIG_ID")) {
                path = this.basePath + "GoogleApps" + File.separator + details.getString("APP_CONFIG_ID") + ".p12";
            }
            logger.log(Level.INFO, "P12 Key path is " + path);
            credential = new GoogleCredential.Builder().setTransport(httpTransport).setJsonFactory((JsonFactory)jFactory).setServiceAccountId(SERVICE_ACCOUNT_EMAIL).setServiceAccountScopes(Arrays.asList("https://www.googleapis.com/auth/admin.directory.user", "https://www.googleapis.com/auth/admin.directory.group", "https://www.googleapis.com/auth/admin.directory.orgunit")).setServiceAccountUser(SERVICE_ACCOUNT_USER).setServiceAccountPrivateKeyFromP12File(new File(path)).build();
            return;
        }
        catch (TokenResponseException e) {
            e.printStackTrace();
            if (e.toString().contains("email")) {
                logger.log(Level.INFO, "Invalid Email");
                this.status.put("eSTATUS", (Object)ADSErrorHandler.getFormattedError((String)"00014"));
            } else if (e.toString().contains("invalid_grant")) {
                this.status.put("eSTATUS", (Object)ADSErrorHandler.getFormattedError((String)"00002"));
                logger.log(Level.INFO, "Invalid Credentials (or) Grant");
            }
        }
        catch (GoogleJsonResponseException gje) {
            gje.printStackTrace();
            this.status.put("eSTATUS", (Object)ADSErrorHandler.getFormattedError((String)"00003"));
            logger.log(Level.INFO, "API is disabled");
        }
        catch (AuthenticationException ae) {
            ae.printStackTrace();
            this.status.put("eSTATUS", (Object)ADSErrorHandler.getFormattedError((String)"00004"));
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Problem while connecting Google domain. [" + e.getMessage() + "]");
            e.printStackTrace();
            this.status.put("eSTATUS", (Object)ADSErrorHandler.getFormattedError((String)"00009"));
        }
        throw new GoogleException((String)this.status.get("eSTATUS"));
    }

    @Override
    public boolean authenticate(JSONObject details) throws GeneralSecurityException, IOException, URISyntaxException, JSONException, GoogleException {
        String APPLICATION_NAME = "PASSWORD_SYNC";
        try {
            this.openConnection(this.getHostInfo(details));
            Directory service = new Directory.Builder(httpTransport, (JsonFactory)jFactory, this.setHttpTimeout((HttpRequestInitializer)credential)).setApplicationName("PASSWORD_SYNC").build();
            ArrayList allUsers = new ArrayList();
            Directory.Users.List grequest = service.users().list().setCustomer("my_customer");
            do {
                Users currentPage = (Users)grequest.execute();
                allUsers.addAll(currentPage.getUsers());
                grequest.setPageToken(currentPage.getNextPageToken());
            } while (grequest.getPageToken() != null && grequest.getPageToken().length() > 0);
            return true;
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)ADSErrorHandler.getFormattedError((String)"00004"));
            logger.log(Level.INFO, "Problem while connecting Google domain. [" + e.getMessage() + "]");
            e.printStackTrace();
            throw new GoogleException((String)this.status.get("eSTATUS"));
        }
    }

    private JSONObject getHostInfo(JSONObject details) throws Exception {
        this.host = new JSONObject();
        this.host.put("USER_NAME", (Object)((String)details.get("USER_NAME")));
        if (details.has("P12_KEY")) {
            this.host.put("P12_KEY", (Object)((String)details.get("P12_KEY")));
        }
        if (details.has("APP_CONFIG_ID")) {
            this.host.put("APP_CONFIG_ID", (Object)((String)details.get("APP_CONFIG_ID")));
        }
        if (details.has("PARAMS")) {
            JSONObject parameter = details.getJSONObject("PARAMS");
            Iterator it = parameter.keys();
            while (it.hasNext()) {
                String pName = it.next().toString();
                this.host.put(pName, (Object)((String)parameter.get(pName)));
            }
        } else {
            this.host.put("SERVICE_ACC_EMAIL", (Object)((String)details.get("SERVICE_ACC_EMAIL")));
        }
        return this.host;
    }

    @Override
    public void resetPassword(JSONObject details) throws Exception {
        try {
            try {
                this.openConnection(details);
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (GoogleException e) {
                e.printStackTrace();
            }
            String username = (String)details.get("END_USER_NAME");
            if (!StrUtil.isValidEmailID(username)) {
                username = username + "@" + (String)details.get("HOST_NAME");
            }
            Directory service = new Directory.Builder(httpTransport, (JsonFactory)jFactory, (HttpRequestInitializer)credential).setApplicationName("PASSWORD_SYNC").build();
            User googleuser = new User();
            googleuser.set("password", (Object)((String)details.get("NEW_PASSWORD")));
            Directory.Users.Update grequest = service.users().update(username, googleuser);
            grequest.execute();
            this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.google.password_reset_success");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.google.reset_internal_error");
        }
    }

    @Override
    public void changePassword(JSONObject details) throws Exception {
        try {
            try {
                this.openConnection(details);
            }
            catch (GeneralSecurityException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (GoogleException e) {
                e.printStackTrace();
            }
            String username = (String)details.get("END_USER_NAME");
            if (!StrUtil.isValidEmailID(username)) {
                username = username + "@" + (String)details.get("HOST_NAME");
            }
            Directory service = new Directory.Builder(httpTransport, (JsonFactory)jFactory, (HttpRequestInitializer)credential).setApplicationName("PASSWORD_SYNC").build();
            User googleuser = new User();
            googleuser.set("password", (Object)((String)details.get("NEW_PASSWORD")));
            Directory.Users.Update grequest = service.users().update(username, googleuser);
            grequest.execute();
            this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.google.password_change_success");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.google.change_internal_error");
        }
    }

    @Override
    public void unlockUser(JSONObject details) throws Exception {
    }

    @Override
    public JSONObject getStatus() {
        try {
            if (this.status.has("eSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("eSTATUS") + "_message"));
            } else if (this.status.has("sSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("sSTATUS") + "_message"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.status;
    }

    @Override
    public boolean connectAccount(JSONObject details) throws Exception {
        try {
            this.setProxySettings();
            String username = (String)details.get("USER_NAME");
            String password = (String)details.get("PASSWORD");
            String domain = (String)details.get("HOST_NAME");
            httpTransport = new NetHttpTransport();
            if (!username.endsWith("@" + domain)) {
                username = username + "@" + domain;
            }
            ClientLogin authenticator = new ClientLogin();
            authenticator.transport = httpTransport;
            authenticator.authTokenType = "cl";
            authenticator.username = username;
            authenticator.password = password;
            authenticator.authenticate();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.google.invalid_credential");
            throw new GoogleException((String)this.status.get("eSTATUS"));
        }
    }
}

