/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice.nonad.hp;

import com.adventnet.sym.adsm.common.server.selfservice.nonad.PasswordSynchronizer;
import com.adventnet.sym.adsm.common.server.selfservice.nonad.hp.SavingTrustManager;
import com.manageengine.ads.fw.iamapps.onpremise.hp.HPUXAuthentication;
import com.manageengine.ads.fw.iamapps.onpremise.hp.HPUXException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.json.JSONObject;

public class HPUXHandler
implements PasswordSynchronizer {
    private static Logger logger = Logger.getLogger(HPUXHandler.class.getName());
    private final String iNITCTX = "com.sun.jndi.ldap.LdapCtxFactory";
    private JSONObject host = null;
    private JSONObject status;
    private DirContext connection = null;
    private String user;
    HPUXAuthentication hpauth = new HPUXAuthentication();

    public HPUXHandler() {
        this.status = new JSONObject();
    }

    private DirContext getConnection() throws Exception {
        Hashtable<String, String> env = new Hashtable<String, String>();
        InitialDirContext ctx = null;
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        String systemname = (String)this.host.get("PORT_TYPE") + "://" + (String)this.host.get("HOST_NAME") + ":" + (String)this.host.get("PORT_NO");
        env.put("java.naming.provider.url", systemname);
        env.put("java.naming.security.principal", (String)this.host.get("USER_NAME"));
        env.put("java.naming.security.credentials", (String)this.host.get("PASSWORD"));
        InitialDirContext connection = ctx = new InitialDirContext(env);
        connection.lookup((String)this.host.get("FQ_DOMAIN_NAME"));
        logger.log(Level.INFO, "HPUX connection established, URL:" + systemname);
        return connection;
    }

    private void openConnection(JSONObject host) throws Exception {
        try {
            this.host = host;
            String port_type = (String)host.get("PORT_TYPE");
            if (port_type.equalsIgnoreCase("LDAPS")) {
                try {
                    this.connection = this.getConnection();
                }
                catch (Exception e) {
                    this.installCertificateToKeyStore();
                    try {
                        this.connection = this.getConnection();
                    }
                    catch (Exception ex) {
                        throw new HPUXException("adssp.nonad.pwdsync.hpux.certificate_installed_needed_restart");
                    }
                }
            } else {
                this.connection = this.getConnection();
            }
            return;
        }
        catch (HPUXException e) {
            this.status.put("eSTATUS", (Object)e.getMessage());
        }
        catch (UnknownHostException e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.hpux.host_unreachable");
        }
        catch (NumberFormatException e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.hpux.port_invalid");
        }
        catch (CommunicationException e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.hpux.host_unreachable");
        }
        catch (AuthenticationException e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.hpux.user_not_found");
            if (e.getMessage().contains("49")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.hpux.user_password_invalid");
            }
        }
        catch (NameNotFoundException e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.hpux.domain_name_invalid");
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Problem while connecting HPUX system. [" + e.getMessage() + "]");
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.hpux.internal_error");
        }
        throw new HPUXException((String)this.status.get("eSTATUS"));
    }

    private void closeConnection() {
        try {
            this.connection.close();
            this.connection = null;
            logger.log(Level.INFO, "HPUX connection closed.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void installCertificateToKeyStore() throws Exception {
        String hostname = (String)this.host.get("HOST_NAME");
        int port = Integer.parseInt((String)this.host.get("PORT_NO"));
        char SEP = File.separatorChar;
        char[] passphrase = "changeit".toCharArray();
        File dir = new File(System.getProperty("java.home") + SEP + "lib" + SEP + "security");
        File file = new File(dir, "jssecacerts");
        if (!file.isFile()) {
            file = new File(dir, "cacerts");
        }
        logger.log(Level.INFO, "Loading KeyStore " + file + "...");
        FileInputStream in = new FileInputStream(file);
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(in, passphrase);
        ((InputStream)in).close();
        SSLContext context = SSLContext.getInstance("TLS");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ks);
        X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
        SavingTrustManager tm = new SavingTrustManager(defaultTrustManager);
        context.init(null, new TrustManager[]{tm}, null);
        SSLSocketFactory factory = context.getSocketFactory();
        logger.log(Level.INFO, "Opening connection to " + hostname + ":" + port + "...");
        try {
            logger.log(Level.INFO, "Starting SSL handshake...");
            SSLSocket socket = (SSLSocket)factory.createSocket(hostname, port);
            socket.setSoTimeout(10000);
            socket.startHandshake();
            socket.close();
            logger.log(Level.INFO, "No errors, certificate is already trusted");
        }
        catch (Exception e) {
            logger.log(Level.INFO, "SSL handshake failed. [" + e.getMessage() + "]");
        }
        X509Certificate[] chain = tm.chain;
        if (chain == null) {
            logger.log(Level.INFO, "Unable to obtain server certificate chain.");
            throw new HPUXException("adssp.nonad.pwdsync.hpux.no_certificate_installed");
        }
        logger.log(Level.INFO, "Server sent " + chain.length + " certificate(s):");
        for (int i = 0; i < chain.length; ++i) {
            X509Certificate cert = chain[i];
            logger.log(Level.INFO, i + 1 + " Subject " + cert.getSubjectDN());
            logger.log(Level.INFO, "   Issuer  " + cert.getIssuerDN());
            String alias = hostname + "-" + (i + 1);
            ks.setCertificateEntry(alias, cert);
            FileOutputStream out = new FileOutputStream(file.getPath());
            ks.store(out, passphrase);
            ((OutputStream)out).close();
            logger.log(Level.INFO, "Added certificate to keystore " + file.getPath() + " using alias '" + alias + "'");
        }
    }

    private void loadUserInformation(String username) throws Exception {
        String dn = null;
        String MY_FILTER = "uid=" + username;
        SearchControls constraints = new SearchControls();
        constraints.setSearchScope(2);
        NamingEnumeration<SearchResult> results = this.connection.search((String)this.host.get("FQ_DOMAIN_NAME"), MY_FILTER, constraints);
        if (results != null && results.hasMore()) {
            SearchResult sr = results.next();
            dn = sr.getName() + "," + (String)this.host.get("FQ_DOMAIN_NAME");
        }
        if (dn == null) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.hpux.user_not_found");
            throw new HPUXException("adssp.nonad.pwdsync.hpux.user_not_found");
        }
        this.user = dn;
    }

    private JSONObject getHostInfo(JSONObject details) throws Exception {
        this.host = new JSONObject();
        this.host.put("HOST_NAME", (Object)((String)details.get("HOST_NAME")));
        this.host.put("USER_NAME", (Object)((String)details.get("USER_NAME")));
        this.host.put("PASSWORD", (Object)((String)details.get("PASSWORD")));
        if (details.has("PARAMS")) {
            JSONObject parameter = details.getJSONObject("PARAMS");
            Iterator it = parameter.keys();
            while (it.hasNext()) {
                String pName = it.next().toString();
                this.host.put(pName, (Object)((String)parameter.get(pName)));
            }
        } else {
            this.host.put("FQ_DOMAIN_NAME", (Object)((String)details.get("FQ_DOMAIN_NAME")));
            this.host.put("PORT_NO", (Object)((String)details.get("PORT_NO")));
            this.host.put("PORT_TYPE", (Object)((String)details.get("PORT_TYPE")));
        }
        return this.host;
    }

    @Override
    public boolean authenticate(JSONObject details) throws Exception {
        return this.hpauth.authenticate(details);
    }

    @Override
    public void resetPassword(JSONObject details) throws Exception {
        try {
            this.openConnection(details);
            try {
                this.loadUserInformation((String)details.get("END_USER_NAME"));
            }
            catch (Exception e) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.hpux.user_not_found");
                e.printStackTrace();
                return;
            }
            ModificationItem[] mods = new ModificationItem[1];
            BasicAttribute mod0 = new BasicAttribute("userpassword", (String)details.get("NEW_PASSWORD"));
            mods[0] = new ModificationItem(2, mod0);
            this.connection.modifyAttributes(this.user, mods);
            this.closeConnection();
            logger.log(Level.INFO, "Password Reset in HPUX system for the user: " + (String)details.get("END_USER_NAME") + " has done");
            this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.hpux.password_reset_success");
        }
        catch (HPUXException e) {
            this.status.put("eSTATUS", (Object)e.getMessage());
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.hpux.internal_error");
        }
    }

    @Override
    public void changePassword(JSONObject details) throws Exception {
        try {
            this.openConnection(details);
            try {
                this.loadUserInformation((String)details.get("END_USER_NAME"));
            }
            catch (Exception e) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.hpux.user_not_found");
                e.printStackTrace();
                return;
            }
            ModificationItem[] mods = new ModificationItem[1];
            BasicAttribute mod0 = new BasicAttribute("userpassword", (String)details.get("NEW_PASSWORD"));
            mods[0] = new ModificationItem(2, mod0);
            this.connection.modifyAttributes(this.user, mods);
            this.closeConnection();
            logger.log(Level.INFO, "Password Reset in HPUX system for the user: " + (String)details.get("END_USER_NAME") + " has done");
            this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.hpux.password_change_success");
        }
        catch (HPUXException e) {
            this.status.put("eSTATUS", (Object)e.getMessage());
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.hpux.internal_error");
        }
    }

    @Override
    public void unlockUser(JSONObject details) throws Exception {
        try {
            ModificationItem[] mods = new ModificationItem[1];
            this.openConnection(details);
            try {
                this.loadUserInformation((String)details.get("END_USER_NAME"));
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            try {
                mods[0] = new ModificationItem(3, new BasicAttribute("accountUnlockTime"));
                this.connection.modifyAttributes(this.user, mods);
            }
            catch (Exception e) {
                throw new HPUXException("adssp.nonad.pwdsync.hpux.account_not_locked");
            }
            try {
                mods[0] = new ModificationItem(3, new BasicAttribute("passwordRetryCount"));
                this.connection.modifyAttributes(this.user, mods);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.closeConnection();
            logger.log(Level.INFO, "Account unlock in HPUX system for the user: " + (String)details.get("END_USER_NAME") + " has done");
            this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.hpux.account_unlock_success");
        }
        catch (HPUXException e) {
            this.status.put("eSTATUS", (Object)e.getMessage());
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.hpux.internal_error");
        }
    }

    @Override
    public JSONObject getStatus() {
        try {
            if (this.status.has("eSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("eSTATUS") + "_message"));
            } else if (this.status.has("sSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("sSTATUS") + "_message"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.status;
    }

    @Override
    public boolean connectAccount(JSONObject details) throws Exception {
        String username = (String)details.get("USER_NAME");
        String password = (String)details.get("PASSWORD");
        details.put("USER_NAME", (Object)((String)details.get("ADMIN_USER_NAME")));
        details.put("PASSWORD", (Object)((String)details.get("ADMIN_PASSWORD")));
        this.openConnection(this.getHostInfo(details));
        this.loadUserInformation(username);
        details.put("USER_NAME", (Object)this.user);
        details.put("PASSWORD", (Object)password);
        if (this.authenticate(details)) {
            details.put("USER_NAME", (Object)username);
            return true;
        }
        return false;
    }
}

