/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice.nonad.ibm;

import com.adventnet.sym.adsm.common.server.selfservice.nonad.PasswordSynchronizer;
import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.CommandCall;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.SystemValue;
import com.ibm.as400.access.User;
import com.manageengine.ads.fw.iamapps.onpremise.ibm.IBMAS400Authentication;
import com.manageengine.ads.fw.iamapps.onpremise.ibm.IBMAS400Exception;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class AS400Handler
implements PasswordSynchronizer {
    private static Logger logger = Logger.getLogger(AS400Handler.class.getName());
    public final int sIGNIN = 7;
    private AS400 connection = null;
    private User user = null;
    private CommandCall prompt = null;
    private JSONObject status;
    IBMAS400Authentication ibmauth = new IBMAS400Authentication();

    public AS400Handler() {
        this.status = new JSONObject();
    }

    private void openConnection(JSONObject host) throws Exception {
        try {
            this.connection = new AS400();
            this.connection.setGuiAvailable(false);
            this.connection.setSystemName((String)host.get("HOST_NAME"));
            this.connection.setUserId((String)host.get("USER_NAME"));
            this.connection.setPassword((String)host.get("PASSWORD"));
            this.connection.connectService(7);
            this.prompt = new CommandCall(this.connection);
            logger.log(Level.INFO, "IBM i/AS400 connection established, system:" + (String)host.get("HOST_NAME"));
            return;
        }
        catch (ConnectException e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.ibmas400.host_unreachable");
        }
        catch (UnknownHostException e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.ibmas400.host_unreachable");
        }
        catch (ExtendedIllegalArgumentException e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.ibmas400.invalid_credentials");
        }
        catch (AS400SecurityException e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.ibmas400.user_not_found");
            if (e.getMessage().contains("character")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.ibmas400.invalid_credentials");
            } else if (e.getMessage().contains("disabled")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.ibmas400.user_id_diabled");
            } else if (e.getMessage().contains("Password")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.ibmas400.user_password_invalid");
            }
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.ibmas400.internal_error");
        }
        throw new IBMAS400Exception((String)this.status.get("eSTATUS"));
    }

    private void closeConnection() {
        try {
            this.connection.disconnectAllServices();
            this.connection = null;
            logger.log(Level.INFO, "IBM i/AS400 connection closed.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean authenticate(JSONObject host) throws Exception {
        return this.ibmauth.authenticate(host);
    }

    private void loadUserInformation(String username) throws Exception {
        try {
            this.user = new User(this.connection, username);
            this.user.loadUserInformation();
        }
        catch (AS400Exception e) {
            this.closeConnection();
            throw new IBMAS400Exception("adssp.nonad.pwdsync.ibmas400.user_not_found");
        }
    }

    private boolean accountIsLocked() {
        boolean isLocked = true;
        if (this.user.getStatus().equalsIgnoreCase("*ENABLED")) {
            isLocked = false;
        }
        return isLocked;
    }

    @Override
    public JSONObject getStatus() {
        try {
            if (this.status.has("eSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("eSTATUS") + "_message"));
            } else if (this.status.has("sSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("sSTATUS") + "_message"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.status;
    }

    @Override
    public void resetPassword(JSONObject details) throws Exception {
        try {
            this.openConnection(details);
            try {
                this.loadUserInformation((String)details.get("END_USER_NAME"));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.status.put("eSTATUS", (Object)e.getMessage());
                return;
            }
            SystemValue sv = new SystemValue(this.connection, "QPWDLVL");
            int pwdLevel = (Integer)sv.getValue();
            logger.log(Level.INFO, "the Password level is " + pwdLevel);
            String password = (String)details.get("NEW_PASSWORD");
            if (pwdLevel > 1) {
                password = "'" + password + "'";
            }
            if (!this.prompt.run("CHGUSRPRF USRPRF(" + this.user.getName() + ") PASSWORD(" + password + ")")) {
                AS400Message[] messagelist = this.prompt.getMessageList();
                for (int i = 0; i < messagelist.length; ++i) {
                    logger.log(Level.INFO, messagelist[i].getID() + " : " + messagelist[i].getText());
                }
                throw new IBMAS400Exception("adssp.nonad.pwdsync.ibmas400.new_password_invalid");
            }
            this.closeConnection();
            logger.log(Level.INFO, "Password Reset in IBM i/AS400 system for the user: " + (String)details.get("END_USER_NAME") + " has done");
            this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.ibmas400.password_reset_success");
        }
        catch (IBMAS400Exception e) {
            this.status.put("eSTATUS", (Object)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.ibmas400.internal_error");
        }
    }

    @Override
    public void changePassword(JSONObject details) throws Exception {
        try {
            this.openConnection(details);
            try {
                this.loadUserInformation((String)details.get("END_USER_NAME"));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.status.put("eSTATUS", (Object)e.getMessage());
                return;
            }
            SystemValue sv = new SystemValue(this.connection, "QPWDLVL");
            int pwdLevel = (Integer)sv.getValue();
            logger.log(Level.INFO, "the Password level is " + pwdLevel);
            String password = (String)details.get("NEW_PASSWORD");
            if (pwdLevel > 1) {
                password = "'" + password + "'";
            }
            if (!this.prompt.run("CHGUSRPRF USRPRF(" + this.user.getName() + ") PASSWORD(" + password + ")")) {
                AS400Message[] messagelist = this.prompt.getMessageList();
                for (int i = 0; i < messagelist.length; ++i) {
                    logger.log(Level.INFO, messagelist[i].getID() + " : " + messagelist[i].getText());
                }
                throw new IBMAS400Exception("adssp.nonad.pwdsync.ibmas400.new_password_invalid");
            }
            this.closeConnection();
            logger.log(Level.INFO, "Password Reset in IBM i/AS400 system for the user: " + (String)details.get("END_USER_NAME") + " has done");
            this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.ibmas400.password_change_success");
        }
        catch (IBMAS400Exception e) {
            this.status.put("eSTATUS", (Object)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.ibmas400.internal_error");
        }
    }

    @Override
    public void unlockUser(JSONObject details) throws Exception {
        try {
            this.openConnection(details);
            try {
                this.loadUserInformation((String)details.get("END_USER_NAME"));
            }
            catch (Exception e) {
                e.printStackTrace();
                this.status.put("eSTATUS", (Object)e.getMessage());
                return;
            }
            if (!this.accountIsLocked()) {
                throw new IBMAS400Exception("adssp.nonad.pwdsync.ibmas400.account_not_locked");
            }
            if (!this.prompt.run("CHGUSRPRF USRPRF(" + this.user.getName() + ") STATUS(*ENABLED)")) {
                throw new IBMAS400Exception("adssp.nonad.pwdsync.ibmas400.account_unlock_failed");
            }
            this.closeConnection();
            logger.log(Level.INFO, "Account unlock in IBM i/AS400 system for the user: " + (String)details.get("END_USER_NAME") + " has done");
            this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.ibmas400.account_unlock_success");
        }
        catch (IBMAS400Exception e) {
            this.status.put("eSTATUS", (Object)e.getMessage());
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.ibmas400.internal_error");
        }
    }

    @Override
    public boolean connectAccount(JSONObject details) throws Exception {
        return this.authenticate(details);
    }
}

