/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice.nonad.office365;

import com.adventnet.sym.adsm.common.server.selfservice.nonad.PasswordSynchronizer;
import com.adventnet.sym.adsm.common.server.util.ServerUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.manageengine.ads.fw.iamapps.cloud.office365.Office365Authentication;
import com.manageengine.ads.fw.iamapps.cloud.office365.Office365Exception;
import com.manageengine.ads.fw.iamapps.cloud.office365.PowerShellStreamHandler;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.logging.Logger;
import org.json.JSONObject;

public class Office365Handler
implements PasswordSynchronizer {
    Office365Authentication ofauth = new Office365Authentication();
    private static Logger logger = Logger.getLogger(Office365Handler.class.getName());
    private JSONObject host;
    private JSONObject status;
    private ProcessBuilder pb;
    Process p;
    boolean closed = false;
    PrintWriter writer;
    PowerShellStreamHandler outStream;
    PowerShellStreamHandler errStream;

    public Office365Handler() {
        this.host = null;
        this.status = new JSONObject();
    }

    Office365Handler(String[] commandList) {
        this.pb = new ProcessBuilder(commandList);
        try {
            this.p = this.pb.start();
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot execute PowerShell.exe", ex);
        }
        this.writer = new PrintWriter((Writer)new OutputStreamWriter(new BufferedOutputStream(this.p.getOutputStream())), true);
        this.outStream = new PowerShellStreamHandler(this.p.getInputStream(), System.out);
        this.errStream = new PowerShellStreamHandler(this.p.getErrorStream(), System.out);
        Thread outThread = new Thread((Runnable)this.outStream);
        Thread errThread = new Thread((Runnable)this.errStream);
        outThread.start();
        errThread.start();
    }

    public void execute(String command) {
        if (this.closed) {
            throw new IllegalStateException("Power console has ben closed.");
        }
        this.writer.println(command);
        this.writer.flush();
    }

    public void close() throws IOException {
        try {
            this.execute("exit");
            this.p.waitFor();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setProxySettings() throws Exception {
        try {
            Properties proxySettings = ServerUtil.getProxySettings();
            if (!proxySettings.isEmpty()) {
                String serverName = proxySettings.getProperty("SERVER_NAME");
                String port = proxySettings.getProperty("PORT");
                String userName = proxySettings.getProperty("USER_NAME");
                String password = proxySettings.getProperty("PASSWORD");
                System.getProperties().put("https.proxyHost", serverName);
                System.getProperties().put("https.proxyPort", port);
                System.getProperties().put("https.proxyUser", userName);
                System.getProperties().put("https.proxyPassword", password);
            }
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.proxy_exception");
        }
    }

    private String getUserName(String userName, String domain) {
        if (!StrUtil.isValidEmailID(userName)) {
            userName = userName + "@" + domain;
        }
        return userName;
    }

    @Override
    public boolean authenticate(JSONObject details) throws Exception {
        return this.ofauth.authenticate(details);
    }

    @Override
    public void changePassword(JSONObject details) throws Exception {
        this.host = details;
        try {
            String userName = (String)details.get("USER_NAME");
            String password = (String)details.get("PASSWORD");
            String endUserName = (String)details.get("END_USER_NAME");
            String endUserNewPassword = (String)details.get("NEW_PASSWORD");
            String hostName = (String)details.get("HOST_NAME");
            userName = this.getUserName(userName, hostName);
            endUserName = this.getUserName(endUserName, hostName);
            Office365Handler pc = new Office365Handler(new String[]{"powershell.exe", "-NoExit", "-Command", "-"});
            String scriptText = "import-module MSOnline\r\n$Username = '" + userName + "'\r\n" + "$Password = ConvertTo-SecureString -AsPlainText '" + password + "' -Force\r\n" + "$Livecred = New-Object System.Management.Automation.PSCredential $Username, $Password\r\n" + "Connect-MsolService -Credential $Livecred\r\n" + "Set-MsolUserPassword -userprincipalname " + endUserName + " -NewPassword '" + endUserNewPassword + "' -ForceChangePassword $false";
            pc.execute(scriptText);
            pc.close();
            if (pc.errStream.output == null) {
                this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.office365.password_change_success");
            } else if (pc.errStream.output != null) {
                if (pc.errStream.output.contains("no valid module file") || pc.errStream.output.contains("Module is not configured properly")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.power_shell_error");
                } else if (pc.errStream.output.contains("User Not Found") || pc.errStream.output.contains("UserNotFound")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.user_not_found");
                } else if (pc.errStream.output.contains("InvalidPasswordWeakException") || pc.errStream.output.contains("must choose a strong password ")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.password_complex_mismatch");
                } else if (pc.errStream.output.contains("You cannot reset a password for a federated user")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.cant_change_password_federated_user");
                } else {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.password_change_failure");
                }
            }
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.password_change_failure");
            e.printStackTrace();
        }
    }

    @Override
    public boolean connectAccount(JSONObject details) throws Exception {
        this.setProxySettings();
        String domain = (String)details.get("HOST_NAME");
        String email = (String)details.get("USER_NAME");
        String password = (String)details.get("PASSWORD");
        email = this.getUserName(email, domain);
        Office365Handler pc = new Office365Handler(new String[]{"powershell.exe", "-NoExit", "-Command", "-"});
        String scriptText = "import-module MSOnline\r\n$Username = '" + email + "'\r\n" + "$Password = ConvertTo-SecureString -AsPlainText '" + password + "' -Force\r\n" + "$Livecred = New-Object System.Management.Automation.PSCredential $Username, $Password\r\n" + "Connect-MsolService -Credential $Livecred\r\n";
        pc.execute(scriptText);
        pc.close();
        if (pc.errStream.output == null) {
            return true;
        }
        if (pc.errStream.output != null) {
            if (pc.errStream.output.contains("no valid module file") || pc.errStream.output.contains("Module is not configured properly")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.power_shell_error");
            } else if (pc.errStream.output.contains("Your password must be changed")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.invalid_credential");
            } else {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.invalid_credential");
            }
        } else {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.invalid_credential");
        }
        throw new Office365Exception((String)this.status.get("eSTATUS"));
    }

    @Override
    public JSONObject getStatus() {
        try {
            if (this.status.has("eSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("eSTATUS") + "_message"));
            } else if (this.status.has("sSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("sSTATUS") + "_message"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.status;
    }

    @Override
    public void resetPassword(JSONObject details) throws Exception {
        this.host = details;
        try {
            String userName = (String)details.get("USER_NAME");
            String password = (String)details.get("PASSWORD");
            String endUserName = (String)details.get("END_USER_NAME");
            String endUserNewPassword = (String)details.get("NEW_PASSWORD");
            String hostName = (String)details.get("HOST_NAME");
            userName = this.getUserName(userName, hostName);
            endUserName = this.getUserName(endUserName, hostName);
            Office365Handler pc = new Office365Handler(new String[]{"powershell.exe", "-NoExit", "-Command", "-"});
            String scriptText = "import-module MSOnline\r\n$Username = '" + userName + "'\r\n" + "$Password = ConvertTo-SecureString -AsPlainText '" + password + "' -Force\r\n" + "$Livecred = New-Object System.Management.Automation.PSCredential $Username, $Password\r\n" + "Connect-MsolService -Credential $Livecred\r\n" + "Set-MsolUserPassword -userprincipalname " + endUserName + " -NewPassword '" + endUserNewPassword + "' -ForceChangePassword $false";
            pc.execute(scriptText);
            pc.close();
            if (pc.errStream.output == null) {
                this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.office365.password_reset_success");
            } else if (pc.errStream.output != null) {
                if (pc.errStream.output.contains("no valid module file") || pc.errStream.output.contains("Module is not configured properly")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.power_shell_error");
                } else if (pc.errStream.output.contains("User Not Found") || pc.errStream.output.contains("UserNotFound")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.user_not_found");
                } else if (pc.errStream.output.contains("InvalidPasswordWeakException") || pc.errStream.output.contains("You must choose a strong password ")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.password_complex_mismatch");
                } else if (pc.errStream.output.contains("You cannot reset a password for a federated user")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.cant_reset_federated_user");
                } else {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.password_reset_failure");
                }
            }
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.password_reset_failure");
            e.printStackTrace();
        }
    }

    @Override
    public void unlockUser(JSONObject details) throws Exception {
        Office365Handler pc = new Office365Handler(new String[]{"powershell.exe", "-NoExit", "-Command", "-"});
        this.host = details;
        try {
            String userName = (String)details.get("USER_NAME");
            String adminPassword = (String)details.get("PASSWORD");
            String endUserName = (String)details.get("END_USER_NAME");
            String hostName = (String)details.get("HOST_NAME");
            userName = this.getUserName(userName, hostName);
            endUserName = this.getUserName(endUserName, hostName);
            String scriptText = "import-module MSOnline\r\n$Username = '" + userName + "'\r\n" + "$Password = ConvertTo-SecureString -AsPlainText '" + adminPassword + "' -Force\r\n" + "$Livecred = New-Object System.Management.Automation.PSCredential $Username, $Password\r\n" + "Connect-MsolService -Credential $Livecred\r\n" + " Get-MsolUser -EnabledFilter DisabledOnly | where-object      {$_.userprincipalname -eq \"" + endUserName + "\"}";
            pc.execute(scriptText);
            pc.close();
            if (pc.errStream.output == null) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.user_ac_not_locked");
            } else if (pc.errStream.output != null) {
                if (pc.errStream.output.contains("User Not Found") || pc.errStream.output.contains("UserNotFound")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.user_not_found");
                } else {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.unlock_failure");
                }
            } else if (this.outStream.output != null) {
                this.outStream.output = null;
                this.errStream.output = null;
                pc = new Office365Handler(new String[]{"powershell.exe", "-NoExit", "-Command", "-"});
                scriptText = "import-module MSOnline\r\n$Username = '" + userName + "'\r\n" + "$Password = ConvertTo-SecureString -AsPlainText '" + adminPassword + "' -Force\r\n" + "$Livecred = New-Object System.Management.Automation.PSCredential $Username, $Password\r\n" + "Connect-MsolService -Credential $Livecred\r\n" + " set-MsolUser -Userprincipalname " + endUserName + " -BlockCredential $false";
                pc.execute(scriptText);
                pc.close();
                if (pc.errStream.output == null) {
                    this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.office365.user_unlocked");
                } else {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.unlock_failure");
                }
            } else {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.unlock_failure");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.office365.unlock_failure");
        }
    }
}

