/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice.nonad.office365;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.json.JSONObject;

public class Office365WebToken {
    private Date unixEpochDateTime;
    private String issuer;
    private String audience;
    private Date notBeforeDate;
    private Date expirationDate;
    private HashMap<String, String> otherClaims = new HashMap();

    public Office365WebToken(String issuerPrincipalId, String tenantRealm, String audienceHostName, String audiencePrincipalId, Date nbfTime, int validitySeconds) {
        this.issuer = Office365WebToken.getFormattedPrincipal(issuerPrincipalId, null, tenantRealm);
        this.audience = Office365WebToken.getFormattedPrincipal(audiencePrincipalId, audienceHostName, tenantRealm);
        this.notBeforeDate = nbfTime;
        this.expirationDate = Office365WebToken.addSecondsToCurrentTime(validitySeconds);
        this.unixEpochDateTime = Office365WebToken.getUnixEpochDateTime();
    }

    public static String getFormattedPrincipal(String principalName, String hostName, String realm) {
        if (hostName != null && realm != null) {
            return String.format("%s/%s@%s", principalName, hostName, realm);
        }
        if (realm == null || realm.trim() == null) {
            return String.format("%s/%s", principalName, hostName);
        }
        return String.format("%s@%s", principalName, realm);
    }

    public static Date getUnixEpochDateTime() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(1970, 0, 1, 0, 0, 0);
        return calendar.getTime();
    }

    public static Date getCurrentDateTime() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        return calendar.getTime();
    }

    public static Date addSecondsToCurrentTime(int seconds) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.add(13, seconds);
        return calendar.getTime();
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public HashMap<String, String> getOtherClaims() {
        return this.otherClaims;
    }

    public void setOtherClaims(HashMap<String, String> otherClaims) {
        this.otherClaims = otherClaims;
    }

    public Date getNotBeforeDate() {
        return this.notBeforeDate;
    }

    public void setNotBeforeDate(Date notBeforeDate) {
        this.notBeforeDate = notBeforeDate;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String encodeToJson() {
        HashMap<String, String> allClaims = new HashMap<String, String>();
        allClaims.put("aud", this.audience);
        allClaims.put("iss", this.issuer);
        String totalSeconds = "" + this.notBeforeDate.getTime() / 1000L;
        allClaims.put("nbf", totalSeconds);
        String expSeconds = "" + this.expirationDate.getTime() / 1000L;
        allClaims.put("exp", expSeconds);
        return new JSONObject(allClaims).toString();
    }
}

