/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice.nonad.oracle.db;

import com.adventnet.sym.adsm.common.server.selfservice.nonad.PasswordSynchronizer;
import com.manageengine.ads.fw.iamapps.onpremise.oracle.db.OracleDBAuthentication;
import com.manageengine.ads.fw.iamapps.onpremise.oracle.db.OracleDBException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;
import org.json.JSONObject;

public class OracleDBHandler
implements PasswordSynchronizer {
    private static Logger logger = Logger.getLogger(OracleDBHandler.class.getName());
    private JSONObject host = null;
    private JSONObject status;
    private OracleDataSource oracleDataSource;
    private OracleConnection oracleConnection;
    OracleDBAuthentication oracleauth = new OracleDBAuthentication();

    public OracleDBHandler() {
        this.status = new JSONObject();
    }

    private void openConnection(JSONObject host) throws Exception {
        try {
            this.oracleDataSource = new OracleDataSource();
            this.oracleDataSource.setDriverType("thin");
            this.oracleDataSource.setNetworkProtocol("tcp");
            this.oracleDataSource.setDatabaseName((String)host.get("SCHEMA_NAME"));
            this.oracleDataSource.setServerName((String)host.get("HOST_NAME"));
            this.oracleDataSource.setPortNumber(Integer.parseInt((String)host.get("PORT_NO")));
            this.oracleDataSource.setUser((String)host.get("USER_NAME"));
            this.oracleDataSource.setPassword((String)host.get("PASSWORD"));
            this.oracleConnection = (OracleConnection)this.oracleDataSource.getConnection();
            this.oracleConnection.setAutoCommit(false);
            return;
        }
        catch (IllegalArgumentException portOutOfRange) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.port_out_range");
        }
        catch (SQLException sqle) {
            if (sqle.getMessage().contains("ORA-01017")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.invalid_credential");
            } else if (sqle.getMessage().contains("ORA-12505")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.invalid_schema_name");
            } else {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.invalid_host_port");
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Problem while connecting Oracle domain. [" + e.getMessage() + "]");
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.internal_error");
        }
        throw new OracleDBException((String)this.status.get("eSTATUS"));
    }

    private void closeConnection() throws Exception {
        try {
            this.oracleDataSource.close();
            this.oracleConnection.close();
            logger.log(Level.INFO, "Oracle connection closed.");
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Problem while closing Oracle domain. [" + e.getMessage() + "]");
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.internal_error");
        }
    }

    private JSONObject getHostInfo(JSONObject details) throws Exception {
        this.host = new JSONObject();
        this.host.put("HOST_NAME", (Object)((String)details.get("HOST_NAME")));
        this.host.put("USER_NAME", (Object)((String)details.get("USER_NAME")));
        this.host.put("PASSWORD", (Object)((String)details.get("PASSWORD")));
        if (details.has("PARAMS")) {
            JSONObject parameter = details.getJSONObject("PARAMS");
            Iterator it = parameter.keys();
            while (it.hasNext()) {
                String pName = it.next().toString();
                this.host.put(pName, (Object)((String)parameter.get(pName)));
            }
        } else {
            this.host.put("SCHEMA_NAME", (Object)((String)details.get("SCHEMA_NAME")));
            this.host.put("PORT_NO", (Object)((String)details.get("PORT_NO")));
        }
        return this.host;
    }

    @Override
    public boolean authenticate(JSONObject details) throws Exception {
        return this.oracleauth.authenticate(details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetPassword(JSONObject details) throws Exception {
        Statement st = null;
        try {
            this.openConnection(this.getHostInfo(details));
            String username = ((String)details.get("END_USER_NAME")).toUpperCase();
            String newPassword = (String)details.get("NEW_PASSWORD");
            String resetQuery = "alter user " + username + " identified by \"" + newPassword + "\"";
            st = this.oracleConnection.createStatement();
            if (st.executeUpdate(resetQuery) == 0) {
                this.oracleConnection.commit();
                logger.log(Level.INFO, "Password Reset in Oracle DB for the user: " + (String)details.get("END_USER_NAME") + " has done");
                this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.password_reset_success");
            } else {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.reset_internal_error");
            }
            this.closeConnection();
        }
        catch (SQLException sqle) {
            if (sqle.getMessage().contains("ORA-01918")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.user_not_found");
            } else if (sqle.getMessage().contains("ORA-00922")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.password_complexity_mismatch");
            } else {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.reset_internal_error");
            }
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.reset_internal_error");
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changePassword(JSONObject details) throws Exception {
        Statement st = null;
        try {
            this.openConnection(this.getHostInfo(details));
            String username = ((String)details.get("END_USER_NAME")).toUpperCase();
            String newPassword = (String)details.get("NEW_PASSWORD");
            String changeQuery = "alter user " + username + " identified by \"" + newPassword + "\"";
            st = this.oracleConnection.createStatement();
            if (st.executeUpdate(changeQuery) == 0) {
                this.oracleConnection.commit();
                logger.log(Level.INFO, "Password change in Oracle DB for the user: " + (String)details.get("END_USER_NAME") + " has done");
                this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.password_change_success");
            } else {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.change_internal_error");
            }
            st.close();
            this.closeConnection();
        }
        catch (SQLException sqle) {
            if (sqle.getMessage().contains("ORA-01918")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.user_not_found");
            } else if (sqle.getMessage().contains("ORA-00922")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.password_complexity_mismatch");
            } else {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.change_internal_error");
            }
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.change_internal_error");
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockUser(JSONObject details) throws Exception {
        Statement preStatement = null;
        Statement st = null;
        ResultSet result = null;
        try {
            this.openConnection(details);
            String username = ((String)details.get("END_USER_NAME")).toUpperCase();
            String uQuery = "select account_status from dba_users where username='" + username + "'";
            preStatement = this.oracleConnection.prepareStatement(uQuery);
            result = preStatement.executeQuery();
            if (result.next()) {
                if ("OPEN".equals(result.getString("ACCOUNT_STATUS").toUpperCase())) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.account_not_locked");
                } else {
                    String unlockQuery = "alter user " + username + " account unlock";
                    st = this.oracleConnection.createStatement();
                    if (st.executeUpdate(unlockQuery) == 0) {
                        this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.account_unlock_success");
                    } else {
                        this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.account_unlock_failed");
                    }
                }
            } else {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.user_not_found");
            }
            preStatement.close();
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.unlock.internal_error");
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
                if (preStatement != null) {
                    preStatement.close();
                }
                if (result != null) {
                    result.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean connectAccount(JSONObject details) throws Exception {
        Statement preStatement = null;
        Statement st = null;
        ResultSet result = null;
        try {
            String username = ((String)details.get("USER_NAME")).toUpperCase();
            String password = (String)details.get("PASSWORD");
            details.put("USER_NAME", (Object)((String)details.get("ADMIN_USER_NAME")));
            details.put("PASSWORD", (Object)((String)details.get("ADMIN_PASSWORD")));
            this.openConnection(this.getHostInfo(details));
            String userCheck = "select * from dba_users where username='" + username + "'";
            preStatement = this.oracleConnection.prepareStatement(userCheck);
            result = preStatement.executeQuery();
            if (result.next()) {
                String sql = "select granted_role priv from dba_role_privs where grantee='" + username + "' and granted_role ='CONNECT'";
                preStatement = this.oracleConnection.prepareStatement(sql);
                result = preStatement.executeQuery();
                this.oracleConnection.setAutoCommit(false);
                if (!result.next()) {
                    String grant = "grant connect to " + username;
                    st = this.oracleConnection.createStatement();
                    if (st.executeUpdate(grant) == 0) {
                        try {
                            OracleDataSource odsUser = new OracleDataSource();
                            odsUser.setDriverType("thin");
                            odsUser.setNetworkProtocol("tcp");
                            odsUser.setDatabaseName((String)details.get("SCHEMA_NAME"));
                            odsUser.setServerName((String)details.get("HOST_NAME"));
                            odsUser.setPortNumber(Integer.parseInt((String)details.get("PORT_NO")));
                            odsUser.setUser(username);
                            odsUser.setPassword(password);
                            OracleConnection oconUser = (OracleConnection)odsUser.getConnection();
                            if (oconUser == null) {
                                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.invalid_credential_user");
                            }
                            String revoke = "revoke connect from " + username;
                            st = this.oracleConnection.createStatement();
                            if (st.executeUpdate(revoke) == 0) {
                                this.oracleConnection.commit();
                            }
                            oconUser.close();
                            odsUser.close();
                            this.closeConnection();
                            details.put("USER_NAME", (Object)username);
                            boolean bl = true;
                            return bl;
                        }
                        catch (SQLException sqle) {
                            if (sqle.getMessage().contains("ORA-28000")) {
                                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.account_locked");
                                return true;
                            }
                            if (sqle.getMessage().contains("ORA-01017")) {
                                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.invalid_password");
                                return true;
                            }
                            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.system_unreachable");
                            return true;
                        }
                    }
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.invalid_credential_user");
                    return true;
                }
                try {
                    OracleDataSource odsUser = new OracleDataSource();
                    odsUser.setDriverType("thin");
                    odsUser.setNetworkProtocol("tcp");
                    odsUser.setDatabaseName((String)details.get("SCHEMA_NAME"));
                    odsUser.setServerName((String)details.get("HOST_NAME"));
                    odsUser.setPortNumber(Integer.parseInt((String)details.get("PORT_NO")));
                    odsUser.setUser(username);
                    odsUser.setPassword(password);
                    OracleConnection oconUser = (OracleConnection)odsUser.getConnection();
                    oconUser.close();
                    odsUser.close();
                    this.closeConnection();
                    details.put("USER_NAME", (Object)username);
                    boolean bl = true;
                    return bl;
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().contains("ORA-28000")) {
                        this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.account_locked");
                        return true;
                    }
                    if (sqle.getMessage().contains("ORA-01017")) {
                        this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.invalid_password");
                        return true;
                    }
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.system_unreachable");
                    return true;
                }
            }
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.user_not_found");
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.invalid_credential_user");
            logger.log(Level.INFO, "Problem while connecting Oracle domain. [" + e.getMessage() + "]");
            return true;
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
                if (preStatement != null) {
                    preStatement.close();
                }
                if (this.status.has("eSTATUS")) {
                    throw new OracleDBException((String)this.status.get("eSTATUS"));
                }
                if (result != null) {
                    result.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new OracleDBException((String)this.status.get("eSTATUS"));
            }
        }
        return true;
    }

    @Override
    public JSONObject getStatus() {
        try {
            if (this.status.has("eSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("eSTATUS") + "_message"));
            } else if (this.status.has("sSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("sSTATUS") + "_message"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.status;
    }
}

