/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice.nonad.oracle.ebs;

import com.adventnet.sym.adsm.common.server.selfservice.nonad.PasswordSynchronizer;
import com.manageengine.ads.fw.iamapps.onpremise.oracle.db.OracleDBException;
import com.manageengine.ads.fw.iamapps.onpremise.oracle.ebs.OracleEBSAuthentication;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;
import org.json.JSONObject;

public class OracleEBSHandler
implements PasswordSynchronizer {
    private static Logger logger = Logger.getLogger(OracleEBSHandler.class.getName());
    private JSONObject host = null;
    private JSONObject status;
    private OracleDataSource oracleDataSource;
    private OracleConnection oracleConnection;
    OracleEBSAuthentication oracleebsauth = new OracleEBSAuthentication();

    public OracleEBSHandler() {
        this.status = new JSONObject();
    }

    private void openConnection(JSONObject host) throws Exception {
        try {
            this.oracleDataSource = new OracleDataSource();
            this.oracleDataSource.setDriverType("thin");
            this.oracleDataSource.setNetworkProtocol("tcp");
            this.oracleDataSource.setDatabaseName((String)host.get("SCHEMA_NAME"));
            this.oracleDataSource.setServerName((String)host.get("HOST_NAME"));
            this.oracleDataSource.setPortNumber(Integer.parseInt((String)host.get("PORT_NO")));
            this.oracleDataSource.setUser((String)host.get("USER_NAME"));
            this.oracleDataSource.setPassword((String)host.get("PASSWORD"));
            this.oracleConnection = (OracleConnection)this.oracleDataSource.getConnection();
            return;
        }
        catch (IllegalArgumentException portOutOfRange) {
            portOutOfRange.printStackTrace();
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_db.port_out_range");
        }
        catch (SQLException sqle) {
            if (sqle.getMessage().contains("ORA-01017")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.invalid_credential");
            } else if (sqle.getMessage().contains("ORA-12505")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.invalid_schema_name");
            } else {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.invalid_host_port");
            }
            sqle.printStackTrace();
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Problem while connecting Oracle domain. [" + e.getMessage() + "]");
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.internal_error");
            e.printStackTrace();
        }
        throw new OracleDBException((String)this.status.get("eSTATUS"));
    }

    private void closeConnection() throws Exception {
        try {
            this.oracleDataSource.close();
            this.oracleConnection.close();
            logger.log(Level.INFO, "Oracle connection closed.");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.INFO, "Problem while closing Oracle domain. [" + e.getMessage() + "]");
        }
    }

    private JSONObject getHostInfo(JSONObject details) throws Exception {
        this.host = new JSONObject();
        this.host.put("HOST_NAME", (Object)((String)details.get("HOST_NAME")));
        this.host.put("USER_NAME", (Object)((String)details.get("USER_NAME")));
        this.host.put("PASSWORD", (Object)((String)details.get("PASSWORD")));
        if (details.has("PARAMS")) {
            JSONObject parameter = details.getJSONObject("PARAMS");
            Iterator it = parameter.keys();
            while (it.hasNext()) {
                String pName = it.next().toString();
                this.host.put(pName, (Object)((String)parameter.get(pName)));
            }
        } else {
            this.host.put("SCHEMA_NAME", (Object)((String)details.get("SCHEMA_NAME")));
            this.host.put("PORT_NO", (Object)((String)details.get("PORT_NO")));
        }
        return this.host;
    }

    @Override
    public boolean authenticate(JSONObject details) throws Exception {
        return this.oracleebsauth.authenticate(details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetPassword(JSONObject details) throws Exception {
        try {
            this.openConnection(this.getHostInfo(details));
            String username = ((String)details.get("END_USER_NAME")).toUpperCase();
            String newPassword = (String)details.get("NEW_PASSWORD");
            String call = "declare x BOOLEAN; y varchar2(2); begin x := apps.FND_USER_PKG.changePassword(?,?); if x !=TRUE then y := 'N'; else y :='Y'; end if; ? := y; end;";
            CallableStatement cstmt = this.oracleConnection.prepareCall(call);
            cstmt.registerOutParameter(3, 12);
            cstmt.setString(1, username.toUpperCase());
            cstmt.setString(2, newPassword);
            cstmt.executeUpdate();
            if (cstmt.getString(3).equalsIgnoreCase("Y")) {
                this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.password_reset_success");
            } else {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.password_reset_failure");
            }
            cstmt.close();
            this.closeConnection();
        }
        catch (SQLException sqle) {
            if (sqle.getMessage().contains("ORA-01918")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.user_not_found");
            } else if (sqle.getMessage().contains("ORA-00922")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.password_complexity_mismatch");
            } else {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.reset_internal_error");
            }
            sqle.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.reset_internal_error");
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changePassword(JSONObject details) throws Exception {
        try {
            this.openConnection(this.getHostInfo(details));
            String username = ((String)details.get("END_USER_NAME")).toUpperCase();
            String newPassword = (String)details.get("NEW_PASSWORD");
            String call = "declare x BOOLEAN; y varchar2(2); begin x := apps.FND_USER_PKG.changePassword(?,?); if x !=TRUE then y := 'N'; else y :='Y'; end if; ? := y; end;";
            CallableStatement cstmt = this.oracleConnection.prepareCall(call);
            cstmt.registerOutParameter(3, 12);
            cstmt.setString(1, username.toUpperCase());
            cstmt.setString(2, newPassword);
            cstmt.executeUpdate();
            if (cstmt.getString(3).equalsIgnoreCase("Y")) {
                this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.password_change_success");
            } else {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.password_change_failure");
            }
            cstmt.close();
            this.closeConnection();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            if (sqle.getMessage().contains("ORA-01918")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.user_not_found");
            } else if (sqle.getMessage().contains("ORA-00922")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.password_complexity_mismatch");
            } else {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.change_internal_error");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.change_internal_error");
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockUser(JSONObject details) throws Exception {
        try {
            this.openConnection(details);
            String username = ((String)details.get("END_USER_NAME")).toUpperCase();
            String call = "declare x BOOLEAN; y varchar2(2);begin x := apps.FND_USER_PKG.EnableUser (?); if x then y := 'S'; else y :='N'; end if; ? := y;end;";
            CallableStatement cstmt = this.oracleConnection.prepareCall(call);
            cstmt.registerOutParameter(2, 12);
            cstmt.setString(1, username.toUpperCase());
            cstmt.executeUpdate();
            if (cstmt.getString(2).equalsIgnoreCase("S")) {
                this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.unlock_success");
            } else {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.unlock_failure");
            }
            cstmt.close();
            this.closeConnection();
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            if (sqle.getMessage().contains("ORA-01918")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.user_not_found");
            } else {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.account_unlock_failed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.account_unlock_failed");
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connectAccount(JSONObject details) throws Exception {
        try {
            JSONObject conDetails = new JSONObject();
            conDetails.put("USER_NAME", (Object)((String)details.get("ADMIN_USER_NAME")));
            conDetails.put("PASSWORD", (Object)((String)details.get("ADMIN_PASSWORD")));
            conDetails.put("SCHEMA_NAME", (Object)((String)details.get("SCHEMA_NAME")));
            conDetails.put("HOST_NAME", (Object)((String)details.get("HOST_NAME")));
            conDetails.put("PORT_NO", (Object)((String)details.get("PORT_NO")));
            String username = ((String)details.get("USER_NAME")).toUpperCase();
            String password = (String)details.get("PASSWORD");
            this.openConnection(this.getHostInfo(conDetails));
            if (!username.equals("") && !password.equals("")) {
                String call = "declare x BOOLEAN; y varchar2(2);begin  y:= apps.fnd_web_sec.validate_login(?,?); ? := y;end;";
                CallableStatement cstmt = this.oracleConnection.prepareCall(call);
                cstmt.registerOutParameter(3, 12);
                cstmt.setString(1, username.toUpperCase());
                cstmt.setString(2, password);
                cstmt.executeUpdate();
                if (cstmt.getString(3).equalsIgnoreCase("Y")) {
                    this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.acc_linked");
                    boolean bl = true;
                    return bl;
                }
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.invalid_credential");
                cstmt.close();
                this.closeConnection();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.oracle_ebs.invalid_credential");
        }
        finally {
            this.closeConnection();
        }
        throw new OracleDBException((String)this.status.get("eSTATUS"));
    }

    @Override
    public JSONObject getStatus() {
        try {
            if (this.status.has("eSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("eSTATUS") + "_message"));
            } else if (this.status.has("sSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("sSTATUS") + "_message"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.status;
    }
}

