/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice.nonad.salesforce;

import com.adventnet.sym.adsm.common.server.selfservice.nonad.PasswordSynchronizer;
import com.adventnet.sym.adsm.common.server.util.ServerUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.manageengine.ads.fw.api.RestAPI;
import com.manageengine.ads.fw.iamapps.cloud.salesforce.SalesForceException;
import com.manageengine.ads.fw.iamapps.cloud.salesforce.SalesforceAuthentication;
import com.manageengine.ads.fw.util.ADSErrorHandler;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SalesForceHandler
implements PasswordSynchronizer {
    private static Logger logger = Logger.getLogger(SalesForceHandler.class.getName());
    private final RestAPI apiHandler = new RestAPI();
    private JSONObject host = null;
    private JSONObject status;
    public static String accessToken;
    public static String instanceURL;
    SalesforceAuthentication sauth = new SalesforceAuthentication();

    public SalesForceHandler() {
        this.status = new JSONObject();
    }

    public void setProxySettings() throws Exception {
        try {
            Properties proxySettings = ServerUtil.getProxySettings();
            if (!proxySettings.isEmpty()) {
                String serverName = proxySettings.getProperty("SERVER_NAME");
                String port = proxySettings.getProperty("PORT");
                String userName = proxySettings.getProperty("USER_NAME");
                String password = proxySettings.getProperty("PASSWORD");
                System.getProperties().put("https.proxyHost", serverName);
                System.getProperties().put("https.proxyPort", port);
                System.getProperties().put("https.proxyUser", userName);
                System.getProperties().put("https.proxyPassword", password);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.salesforce.proxy_error_details");
        }
    }

    void openConnection(JSONObject host) throws Exception {
        try {
            this.host = host;
            String response = "";
            String clientId = (String)host.get("CLIENT_ID");
            String clientSecret = (String)host.get("CLIENT_SECRET");
            String email = (String)host.get("USER_NAME");
            String password = (String)host.get("PASSWORD") + host.getString("SECURITY_KEY");
            System.setProperty("https.protocols", "TLSv1,TLSv1.1,TLSv1.2");
            String endPoint = "https://login.salesforce.com/services/oauth2/token";
            Properties sForceDetails = new Properties();
            sForceDetails.put("url", endPoint);
            sForceDetails.put("method", "post");
            sForceDetails.put("grant_type", "password");
            sForceDetails.put("client_id", clientId);
            sForceDetails.put("client_secret", clientSecret);
            sForceDetails.put("username", email);
            sForceDetails.put("password", password);
            sForceDetails.put("IS_EXTERNAL_API", (Object)true);
            try {
                this.apiHandler.execute(new StringBuilder(endPoint), sForceDetails);
                response = this.apiHandler.getResponseText();
                logger.log(Level.INFO, "Response from Salesforce API - " + response + " url " + endPoint);
            }
            catch (ServletException e) {
                e.printStackTrace();
                this.status.put("eSTATUS", (Object)ADSErrorHandler.getFormattedError((String)"00029"));
            }
            if (response.contains("invalid") || response.contains("expired")) {
                logger.log(Level.INFO, "Invalid grant (or) token");
                this.status.put("eSTATUS", (Object)ADSErrorHandler.getFormattedError((String)"00029"));
            } else if (!response.contains("access_token")) {
                this.status.put("eSTATUS", (Object)ADSErrorHandler.getFormattedError((String)"00029"));
            }
            accessToken = this.getTokenInfo(response, "access_token");
            instanceURL = this.getTokenInfo(response, "instance_url");
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.status.put("eSTATUS", (Object)ADSErrorHandler.getFormattedError((String)"00029"));
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
            throw new SalesForceException((String)this.status.get("eSTATUS"));
        }
    }

    private JSONObject getHostInfo(JSONObject details) throws Exception {
        this.host = new JSONObject();
        this.host.put("USER_NAME", (Object)((String)details.get("USER_NAME")));
        this.host.put("PASSWORD", (Object)((String)details.get("PASSWORD")));
        if (details.has("PARAMS")) {
            JSONObject parameter = details.getJSONObject("PARAMS");
            Iterator it = parameter.keys();
            while (it.hasNext()) {
                String pName = it.next().toString();
                this.host.put(pName, (Object)((String)parameter.get(pName)));
            }
        } else {
            this.host.put("SECURITY_KEY", (Object)((String)details.get("SECURITY_KEY")));
            this.host.put("CLIENT_ID", (Object)((String)details.get("CLIENT_ID")));
            this.host.put("CLIENT_SECRET", (Object)((String)details.get("CLIENT_SECRET")));
        }
        return this.host;
    }

    @Override
    public boolean authenticate(JSONObject details) throws Exception {
        return this.sauth.authenticate(details);
    }

    private String getUserName(String userName, String domain) {
        if (!StrUtil.isValidEmailID(userName)) {
            userName = userName.trim() + "@" + domain.trim();
        }
        return userName.trim();
    }

    @Override
    public void resetPassword(JSONObject details) throws Exception {
        try {
            JSONArray response;
            String userName = this.getUserName((String)details.get("END_USER_NAME"), (String)details.get("HOST_NAME"));
            String userId = this.getUserId(userName, details);
            if (userId == null) {
                userId = "";
            }
            String userNewPassword = details.getString("NEW_PASSWORD");
            JSONObject update = new JSONObject();
            update.put("NewPassword", (Object)userNewPassword);
            Properties sForceHeader = new Properties();
            sForceHeader.put("Authorization", "OAuth " + accessToken);
            sForceHeader.put("Content-Type", "application/json");
            String endPoint = instanceURL + "/services/data/v25.0/sobjects/User/" + userId + "/password";
            Properties sForceDetails = new Properties();
            sForceDetails.put("url", endPoint);
            sForceDetails.put("method", "post");
            sForceDetails.put("header", sForceHeader);
            sForceDetails.put("rawPayLoad", update.toString());
            sForceDetails.put("IS_EXTERNAL_API", (Object)true);
            try {
                this.apiHandler.execute(new StringBuilder(endPoint), sForceDetails);
                response = new JSONArray(this.apiHandler.getResponseText());
                logger.log(Level.INFO, "Response from Salesforce API - " + response + " url " + endPoint);
            }
            catch (Exception e) {
                response = new JSONArray();
            }
            JSONObject result = new JSONObject();
            if (response.length() >= 1) {
                result = response.getJSONObject(0);
            }
            if (result.has("errorCode")) {
                String errorCode = result.getString("errorCode");
                if (errorCode.equals("NOT_FOUND")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.salesforce.user_not_found");
                } else if (errorCode.equals("INVALID_NEW_PASSWORD")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.salesforce.complexity_mismatch");
                } else if (errorCode.equals("INVALID_SESSION_ID")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.salesforce.inactive_account");
                } else if (errorCode.equals("UNKNOWN_EXCEPTION") && result.getString("message").contains("repeated")) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.salesforce.invalid_old_password");
                } else {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.salesforce.reset.internal_error");
                }
            } else {
                this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.salesforce.password_reset_success");
            }
        }
        catch (Exception ce) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.salesforce.reset.internal_error");
            ce.printStackTrace();
        }
    }

    public String getUserId(String userEmail, JSONObject details) throws Exception {
        String userId = null;
        try {
            this.openConnection(this.getHostInfo(details));
            String userName = this.getUserName((String)details.get("END_USER_NAME"), (String)details.get("HOST_NAME"));
            Properties sForceHeader = new Properties();
            sForceHeader.put("Authorization", "OAuth " + accessToken);
            String url = instanceURL + "/services/data/v30.0/query";
            Properties sForceDetails = new Properties();
            sForceDetails.put("url", url);
            sForceDetails.put("method", "get");
            sForceDetails.put("header", sForceHeader);
            sForceDetails.put("q", "SELECT Name,Id,LastName,FirstName,Department,Username,AccountId,SmallPhotoUrl,Country,CompanyName,IsActive,MobilePhone,PostalCode,State,Street,City,Email,Alias,Phone from User");
            sForceDetails.put("IS_EXTERNAL_API", (Object)true);
            this.apiHandler.execute(new StringBuilder(url), sForceDetails);
            String response = this.apiHandler.getResponseText();
            logger.log(Level.INFO, "Response from Salesforce API - " + response + " url " + url);
            JSONObject temp = new JSONObject(response);
            JSONArray authResponse = new JSONArray(temp.getString("records"));
            for (int i = 0; i < authResponse.length(); ++i) {
                JSONObject user = authResponse.getJSONObject(i);
                String sfUserName = user.getString("Username");
                if (!sfUserName.equals(userName)) continue;
                userId = user.getString("Id");
                break;
            }
            logger.log(Level.INFO, "Getting user ID for " + userEmail + "ID is " + userId);
            return userId;
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.salesforce.reset.internal_error");
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
            throw new SalesForceException((String)this.status.get("eSTATUS"));
        }
    }

    @Override
    public void changePassword(JSONObject details) throws Exception {
        this.resetPassword(details);
    }

    @Override
    public boolean connectAccount(JSONObject details) throws Exception {
        try {
            this.setProxySettings();
            this.host = details;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.salesforce.invalid_credential");
            throw new SalesForceException((String)this.status.get("eSTATUS"));
        }
    }

    @Override
    public void unlockUser(JSONObject details) throws Exception {
    }

    @Override
    public JSONObject getStatus() {
        try {
            if (this.status.has("eSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("eSTATUS") + "_message"));
            } else if (this.status.has("sSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("sSTATUS") + "_message"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.status;
    }

    String getTokenInfo(String response, String info) throws JSONException {
        JSONObject httpResponse = new JSONObject(response);
        return httpResponse.getString(info);
    }
}

