/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice.nonad.servicenow;

import com.adventnet.sym.adsm.common.server.selfservice.nonad.PasswordSynchronizer;
import com.adventnet.sym.adsm.common.server.util.ServerUtil;
import com.manageengine.ads.fw.util.ADSErrorHandler;
import com.ning.http.util.Base64;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class ServiceNowHandler
implements PasswordSynchronizer {
    private static Logger logger = Logger.getLogger(ServiceNowHandler.class.getName());
    static JSONObject QUERY_PARAMS;
    static String[] SYSPARM_FIELDS;
    static String SYSPARM_QUERY;
    static boolean SYSPARM_INPUT_DISPLAY_VALUE;
    String errorstat = "config";
    String id;
    String lockout_flag;
    String url;
    JSONObject status = new JSONObject();
    HttpURLConnection urlConnection;

    public void setProxySettings() throws Exception {
        try {
            Properties proxySettings = ServerUtil.getProxySettings();
            if (!proxySettings.isEmpty()) {
                String serverName = proxySettings.getProperty("SERVER_NAME");
                String port = proxySettings.getProperty("PORT");
                String userName = proxySettings.getProperty("USER_NAME");
                String password = proxySettings.getProperty("PASSWORD");
                System.getProperties().put("https.proxyHost", serverName);
                System.getProperties().put("https.proxyPort", port);
                System.getProperties().put("https.proxyUser", userName);
                System.getProperties().put("https.proxyPassword", password);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error in proxy setting(Service Now). " + e.getMessage());
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.servicenow.proxy_error");
        }
    }

    public String getServiceNowURL(String domain) {
        return "https://" + domain + ".service-now.com/api/now/table/sys_user";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passwordOps(JSONObject details) throws Exception {
        try (FilterOutputStream wr = null;){
            if (this.authenticate(details)) {
                this.status = new JSONObject();
                String username = (String)details.get("USER_NAME");
                String adminpass = (String)details.get("PASSWORD");
                String enduser = (String)details.get("END_USER_NAME");
                String password = (String)details.get("NEW_PASSWORD");
                String domain = (String)details.get("HOST_NAME");
                String userpass = username + ":" + adminpass;
                JSONObject data = new JSONObject();
                String authencode = "Basic " + new String(Base64.encode((byte[])userpass.getBytes()));
                data.put("user_password", (Object)password);
                this.urlConnection = (HttpURLConnection)new URL(this.getServiceNowURL(domain) + "/" + this.id + "?" + QUERY_PARAMS.getString("sysparm_fields") + "&" + QUERY_PARAMS.getString("sysparm_input_display_value")).openConnection();
                this.urlConnection.setRequestProperty("X-HTTP-Method-Override", "PATCH");
                this.urlConnection.setRequestMethod("POST");
                this.urlConnection.setRequestProperty("Content-Type", "application/json");
                this.urlConnection.setRequestProperty("charset", "utf-8");
                this.urlConnection.setRequestProperty("Authorization", authencode);
                this.urlConnection.setDoOutput(true);
                wr = new DataOutputStream(this.urlConnection.getOutputStream());
                ((DataOutputStream)wr).writeBytes(data.toString());
                ((DataOutputStream)wr).flush();
                BufferedReader in = new BufferedReader(new InputStreamReader(this.urlConnection.getInputStream()));
                String responseBody = in.readLine();
                in.close();
                this.status.put("sSTATUS", (Object)("adssp.nonad.pwdsync.servicenow." + this.errorstat + "_success"));
            }
        }
    }

    @Override
    public boolean connectAccount(JSONObject details) throws Exception {
        this.errorstat = "config";
        try {
            String username = (String)details.get("USER_NAME");
            String adminpass = (String)details.get("PASSWORD");
            String domain = (String)details.get("HOST_NAME");
            String query_username = username;
            String userpass = username + ":" + adminpass;
            String authencode = "Basic " + new String(Base64.encode((byte[])userpass.getBytes()));
            this.setProxySettings();
            query_username = URLEncoder.encode(query_username, "UTF-8");
            this.urlConnection = (HttpURLConnection)new URL(this.getServiceNowURL(domain) + "?" + QUERY_PARAMS.getString("sysparm_query") + query_username + "&" + QUERY_PARAMS.getString("sysparm_fields")).openConnection();
            this.urlConnection.setRequestMethod("GET");
            this.urlConnection.setRequestProperty("Authorization", authencode);
            int response_code = this.urlConnection.getResponseCode();
            if (response_code == 401) {
                this.status.put("eSTATUS", (Object)ADSErrorHandler.getFormattedError((String)"00007"));
            } else if (response_code == 200) {
                BufferedReader in = new BufferedReader(new InputStreamReader(this.urlConnection.getInputStream()));
                String responseBody = in.readLine();
                JSONObject response = (JSONObject)new JSONTokener(responseBody).nextValue();
                if (response.has("result")) {
                    JSONArray result = (JSONArray)response.get("result");
                    if (result.length() == 0) {
                        this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.servicenow.username_not_found");
                        return false;
                    }
                    return true;
                }
                if (response.has("error")) {
                    logger.log(Level.INFO, "Service Now Error Response. " + response.toString());
                    this.status.put("eSTATUS", (Object)ADSErrorHandler.getFormattedError((String)"00007"));
                }
            }
        }
        catch (UnknownHostException u) {
            logger.log(Level.INFO, "Connection Error in Service Now. " + u.getMessage());
            this.status.put("eSTATUS", (Object)("adssp.nonad.pwdsync.servicenow." + this.errorstat + "_connection_error"));
        }
        catch (NoRouteToHostException n) {
            logger.log(Level.INFO, "Connection Error(Route) in Service Now. [" + n.getMessage() + "]");
            this.status.put("eSTATUS", (Object)("adssp.nonad.pwdsync.servicenow." + this.errorstat + "_connection_error"));
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error in Service Now. [" + e.getMessage() + "]");
            this.status.put("eSTATUS", (Object)("adssp.nonad.pwdsync.servicenow." + this.errorstat + "_internal_error"));
        }
        throw new Exception((String)this.status.get("eSTATUS"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean authenticate(JSONObject details) throws Exception {
        try {
            String username = (String)details.get("USER_NAME");
            String adminpass = (String)details.get("PASSWORD");
            String domain = (String)details.get("HOST_NAME");
            String query_username = username;
            String userpass = username + ":" + adminpass;
            String authencode = "Basic " + new String(Base64.encode((byte[])userpass.getBytes()));
            this.setProxySettings();
            if (details.has("END_USER_NAME")) {
                query_username = (String)details.get("END_USER_NAME");
            }
            query_username = URLEncoder.encode(query_username, "UTF-8");
            this.urlConnection = (HttpURLConnection)new URL(this.getServiceNowURL(domain) + "?" + QUERY_PARAMS.getString("sysparm_query") + query_username + "&" + QUERY_PARAMS.getString("sysparm_fields")).openConnection();
            this.urlConnection.setRequestMethod("GET");
            this.urlConnection.setRequestProperty("Authorization", authencode);
            int response_code = this.urlConnection.getResponseCode();
            if (response_code == 401) {
                this.status.put("eSTATUS", (Object)ADSErrorHandler.getFormattedError((String)"00007"));
                throw new Exception((String)this.status.get("eSTATUS"));
            }
            if (response_code != 200) throw new Exception((String)this.status.get("eSTATUS"));
            BufferedReader in = new BufferedReader(new InputStreamReader(this.urlConnection.getInputStream()));
            String responseBody = in.readLine();
            JSONObject response = (JSONObject)new JSONTokener(responseBody).nextValue();
            if (!response.has("result")) {
                if (!response.has("error")) throw new Exception((String)this.status.get("eSTATUS"));
                logger.log(Level.INFO, "Service Now Error Response. " + response.toString());
                this.status.put("eSTATUS", (Object)ADSErrorHandler.getFormattedError((String)"00007"));
                throw new Exception((String)this.status.get("eSTATUS"));
            }
            JSONArray result = (JSONArray)response.get("result");
            if (result.length() == 0) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.servicenow.username_not_found");
                return false;
            }
            this.id = (String)((JSONObject)result.get(0)).get("sys_id");
            if (((JSONObject)result.get(0)).has("user_password") && ((JSONObject)result.get(0)).has("locked_out")) {
                this.lockout_flag = (String)((JSONObject)result.get(0)).get("locked_out");
                this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.servicenow.config_all");
                return true;
            }
            if (((JSONObject)result.get(0)).has("user_password")) {
                if (this.errorstat.contains("lockout")) {
                    this.status.put("eSTATUS", (Object)("adssp.nonad.pwdsync.servicenow.unauthorized_" + this.errorstat));
                    throw new Exception((String)this.status.get("eSTATUS"));
                }
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.servicenow.config_password_sync");
                return true;
            }
            if (!((JSONObject)result.get(0)).has("locked_out")) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.servicenow.user_unauthorized");
                throw new Exception((String)this.status.get("eSTATUS"));
            }
            this.lockout_flag = (String)((JSONObject)result.get(0)).get("locked_out");
            if (this.errorstat.contains("password")) {
                this.status.put("eSTATUS", (Object)("adssp.nonad.pwdsync.servicenow.unauthorized_" + this.errorstat));
                throw new Exception((String)this.status.get("eSTATUS"));
            }
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.servicenow.config_account_unlock");
            return true;
        }
        catch (UnknownHostException u) {
            logger.log(Level.INFO, "Connection Error in Service Now. " + u.getMessage());
            this.status.put("eSTATUS", (Object)("adssp.nonad.pwdsync.servicenow." + this.errorstat + "_connection_error"));
            throw new Exception((String)this.status.get("eSTATUS"));
        }
        catch (NoRouteToHostException n) {
            logger.log(Level.INFO, "Connection Error(Route) in Service Now. [" + n.getMessage() + "]");
            this.status.put("eSTATUS", (Object)("adssp.nonad.pwdsync.servicenow." + this.errorstat + "_connection_error"));
            throw new Exception((String)this.status.get("eSTATUS"));
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error in Service Now. [" + e.getMessage() + "]");
            this.status.put("eSTATUS", (Object)("adssp.nonad.pwdsync.servicenow." + this.errorstat + "_internal_error"));
        }
        throw new Exception((String)this.status.get("eSTATUS"));
    }

    @Override
    public void changePassword(JSONObject details) throws Exception {
        this.errorstat = "password_change";
        this.passwordOps(details);
    }

    @Override
    public void resetPassword(JSONObject details) throws Exception {
        this.errorstat = "password_reset";
        this.passwordOps(details);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockUser(JSONObject details) throws Exception {
        try (FilterOutputStream wr = null;){
            this.errorstat = "lockout";
            if (this.authenticate(details)) {
                this.status = new JSONObject();
                if (this.lockout_flag.equals("true")) {
                    String username = (String)details.get("USER_NAME");
                    String adminpass = (String)details.get("PASSWORD");
                    String enduser = (String)details.get("END_USER_NAME");
                    String domain = (String)details.get("HOST_NAME");
                    String userpass = username + ":" + adminpass;
                    JSONObject data = new JSONObject();
                    String authencode = "Basic " + new String(Base64.encode((byte[])userpass.getBytes()));
                    data.put("locked_out", (Object)"false");
                    this.urlConnection = (HttpURLConnection)new URL(this.getServiceNowURL(domain) + "/" + this.id + "?" + QUERY_PARAMS.getString("sysparm_fields") + "&" + QUERY_PARAMS.getString("sysparm_input_display_value")).openConnection();
                    this.urlConnection.setRequestProperty("X-HTTP-Method-Override", "PATCH");
                    this.urlConnection.setRequestMethod("POST");
                    this.urlConnection.setRequestProperty("Content-Type", "application/json");
                    this.urlConnection.setRequestProperty("charset", "utf-8");
                    this.urlConnection.setRequestProperty("Authorization", authencode);
                    this.urlConnection.setDoOutput(true);
                    wr = new DataOutputStream(this.urlConnection.getOutputStream());
                    ((DataOutputStream)wr).writeBytes(data.toString());
                    ((DataOutputStream)wr).flush();
                    BufferedReader in = new BufferedReader(new InputStreamReader(this.urlConnection.getInputStream()));
                    String responseBody = in.readLine();
                    in.close();
                    this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.servicenow.lockout_success");
                } else {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.servicenow.lockout_off");
                }
            }
        }
    }

    @Override
    public JSONObject getStatus() {
        try {
            if (this.status.has("eSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", this.status.get("eSTATUS"));
            } else if (this.status.has("sSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", this.status.get("sSTATUS"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.status;
    }

    static {
        SYSPARM_FIELDS = new String[]{"sys_id", "user_password", "locked_out"};
        SYSPARM_QUERY = "user_name";
        SYSPARM_INPUT_DISPLAY_VALUE = true;
        try {
            String fields = new String();
            QUERY_PARAMS = new JSONObject();
            QUERY_PARAMS.put("sysparm_query", (Object)("sysparm_query=" + SYSPARM_QUERY + "="));
            QUERY_PARAMS.put("sysparm_input_display_value", (Object)("sysparm_input_display_value=" + SYSPARM_INPUT_DISPLAY_VALUE));
            for (String s : SYSPARM_FIELDS) {
                fields = fields + s + ",";
            }
            QUERY_PARAMS.put("sysparm_fields", (Object)("sysparm_fields=" + fields));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

