/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice.nonad.zendesk;

import com.adventnet.sym.adsm.common.server.selfservice.nonad.PasswordSynchronizer;
import com.adventnet.sym.adsm.common.server.util.ServerUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.manageengine.ads.fw.iamapps.cloud.zendesk.ZendeskAuthentication;
import com.manageengine.ads.fw.iamapps.cloud.zendesk.ZendeskException;
import com.ning.http.util.Base64;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class ZendeskHandler
implements PasswordSynchronizer {
    ZendeskAuthentication zauth = new ZendeskAuthentication();
    private static Logger logger = Logger.getLogger(ZendeskHandler.class.getName());
    private JSONObject host = null;
    private JSONObject status = new JSONObject();
    URL url;
    HttpURLConnection huc;
    private String domain;
    private String email;
    private String domainName;
    private String stringUrl;
    int start;
    int end;
    int userId;

    public void setProxySettings() throws Exception {
        try {
            Properties proxySettings = ServerUtil.getProxySettings();
            if (!proxySettings.isEmpty()) {
                String serverName = proxySettings.getProperty("SERVER_NAME");
                String port = proxySettings.getProperty("PORT");
                String userName = proxySettings.getProperty("USER_NAME");
                String password = proxySettings.getProperty("PASSWORD");
                System.getProperties().put("https.proxyHost", serverName);
                System.getProperties().put("https.proxyPort", port);
                System.getProperties().put("https.proxyUser", userName);
                System.getProperties().put("https.proxyPassword", password);
            }
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.proxy_error");
        }
    }

    public String getUserName(String mail, String domain) {
        if (!StrUtil.isValidEmailID(mail)) {
            mail = mail + "@" + domain;
        }
        return mail;
    }

    private void openConnection(JSONObject host) throws Exception {
        try {
            String inputLine;
            this.setProxySettings();
            this.host = host;
            this.domain = (String)host.get("HOST_NAME");
            this.email = (String)host.get("USER_NAME");
            String admin_pass = (String)host.get("PASSWORD");
            this.start = this.domain.startsWith("https") ? 8 : 0;
            if (this.domain.endsWith("zendesk.com")) {
                this.end = this.domain.indexOf(".zendesk");
                this.domainName = this.domain.substring(this.start, this.end);
            } else {
                this.domainName = this.domain;
            }
            this.email = this.getUserName(this.email, this.domainName);
            this.stringUrl = "https://" + this.domainName + ".zendesk.com/api/v2/groups.json?";
            this.url = new URL(this.stringUrl);
            this.huc = (HttpURLConnection)this.url.openConnection();
            String userpass = this.email + ":" + admin_pass;
            String basicAuth = "Basic " + new String(Base64.encode((byte[])userpass.getBytes()));
            this.huc.setRequestProperty("Authorization", basicAuth);
            BufferedReader in = new BufferedReader(new InputStreamReader(this.huc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                int s = inputLine.indexOf("id");
                int e = inputLine.indexOf(",", s + 4);
                String uId = inputLine.substring(s + 4, e);
                this.userId = Integer.parseInt(uId);
            }
            in.close();
            return;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(ZendeskHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException fe) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.error_in_domain_name");
        }
        catch (NumberFormatException nf) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.error_in_username_or_password");
        }
        catch (IOException ie) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.access_denied");
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Problem while connecting zendesk domain. [" + e.getMessage() + "]");
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.internal_error");
        }
    }

    private void closeConnection() throws Exception {
        try {
            this.huc.disconnect();
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Problem while closing zendesk domain. [" + e.getMessage() + "]");
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.internal_error");
        }
    }

    @Override
    public boolean authenticate(JSONObject details) throws Exception {
        try {
            this.zauth.authenticate(details);
            return true;
        }
        catch (Exception e) {
            throw new ZendeskException("adssp.nonad.pwdsync.zendesk.internal_error");
        }
    }

    private JSONObject getHostInfo(JSONObject details) throws Exception {
        this.host = new JSONObject();
        this.host.put("HOST_NAME", (Object)((String)details.get("HOST_NAME")));
        this.host.put("USER_NAME", (Object)((String)details.get("USER_NAME")));
        this.host.put("PASSWORD", (Object)((String)details.get("PASSWORD")));
        return this.host;
    }

    public int getUserId(JSONObject details) throws Exception {
        this.host = details;
        this.domain = (String)this.host.get("HOST_NAME");
        this.email = (String)this.host.get("USER_NAME");
        String admin_pass = (String)this.host.get("PASSWORD");
        String userName = (String)this.host.get("END_USER_NAME");
        this.start = this.domain.startsWith("https") ? 8 : 0;
        if (this.domain.endsWith("zendesk.com")) {
            this.end = this.domain.indexOf(".zendesk");
            this.domainName = this.domain.substring(this.start, this.end);
        } else {
            this.domainName = this.domain;
        }
        this.email = this.getUserName(this.email, this.domainName);
        userName = this.getUserName(userName, this.domainName);
        userName = URLEncoder.encode(userName, "UTF-8");
        this.stringUrl = "https://" + this.domainName + ".zendesk.com/api/v2/users/search.json?query=" + userName;
        try {
            String inputLine;
            this.url = new URL(this.stringUrl);
            HttpURLConnection uc = (HttpURLConnection)this.url.openConnection();
            String userpass = this.email + ":" + admin_pass;
            String basicAuth = "Basic " + new String(Base64.encode((byte[])userpass.getBytes()));
            uc.setRequestProperty("Authorization", basicAuth);
            BufferedReader in = new BufferedReader(new InputStreamReader(uc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                int s = inputLine.indexOf("id");
                int e = inputLine.indexOf(",", s + 4);
                String uId = inputLine.substring(s + 4, e);
                this.userId = Integer.parseInt(uId);
            }
            in.close();
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(ZendeskHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(ZendeskHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this.userId;
    }

    @Override
    public void resetPassword(JSONObject details) throws Exception {
        block11: {
            try {
                this.openConnection(details);
                try {
                    this.userId = this.getUserId(details);
                    this.host = details;
                    String password = (String)this.host.get("NEW_PASSWORD");
                    this.domain = (String)this.host.get("HOST_NAME");
                    this.email = (String)this.host.get("USER_NAME");
                    String admin_pass = (String)this.host.get("PASSWORD");
                    String userName = (String)this.host.get("END_USER_NAME");
                    this.start = this.domain.startsWith("https") ? 8 : 0;
                    if (this.domain.endsWith("zendesk.com")) {
                        this.end = this.domain.indexOf(".zendesk");
                        this.domainName = this.domain.substring(this.start, this.end);
                    } else {
                        this.domainName = this.domain;
                    }
                    this.email = this.getUserName(this.email, this.domainName);
                    userName = this.getUserName(userName, this.domainName);
                    password = URLEncoder.encode(password, "UTF-8");
                    this.stringUrl = "https://" + this.domainName + ".zendesk.com/api/v2/users/" + this.userId + "/password.json?password=" + password;
                    this.url = new URL(this.stringUrl);
                    HttpURLConnection uc = (HttpURLConnection)this.url.openConnection();
                    uc.setRequestMethod("POST");
                    String userpass = this.email + ":" + admin_pass;
                    String basicAuth = "Basic " + new String(Base64.encode((byte[])userpass.getBytes()));
                    uc.setRequestProperty("Authorization", basicAuth);
                    uc.setDoOutput(true);
                    int responseCode = uc.getResponseCode();
                    if (responseCode == 200) {
                        logger.log(Level.INFO, "Password reset in zendesk App for the user: " + (String)this.host.get("END_USER_NAME") + " has done");
                        this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.password_reset_success");
                        break block11;
                    }
                    if (responseCode == 422) {
                        this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.invalid_password_txt");
                        break block11;
                    }
                    if (responseCode == 404) {
                        this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.account_expired");
                        break block11;
                    }
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.reset_internal_error");
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(ZendeskHandler.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (NumberFormatException nfe) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.username_not_found");
                }
                catch (Exception e) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.reset_internal_error");
                }
            }
            catch (Exception e) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.network_error");
            }
        }
    }

    @Override
    public void changePassword(JSONObject details) throws Exception {
        block10: {
            try {
                this.openConnection(details);
                try {
                    this.userId = this.getUserId(details);
                    this.host = details;
                    String password = (String)this.host.get("NEW_PASSWORD");
                    this.domain = (String)this.host.get("HOST_NAME");
                    this.email = (String)this.host.get("USER_NAME");
                    String admin_pass = (String)this.host.get("PASSWORD");
                    String userName = (String)this.host.get("END_USER_NAME");
                    this.start = this.domain.startsWith("https") ? 8 : 0;
                    if (this.domain.endsWith("zendesk.com")) {
                        this.end = this.domain.indexOf(".zendesk");
                        this.domainName = this.domain.substring(this.start, this.end);
                    } else {
                        this.domainName = this.domain;
                    }
                    this.email = this.getUserName(this.email, this.domainName);
                    userName = this.getUserName(userName, this.domainName);
                    password = URLEncoder.encode(password, "UTF-8");
                    this.stringUrl = "https://" + this.domainName + ".zendesk.com/api/v2/users/" + this.userId + "/password.json?password=" + password;
                    this.url = new URL(this.stringUrl);
                    HttpURLConnection uc = (HttpURLConnection)this.url.openConnection();
                    uc.setRequestMethod("POST");
                    String userpass = this.email + ":" + admin_pass;
                    String basicAuth = "Basic " + new String(Base64.encode((byte[])userpass.getBytes()));
                    uc.setRequestProperty("Authorization", basicAuth);
                    uc.setDoOutput(true);
                    int responseCode = uc.getResponseCode();
                    if (responseCode == 200) {
                        logger.log(Level.INFO, "Password change in zendesk App for the user: " + (String)this.host.get("END_USER_NAME") + " has done");
                        this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.password_change_success");
                        break block10;
                    }
                    if (responseCode == 422) {
                        this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.invalid_password_txt");
                        break block10;
                    }
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.change_internal_error");
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(ZendeskHandler.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (NumberFormatException nfe) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.username_not_found");
                }
                catch (Exception e) {
                    this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.change_internal_error");
                }
            }
            catch (Exception e) {
                this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.network_error");
            }
        }
    }

    @Override
    public void unlockUser(JSONObject details) throws Exception {
    }

    @Override
    public JSONObject getStatus() {
        try {
            if (this.status.has("eSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("eSTATUS") + "_message"));
            } else if (this.status.has("sSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("sSTATUS") + "_message"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.status;
    }

    @Override
    public boolean connectAccount(JSONObject details) throws Exception {
        try {
            String inputLine;
            this.setProxySettings();
            this.host = details;
            this.domain = (String)this.host.get("HOST_NAME");
            this.email = (String)this.host.get("USER_NAME");
            String admin_pass = (String)this.host.get("PASSWORD");
            this.start = this.domain.startsWith("https") ? 8 : 0;
            if (this.domain.endsWith("zendesk.com")) {
                this.end = this.domain.indexOf(".zendesk");
                this.domainName = this.domain.substring(this.start, this.end);
            } else {
                this.domainName = this.domain;
            }
            this.email = this.getUserName(this.email, this.domainName);
            this.stringUrl = "https://" + this.domainName + ".zendesk.com/api/v2/users/me.json?";
            this.url = new URL(this.stringUrl);
            HttpURLConnection uc = (HttpURLConnection)this.url.openConnection();
            String userpass = this.email + ":" + admin_pass;
            String basicAuth = "Basic " + new String(Base64.encode((byte[])userpass.getBytes()));
            uc.setRequestProperty("Authorization", basicAuth);
            BufferedReader in = new BufferedReader(new InputStreamReader(uc.getInputStream()));
            while ((inputLine = in.readLine()) != null) {
                int s = inputLine.indexOf("id");
                int e = inputLine.indexOf(",", s + 4);
                String uId = inputLine.substring(s + 4, e);
                this.userId = Integer.parseInt(uId);
            }
            in.close();
            return true;
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(ZendeskHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (FileNotFoundException fe) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.error_in_domain_name");
        }
        catch (NumberFormatException nf) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.error_in_username_or_password");
        }
        catch (UnknownHostException uhe) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.check_your_network_connections");
        }
        catch (IOException ie) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.access_denied");
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Problem while connecting zendesk domain. [" + e.getMessage() + "]");
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zendesk.internal_error");
        }
        throw new ZendeskException((String)this.status.get("eSTATUS"));
    }
}

