/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice.nonad.zoho;

import com.adventnet.sym.adsm.common.server.selfservice.nonad.zoho.ZohoException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ZohoAPIAction {
    private static final Logger LOGGER = Logger.getLogger(ZohoAPIAction.class.getName());
    private static final String ZOHO_ACCOUNTS_SERVERURL = "com.zoho.accounts.serverurl";
    public static final String ATOM_FEED_ENTRY_TAGNAME = "entry";
    public static final String ATOM_NAMESPACE = "http://www.w3.org/2005/Atom";
    public static final String ZB_NAMESPACE = "http://schemas.api.zoho.com/accounts/v1";
    public static final String ZB_NAMESPACE_PREFIX = "zb";
    public static final String ATOM_NAMESPACE_PREFIX = "atom";
    private static String accountsServerURL = null;
    private static int connectionTimeout = 100000;
    private static int readTimeout = 100000;
    private String domainName;
    private String authToken;

    public ZohoAPIAction(String domainName, String authToken) {
        this.domainName = domainName;
        this.authToken = authToken;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getAuthToken() {
        return this.authToken;
    }

    public String getBaseURL() {
        return ZohoAPIAction.getAccountsServerURL() + "/accounts/feeds/v1/" + this.getDomainName();
    }

    public Document fetchUsers(int startIndex, int noOfResults) throws ZohoException {
        LOGGER.warning("In fetch users");
        String URL2 = this.getBaseURL() + "/user?start=" + startIndex + "&total=" + noOfResults;
        LOGGER.warning("In base URL : " + URL2);
        String response = this.getResponse(URL2, "GET", "");
        if (response == null) {
            return null;
        }
        return ZohoAPIAction.getDocument(response);
    }

    public Document getUser(String ZUID) throws ZohoException {
        String URL2 = this.getBaseURL() + "/user/" + ZohoAPIAction.encode(ZUID);
        String response = this.getResponse(URL2, "GET", "");
        if (response == null) {
            return null;
        }
        return ZohoAPIAction.getDocument(response);
    }

    public Document updateUser(String ZUID, Document document) throws ZohoException {
        String xmlString = this.convertToString(document);
        String URL2 = this.getBaseURL() + "/user/" + ZohoAPIAction.encode(ZUID);
        String response = this.getResponse(URL2, "PUT", xmlString);
        if (response == null) {
            return null;
        }
        return ZohoAPIAction.getDocument(response);
    }

    private String convertToString(Document document) {
        try {
            TransformerFactory fac = TransformerFactory.newInstance();
            Transformer trans = fac.newTransformer();
            DOMSource domSource = new DOMSource(document.getDocumentElement());
            StreamResult streamResult = new StreamResult(new StringWriter());
            trans.transform(domSource, streamResult);
            return streamResult.getWriter().toString();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
    }

    public static void setAccountsServerURL(String accountsServerURL) {
        ZohoAPIAction.accountsServerURL = accountsServerURL;
    }

    public static String getAccountsServerURL() {
        if (accountsServerURL == null) {
            String serverURL = System.getProperty(ZOHO_ACCOUNTS_SERVERURL);
            accountsServerURL = serverURL != null ? serverURL : "https://accounts.zoho.com";
            LOGGER.log(Level.INFO, "Zoho Accounts Server URL : {0}", accountsServerURL);
        }
        return accountsServerURL;
    }

    private String getResponse(String apiURL, String requestMethod, String requestContent) throws ZohoException {
        try {
            HttpURLConnection urlConnection = (HttpURLConnection)new URL(apiURL).openConnection();
            if ("PUT".equalsIgnoreCase(requestMethod)) {
                urlConnection.setRequestProperty("X-HTTP-Method-Override", "PUT");
            } else if ("DELETE".equalsIgnoreCase(requestMethod)) {
                urlConnection.setRequestProperty("X-HTTP-Method-Override", "DELETE");
            }
            urlConnection.setRequestMethod(requestMethod);
            urlConnection.setRequestProperty("Authorization", "ZohoLogin auth=" + this.authToken);
            urlConnection.setRequestProperty("X-Z-User-Agent", "ManageEngine ADSSP");
            urlConnection.setConnectTimeout(connectionTimeout);
            urlConnection.setReadTimeout(readTimeout);
            LOGGER.log(Level.FINE, "Sending request to [{0}] {1}", new Object[]{requestMethod, apiURL});
            LOGGER.log(Level.FINEST, "API URL : {0}, Request Content : {1}", new Object[]{apiURL, requestContent});
            if ("PUT".equalsIgnoreCase(requestMethod) || "POST".equalsIgnoreCase(requestMethod)) {
                urlConnection.setDoOutput(true);
                urlConnection.setDoInput(true);
                OutputStream os = urlConnection.getOutputStream();
                os.write(requestContent.getBytes());
                os.flush();
                os.close();
            }
            urlConnection.connect();
            LOGGER.log(Level.FINE, "Response Code received : {0}", urlConnection.getResponseCode());
            InputStream is = null;
            if (urlConnection.getResponseCode() == 200 || urlConnection.getResponseCode() == 201) {
                is = urlConnection.getInputStream();
                StringBuilder sb = new StringBuilder();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                String eachLine = br.readLine();
                while (eachLine != null) {
                    sb.append(eachLine);
                    eachLine = br.readLine();
                }
                br.close();
                is.close();
                LOGGER.log(Level.FINER, "API URL : {0}, Response Received : {1}", new Object[]{apiURL, sb});
                return sb.toString();
            }
            if ("DELETE".equalsIgnoreCase(requestMethod) && urlConnection.getResponseCode() == 204) {
                return "SUCCESS";
            }
            is = urlConnection.getErrorStream();
            StringBuilder sb = new StringBuilder();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String eachLine = br.readLine();
            while (eachLine != null) {
                sb.append(eachLine);
                eachLine = br.readLine();
            }
            br.close();
            is.close();
            String error = sb.toString();
            LOGGER.log(Level.FINER, "API URL : {0}, Error Response Received : {1}", new Object[]{apiURL, sb});
            this.throwError(error);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        return null;
    }

    private String throwError(String errorMsg) throws ZohoException {
        Node error;
        Node node;
        NodeList errorNodes;
        Document document = ZohoAPIAction.getDocument(errorMsg);
        NodeList errorEle = document.getElementsByTagName("ZohoAPIError");
        if (errorEle.getLength() > 0 && (errorNodes = (node = errorEle.item(0)).getChildNodes()).getLength() > 0 && (error = errorNodes.item(0)).getNodeType() == 1) {
            Element ele = (Element)error;
            String errorCode = ele.getAttribute("code");
            throw new ZohoException(ZohoException.getErrorMessage(errorCode));
        }
        return null;
    }

    private static Document getDocument(String xmlString) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = docBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new DummyEntityResolver());
            return documentBuilder.parse(new ByteArrayInputStream(xmlString.getBytes()));
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, null, ex);
            return null;
        }
    }

    public static String encode(String input) {
        try {
            return input == null ? "null" : URLEncoder.encode(input, "UTF-8");
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, null, e);
            return input;
        }
    }

    public static Properties getResponseAsProperties(String serverUrl, String params) {
        OutputStream os = null;
        InputStream is = null;
        try {
            HttpURLConnection urlConnection = (HttpURLConnection)new URL(serverUrl).openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setRequestMethod("POST");
            urlConnection.setConnectTimeout(connectionTimeout);
            urlConnection.setReadTimeout(readTimeout);
            urlConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            urlConnection.setRequestProperty("X-Z-User-Agent", "ManageEngine ADSelfService");
            if (params != null) {
                os = urlConnection.getOutputStream();
                os.write(params.getBytes("UTF-8"));
                os.flush();
                os.close();
            }
            urlConnection.connect();
            is = urlConnection.getInputStream();
            Properties p = new Properties();
            p.load(is);
            is.close();
            Properties properties = p;
            return properties;
        }
        catch (Exception ioException) {
            LOGGER.log(Level.WARNING, null, ioException);
            throw new RuntimeException(ioException);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, ioe);
            }
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, null, ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getLinkedAccountResponse(String loginURL, String params) {
        FilterOutputStream doStream = null;
        try {
            String str;
            URL localURL = new URL(loginURL);
            HttpURLConnection conn = (HttpURLConnection)localURL.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8");
            conn.setDoOutput(true);
            doStream = new DataOutputStream(conn.getOutputStream());
            ((DataOutputStream)doStream).writeBytes(params);
            ((DataOutputStream)doStream).flush();
            int i = conn.getResponseCode();
            Properties props = new Properties();
            props.load(conn.getInputStream());
            BufferedReader breader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuffer output = new StringBuffer();
            while ((str = breader.readLine()) != null) {
                output.append(str);
            }
            breader.close();
            LOGGER.log(Level.INFO, "Linking response - " + props.toString());
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                doStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean verifyPassword(String username, String password) throws ZohoException {
        LOGGER.log(Level.FINE, "Gonna verify password for the user : {0} with password length : {1}", new Object[]{username, password.length()});
        String loginURL = "https://accounts.zoho.com/getauthtoken/fetchtoken";
        String params = "login=" + username + "&password=" + password;
        Properties properties = ZohoAPIAction.getLinkedAccountResponse(loginURL, params);
        if (properties.containsKey("AUTHTOKEN") && properties != null) {
            LOGGER.log(Level.FINE, "Login success for the user : {0}", username);
            return true;
        }
        LOGGER.log(Level.FINE, "Login failed for the user : {0}, Response received : {1}", new Object[]{username, properties});
        String cause = properties.getProperty("ERROR");
        if ("Account is inactive".equals(cause) || "Account is disabled".equals(cause)) {
            throw new ZohoException(ZohoException.ErrorCode.U103);
        }
        throw new ZohoException(ZohoException.ErrorCode.AUTH001);
    }

    public static class DummyEntityResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return new InputSource(new StringReader(""));
        }
    }
}

