/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice.nonad.zoho;

import java.util.logging.Level;
import java.util.logging.Logger;

public class ZohoException
extends Exception {
    private static final long serialVersionUID = -3029843632991306639L;
    private static final Logger LOGGER = Logger.getLogger(ZohoException.class.getName());
    private String message;

    public ZohoException(String message) {
        this.message = message;
    }

    public ZohoException(ErrorCode errorCode) {
        this(errorCode.getADSSPMessage());
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public static String getErrorMessage(String errorCode) {
        String msg = "adssp.nonad.pwdsync.zoho.internal_error";
        try {
            msg = ErrorCode.valueOf(errorCode).getADSSPMessage();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unhandled ErrorCode : {0}, Exception : {1}", new Object[]{errorCode, e.getMessage()});
            LOGGER.log(Level.FINE, null, e);
        }
        return msg;
    }

    public static enum ErrorCode {
        API100("Operation not allowed. Authorization failed", "adssp.nonad.pwdsync.zoho.unauthorized"),
        API101("API not enabled", "adssp.nonad.pwdsync.zoho.enable_api"),
        API102("Error occured", "adssp.nonad.pwdsync.zoho.internal_error"),
        API104("Invalid authorization header", "adssp.nonad.pwdsync.zoho.invalid_apikey"),
        API105("IP not allowed for API Invocation", "adssp.nonad.pwdsync.zoho.ip_not_allowed_for_api"),
        API106("APIKEY is invalid. APIKEY should be renewed", "adssp.nonad.pwdsync.zoho.invalid_apikey"),
        API107("Unsupported API", "adssp.nonad.pwdsync.zoho.unsupported_api"),
        U101("User not found", "adssp.nonad.pwdsync.zoho.user_not_avil"),
        U102("Email address not found", "adssp.nonad.pwdsync.zoho.user_not_avil"),
        U103("User not enabled ", "adssp.nonad.pwdsync.zoho.user_disabled"),
        O102("No such domain", "adssp.nonad.pwdsync.zoho.domin_not_verified"),
        O103("Org Domain is not yet verified", "adssp.nonad.pwdsync.zoho.domin_not_verified"),
        AUTH001("Invalid User Name or Password", "adssp.nonad.pwdsync.zoho.login_failed");

        private final String adsspMessage;
        private final String zohoMessage;

        private ErrorCode(String zohoMessage, String adsspMessage) {
            this.zohoMessage = zohoMessage;
            this.adsspMessage = adsspMessage;
        }

        public String getZohoMessage() {
            return this.zohoMessage;
        }

        public String getADSSPMessage() {
            return this.adsspMessage;
        }
    }
}

