/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.selfservice.nonad.zoho;

import com.adventnet.sym.adsm.common.server.selfservice.nonad.PasswordSynchronizer;
import com.adventnet.sym.adsm.common.server.selfservice.nonad.zoho.ZohoAPIAction;
import com.adventnet.sym.adsm.common.server.selfservice.nonad.zoho.ZohoException;
import com.adventnet.sym.adsm.common.server.util.ServerUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.manageengine.ads.fw.iamapps.cloud.zoho.ZohoAuthentication;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ZohoHandler
implements PasswordSynchronizer {
    private static final Logger LOGGER = Logger.getLogger(ZohoHandler.class.getName());
    ZohoAuthentication zauth = new ZohoAuthentication();
    private JSONObject status = new JSONObject();
    private ZohoAPIAction zApiAction = null;

    public void setProxySettings() throws Exception {
        try {
            Properties proxySettings = ServerUtil.getProxySettings();
            if (!proxySettings.isEmpty()) {
                String serverName = proxySettings.getProperty("SERVER_NAME");
                String port = proxySettings.getProperty("PORT");
                String userName = proxySettings.getProperty("USER_NAME");
                String password = proxySettings.getProperty("PASSWORD");
                System.getProperties().put("https.proxyHost", serverName);
                System.getProperties().put("https.proxyPort", port);
                System.getProperties().put("https.proxyUser", userName);
                System.getProperties().put("https.proxyPassword", password);
            }
        }
        catch (Exception e) {
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zoho.proxy_error");
            LOGGER.log(Level.WARNING, null, e);
        }
    }

    @Override
    public boolean authenticate(JSONObject details) throws Exception {
        return this.zauth.authenticate(details);
    }

    @Override
    public void resetPassword(JSONObject details) throws Exception {
        try {
            Document document;
            String endUserName = details.getString("END_USER_NAME");
            String newPassword = details.getString("NEW_PASSWORD");
            this.setProxySettings();
            LOGGER.log(Level.FINE, "Gonna reset the password for the user : {0}, Password Length : {1}", new Object[]{endUserName, newPassword.length()});
            ZohoAPIAction zaa = this.getZohoAPIInstance(details);
            String userEmail = (String)details.get("END_USER_NAME");
            if (!StrUtil.isValidEmailID(userEmail)) {
                userEmail = userEmail + "@" + zaa.getDomainName();
            }
            if ((document = zaa.getUser(userEmail)) == null) {
                throw new ZohoException(ZohoException.ErrorCode.U101);
            }
            NodeList loginNL = document.getElementsByTagNameNS("http://schemas.api.zoho.com/accounts/v1", "login");
            LOGGER.log(Level.FINE, "Login NodeList size : {0}", loginNL.getLength());
            if (loginNL.getLength() < 1) {
                Node userNode = document.getElementsByTagNameNS("http://www.w3.org/2005/Atom", "entry").item(0);
                Element loginElement = document.createElementNS("http://schemas.api.zoho.com/accounts/v1", "zb:login");
                loginElement.setAttribute("password", newPassword);
                userNode.appendChild(loginElement);
            } else {
                ((Element)loginNL.item(0)).setAttribute("password", newPassword);
            }
            Element propertiesElement = (Element)document.getElementsByTagNameNS("http://schemas.api.zoho.com/accounts/v1", "properties").item(0);
            String uniqueId = propertiesElement.getAttribute("unique-id");
            LOGGER.log(Level.FINE, "Gonna reset Password for the user : {0}, Unique Id : {1}", new Object[]{endUserName, uniqueId});
            zaa.updateUser(uniqueId, document);
            LOGGER.log(Level.FINE, "Password reset successful for the user : {0}, Unique Id : {1}", new Object[]{endUserName, uniqueId});
            this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.zoho.password_reset_success");
        }
        catch (ZohoException zex) {
            this.status.put("eSTATUS", (Object)zex.getMessage());
            throw zex;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, null, ex);
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zoho.internal_error");
            throw new ZohoException("adssp.nonad.pwdsync.zoho.internal_error");
        }
    }

    @Override
    public void changePassword(JSONObject details) throws Exception {
        this.resetPassword(details);
        this.status.put("sSTATUS", (Object)"adssp.nonad.pwdsync.zoho.password_change_success");
    }

    @Override
    public void unlockUser(JSONObject details) throws Exception {
    }

    @Override
    public boolean connectAccount(JSONObject details) throws Exception {
        try {
            String username = (String)details.get("USER_NAME");
            String password = (String)details.get("PASSWORD");
            LOGGER.log(Level.FINE, "Gonna connectAccount for the user : {0}, Password Length : {1}", new Object[]{username, password.length()});
            ZohoAPIAction zaa = this.getZohoAPIInstance(details);
            String email = username + "@" + zaa.getDomainName();
            boolean verified = ZohoAPIAction.verifyPassword(email, password);
            if (!verified) {
                throw new ZohoException(ZohoException.ErrorCode.AUTH001);
            }
            Document userDocument = zaa.getUser(email);
            if (userDocument == null) {
                throw new ZohoException(ZohoException.ErrorCode.U101);
            }
            Element propertiesElement = (Element)userDocument.getElementsByTagNameNS("http://schemas.api.zoho.com/accounts/v1", "properties").item(0);
            String uniqueId = propertiesElement.getAttribute("unique-id");
            LOGGER.log(Level.FINE, "Unique Id : {0} for User : {1}", new Object[]{uniqueId, username});
            if (uniqueId == null) {
                throw new ZohoException(ZohoException.ErrorCode.U101);
            }
            return verified;
        }
        catch (ZohoException zex) {
            if (zex.getMessage() == ZohoException.ErrorCode.API102.getADSSPMessage()) {
                zex = new ZohoException(ZohoException.ErrorCode.API102);
            }
            this.status.put("eSTATUS", (Object)zex.getMessage());
            throw zex;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, null, ex);
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zoho.internal_error");
            throw new ZohoException("adssp.nonad.pwdsync.zoho.internal_error");
        }
    }

    private ZohoAPIAction getZohoAPIInstance(JSONObject details) throws JSONException, ZohoException {
        try {
            if (this.zApiAction == null) {
                String authToken;
                String domain = details.getString("HOST_NAME");
                String string = authToken = details.has("AUTH_TOKEN") ? details.getString("AUTH_TOKEN") : details.getJSONObject("PARAMS").getString("AUTH_TOKEN");
                if (authToken == null || authToken.length() < 1) {
                    throw new ZohoException(ZohoException.ErrorCode.API106);
                }
                LOGGER.log(Level.FINE, "Creating instance of ZBAction for Domain : {0}, Auth Token length : {1}", new Object[]{domain, authToken.length()});
                this.zApiAction = new ZohoAPIAction(domain, authToken);
            }
            return this.zApiAction;
        }
        catch (ZohoException zex) {
            this.status.put("eSTATUS", (Object)zex.getMessage());
            throw zex;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, null, ex);
            this.status.put("eSTATUS", (Object)"adssp.nonad.pwdsync.zoho.internal_error");
            throw new ZohoException("adssp.nonad.pwdsync.zoho.internal_error");
        }
    }

    @Override
    public JSONObject getStatus() {
        try {
            if (this.status.has("eSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("eSTATUS") + "_message"));
            } else if (this.status.has("sSTATUS")) {
                this.status.put("DISPLAY_MESSAGE", (Object)(this.status.get("sSTATUS") + "_message"));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, null, e);
        }
        return this.status;
    }
}

