/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.servlet;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.iam.security.SecurityUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.start.util.SDInstallUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;

public class HtmlHandler
extends HttpServlet
implements Servlet {
    public static AdventNetResourceBundle rb = null;
    public String context = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] readFile(String strFile) throws IOException {
        int nSize = 32768;
        byte[] pBuffer = new byte[nSize];
        int nPos = 0;
        try (BufferedInputStream inStream = null;){
            inStream = new BufferedInputStream(new FileInputStream(strFile), nSize);
            nPos += inStream.read(pBuffer, nPos, nSize - nPos);
            while (nPos == nSize) {
                byte[] pTemp = pBuffer;
                pBuffer = new byte[nSize *= 2];
                System.arraycopy(pTemp, 0, pBuffer, 0, nPos);
                nPos += inStream.read(pBuffer, nPos, nSize - nPos);
            }
        }
        if (nPos == 0) {
            return "".getBytes();
        }
        byte[] pData = new byte[nPos];
        System.arraycopy(pBuffer, 0, pData, 0, nPos);
        return pData;
    }

    public static String replaceResourceBundle(String message, AdventNetResourceBundle rb) {
        String groupString = "";
        StringBuffer sbf = new StringBuffer();
        Pattern pattern = Pattern.compile("\\$\\{([^\\}]*).");
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            groupString = matcher.group(1);
            System.out.println(groupString);
            groupString = "requestContextPath".equals(groupString) ? SDInstallUtil.getContextPathName(null) : (String)rb.handleGetObject(groupString);
            matcher.appendReplacement(sbf, groupString);
        }
        matcher.appendTail(sbf);
        return sbf.toString();
    }

    public void init(ServletConfig config) {
        this.context = config.getServletContext().getRealPath("/");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setContentType("Text/Html");
        PrintWriter out = res.getWriter();
        rb = ResourceBundleMgr.getInstance().getBundle(req);
        System.out.println("<br> Virtual Path : " + req.getServletPath());
        String resourceFileName = req.getRealPath(req.getServletPath());
        System.out.println("<br> Real Path : " + resourceFileName);
        System.out.println(" servlet context path : " + this.context);
        File propFile = new File(resourceFileName);
        if (propFile.exists() && propFile.isFile()) {
            String fileContentType = SecurityUtil.getMimeTypeUsingTika((File)propFile);
            if (!"application/xhtml+xml".equalsIgnoreCase(fileContentType)) {
                res.setContentType(fileContentType);
            }
            Credential cred = AuthUtil.getUserCredential();
            HttpSession session = req.getSession();
            DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute("LoginBean");
            String userName = bean != null ? (String)bean.get("USERNAME") : null;
            String resourceFile = resourceFileName.toLowerCase();
            if ((cred == null || userName == null) && resourceFile.indexOf("passwordpolicy") != -1) {
                res.sendError(404);
            }
            System.out.println("<br>ResourceFileName : " + resourceFileName);
            byte[] bytes = HtmlHandler.readFile(resourceFileName);
            String html = new String(bytes);
            html = HtmlHandler.replaceResourceBundle(html, rb);
            out.write(html);
        } else {
            res.sendError(404);
        }
    }
}

