/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.servlet;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedString;
import java.util.Random;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class I18NCaptcha
extends HttpServlet
implements Servlet {
    private Random generator = new Random();
    public static final String SIMPLE_CAPCHA_SESSION_KEY = "SIMPLE_CAPCHA_SESSION_KEY";

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        int y2;
        int ImageWidth = 200;
        int ImageHeight = 70;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(req);
        String captchatext = rb.getString("adssp.captcha.text_captcha_text").trim();
        String ua = req.getHeader("User-Agent").toLowerCase();
        Boolean isMacClient = false;
        String audioCaptchaStatus = (String)req.getSession().getAttribute("audioCaptchaStatus");
        if (ua.indexOf("mac") != -1 && ua.indexOf("safari") == -1 && ua.indexOf("chrome") == -1 && ua.indexOf("firefox") == -1 && ua.indexOf("mobile") == -1 && ua.indexOf("edge") == -1 && ua.indexOf("MSIE") == -1) {
            isMacClient = true;
            req.getSession().setAttribute("audioCaptchaStatus", (Object)"false");
        } else {
            if (audioCaptchaStatus == null) {
                audioCaptchaStatus = ADSMPersUtil.getSyMParameter("audioCaptcha");
                req.getSession().setAttribute("audioCaptchaStatus", (Object)audioCaptchaStatus);
            }
            if ("true".equalsIgnoreCase(audioCaptchaStatus)) {
                captchatext = rb.getString("adssp.captcha.audio_captcha_text").trim();
            }
        }
        int car = captchatext.length() - 1;
        String text = "";
        for (int i = 0; i < 6; ++i) {
            text = text + captchatext.charAt(this.generator.nextInt(car) + 1);
        }
        req.getSession().setAttribute(SIMPLE_CAPCHA_SESSION_KEY, (Object)text);
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)resp.getOutputStream());
        BufferedImage bi = new BufferedImage(ImageWidth + 0, ImageHeight + 5, 13);
        Graphics2D graphics = bi.createGraphics();
        graphics.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        graphics.setColor(Color.green.darker());
        AttributedString attstr = new AttributedString(text);
        TextLayout textTl = new TextLayout(text, new Font("Courier", 0, 40), new FontRenderContext(null, true, false));
        AffineTransform textAt = graphics.getTransform();
        textTl.draw(graphics, 4.0f, 60.0f);
        int w = bi.getWidth();
        int h = bi.getHeight();
        this.shear(graphics, w, h, Color.white);
        int y1 = this.generator.nextInt(ImageHeight) + 1;
        if (y1 < 30 || y1 > 70) {
            y1 = 51;
        }
        if ((y2 = this.generator.nextInt(ImageHeight) + 1) < 30 || y1 > 70) {
            y2 = 55;
        }
        resp.setContentType("image/jpeg");
        encoder.encode(bi);
    }

    private void shear(Graphics g, int w1, int h1, Color color) {
        this.shearX(g, w1, h1, color);
        this.shearY(g, w1, h1, color);
    }

    public void shearX(Graphics g, int w1, int h1, Color color) {
        int period = this.generator.nextInt(10) + 5;
        boolean borderGap = false;
        int frames = 15;
        int phase = this.generator.nextInt(5) + 2;
        for (int i = 0; i < h1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(0, i, w1, 1, (int)d, 0);
            if (!borderGap) continue;
            g.setColor(color);
            g.drawLine((int)d, i, 0, i);
            g.drawLine((int)d + w1, i, w1, i);
        }
    }

    public void shearY(Graphics g, int w1, int h1, Color color) {
        int period = this.generator.nextInt(30) + 10;
        boolean borderGap = true;
        int frames = 15;
        int phase = 7;
        for (int i = 0; i < w1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(i, 0, 1, h1, 0, (int)d);
            if (!borderGap) continue;
            g.setColor(color);
            g.drawLine(i, (int)d, i, 0);
            g.drawLine(i, (int)d + h1, i, h1);
        }
    }

    private void drawThickLine(Graphics g, int x1, int y1, int x2, int y2, int thickness, Color c) {
        g.setColor(c);
        int dX = x2 - x1;
        int dY = y2 - y1;
        double lineLength = Math.sqrt(dX * dX + dY * dY);
        double scale = (double)thickness / (2.0 * lineLength);
        double ddx = -scale * (double)dY;
        double ddy = scale * (double)dX;
        double d = ddy > 0.0 ? 0.5 : -0.5;
        int dx = (int)(ddx += ddx > 0.0 ? 0.5 : -0.5);
        int dy = (int)(ddy += d);
        int[] xPoints = new int[4];
        int[] yPoints = new int[4];
        xPoints[0] = x1 + dx;
        yPoints[0] = y1 + dy;
        xPoints[1] = x1 - dx;
        yPoints[1] = y1 - dy;
        xPoints[2] = x2 - dx;
        yPoints[2] = y2 - dy;
        xPoints[3] = x2 + dx;
        yPoints[3] = y2 + dy;
        g.fillPolygon(xPoints, yPoints, 4);
    }
}

