/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.servlet;

import com.adventnet.sym.adsm.common.server.admin.AdminHandler;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.manageengine.ads.fw.util.CommonUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ProductConfigServlet
extends HttpServlet {
    public static final String ME_SERVICEDESK_PLUS = "ManageEngine ServiceDesk Plus";
    public static final String SPICEWORKS = "Spiceworks";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String productName = request.getParameter("product");
            String message = "Unable to integrate with " + productName + ". Please upgrade " + productName + " and try again. Do keep us(support@adselfserviceplus.com) posted if you still see the error message.";
            if (productName != null) {
                if (productName.equals(ME_SERVICEDESK_PLUS)) {
                    String appName = request.getParameter("appName");
                    if (appName != null && appName.equals(CommonUtil.getProductName())) {
                        message = ProductConfigServlet.addProductDetails(request, productName, message);
                    }
                } else if (productName.equalsIgnoreCase(SPICEWORKS)) {
                    ADSMPersUtil.updateSyMParameter("IS_SPICEWORKS_INTEGRATED", "true");
                    message = "Successfully Integrated";
                } else {
                    message = ProductConfigServlet.addProductDetails(request, productName, message);
                }
            }
            PrintWriter out = response.getWriter();
            response.setContentType("text/html");
            out.println(StrUtil.encodeURIComponent(message));
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String addProductDetails(HttpServletRequest request, String productName, String message) {
        try {
            Properties productSettings = new Properties();
            productSettings.put("PROTOCOL", request.getParameter("protocol"));
            productSettings.put("HOST", request.getParameter("host"));
            productSettings.put("PORT", Integer.valueOf(request.getParameter("port")));
            if (request.getParameter("TECHNICIAN_KEY") == null) {
                productSettings.put("TECHNICIAN_KEY", "");
            } else {
                productSettings.put("TECHNICIAN_KEY", request.getParameter("TECHNICIAN_KEY"));
            }
            AdminHandler.addProductDetails(productName, productSettings);
            message = "Successfully Configured.";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message;
    }
}

