/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.sms;

import com.adventnet.sym.adsm.common.server.sms.SMSAction;
import com.adventnet.sym.adsm.common.server.sms.SMSProvider;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.BASE64Encoder;

public class Clickatell
implements SMSProvider {
    private static Logger logger = Logger.getLogger(SMSAction.class.getName());
    private Properties providerProps = null;
    private Properties msgProps = null;
    private String deliveryStatus = null;
    private String errorCode = null;
    private boolean unicode = true;
    List errorCodes = Arrays.asList("001", "002", "003", "004", "005", "007", "101", "102", "103", "104", "105", "106", "107", "108", "109", "110", "111", "112", "113", "114", "115", "116", "120", "121", "122", "123", "128", "130", "201", "202", "301", "302", "901", "00000001");

    @Override
    public void setSMSProperties(Properties providerProps, Properties msgProps) {
        try {
            logger.log(Level.INFO, "Clickatell : SetSMSProperties");
            this.providerProps = providerProps;
            this.msgProps = msgProps;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendSMS() {
        OutputStreamWriter wr = null;
        BufferedReader rd = null;
        try {
            String userName = this.providerProps.getProperty("USER_NAME");
            String password = this.providerProps.getProperty("PASSWORD");
            String apiId = this.providerProps.getProperty("API_ID");
            String urlForSMS = this.providerProps.getProperty("ACCESS_PARAM");
            String[] numbers = (String[])this.msgProps.get("NUMBERS");
            String number = numbers[0];
            String message = this.msgProps.getProperty("MESSAGE");
            String data = "";
            data = data + "user=" + URLEncoder.encode(userName, "ISO-8859-1");
            data = data + "&password=" + URLEncoder.encode(password, "ISO-8859-1");
            data = data + "&api_id=" + apiId;
            data = data + "&to=" + StrUtil.getFormatedNumber(number, "Clickatell");
            this.unicode = StrUtil.isMultiByteString(message);
            if (this.unicode) {
                data = data + "&text=" + StrUtil.stringToHex(message);
                data = data + "&unicode=1";
            } else {
                data = data + "&text=" + message;
                data = data + "&unicode=0";
            }
            data = data + "&concat=" + String.valueOf(StrUtil.stringSplitCount(message, 63));
            URL url = new URL(urlForSMS);
            URLConnection conn = url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            if (this.providerProps.get("PROXY_SETTINGS") != null) {
                Properties proxySettings = (Properties)this.providerProps.get("PROXY_SETTINGS");
                System.setProperty("http.proxyHost", proxySettings.getProperty("SERVER_NAME"));
                System.setProperty("http.proxyPort", proxySettings.getProperty("PORT"));
                System.setProperty("https.proxyHost", proxySettings.getProperty("SERVER_NAME"));
                System.setProperty("https.proxyPort", proxySettings.getProperty("PORT"));
                BASE64Encoder encoder = new BASE64Encoder();
                String proxyUserName = proxySettings.getProperty("USER_NAME");
                if (proxyUserName != null && !proxyUserName.equals("")) {
                    String unameAndPwd = proxyUserName + ":" + proxySettings.getProperty("PASSWORD");
                    String encodedUserPwd = encoder.encode(unameAndPwd.getBytes());
                    conn.setRequestProperty("Proxy-Authorization", "Basic " + encodedUserPwd);
                }
            }
            String response = null;
            try {
                String line;
                wr = new OutputStreamWriter(conn.getOutputStream());
                wr.write(data);
                wr.flush();
                rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                StringBuilder result = new StringBuilder("");
                while ((line = rd.readLine()) != null) {
                    result.append(line);
                }
                response = result.toString();
                logger.log(Level.INFO, "ClickATell SMS : The Response after Sending the SMS : " + response);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "ClickATell SMS : Exception while send SMS using HTTP is : " + e);
                this.errorCode = "00000001";
                if (wr != null) {
                    try {
                        wr.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                if (rd != null) {
                    try {
                        rd.close();
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                }
                return;
            }
            if (response != null && response.startsWith("ERR")) {
                this.errorCode = this.getErrorCode(response);
                logger.log(Level.INFO, "ClickATell SMS : ErrorCode in Sending SMS is " + this.errorCode);
            } else {
                this.errorCode = "00000003";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.INFO, "ClickATell SMS : Exception while Send SMS using URL");
            this.errorCode = "00000002";
        }
        finally {
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public String getDeliveryStatus() {
        this.deliveryStatus = this.errorCode.equals("00000003") ? "adssp.common.text.smssent" : "adssp.sms_gateway.clickatell.errorcode_" + (this.errorCode != null ? this.errorCode : "00000002");
        return this.deliveryStatus;
    }

    private String getErrorCode(String errorString) {
        String errorcode = errorString.substring(errorString.indexOf(58) + 1);
        errorcode = errorcode.substring(0, 4);
        errorcode = errorcode.trim();
        return errorcode;
    }

    private String getTrimmedMessage() {
        if (this.unicode) {
            return StrUtil.truncate(this.msgProps.getProperty("MESSAGE"), 69);
        }
        return StrUtil.truncate(this.msgProps.getProperty("MESSAGE"), 159);
    }

    @Override
    public Boolean isMsgSent() {
        return !this.errorCodes.contains(this.errorCode);
    }
}

