/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.sms;

import com.adventnet.sym.adsm.common.server.sms.SMSAction;
import com.adventnet.sym.adsm.common.server.sms.SMSProvider;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.smslib.AGateway;
import org.smslib.Message;
import org.smslib.OutboundMessage;
import org.smslib.Service;
import org.smslib.modem.SerialModemGateway;

public class GSMModem
implements SMSProvider {
    private static Logger logger = Logger.getLogger(SMSAction.class.getName());
    private Properties providerProps = null;
    private Properties msgProps = null;
    private String deliveryStatus = null;
    private Boolean isMsgSent = true;
    private String port = null;
    private int portSpeed = 9600;
    private String msgcen = null;
    private String pinNumber = "0000";

    @Override
    public void setSMSProperties(Properties providerProps, Properties msgProps) {
        try {
            logger.log(Level.INFO, "GSMModem : SetSMSProperties");
            this.providerProps = providerProps;
            this.msgProps = msgProps;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendSMS() {
        String result = "adssp.common.text.smssent";
        SerialModemGateway gateway = null;
        Service srv = Service.getInstance();
        try {
            String[] numbers = (String[])this.msgProps.get("NUMBERS");
            String message = this.msgProps.getProperty("MESSAGE");
            this.port = this.providerProps.getProperty("ACCESS_PARAM");
            String speed = this.providerProps.getProperty("PORT_SPEED");
            if (speed != null && !speed.equals("")) {
                this.portSpeed = Integer.parseInt(speed);
            }
            logger.log(Level.INFO, "Modem Port Speed" + this.portSpeed);
            String modermName = "Nokia";
            String modermModel = "6303";
            this.msgcen = this.providerProps.getProperty("MSG_CENTER");
            this.pinNumber = this.providerProps.getProperty("PIN_NUMBER");
            if (srv.getServiceStatus().equals((Object)Service.ServiceStatus.STOPPED)) {
                gateway = this.getModemGateWay("SSPGSMModem", modermName, modermModel);
                srv.addGateway((AGateway)gateway);
                srv.startService();
                logger.log(Level.FINE, "Modem Information:");
                logger.log(Level.FINE, "Manufacturer: " + gateway.getManufacturer());
                logger.log(Level.FINE, "Model: " + gateway.getModel());
                logger.log(Level.FINE, "Serial No: " + gateway.getSerialNo());
                logger.log(Level.FINE, "SIM IMSI: " + gateway.getImsi());
                logger.log(Level.FINE, "Signal Level: " + gateway.getSignalLevel() + " dBm");
                logger.log(Level.FINE, "Battery Level: " + gateway.getBatteryLevel() + "%");
            } else {
                SerialModemGateway oldGateway = (SerialModemGateway)srv.findGateway("SSPGSMModem");
                if (oldGateway == null) {
                    srv.stopService();
                    gateway = this.getModemGateWay("SSPGSMModem", modermName, modermModel);
                    srv.addGateway((AGateway)gateway);
                    srv.startService();
                    logger.log(Level.FINE, "Modem Information:");
                    logger.log(Level.FINE, "Manufacturer: " + gateway.getManufacturer());
                    logger.log(Level.FINE, "Model: " + gateway.getModel());
                    logger.log(Level.FINE, "Serial No: " + gateway.getSerialNo());
                    logger.log(Level.FINE, "SIM IMSI: " + gateway.getImsi());
                    logger.log(Level.FINE, "Signal Level: " + gateway.getSignalLevel() + " dBm");
                    logger.log(Level.FINE, "Battery Level: " + gateway.getBatteryLevel() + "%");
                } else {
                    gateway = oldGateway;
                }
            }
            String number = StrUtil.getFormatedNumber(numbers[0], "GSMModem");
            logger.log(Level.INFO, "Sending Msg to the number " + number);
            OutboundMessage msg = new OutboundMessage(number, message);
            msg.setEncoding(Message.MessageEncodings.ENCUCS2);
            Boolean status = srv.sendMessage(msg);
            if (status.booleanValue()) {
                logger.log(Level.INFO, "Sending Msg Successfull");
            } else {
                logger.log(Level.INFO, "Sending Failed Reason because the gateway error" + msg.getFailureCause());
                result = "adssp.common.text.message_failed_gateway_incorrectnumber_etc";
                this.isMsgSent = false;
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Sending Failed Reason: " + e.getMessage());
            logger.log(Level.INFO, "Sending Failed Reason: " + e);
            result = "adssp.common.text.message_failed";
            this.isMsgSent = false;
            try {
                srv.stopService();
                srv.removeGateway(gateway);
                gateway.stopGateway();
            }
            catch (Exception e1) {
                logger.log(Level.INFO, "Closing exception  Reason: " + e1);
            }
        }
        this.deliveryStatus = result;
    }

    public SerialModemGateway getModemGateWay(String gatewayId, String modermName, String modermModel) throws Exception {
        SerialModemGateway gateway = new SerialModemGateway(gatewayId, this.port, this.portSpeed, modermName, modermModel);
        gateway.setOutbound(true);
        if (this.pinNumber != null && !this.pinNumber.equals("")) {
            gateway.setSimPin(this.pinNumber);
        } else {
            gateway.setSimPin("0000");
        }
        if (this.msgcen != null && !this.msgcen.equals("")) {
            gateway.setSmscNumber(this.msgcen);
        }
        return gateway;
    }

    @Override
    public String getDeliveryStatus() {
        return this.deliveryStatus;
    }

    @Override
    public Boolean isMsgSent() {
        return this.isMsgSent;
    }
}

