/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.sms;

import com.adventnet.sym.adsm.common.server.admin.AuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mail.SendMailAPI;
import com.adventnet.sym.adsm.common.server.sms.SMSProvider;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ServerUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class SMSAction {
    private static Logger logger = Logger.getLogger(SMSAction.class.getName());

    public static String sendSMS(String mobileNo, String msg, JSONObject smsSettings) {
        return SMSAction.sendSMS(new String[]{mobileNo}, msg, false, smsSettings);
    }

    public static String sendSMS(String mobileNo, String msg) {
        return SMSAction.sendSMS(new String[]{mobileNo}, msg, false, null);
    }

    public static String sendSMS(String mobileNo, String msg, Boolean isOTP) {
        return SMSAction.sendSMS(new String[]{mobileNo}, msg, isOTP, null);
    }

    public static String sendSMS(String[] mobileNos, String msg) {
        return SMSAction.sendSMS(mobileNos, msg, false, null);
    }

    public static String sendSMS(String[] mobileNos, String msg, Boolean isOTP, JSONObject smsSettings) {
        String statusMessage = "";
        HashMap prop = new HashMap();
        try {
            if (smsSettings == null) {
                smsSettings = ServerUtil.getSMSSettings();
            }
            if (!smsSettings.isNull("SELECTED_PROVIDER")) {
                JSONObject accDetails;
                String selectedProvider = smsSettings.getString("SELECTED_PROVIDER");
                if (!SMSAction.isCreditAvailable(selectedProvider, msg, accDetails = smsSettings.getJSONObject("SMS_ACCOUNT"))) {
                    return "adssp.sms_gateway.common.no_credit_left";
                }
                Object providerClass = null;
                Class<?> classToInvoke = null;
                JSONArray providers = smsSettings.getJSONArray("PROVIDERS");
                for (int i = 0; i < providers.length(); ++i) {
                    JSONObject provider = providers.getJSONObject(i);
                    if (!selectedProvider.equals(provider.getString("PROVIDER_NAME"))) continue;
                    classToInvoke = Class.forName(provider.getString("CLASS_NAME").trim());
                }
                Properties providerProps = new Properties();
                JSONArray apiSettings = smsSettings.getJSONArray("API_SETTINGS");
                for (int i = 0; i < apiSettings.length(); ++i) {
                    JSONObject setting = apiSettings.getJSONObject(i);
                    Iterator keys = setting.keys();
                    while (keys.hasNext()) {
                        String key;
                        Object val = setting.get(key = (String)keys.next());
                        providerProps.put(key, val != null ? val : "");
                    }
                }
                Properties proxySettings = ServerUtil.getProxySettings();
                if (!proxySettings.isEmpty()) {
                    providerProps.put("PROXY_SETTINGS", proxySettings);
                }
                Properties msgProps = new Properties();
                msgProps.put("NUMBERS", mobileNos);
                msgProps.put("MESSAGE", msg);
                msgProps.put("IS_OTP", isOTP);
                prop = SMSAction.sendSMS(classToInvoke, providerProps, msgProps);
                statusMessage = (String)prop.get("statusMessage");
                boolean isMsgSent = (Boolean)prop.get("isMsgSent");
                if (isMsgSent) {
                    SMSAction.setSMSSentCount(selectedProvider, msg, accDetails);
                }
            } else {
                statusMessage = "adssp.sms_gateway.common.no_provider_configured";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statusMessage;
    }

    public static HashMap sendSMS(Class classToInvoke, Properties providerProps, Properties msgProps) {
        HashMap<String, Object> prop = new HashMap<String, Object>();
        Boolean isMsgSent = true;
        String statusMessage = "";
        try {
            Method[] methods;
            SMSProvider providerClass = (SMSProvider)classToInvoke.newInstance();
            providerClass.setSMSProperties(providerProps, msgProps);
            providerClass.sendSMS();
            for (Method method : methods = classToInvoke.getDeclaredMethods()) {
                if (!method.getName().equalsIgnoreCase("isMsgSent")) continue;
                isMsgSent = providerClass.isMsgSent();
            }
            statusMessage = providerClass.getDeliveryStatus();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        prop.put("isMsgSent", isMsgSent);
        prop.put("statusMessage", statusMessage);
        return prop;
    }

    private static boolean isCreditAvailable(String providerName, String message, JSONObject accDetails) throws Exception {
        block5: {
            try {
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
                String notifyAdmin = accDetails.getString("NOTIFY_ADMIN");
                String threshold = accDetails.getString("ACCOUNT_THRESHOLD");
                String adminMailId = accDetails.getString("EMAIL_ID");
                Long noOfSMSSent = Long.parseLong(accDetails.getString("NO_OF_SMS_SENT"));
                String licensedProvider = CommonUtil.getLicenseProperty("SMSGateway", "ProviderName");
                if (!providerName.equals(licensedProvider)) break block5;
                Long noOfSMSPurchased = Long.parseLong(CommonUtil.getLicenseProperty("SMSGateway", "NumberOfSMS"));
                Long balanceLeft = noOfSMSPurchased - noOfSMSSent;
                int concatCount = StrUtil.stringSplitCount(message, 63);
                if (balanceLeft <= 0L) {
                    return false;
                }
                balanceLeft = balanceLeft - (long)concatCount;
                if (!notifyAdmin.equals("1") || balanceLeft > Long.parseLong(threshold)) break block5;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("MAIL_IDS", adminMailId.split(","));
                map.put("MAIL_SUBJECT", rb.getString("adssp.admin.server_settings.sms_balance_alert_sub"));
                map.put("MAIL_CONTENT", rb.getString("adssp.admin.server_settings.sms_balance_alert_body"));
                Hashtable auditProps = new Hashtable();
                try {
                    SendMailAPI.getInstance().sendMail(map, auditProps, ServerUtil.getMailServerSettings());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                AuditAPI.getInstance();
                AuditAPI.addAuditLogs(auditProps);
                logger.log(Level.INFO, "Send notification to admin");
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private static void setSMSSentCount(String providerName, String message, JSONObject accDetails) {
        try {
            Long noOfSMSSent = Long.parseLong(accDetails.getString("NO_OF_SMS_SENT"));
            String licensedProvider = CommonUtil.getLicenseProperty("SMSGateway", "ProviderName");
            if (providerName.equals(licensedProvider)) {
                int concatCount = StrUtil.stringSplitCount(message, 63);
                ServerUtil.setSMSSentCount(providerName, noOfSMSSent + (long)concatCount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

