/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.sms;

import com.adventnet.sym.adsm.common.server.mail.SendMailAPI;
import com.adventnet.sym.adsm.common.server.sms.SMSAction;
import com.adventnet.sym.adsm.common.server.sms.SMSProvider;
import com.adventnet.sym.adsm.common.server.util.ServerUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;
import sun.misc.BASE64Encoder;

public class SSPCustomSMSProvider
implements SMSProvider {
    private static Logger logger = Logger.getLogger(SMSAction.class.getName());
    private Properties providerProps = null;
    private Properties msgProps = null;
    private String deliveryStatus = null;
    private String errorCode = null;
    private String userName = null;
    private String password = null;
    private String apiId = null;
    private String successResponse = null;
    private Socket smppConnection;
    private DataInputStream in;
    private DataOutputStream out;
    private byte[] bindOrSubmitBytes;
    public int sequenceNumber = 1;
    private int requestlength;
    private String sourceAddr = "";
    private String customESMESysType = "";
    private int sourceAddrTon = 0;
    private int sourceAddrNpi = 0;
    private int destAddrTon = 0;
    private int destAddrNpi = 0;
    private int smppSupportedTime = 5;
    private int esmeBindType = 2;

    @Override
    public void setSMSProperties(Properties providerProps, Properties msgProps) {
        try {
            logger.log(Level.INFO, "SSPCustomSMSProvider : SetSMSProperties");
            this.providerProps = providerProps;
            this.msgProps = msgProps;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendSMS() {
        try {
            JSONObject accessParam = new JSONObject(this.providerProps.getProperty("ACCESS_PARAM"));
            String customSMSType = accessParam.getString("CUSTOM_SMS_TYPE");
            if ("HTTP".equalsIgnoreCase(customSMSType)) {
                logger.log(Level.INFO, "SSPCustomSMSProvider SMS : Calling sendHTTPSMS");
                this.sendHTTPSMS(accessParam);
            } else if ("SMTP".equalsIgnoreCase(customSMSType)) {
                logger.log(Level.INFO, "SSPCustomSMSProvider SMS : Calling sendSMTPSMS");
                this.sendSMTPSMS(accessParam);
            } else {
                logger.log(Level.INFO, "SSPCustomSMSProvider SMS : Calling sendSMTPSMS");
                this.sendSMPPSMS(accessParam);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.INFO, "SSPCustomSMSProvider SMS : Exception while Send SMS using URL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHTTPSMS(JSONObject accessParam) {
        OutputStreamWriter wr = null;
        BufferedReader rd = null;
        try {
            String urlForSMS = accessParam.getString("CUSTOM_SMS_URL");
            logger.log(Level.INFO, "SSPCustomSMSProvider SMS : CUSTOM SMS HTTP URL " + urlForSMS);
            boolean isPost = false;
            if ("POST".equalsIgnoreCase(accessParam.optString("CUSTOM_HTTP_METHOD"))) {
                isPost = true;
            }
            boolean unicode = accessParam.optBoolean("MESSAGE_INTO_UNICODE");
            String message = this.msgProps.getProperty("MESSAGE");
            String[] numbers = (String[])this.msgProps.get("NUMBERS");
            String successResp = accessParam.optString("SUCCESS_RESPONSE");
            String failureResp = accessParam.optString("FAILURE_RESPONSE");
            Hashtable<String, String> prop = new Hashtable<String, String>();
            prop.put("message", unicode ? StrUtil.stringToHex(message) : message);
            prop.put("mobNo", StrUtil.getFormatedNumber(numbers[0], "HTTPCustomSMS"));
            String data = this.getMacro(accessParam.getString("URL_PARAMETERS"), prop);
            HttpURLConnection conn = null;
            if (isPost) {
                logger.log(Level.INFO, "SSPCustomSMSProvider SMS : Calling Post Method");
                URL url = new URL(urlForSMS);
                conn = (HttpURLConnection)url.openConnection();
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setUseCaches(false);
            } else {
                logger.log(Level.INFO, "SSPCustomSMSProvider SMS : Calling Get Method");
                URI uri = new URI(urlForSMS.substring(0, urlForSMS.indexOf(58)), urlForSMS.substring(urlForSMS.indexOf(58) + 1, urlForSMS.length()) + "?" + data, null);
                URL url = uri.toURL();
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
            }
            String reqHeaderValues = accessParam.optString("REQUEST_HEADERS");
            for (String reqHeaderValue : reqHeaderValues.split("\n")) {
                if ((reqHeaderValue = reqHeaderValue.trim()).indexOf(58) <= 0 || reqHeaderValue.indexOf(58) >= reqHeaderValue.length() - 1) continue;
                String headerKey = reqHeaderValue.substring(0, reqHeaderValue.indexOf(58));
                String headerValue = reqHeaderValue.substring(reqHeaderValue.indexOf(58) + 1);
                conn.setRequestProperty(headerKey, headerValue);
                logger.log(Level.FINE, "SSPCustomSMSProvider SMS : Valid Header " + headerKey + " : " + headerValue);
            }
            if (this.providerProps.get("PROXY_SETTINGS") != null) {
                Properties proxySettings = (Properties)this.providerProps.get("PROXY_SETTINGS");
                System.setProperty("http.proxyHost", proxySettings.getProperty("SERVER_NAME"));
                System.setProperty("http.proxyPort", proxySettings.getProperty("PORT"));
                System.setProperty("https.proxyHost", proxySettings.getProperty("SERVER_NAME"));
                System.setProperty("https.proxyPort", proxySettings.getProperty("PORT"));
                BASE64Encoder encoder = new BASE64Encoder();
                String proxyUserName = proxySettings.getProperty("USER_NAME");
                if (proxyUserName != null && !proxyUserName.equals("")) {
                    String unameAndPwd = proxyUserName + ":" + proxySettings.getProperty("PASSWORD");
                    String encodedUserPwd = encoder.encode(unameAndPwd.getBytes());
                    conn.setRequestProperty("Proxy-Authorization", "Basic " + encodedUserPwd);
                }
            }
            String resultMsg = null;
            try {
                String line;
                if (isPost) {
                    wr = new OutputStreamWriter(conn.getOutputStream());
                    wr.write(data);
                    wr.flush();
                }
                int responseCode = conn.getResponseCode();
                logger.log(Level.INFO, "SSPCustomSMSProvider SMS : The Response Code  after Sending the SMS : " + responseCode);
                InputStream isr = responseCode >= 200 && responseCode < 300 ? conn.getInputStream() : conn.getErrorStream();
                rd = new BufferedReader(new InputStreamReader(isr));
                StringBuilder result = new StringBuilder("");
                while ((line = rd.readLine()) != null) {
                    result.append(line);
                }
                String response = result.toString();
                logger.log(Level.INFO, "SSPCustomSMSProvider SMS : The Response after Sending the SMS : " + response);
                resultMsg = responseCode >= 200 && responseCode < 300 ? this.getStatusMessage(response, successResp, failureResp, "SUCCESS") : this.getStatusMessage(response, successResp, failureResp, "FAILURE");
                logger.log(Level.INFO, "SSPCustomSMSProvider SMS : Customized message : " + resultMsg);
            }
            catch (Exception e) {
                logger.log(Level.INFO, "SSPCustomSMSProvider SMS : Exception while send SMS using HTTP is : " + e);
                e.printStackTrace();
                if (e instanceof ConnectException) {
                    this.errorCode = "adssp.admin.server_settings.http_bloked_by_firewall";
                } else {
                    this.errorCode = e.getMessage();
                    if (this.errorCode != null && this.errorCode.indexOf("sun.security.validator.ValidatorException: PKIX path building failed: sun.security.provider.certpath.SunCertPathBuilderException:") > -1) {
                        this.errorCode = "adssp.admin.server_settings.not_trusted_sms_server_cert";
                    }
                }
                if (wr != null) {
                    try {
                        wr.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                if (rd != null) {
                    try {
                        rd.close();
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                }
                return;
            }
            if (resultMsg != null && "SUCCESS".equalsIgnoreCase(resultMsg)) {
                this.errorCode = "00000003";
            } else {
                this.errorCode = resultMsg;
                logger.log(Level.INFO, "SSPCustomSMSProvider SMS : ErrorCode in Sending SMS is " + this.errorCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.INFO, "SSPCustomSMSProvider SMS : Exception while Send SMS using URL");
            this.errorCode = "adssp.common.custom.message_failed";
        }
        finally {
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void sendSMTPSMS(JSONObject accessParam) {
        try {
            String resultMsg = "adssp.reset_unlock.accounts.status_msg_unable_send_code";
            Boolean useMailSettings = accessParam.optBoolean("USE_MAIL_SETTINGS");
            String serverName = accessParam.optString("CUSTOM_MAIL_SERVER");
            String portNumber = accessParam.optString("CUSTOM_MAIL_PORT");
            String userName = accessParam.optString("CUSTOM_MAIL_USERNAME");
            String password = accessParam.optString("CUSTOM_MAIL_PASSWORD");
            String securityType = accessParam.optString("CUSTOM_SECURE_CONNECTION");
            if (serverName.equals("") || portNumber.equals("")) {
                this.providerProps = ServerUtil.getMailServerSettings();
                serverName = (String)this.providerProps.get("MAIL_SERVER");
                portNumber = (String)this.providerProps.get("SMTP_PORT");
                userName = (String)this.providerProps.get("MAIL_SERVER_USER");
                password = (String)this.providerProps.get("MAIL_SERVER_PWD");
                securityType = (String)this.providerProps.get("USE_SECURE_CONNECTION");
            }
            String customMailFrom = accessParam.getString("CUSTOM_MAIL_FROM");
            String customMailTo = accessParam.getString("CUSTOM_MAIL_TO");
            String customMailSubject = accessParam.optString("CUSTOM_MAIL_SUBJECT");
            String customMailContent = accessParam.getString("CUSTOM_MAIL_CONTENT");
            if (serverName != null && !serverName.equals("")) {
                String[] numbers = (String[])this.msgProps.get("NUMBERS");
                String message = this.msgProps.getProperty("MESSAGE");
                Hashtable<String, String> prop = new Hashtable<String, String>();
                prop.put("message", message);
                prop.put("mobNo", StrUtil.getFormatedNumber(numbers[0], "SMTPCustomSMS"));
                Properties mailServerProp = new Properties();
                mailServerProp.put("MAIL_SERVER", serverName);
                mailServerProp.put("SMTP_PORT", portNumber);
                mailServerProp.put("MAIL_SERVER_USER", userName);
                mailServerProp.put("MAIL_SERVER_PWD", password);
                mailServerProp.put("FROM_ADDRESS", customMailFrom);
                mailServerProp.put("USE_SECURE_CONNECTION", securityType);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("MAIL_SUBJECT", this.getMacro(customMailSubject, prop));
                map.put("MAIL_CONTENT", this.getMacro(customMailContent, prop));
                map.put("MAIL_IDS", new String[]{this.getMacro(customMailTo, prop)});
                logger.log(Level.INFO, "SSPCustomSMSProvider SMS : Sending messsage to " + this.getMacro(customMailTo, prop));
                try {
                    resultMsg = SendMailAPI.getInstance().sendMail(map, new Hashtable(), mailServerProp);
                    logger.log(Level.INFO, "SSPCustomSMSProvider SMS : The Response after Sending the SMS : " + resultMsg);
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "SSPCustomSMSProvider SMS : Exception while send SMS using SMTP is : " + e);
                    e.printStackTrace();
                    this.errorCode = e.toString();
                    return;
                }
            }
            if (resultMsg != null && resultMsg.indexOf("adssp.common.text.mail_sent_success") != -1) {
                this.errorCode = "00000003";
            } else {
                this.errorCode = resultMsg;
                logger.log(Level.INFO, "SSPCustomSMSProvider SMS : ErrorCode in Sending SMS is " + this.errorCode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.INFO, "SSPCustomSMSProvider SMS : Exception while Send SMS using SMTP");
            this.errorCode = "adssp.common.custom.message_failed";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendSMPPSMS(JSONObject accessParam) {
        OutputStreamWriter wr = null;
        BufferedReader rd = null;
        try {
            this.userName = accessParam.getString("SMPP_USER_NAME");
            this.password = accessParam.getString("SMPP_PASSWORD");
            this.apiId = this.providerProps.getProperty("API_ID");
            int smppPort = accessParam.optInt("SMPP_PORT_NUMBER");
            String smppHost = accessParam.getString("SMPP_SERVER_NAME");
            this.sourceAddr = accessParam.optString("SMPP_SOURCE_ADDRESS");
            this.customESMESysType = accessParam.optString("ESME_SYSTEM_TYPE", "cp");
            this.smppSupportedTime = accessParam.optInt("SMPP_TIME_OUT", 5);
            this.esmeBindType = accessParam.optInt("ESME_BIND_TYPE", 2);
            this.sourceAddrTon = accessParam.optInt("SOURCE_ADDRESS_TON");
            this.sourceAddrNpi = accessParam.optInt("SOURCE_ADDRESS_NPI");
            this.destAddrTon = accessParam.optInt("DESTINATION_ADDRESS_TON");
            this.destAddrNpi = accessParam.optInt("DESTINATION_ADDRESS_NPI");
            String[] numbers = (String[])this.msgProps.get("NUMBERS");
            String number = StrUtil.getFormatedNumber(numbers[0], "SMPPCustomSMS");
            String message = this.msgProps.getProperty("MESSAGE");
            try {
                String sysId = this.connectAndBind(smppHost, smppPort);
                if (sysId != null) {
                    String messageId = this.submitMessage(number, message.getBytes("UTF-16BE"));
                    if (messageId != null) {
                        this.errorCode = "00000003";
                    } else {
                        this.errorCode = "adssp.common.custom.message_failed_smpp_submit_failed";
                        logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : ErrorCode in Sending SMS is " + this.errorCode);
                    }
                    this.unBind();
                } else {
                    this.errorCode = "adssp.common.custom.message_failed_smpp_bind_failed";
                    logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : ErrorCode in Sending SMS is " + this.errorCode);
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : Exception while send SMS using SMPP is : " + e);
                e.printStackTrace();
                this.errorCode = e.getMessage();
                if (wr != null) {
                    try {
                        wr.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
                if (rd != null) {
                    try {
                        rd.close();
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                }
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : Exception while Send SMS using SMPP");
            this.errorCode = "adssp.common.custom.message_failed";
        }
        finally {
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unBind() {
        try {
            this.bindOrSubmitBytes = new byte[4];
            this.requestlength = 4;
            this.assignLength(this.requestlength);
            this.append(6);
            this.append(0);
            this.append(this.sequenceNumber);
            ++this.sequenceNumber;
            logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : UnBinding Connection Starts");
            this.out.write(this.bindOrSubmitBytes);
            this.out.flush();
        }
        catch (Exception e) {
            logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : Error in un binding SMPP connection");
        }
        finally {
            try {
                this.smppConnection.close();
            }
            catch (Exception e) {
                logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : Error in closing socket  connection");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processBindOrSubmitResponse() {
        String sysOrMsgId = null;
        try {
            int reponseLength = this.in.readInt();
            if (reponseLength < 16) {
                throw new Exception("adssp.common.custom.message_failed_smpp_invalid_response");
            }
            int responseCommandId = this.in.readInt();
            int responseCommandStatus = this.in.readInt();
            int responseSequenceNumber = this.in.readInt();
            logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : reponseLength = " + reponseLength + " responseCommandId = " + responseCommandId + " responseCommandStatus = " + responseCommandStatus + " responseSequenceNumber = " + responseSequenceNumber);
            byte[] b = new byte[reponseLength];
            System.arraycopy(this.intToBytes(reponseLength), 0, b, 0, 4);
            System.arraycopy(this.intToBytes(responseCommandId), 0, b, 4, 4);
            System.arraycopy(this.intToBytes(responseCommandStatus), 0, b, 8, 4);
            System.arraycopy(this.intToBytes(responseSequenceNumber), 0, b, 12, 4);
            int unReadedLen = reponseLength - 16;
            int totalReaded = -1;
            DataInputStream dataInputStream = this.in;
            synchronized (dataInputStream) {
                int j;
                int len = this.in.read(b, 16, unReadedLen);
                totalReaded = len == -1 || unReadedLen == len ? len : ((j = this.in.read(b, 16 + len, unReadedLen - len)) == -1 ? len : len + j);
            }
            if (totalReaded != unReadedLen) {
                throw new Exception("adssp.common.custom.message_failed_smpp_cant_read_response");
            }
            if (reponseLength > 16 && responseCommandStatus == 0) {
                sysOrMsgId = this.readCString(b);
            }
            if (responseCommandStatus == 0 && sysOrMsgId == null) {
                logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : responseCommandStatus is success but some SMPP Server sends Empty SystemID");
                sysOrMsgId = "Empty SystemID ";
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : Exception while send SMS using HTTP is : " + e);
            e.printStackTrace();
        }
        return sysOrMsgId;
    }

    public String connectAndBind(String smppHost, int smppPort) throws Exception {
        String sysId = null;
        try {
            logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : Connecting SMPP Socket Connection ");
            this.smppConnection = new Socket(smppHost, smppPort);
            logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : SMPP Connection Established for " + this.smppSupportedTime + " seconds");
            this.in = new DataInputStream(new BufferedInputStream(this.smppConnection.getInputStream(), 65536));
            this.out = new DataOutputStream(this.smppConnection.getOutputStream());
            this.smppConnection.setSoTimeout(this.smppSupportedTime * 1000);
            this.bindOrSubmitBytes = new byte[4];
            this.requestlength = 4;
            this.assignLength(this.requestlength);
            this.append(this.esmeBindType);
            this.append(0);
            this.append(this.sequenceNumber);
            ++this.sequenceNumber;
            this.append(this.userName);
            this.append(this.password);
            this.append(this.customESMESysType);
            this.append((byte)52);
            this.append((byte)0);
            this.append((byte)0);
            this.append((byte)0);
            logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : Going to Bind ");
            this.out.write(this.bindOrSubmitBytes);
            this.out.flush();
            logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : Successfully Bind is submitted, Reading resonse ");
            sysId = this.processBindOrSubmitResponse();
            logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : Finished Response, SystemId = " + sysId);
        }
        catch (UnknownHostException ex) {
            throw new Exception("adssp.common.custom.message_failed_unknown_smpp_host");
        }
        catch (ConnectException ex) {
            throw new Exception("adssp.common.custom.message_failed_cannot_connect_smpp");
        }
        catch (Exception e) {
            logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : Exception while Submitting Bind and Getting response: " + e);
            e.printStackTrace();
        }
        return sysId;
    }

    public String submitMessage(String number, byte[] message) {
        String messageId = null;
        try {
            this.bindOrSubmitBytes = new byte[4];
            this.requestlength = 4;
            this.assignLength(this.requestlength);
            this.append(4);
            this.append(0);
            this.append(this.sequenceNumber);
            ++this.sequenceNumber;
            this.append("");
            this.append((byte)this.sourceAddrTon);
            this.append((byte)this.sourceAddrNpi);
            this.append(this.sourceAddr);
            this.append((byte)this.destAddrTon);
            this.append((byte)this.destAddrNpi);
            this.append("" + number + "");
            this.append((byte)0);
            this.append((byte)0);
            this.append((byte)3);
            this.append((byte)0);
            this.append((String)null);
            this.append((byte)0);
            this.append((byte)0);
            this.append((byte)8);
            this.append((byte)0);
            int messageByteLen = message.length;
            if (messageByteLen <= 254) {
                this.append((byte)messageByteLen);
                this.append(message);
            } else {
                this.append((byte)0);
                this.append(this.shortToBytes((short)1060));
                this.append(this.shortToBytes((short)messageByteLen));
                this.append(message);
            }
            logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : Going to Submit Message ");
            this.out.write(this.bindOrSubmitBytes);
            this.out.flush();
            logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : Message is submitted,Reading response");
            messageId = this.processBindOrSubmitResponse();
            logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : Finished response, MessageId = " + messageId);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "SSPCustomSMSProvider  SMS : Exception while Submitting MSG and Gettting response : " + e);
            e.printStackTrace();
        }
        return messageId;
    }

    public String readCString(byte[] bytes) {
        int i = 16;
        while (bytes[i] != 0) {
            ++i;
        }
        int length = i - 16;
        if (length == 0) {
            return null;
        }
        String val = new String(bytes, 16, length);
        return val;
    }

    public void assignLength(int value) {
        byte[] intBytes = this.intToBytes(value);
        System.arraycopy(intBytes, 0, this.bindOrSubmitBytes, 0, 4);
    }

    public byte[] shortToBytes(short value) {
        byte[] shortBytes = new byte[2];
        shortBytes[1] = (byte)(value & 0xFF);
        shortBytes[0] = (byte)(value >> 8 & 0xFF);
        return shortBytes;
    }

    public byte[] intToBytes(int value) {
        byte[] intBytes = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
        return intBytes;
    }

    public int append(int intValue) {
        return this.append(this.intToBytes(intValue));
    }

    public int append(byte[] b, int offset, int length) {
        int newCapacity;
        int oldLength = this.requestlength;
        this.requestlength += length;
        int n = newCapacity = this.requestlength > this.bindOrSubmitBytes.length ? this.requestlength : this.bindOrSubmitBytes.length;
        if (newCapacity > this.bindOrSubmitBytes.length) {
            byte[] newByte = new byte[newCapacity];
            System.arraycopy(this.bindOrSubmitBytes, 0, newByte, 0, this.bindOrSubmitBytes.length);
            this.bindOrSubmitBytes = newByte;
        }
        System.arraycopy(b, offset, this.bindOrSubmitBytes, oldLength, length);
        this.assignLength(this.requestlength);
        return this.requestlength;
    }

    public int append(byte[] bytes) {
        return this.append(bytes, 0, bytes.length);
    }

    public int append(byte b) {
        return this.append(new byte[]{b});
    }

    public int append(String string, boolean nullTerminated) {
        if (string != null) {
            this.append(string.getBytes());
        }
        if (nullTerminated) {
            this.append((byte)0);
        }
        return this.requestlength;
    }

    public int append(String string) {
        return this.append(string, true);
    }

    @Override
    public String getDeliveryStatus() {
        this.deliveryStatus = this.errorCode.equals("00000003") ? "adssp.common.text.smssent" : (this.errorCode != null ? this.errorCode : "adssp.common.custom.message_failed");
        return this.deliveryStatus;
    }

    public String getStatusMessage(String statusMessage, String successResp, String failureResp, String defaultResponse) {
        String status = null;
        try {
            if (!"".equals(successResp) && statusMessage.indexOf(successResp) != -1) {
                status = "SUCCESS";
            } else if (!"".equals(failureResp) && statusMessage.indexOf(failureResp) != -1) {
                status = "SMS is Failed because of : " + statusMessage;
            } else {
                logger.log(Level.INFO, "SSPCustomSMSProvider SMS : Response received " + statusMessage);
                if ("SUCCESS".equalsIgnoreCase(defaultResponse)) {
                    status = defaultResponse;
                } else {
                    status = "SMS Sending Failed";
                    logger.log(Level.INFO, "SSPCustomSMSProvider SMS : SMS is Failed because of :  " + statusMessage);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    private String getMacro(String message, Hashtable prop) {
        String[] macros;
        for (String macro : macros = new String[]{"message", "mobNo"}) {
            String key = "%" + macro + "%";
            String value = (String)prop.get(macro);
            message = message.replaceAll(key, StrUtil.escapeSplChars(value));
            String keyInSensitive = "(?i)" + key;
            message = message.replaceAll(keyInSensitive, StrUtil.escapeSplChars(value));
        }
        return message;
    }

    @Override
    public Boolean isMsgSent() {
        return true;
    }
}

