/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.sms;

import com.adventnet.sym.adsm.common.server.sms.SMSAction;
import com.adventnet.sym.adsm.common.server.sms.SMSProvider;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SignatureException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.json.JSONArray;
import org.json.JSONObject;
import sun.misc.BASE64Encoder;

public class TeleSign
implements SMSProvider {
    private static Logger logger = Logger.getLogger(SMSAction.class.getName());
    private static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private TreeMap<String, String> ts_headers = new TreeMap();
    private Properties providerProps = null;
    private Properties msgProps = null;
    private String deliveryStatus = null;
    private String errorCode = null;
    private boolean unicode = true;

    @Override
    public void setSMSProperties(Properties providerProps, Properties msgProps) {
        try {
            logger.log(Level.INFO, "TeleSign : SetSMSProperties");
            this.providerProps = providerProps;
            this.msgProps = msgProps;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendSMS() {
        String errorMessage = null;
        try {
            String customerId = this.providerProps.getProperty("USER_NAME");
            String teleSignAPIKey = this.providerProps.getProperty("API_ID");
            String urlForSMS = this.providerProps.getProperty("ACCESS_PARAM");
            String[] numbers = (String[])this.msgProps.get("NUMBERS");
            String phone_number = StrUtil.getFormatedNumber(numbers[0], "Clickatell");
            String message = this.msgProps.getProperty("MESSAGE");
            String language = null;
            String dateString = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ZZZ").format(new Date());
            this.ts_headers.put("X-TS-Date", dateString);
            String data = "phone_number=" + URLEncoder.encode(phone_number, "UTF-8");
            if (language != null) {
                data = data + "&language=" + URLEncoder.encode(language, "UTF-8");
            }
            data = data + "&template=" + URLEncoder.encode(message, "UTF-8");
            Object resultMsg = null;
            try {
                String result = this.connectAndGet(data, urlForSMS, "/v1/verify/sms", true, teleSignAPIKey, customerId);
                JSONObject jsonResponse = new JSONObject(result);
                logger.log(Level.INFO, "TeleSign SMS : The Response after Sending the SMS : " + jsonResponse);
                PhoneResponse smsResponse = new PhoneResponse(jsonResponse);
                if (!smsResponse.isErrorOccurred()) {
                    String refernceId = smsResponse.getReferenceId();
                    int statusCode = smsResponse.getStatusCode();
                    Integer[] successCode = new Integer[]{200, 203, 290, 291, 292};
                    List<Integer> successList = Arrays.asList(successCode);
                    if (successList.contains(statusCode)) {
                        logger.log(Level.INFO, "TeleSign SMS : Customized success message : " + smsResponse.getStatusDescription());
                    } else {
                        errorMessage = smsResponse.getStatusDescription();
                        this.errorCode = Integer.toString(smsResponse.getStatusCode());
                    }
                } else {
                    errorMessage = smsResponse.getErrorMessage();
                    this.errorCode = Integer.toString(smsResponse.getErrorCode());
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "TeleSign SMS : Exception while send SMS using HTTP is : " + e);
                e.printStackTrace();
                this.errorCode = "00000002";
                return;
            }
            if (errorMessage == null) {
                this.errorCode = "00000003";
            } else {
                logger.log(Level.INFO, "TeleSign SMS : ErrorCode in Sending SMS is " + errorMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.INFO, "TeleSign SMS : Exception while Send SMS using URL");
            this.errorCode = "Unexpected Error Occurred. Try again later.";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String connectAndGet(String data, String urlForSMS, String resourceURL, Boolean post, String teleSignAPIKey, String customerId) throws Exception {
        OutputStreamWriter wr = null;
        BufferedReader rd = null;
        urlForSMS = urlForSMS + resourceURL;
        if (!post.booleanValue()) {
            urlForSMS = urlForSMS + "?" + data;
        }
        URL url = new URL(urlForSMS);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("Content-Type", CONTENT_TYPE);
        String stringToSign = this.getSigningString(data, resourceURL);
        String signature = null;
        try {
            logger.log(Level.FINE, "The stringToSign is " + stringToSign);
            signature = this.encode(stringToSign, teleSignAPIKey);
        }
        catch (SignatureException e) {
            logger.log(Level.INFO, "Error signing request " + e.getMessage());
        }
        String auth_header = "TSA " + customerId + ":" + signature;
        logger.log(Level.FINE, auth_header);
        conn.setRequestProperty("Authorization", auth_header);
        conn.setRequestProperty("Content-Length", Integer.toString(data.length()));
        for (String key : this.ts_headers.keySet()) {
            conn.setRequestProperty(key, this.ts_headers.get(key));
        }
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        if (this.providerProps.get("PROXY_SETTINGS") != null) {
            Properties proxySettings = (Properties)this.providerProps.get("PROXY_SETTINGS");
            System.setProperty("http.proxyHost", proxySettings.getProperty("SERVER_NAME"));
            System.setProperty("http.proxyPort", proxySettings.getProperty("PORT"));
            System.setProperty("https.proxyHost", proxySettings.getProperty("SERVER_NAME"));
            System.setProperty("https.proxyPort", proxySettings.getProperty("PORT"));
            BASE64Encoder encoder = new BASE64Encoder();
            String proxyUserName = proxySettings.getProperty("USER_NAME");
            if (proxyUserName != null && !proxyUserName.equals("")) {
                String unameAndPwd = proxyUserName + ":" + proxySettings.getProperty("PASSWORD");
                String encodedUserPwd = encoder.encode(unameAndPwd.getBytes());
                conn.setRequestProperty("Proxy-Authorization", "Basic " + encodedUserPwd);
            }
        }
        Object resultMsg = null;
        try {
            String line;
            int response;
            if (post.booleanValue()) {
                wr = new OutputStreamWriter(conn.getOutputStream());
                wr.write(data);
                wr.flush();
            }
            InputStream isr = (response = conn.getResponseCode()) == 200 ? conn.getInputStream() : conn.getErrorStream();
            rd = new BufferedReader(new InputStreamReader(isr));
            StringBuilder result = new StringBuilder("");
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
            String string = result.toString();
            return string;
        }
        catch (Exception e) {
            logger.log(Level.INFO, "TeleSign SMS : Exception while send SMS using HTTP is : " + e);
            e.printStackTrace();
            this.errorCode = e.toString();
        }
        finally {
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @Override
    public String getDeliveryStatus() {
        this.deliveryStatus = this.errorCode.equals("00000003") ? "adssp.common.text.smssent" : "adssp.sms_gateway.telesign.errorcode_" + (this.errorCode != null ? this.errorCode : "00000002");
        return this.deliveryStatus;
    }

    public String getSigningString(String params, String resourceURL) throws Exception {
        String stringToSign = "POST\n";
        stringToSign = stringToSign + "application/x-www-form-urlencoded\n";
        stringToSign = stringToSign + "\n";
        Set<String> orderedKeys = this.ts_headers.keySet();
        for (String key : orderedKeys) {
            stringToSign = stringToSign + key.toLowerCase() + ":" + this.ts_headers.get(key) + "\n";
        }
        stringToSign = stringToSign + params + "\n";
        stringToSign = stringToSign + resourceURL;
        return stringToSign;
    }

    private String encode(String data, String key) throws SignatureException {
        String result;
        try {
            byte[] decoded_key = Base64.decodeBase64((String)key);
            SecretKeySpec signingKey = new SecretKeySpec(decoded_key, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes("UTF-8"));
            BASE64Encoder encoder = new BASE64Encoder();
            result = new String(Base64.encodeBase64((byte[])rawHmac));
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
        return result;
    }

    @Override
    public Boolean isMsgSent() {
        return this.errorCode.equalsIgnoreCase("00000003");
    }

    public static class PhoneResponse {
        private String referenceId = null;
        private String resourceUri = null;
        private String subResource = null;
        private int errorCode = 0;
        private String description = null;
        private String timeUpdatedOn = null;
        private int statusCode = -1;
        private String statusDescription = null;
        private String codeState = null;
        private String codeEntered = null;
        private String actualResponse = null;

        PhoneResponse(JSONObject jsonObj) {
            try {
                JSONObject verifyJson;
                JSONArray errorJson = (JSONArray)jsonObj.get("errors");
                if (errorJson != null && errorJson.length() > 0) {
                    JSONObject errorObj = (JSONObject)errorJson.get(0);
                    this.errorCode = Integer.parseInt(errorObj.getString("code"));
                    this.description = errorObj.getString("description");
                }
                this.referenceId = jsonObj.getString("reference_id");
                this.resourceUri = jsonObj.getString("resource_uri");
                this.subResource = jsonObj.getString("sub_resource");
                JSONObject statusJson = (JSONObject)jsonObj.get("status");
                if (statusJson != null) {
                    this.statusCode = Integer.parseInt(statusJson.getString("code"));
                    this.statusDescription = statusJson.getString("description");
                    this.timeUpdatedOn = statusJson.getString("updated_on");
                }
                if ((verifyJson = (JSONObject)jsonObj.opt("verify")) != null) {
                    this.codeState = verifyJson.getString("code_state");
                    this.codeEntered = verifyJson.getString("code_entered");
                }
            }
            catch (Exception ex) {
                if (this.errorCode == 0) {
                    this.errorCode = -1;
                    this.description = "Error in Response.";
                }
                logger.log(Level.FINE, ex.getMessage(), ex);
            }
            this.actualResponse = jsonObj.toString();
        }

        public boolean isErrorOccurred() {
            return this.errorCode != 0;
        }

        public String getErrorMessage() {
            return this.description;
        }

        public String getStatusDescription() {
            return this.statusDescription;
        }

        public String getReferenceId() {
            return this.referenceId;
        }

        public String toString() {
            return this.actualResponse;
        }

        public String getCodeState() {
            return this.codeState;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }
    }
}

