/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.ssh;

import com.maverick.ssh.HostKeyVerification;
import com.maverick.ssh.LicenseManager;
import com.maverick.ssh.PasswordAuthentication;
import com.maverick.ssh.SshAuthentication;
import com.maverick.ssh.SshClient;
import com.maverick.ssh.SshConnector;
import com.maverick.ssh.SshException;
import com.maverick.ssh.SshSession;
import com.maverick.ssh.SshTransport;
import com.maverick.ssh.components.SshPublicKey;
import com.maverick.ssh2.Ssh2Context;
import com.sshtools.net.SocketTransport;
import com.sshtools.scp.ScpClient;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class SSHUtil {
    private static Logger logger = Logger.getLogger(SSHUtil.class.getName());
    private String userName;
    private String password;
    private String host;
    private int port;
    private SshConnector con = null;
    private SshClient sshCli = null;
    private PasswordAuthentication pwd = null;
    public String connectionError = "";
    private static final String J2SSH_LICENSE = "----BEGIN 3SP LICENSE----\r\nProduct : J2SSH Maverick\r\nLicensee: Zoho Corporation Private Limited\r\nComments: None\r\nType    : OEM License\r\nCreated : 01-Feb-2015\r\n\r\n378720420626DFDBA600F3CF9CCEF4C802A97AD72B3CD756\r\n51825ECA5A0FAB7A9D50148C3D03458138ED230311C1DF44\r\n86A4598A41447783A438030C30E10FA031853876D2356499\r\n33CA93678E8BF0143E4FA3924C4391B9587924E0389475F9\r\n87AEBDF4A1FFEC4736302126F41D22FE78E9E273C9AD72A9\r\n0D117B46DE452200A74F772B290809B0BD66B63B52CB2C49\r\n----END 3SP LICENSE----\r\n";

    public SSHUtil(String userName, String password, String host, int port) {
        this.userName = userName;
        this.password = password;
        this.host = host;
        this.port = port;
        this.init();
    }

    public SSHUtil(String userName, String password, String host) {
        this.userName = userName;
        this.password = password;
        this.host = host;
        this.port = 22;
        this.init();
    }

    public void init() {
        try {
            LicenseManager.addLicense((String)J2SSH_LICENSE);
            this.con = SshConnector.getInstance();
            this.setPassword(this.password);
        }
        catch (Exception e) {
            this.connectionError = e.getMessage();
            e.printStackTrace();
        }
    }

    public void setPassword(String password) {
        try {
            if (password != null && this.con != null) {
                this.exit();
                HostKeyVerification hkv = new HostKeyVerification(){

                    public boolean verifyHost(String name, SshPublicKey key) {
                        try {
                            logger.log(Level.INFO, "The connected host's key (" + key.getAlgorithm() + ") is");
                            logger.log(Level.INFO, key.getFingerprint());
                        }
                        catch (SshException e) {
                            e.printStackTrace();
                        }
                        return true;
                    }
                };
                this.con.setKnownHosts(hkv);
                ((Ssh2Context)this.con.getContext(2)).supportedKeyExchanges().remove("diffie-hellman-group-exchange-sha1");
                ((Ssh2Context)this.con.getContext(2)).setDHGroupExchangeBackwardsCompatible(false);
                this.sshCli = this.con.connect((SshTransport)new SocketTransport(this.host, this.port), this.userName);
                this.pwd = new PasswordAuthentication();
                do {
                    this.pwd.setPassword(password);
                } while (this.sshCli.authenticate((SshAuthentication)this.pwd) != 1 && this.sshCli.isConnected());
            }
        }
        catch (UnknownHostException e) {
            this.connectionError = "adssp_admin_gina_network_path_not_found";
            e.printStackTrace();
        }
        catch (ConnectException e) {
            this.connectionError = e.getMessage().indexOf("timed out") != -1 ? "adssp_connection_error_timed_out" : (e.getMessage().indexOf("refused") != -1 ? "adssp_connection_error_refused" : e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            this.connectionError = e.getMessage();
            e.printStackTrace();
        }
    }

    public boolean isAuthenticated() {
        boolean result = false;
        try {
            if (this.sshCli != null && this.sshCli.isAuthenticated()) {
                result = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyTo(String localFile, String remoteFile) {
        ScpClient scpCli = null;
        boolean isCopied = true;
        try {
            if (!this.isAuthenticated()) {
                throw new Exception("adssp_config_gina_err_logon_failure_unknow_user_bad_pwd");
            }
            scpCli = new ScpClient(this.sshCli);
            scpCli.put(localFile, remoteFile, false);
        }
        catch (Exception e) {
            isCopied = false;
            logger.log(Level.FINE, "Exception while copying file : " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            try {
                if (scpCli != null) {
                    scpCli.exit();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isCopied;
    }

    public String executeCommand(String command) throws Exception {
        String result;
        block14: {
            SshSession sshSess = null;
            result = "";
            try {
                if (!this.isAuthenticated()) {
                    throw new Exception("adssp_config_gina_err_logon_failure_unknow_user_bad_pwd");
                }
                sshSess = this.sshCli.openSessionChannel();
                boolean isExecuted = sshSess.executeCommand(command, "UTF-8");
                if (isExecuted) {
                    String output = IOUtils.toString((InputStream)sshSess.getInputStream(), (String)"UTF-8").trim();
                    result = !output.equals("") ? output : IOUtils.toString((InputStream)sshSess.getStderrInputStream(), (String)"UTF-8").trim();
                    break block14;
                }
                throw new Exception("Could not execute command");
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Exception while executing command");
                throw new Exception(e.getMessage());
            }
            finally {
                try {
                    if (sshSess != null && !sshSess.isClosed()) {
                        sshSess.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public void exit() {
        try {
            if (this.sshCli != null && this.sshCli.isConnected()) {
                this.sshCli.disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

